/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataSlotService;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.api.JaxRsModuleInfoBuilder;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleInfo;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleMetaData;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleType;
import com.ibm.ws.jaxrs20.support.JaxRsMetaDataManager;
import com.ibm.ws.jaxrs20.utils.JaxRsUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(immediate=true, property={"service.vendor=IBM"}, configurationPolicy=ConfigurationPolicy.OPTIONAL)
public class JaxRsModuleMetaDataListener
implements ModuleMetaDataListener {
    private static final TraceComponent tc = Tr.register(JaxRsModuleMetaDataListener.class);
    private final Map<JaxRsModuleType, JaxRsModuleInfoBuilder> jaxRsModuleInfoBuilderMap = new ConcurrentHashMap<JaxRsModuleType, JaxRsModuleInfoBuilder>();
    private final AtomicServiceReference<ClassLoadingService> classLoadingServiceSR = new AtomicServiceReference("classLoadingService");
    static final long serialVersionUID = -9214003615594584679L;

    /*
     * WARNING - void declaration
     */
    public void moduleMetaDataCreated(MetaDataEvent<ModuleMetaData> event) {
        ExtendedModuleInfo moduleInfo;
        ModuleMetaData mmd = (ModuleMetaData)event.getMetaData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moduleMetaDataCreated(" + mmd.getName() + ") : " + mmd), (Object[])new Object[0]);
        }
        if ((moduleInfo = JaxRsUtils.getModuleInfo(event.getContainer())) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unsupported Module, no JaxRsModuleMetaData will be created for " + mmd.getName()), (Object[])new Object[0]);
            }
            return;
        }
        Container moduleContainer = event.getContainer();
        try {
            NonPersistentCache overlayCache = (NonPersistentCache)moduleContainer.adapt(NonPersistentCache.class);
            JaxRsModuleMetaData jaxRsModuleMetaData = (JaxRsModuleMetaData)overlayCache.getFromCache(JaxRsModuleMetaData.class);
            if (jaxRsModuleMetaData == null) {
                ClassLoader appContextClassLoader = ((ClassLoadingService)this.classLoadingServiceSR.getServiceWithException()).createThreadContextClassLoader(moduleInfo.getClassLoader());
                jaxRsModuleMetaData = new JaxRsModuleMetaData(mmd, event.getContainer(), appContextClassLoader);
                overlayCache.addToCache(JaxRsModuleMetaData.class, (Object)jaxRsModuleMetaData);
            } else {
                jaxRsModuleMetaData.getEnclosingModuleMetaDatas().add(mmd);
            }
            JaxRsMetaDataManager.setJaxRsModuleMetaData(mmd, jaxRsModuleMetaData);
            JaxRsModuleInfo jaxRsModuleInfo = (JaxRsModuleInfo)overlayCache.getFromCache(JaxRsModuleInfo.class);
            if (jaxRsModuleInfo == null) {
                if (JaxRsUtils.isWebModule(moduleContainer)) {
                    jaxRsModuleInfo = new JaxRsModuleInfo(JaxRsModuleType.WEB);
                } else if (JaxRsUtils.isEJBModule(moduleContainer)) {
                    jaxRsModuleInfo = new JaxRsModuleInfo(JaxRsModuleType.EJB);
                }
            }
            overlayCache.addToCache(JaxRsModuleInfo.class, (Object)jaxRsModuleInfo);
            JaxRsModuleInfoBuilder jaxRsModuleInfoBuilder = null;
            if (JaxRsUtils.isWebModule(moduleContainer)) {
                jaxRsModuleInfoBuilder = this.jaxRsModuleInfoBuilderMap.get((Object)JaxRsModuleType.WEB);
            } else if (JaxRsUtils.isEJBModule(moduleContainer)) {
                jaxRsModuleInfoBuilder = this.jaxRsModuleInfoBuilderMap.get((Object)JaxRsModuleType.EJB);
            }
            if (jaxRsModuleInfoBuilder != null) {
                jaxRsModuleInfoBuilder.build(mmd, moduleContainer, jaxRsModuleInfo);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No JaxWsModuleInfoBuilder added to JaxWsModuleMetaDataListener.", (Object[])new Object[0]);
            }
        }
        catch (UnableToAdaptException overlayCache) {
            void e;
            FFDCFilter.processException((Throwable)overlayCache, (String)"com.ibm.ws.jaxrs20.component.JaxRsModuleMetaDataListener", (String)"127", (Object)this, (Object[])new Object[]{event});
            throw new IllegalStateException((Throwable)e);
        }
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.classLoadingServiceSR.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.classLoadingServiceSR.deactivate(cc);
    }

    public void moduleMetaDataDestroyed(MetaDataEvent<ModuleMetaData> event) {
        JaxRsModuleMetaData moduleMetaData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moduleMetaDataDestroyed(" + ((ModuleMetaData)event.getMetaData()).getName() + ") : " + event.getMetaData()), (Object[])new Object[0]);
        }
        if ((moduleMetaData = JaxRsMetaDataManager.getJaxRsModuleMetaData((ModuleMetaData)event.getMetaData())) != null) {
            JaxRsMetaDataManager.setJaxRsModuleMetaData((ModuleMetaData)event.getMetaData(), null);
            if (moduleMetaData.getJ2EEName().equals(((ModuleMetaData)event.getMetaData()).getJ2EEName())) {
                moduleMetaData.destroy();
                ClassLoadingService classLoadingService = (ClassLoadingService)this.classLoadingServiceSR.getService();
                if (classLoadingService != null) {
                    classLoadingService.destroyThreadContextClassLoader(moduleMetaData.getAppContextClassLoader());
                }
            }
        }
    }

    @Reference(name="metaDataSlotService", service=MetaDataSlotService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setMetaDataSlotService(MetaDataSlotService slotService) {
        JaxRsMetaDataManager.jaxrsApplicationSlot = slotService.reserveMetaDataSlot(ApplicationMetaData.class);
        JaxRsMetaDataManager.jaxrsModuleSlot = slotService.reserveMetaDataSlot(ModuleMetaData.class);
        JaxRsMetaDataManager.jaxrsComponentSlot = slotService.reserveMetaDataSlot(ComponentMetaData.class);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setMetaDataSlotService : applicationSlot=" + JaxRsMetaDataManager.jaxrsApplicationSlot), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("setMetaDataSlotService : moduleSlot=" + JaxRsMetaDataManager.jaxrsModuleSlot), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("setMetaDataSlotService : componentSlot=" + JaxRsMetaDataManager.jaxrsComponentSlot), (Object[])new Object[0]);
        }
    }

    protected void unsetMetaDataSlotService(MetaDataSlotService slotService) {
        JaxRsMetaDataManager.jaxrsApplicationSlot = null;
        JaxRsMetaDataManager.jaxrsModuleSlot = null;
        JaxRsMetaDataManager.jaxrsComponentSlot = null;
    }

    @Reference(name="jaxRsModuleInfoBuilders", service=JaxRsModuleInfoBuilder.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void registerJaxRsModuleInfoBuilder(JaxRsModuleInfoBuilder jaxRsModuleInfoBuilder) {
        this.jaxRsModuleInfoBuilderMap.put(jaxRsModuleInfoBuilder.getSupportType(), jaxRsModuleInfoBuilder);
    }

    protected void unregisterJaxRsModuleInfoBuilder(JaxRsModuleInfoBuilder jaxRsModuleInfoBuilder) {
        this.jaxRsModuleInfoBuilderMap.remove((Object)jaxRsModuleInfoBuilder.getSupportType());
    }

    @Reference(name="classLoadingService", service=ClassLoadingService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingServiceSR.setReference(ref);
    }

    protected void unsetClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingServiceSR.unsetReference(ref);
    }
}

