/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class Util {
    private static TraceComponent tc = Tr.register(Util.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    static final String digits = "0123456789abcdef";

    public static String printStatus(int status) {
        switch (status) {
            case 0: {
                return "Status.STATUS_ACTIVE";
            }
            case 3: {
                return "Status.STATUS_COMMITTED";
            }
            case 8: {
                return "Status.STATUS_COMMITTING";
            }
            case 1: {
                return "Status.STATUS_MARKED_ROLLBACK";
            }
            case 6: {
                return "Status.STATUS_NO_TRANSACTION";
            }
            case 2: {
                return "Status.STATUS_PREPARED";
            }
            case 7: {
                return "Status.STATUS_PREPARING";
            }
            case 4: {
                return "Status.STATUS_ROLLEDBACK";
            }
            case 9: {
                return "Status.STATUS_ROLLING_BACK";
            }
        }
        return "Status.STATUS_UNKNOWN";
    }

    public static String printFlag(int flags) {
        StringBuffer sb = new StringBuffer();
        sb.append(Integer.toHexString(flags));
        sb.append("=");
        if (flags == 0) {
            sb.append("TMNOFLAGS");
        } else {
            if ((flags & 0x800000) != 0) {
                sb.append("TMENDRSCAN|");
            }
            if ((flags & 0x20000000) != 0) {
                sb.append("TMFAIL|");
            }
            if ((flags & 0x200000) != 0) {
                sb.append("TMJOIN|");
            }
            if ((flags & 0x40000000) != 0) {
                sb.append("TMONEPHASE|");
            }
            if ((flags & 0x8000000) != 0) {
                sb.append("TMRESUME|");
            }
            if ((flags & 0x1000000) != 0) {
                sb.append("TMSTARTRSCAN|");
            }
            if ((flags & 0x4000000) != 0) {
                sb.append("TMSUCCESS|");
            }
            if ((flags & 0x2000000) != 0) {
                sb.append("TMSUSPEND|");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String identity(Object x) {
        if (x == null) {
            return "" + x;
        }
        return x.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(x));
    }

    public static byte[] duplicateByteArray(byte[] in) {
        if (in == null) {
            return null;
        }
        return Util.duplicateByteArray(in, 0, in.length);
    }

    public static byte[] duplicateByteArray(byte[] in, int offset, int length) {
        if (in == null) {
            return null;
        }
        byte[] out = new byte[length];
        System.arraycopy(in, offset, out, 0, length);
        return out;
    }

    public static int getIntFromBytes(byte[] bytes, int offset, int byteCount) {
        int value = 0;
        switch (byteCount) {
            case 4: {
                value |= bytes[offset + 3] & 0xFF;
            }
            case 3: {
                value |= (bytes[offset + 2] & 0xFF) << 8;
            }
            case 2: {
                value |= (bytes[offset + 1] & 0xFF) << 16;
            }
            case 1: {
                value |= (bytes[offset + 0] & 0xFF) << 24;
                break;
            }
            default: {
                String msg = "byteCount is not between 1 and 4";
                IllegalArgumentException iae = new IllegalArgumentException("byteCount is not between 1 and 4");
                FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.Transaction.JTA.Util.getIntFromBytes", (String)"553");
                throw iae;
            }
        }
        return value >>= (4 - byteCount) * 8;
    }

    public static void setBytesFromInt(byte[] bytes, int offset, int byteCount, int value) {
        long maxval = (1L << 8 * byteCount) - 1L;
        if ((long)value > maxval) {
            String msg = "value too large for byteCount";
            IllegalArgumentException iae = new IllegalArgumentException("value too large for byteCount");
            FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.Transaction.JTA.Util.setBytesFromInt", (String)"579");
            throw iae;
        }
        switch (byteCount) {
            case 4: {
                bytes[offset++] = (byte)(value >> 24 & 0xFF);
            }
            case 3: {
                bytes[offset++] = (byte)(value >> 16 & 0xFF);
            }
            case 2: {
                bytes[offset++] = (byte)(value >> 8 & 0xFF);
            }
            case 1: {
                bytes[offset++] = (byte)(value & 0xFF);
                break;
            }
            default: {
                String msg = "byteCount is not between 1 and 4";
                IllegalArgumentException iae = new IllegalArgumentException("byteCount is not between 1 and 4");
                FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.Transaction.JTA.Util.setBytesFromInt", (String)"598");
                throw iae;
            }
        }
    }

    public static long getLongFromBytes(byte[] bytes, int offset) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getLongFromBytes: length = " + bytes.length + ", data = " + Util.toHexString(bytes)));
        }
        long result = -1L;
        if (bytes.length >= offset + 8) {
            result = ((bytes[0 + offset] & 0xFF) << 56) + ((bytes[1 + offset] & 0xFF) << 48) + ((bytes[2 + offset] & 0xFF) << 40) + ((bytes[3 + offset] & 0xFF) << 32) + ((bytes[4 + offset] & 0xFF) << 24) + ((bytes[5 + offset] & 0xFF) << 16) + ((bytes[6 + offset] & 0xFF) << 8) + (bytes[7 + offset] & 0xFF);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getLongFromBytes " + result));
        }
        return result;
    }

    public static byte[] longToBytes(long rmid) {
        return new byte[]{(byte)(rmid >> 56), (byte)(rmid >> 48), (byte)(rmid >> 40), (byte)(rmid >> 32), (byte)(rmid >> 24), (byte)(rmid >> 16), (byte)(rmid >> 8), (byte)rmid};
    }

    public static byte[] intToBytes(int rmid) {
        return new byte[]{(byte)(rmid >> 24), (byte)(rmid >> 16), (byte)(rmid >> 8), (byte)rmid};
    }

    public static String toHexString(byte[] b) {
        StringBuffer result = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            result.append(digits.charAt(b[i] >> 4 & 0xF));
            result.append(digits.charAt(b[i] & 0xF));
        }
        return result.toString();
    }

    public static boolean equal(byte[] a, byte[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static String byteArrayToString(byte[] b) {
        int l = b.length / 2;
        if (l * 2 != b.length) {
            throw new IllegalArgumentException();
        }
        StringBuffer result = new StringBuffer(l);
        int o = 0;
        for (int i = 0; i < l; ++i) {
            int i1 = b[o++] & 0xFF;
            int i2 = b[o++] & 0xFF;
            result.append((char)(i1 |= (i2 <<= 8)));
        }
        return result.toString();
    }

    public static String stackToDebugString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        String text = sw.toString();
        text = text.substring(text.indexOf("at"));
        return text;
    }
}

