/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.jta.impl.DirectEnlistXAResourceInfo;
import com.ibm.tx.jta.impl.PartnerLogData;
import com.ibm.tx.jta.impl.PartnerLogTable;
import com.ibm.tx.jta.impl.XARecoveryData;
import com.ibm.tx.jta.impl.XARecoveryWrapper;
import com.ibm.tx.jta.impl.XidImpl;
import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.Transaction.JTA.JTAResource;
import com.ibm.ws.Transaction.JTA.JTAResourceBase;
import com.ibm.ws.Transaction.JTA.JTAXAResource;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XAReturnCodeHelper;
import com.ibm.ws.Transaction.JTA.XARminst;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import java.io.Serializable;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class JTAXAResourceImpl
extends JTAResourceBase
implements JTAXAResource {
    private boolean _completed;
    private XARminst _recoveredRM;
    protected XARecoveryData _recoveryData;
    private boolean _recovery;
    private Integer _priority;
    private static final TraceComponent tc = Tr.register(JTAXAResourceImpl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final TraceComponent tcSummary = Tr.register((String)"TRANSUMMARY", (String)"TransactionSummary", null);

    public JTAXAResourceImpl(Xid xid, XAResource resource, XARecoveryData recoveryData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JTAXAResourceImpl", (Object)new Object[]{xid, resource, recoveryData});
        }
        this._xid = xid;
        this._resource = resource;
        this._recoveryData = recoveryData;
        this.traceCreate();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"JTAXAResourceImpl", (Object)this);
        }
    }

    public JTAXAResourceImpl(PartnerLogTable plt, byte[] tid, byte[] logData) throws Exception {
        PartnerLogData pld;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JTAXAResourceImpl", (Object)new Object[]{plt, Util.toHexString(tid), Util.toHexString(logData)});
        }
        byte[] stoken = Util.duplicateByteArray(logData, 0, 8);
        int recoveryId = Util.getIntFromBytes(logData, 8, 4);
        int seqNo = Util.getIntFromBytes(logData, 12, 2);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("recovered stoken is " + Util.toHexString(stoken)));
            Tr.debug((TraceComponent)tc, (String)("recovered recoveryId is " + recoveryId));
            Tr.debug((TraceComponent)tc, (String)("recovered seqNo is " + seqNo));
        }
        if (!((pld = plt.findEntry(recoveryId)) instanceof XARecoveryData)) {
            throw new Exception("Invalid Xid/recoveryId in transaction log");
        }
        this._recoveryData = (XARecoveryData)pld;
        pld.incrementCount();
        this._xid = new XidImpl(tid, seqNo, stoken);
        this._state = 3;
        this._recovery = true;
        this._vote = JTAResource.JTAResourceVote.commit;
        this.traceCreate();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"JTAXAResourceImpl", (Object)this);
        }
    }

    @Override
    public final int prepare() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepare", (Object)new Object[]{this._resource, this._xid});
        }
        if (tcSummary.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcSummary, (String)"xa_prepare", (Object)this);
        }
        int rc = -1;
        try {
            try {
                this._recoveryData.logRecoveryEntry();
            }
            catch (Exception e) {
                throw new XAException(-5);
            }
            rc = this._resource.prepare(this._xid);
            if (rc == 0) {
                this._vote = JTAResource.JTAResourceVote.commit;
                int e = rc;
                return e;
            }
            if (rc == 3) {
                this._vote = JTAResource.JTAResourceVote.readonly;
                this.destroy();
                int e = rc;
                return e;
            }
        }
        catch (XAException xae) {
            this._prepareXARC = xae.errorCode;
            FFDCFilter.processException((Throwable)xae, (String)"com.ibm.ws.Transaction.JTA.JTAXAResourceImpl.prepare", (String)"259", (Object)this);
            if (this._prepareXARC >= 100 && this._prepareXARC <= 107) {
                this._vote = JTAResource.JTAResourceVote.rollback;
            } else if (this._prepareXARC == -7) {
                this._state = 3;
            }
            throw xae;
        }
        finally {
            if (tc.isEntryEnabled()) {
                if (this._vote != null) {
                    Tr.exit((TraceComponent)tc, (String)"prepare", (Object)(XAReturnCodeHelper.convertXACode(rc) + " (" + this._vote.name() + ")"));
                } else {
                    Tr.exit((TraceComponent)tc, (String)"prepare", (Object)XAReturnCodeHelper.convertXACode(rc));
                }
            }
            if (tcSummary.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcSummary, (String)("xa_prepare result: " + XAReturnCodeHelper.convertXACode(rc)));
            }
        }
        throw new XAException(-5);
    }

    @Override
    public final void commit() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit", (Object)new Object[]{this._resource, this._xid, this.getPriority()});
        }
        if (tcSummary.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcSummary, (String)"xa_commit", (Object)this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Committing resource with priority " + this.getPriority()));
        }
        try {
            if (this._state == 3) {
                this._resource = this.reconnectRM();
            }
            this._resource.commit(this._xid, false);
            this._completedCommit = true;
            this.destroy();
        }
        catch (XAException xae) {
            this._completionXARC = xae.errorCode;
            FFDCFilter.processException((Throwable)xae, (String)"com.ibm.ws.Transaction.JTA.JTAXAResourceImpl.commit", (String)"317", (Object)this);
            throw xae;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit");
            }
            if (tcSummary.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcSummary, (String)("xa_commit result: " + XAReturnCodeHelper.convertXACode(this._completionXARC)));
            }
        }
    }

    @Override
    public final void commit_one_phase() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit_one_phase", (Object)new Object[]{this._resource, this._xid});
        }
        if (tcSummary.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcSummary, (String)"commit_one_phase", (Object)this);
        }
        try {
            this._resource.commit(this._xid, true);
            this._completedCommit = true;
            this._vote = JTAResource.JTAResourceVote.commit;
            this.destroy();
        }
        catch (XAException xae) {
            this._completionXARC = xae.errorCode;
            FFDCFilter.processException((Throwable)xae, (String)"com.ibm.ws.Transaction.JTA.JTAXAResourceImpl.commit_one_phase", (String)"354", (Object)this);
            throw xae;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit_one_phase", (Object)this._completionXARC);
            }
            if (tcSummary.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcSummary, (String)("commit_one_phase result: " + XAReturnCodeHelper.convertXACode(this._completionXARC)));
            }
        }
    }

    @Override
    public final void rollback() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollback", (Object)new Object[]{this._resource, this._xid});
        }
        if (tcSummary.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcSummary, (String)"xa_rollback", (Object)this);
        }
        try {
            if (this._state == 3) {
                this._resource = this.reconnectRM();
            }
            this._resource.rollback(this._xid);
            this.destroy();
        }
        catch (XAException xae) {
            this._completionXARC = xae.errorCode;
            FFDCFilter.processException((Throwable)xae, (String)"com.ibm.ws.Transaction.JTA.JTAXAResourceImpl.rollback", (String)"386", (Object)this);
            throw xae;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"rollback");
            }
            if (tcSummary.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcSummary, (String)("xa_rollback result: " + XAReturnCodeHelper.convertXACode(this._completionXARC)));
            }
        }
    }

    @Override
    public final void forget() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forget", (Object)new Object[]{this._resource, this._xid});
        }
        if (tcSummary.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcSummary, (String)"xa_forget", (Object)this);
        }
        int rc = -1;
        try {
            if (!this._completed && this._resource != null) {
                if (this._state == 3) {
                    this._resource = this.reconnectRM();
                }
                this._resource.forget(this._xid);
                rc = 0;
                this.destroy();
            }
        }
        catch (XAException xae) {
            rc = xae.errorCode;
            throw xae;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"forget");
            }
            if (tcSummary.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcSummary, (String)("xa_rollback result: " + XAReturnCodeHelper.convertXACode(rc)));
            }
        }
    }

    @Override
    public void log(RecoverableUnitSection rus) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"log", (Object)new Object[]{this, rus});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("about to log stoken " + Util.toHexString(((XidImpl)this._xid).getStoken())));
            Tr.debug((TraceComponent)tc, (String)("about to log recoveryId " + this.getRecoveryId()));
            Tr.debug((TraceComponent)tc, (String)("about to log seqNo " + ((XidImpl)this._xid).getSequenceNumber()));
            Tr.debug((TraceComponent)tc, (String)("ID from pld " + this._recoveryData._recoveryId));
        }
        byte[] stoken = ((XidImpl)this._xid).getStoken();
        int recoveryId = (int)this.getRecoveryId();
        int seqNo = ((XidImpl)this._xid).getSequenceNumber();
        byte[] data = new byte[stoken.length + 6];
        System.arraycopy(stoken, 0, data, 0, stoken.length);
        Util.setBytesFromInt(data, stoken.length, 4, recoveryId);
        Util.setBytesFromInt(data, stoken.length + 4, 2, seqNo);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("logging stoken " + Util.toHexString(stoken)));
            Tr.debug((TraceComponent)tc, (String)("logging recoveryId " + recoveryId));
            Tr.debug((TraceComponent)tc, (String)("logging seqNo " + seqNo));
            Tr.debug((TraceComponent)tc, (String)"Actual data logged", (Object)Util.toHexString(data));
        }
        try {
            rus.addData(data);
        }
        catch (Exception exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.Transaction.JTA.JTAXAResourceImpl.log", (String)"326", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Exception raised adding data to the transaction log", (Object)exc);
            }
            throw new SystemException(exc.toString());
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"log");
            }
        }
    }

    @Override
    public long getRecoveryId() {
        if (this._recoveryData != null) {
            return this._recoveryData._recoveryId;
        }
        return -1L;
    }

    @Override
    public int getPriority() {
        if (this._priority != null) {
            return this._priority;
        }
        if (this._recoveryData != null) {
            return this._recoveryData.getPriority();
        }
        return 0;
    }

    public boolean getCompleted() {
        return this._completed;
    }

    @Override
    public final void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy", (Object)new Object[]{this._resource, this._xid});
        }
        if (!this._completed) {
            if (this._recoveredRM != null) {
                this._recoveredRM.closeConnection();
                this._recoveredRM = null;
                if (this._recovery && this._recoveryData != null) {
                    this._recoveryData.decrementCount();
                }
            }
            this._completed = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    XAResource reconnectRM() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reconnectRM");
        }
        XAResource resource = null;
        XARecoveryWrapper wrapper = null;
        if (this._recoveryData != null) {
            wrapper = this._recoveryData.getXARecoveryWrapper();
        }
        if (wrapper == null && this._recovery) {
            XAException xae = new XAException(4);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reconnectRM", (Object)xae);
            }
            throw xae;
        }
        if (this._recoveredRM != null) {
            this._recoveredRM.closeConnection();
            this._recoveredRM = null;
        }
        if (wrapper != null) {
            try {
                this._recoveredRM = this._recoveryData.getXARminst();
            }
            catch (XAException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.Transaction.JTA.JTAXAResourceImpl.reconnectRM", (String)"607", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"reconnectRM", (Object)XAReturnCodeHelper.convertXACode(e.errorCode));
                }
                XAException xae = e;
                if (e.errorCode == -3) {
                    xae = (XAException)new XAException(-7).initCause(e);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"reconnectRM", (Object)xae);
                }
                throw xae;
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.Transaction.JTA.JTAXAResourceImpl.reconnectRM", (String)"524", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"reconnectRM caught ", (Object)t);
                }
                XAException xae = (XAException)new XAException(-7).initCause(t);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"reconnectRM", (Object)xae);
                }
                throw xae;
            }
            if (this._recoveredRM != null) {
                resource = this._recoveredRM.getXaResource();
            }
            if (resource != null) {
                this._state = 5;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reconnectRM", resource);
        }
        return resource;
    }

    public final String toString() {
        String tail = this._xid == null ? "" : "#" + this._xid.toString() + ", priority=" + this.getPriority();
        return this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)) + tail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JTAXAResourceImpl && this._resource != null) {
            return this._resource.equals(((JTAXAResourceImpl)o)._resource);
        }
        return super.equals(o);
    }

    @Override
    public String describe() {
        Serializable xaResInfo = this.getXAResourceInfo();
        if (xaResInfo == null) {
            return null;
        }
        if (xaResInfo instanceof DirectEnlistXAResourceInfo) {
            return ((DirectEnlistXAResourceInfo)xaResInfo).getXAResource().toString();
        }
        return xaResInfo.toString();
    }

    public Serializable getXAResourceInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getXAResourceInfo");
        }
        XARecoveryWrapper wrapper = null;
        if (this._recoveryData != null) {
            wrapper = this._recoveryData.getXARecoveryWrapper();
        }
        if (wrapper != null) {
            Serializable xari = wrapper.getXAResourceInfo();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getXAResourceInfo", (Object)xari);
            }
            return xari;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getXAResourceInfo", (Object)"still no wrapper");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getXAResourceInfo", null);
        }
        return null;
    }
}

