/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.jta.TransactionManagerFactory;
import com.ibm.tx.jta.impl.JCARecoveryData;
import com.ibm.tx.jta.impl.JCATranWrapper;
import com.ibm.tx.jta.impl.TranManagerSet;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.jta.impl.TxXATerminator;
import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.Transaction.JTA.HeuristicHazardException;
import com.ibm.ws.Transaction.JTA.ResourceWrapper;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class JCATranWrapperImpl
implements JCATranWrapper {
    private static final TraceComponent tc = Tr.register(JCATranWrapperImpl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected TransactionImpl _txn;
    protected TranManagerSet _tranManager;
    protected boolean _prepared;
    protected boolean _associated;
    protected int _heuristic;
    protected int _suspendedUOWType;
    protected Object _suspendedUOW;

    protected JCATranWrapperImpl() {
    }

    public JCATranWrapperImpl(TransactionImpl transactionImpl, boolean prepared, boolean associated) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JCATranWrapper", (Object)new Object[]{transactionImpl, prepared, associated});
        }
        this._tranManager = (TranManagerSet)TransactionManagerFactory.getTransactionManager();
        this._txn = transactionImpl;
        this._prepared = prepared;
        this._associated = associated;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"JCATranWrapper", (Object)this);
        }
    }

    public JCATranWrapperImpl(int timeout, Xid xid, JCARecoveryData jcard) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JCATranWrapper", (Object)new Object[]{timeout, xid, jcard});
        }
        this._tranManager = (TranManagerSet)TransactionManagerFactory.getTransactionManager();
        this.suspend();
        this._txn = new TransactionImpl(timeout, xid, jcard);
        this._prepared = false;
        this._associated = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"JCATranWrapper", (Object)this);
        }
    }

    @Override
    public int prepare(TxXATerminator xat) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepare", (Object)this._txn);
        }
        if (this._tranManager.isReplayComplete()) {
            this.suspend();
            try {
                this._tranManager.resume(this._txn);
            }
            catch (InvalidTransactionException e) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"prepare", (Object)new Object[]{"resume threw InvalidTransactionException", e});
                }
                this.resume();
                throw new XAException(-3);
            }
            catch (IllegalStateException e) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"prepare", (Object)new Object[]{"resume threw IllegalStateException", e});
                }
                this.resume();
                throw new XAException(-6);
            }
            this._txn.setJCARecoveryData(xat.getJCARecoveryData());
            try {
                int state = this._txn.internalPrepare();
                switch (state) {
                    case 2: {
                        this._prepared = true;
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"prepare", (Object)"XAResource.XA_OK");
                        }
                        int n = 0;
                        return n;
                    }
                    case 4: {
                        this._txn.notifyCompletion();
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"prepare", (Object)"XAResource.XA_RDONLY");
                        }
                        int n = 3;
                        return n;
                    }
                }
                try {
                    this._txn.internalRollback();
                    this._txn.notifyCompletion();
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"prepare", (Object)"throwing XA_RBROLLBACK");
                    }
                    throw new XAException(100);
                }
                catch (HeuristicMixedException e) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"prepare", (Object)"internalPrepare threw HeuristicMixedException");
                    }
                    try {
                        this._txn.internalRollback();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    throw new XAException(5);
                }
                catch (HeuristicHazardException e) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"prepare", (Object)"internalPrepare threw HeuristicHazardException");
                    }
                    try {
                        this._txn.internalRollback();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new XAException(8);
                }
                catch (HeuristicRollbackException e) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"prepare", (Object)"internalPrepare threw HeuristicRollbackException");
                    }
                    throw new XAException(6);
                }
                catch (HeuristicCommitException e) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"prepare", (Object)"internalPrepare threw HeuristicCommitException");
                    }
                    throw new XAException(7);
                }
                catch (IllegalStateException e) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"prepare", (Object)"internalPrepare threw IllegalStateException");
                    }
                    throw new XAException(-6);
                }
                catch (SystemException e) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"prepare", (Object)"internalPrepare threw SystemException");
                    }
                    throw new XAException(-3);
                }
            }
            finally {
                this._tranManager.suspend();
                this.resume();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepare", (Object)"replay not finished");
        }
        throw new XAException(-7);
    }

    @Override
    public void commit() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit", (Object)this._txn);
        }
        if (this._tranManager.isReplayComplete()) {
            int state = this._txn.getTransactionState().getState();
            switch (state) {
                case 2: {
                    try {
                        this.suspend();
                        try {
                            this._tranManager.resume(this._txn);
                        }
                        catch (InvalidTransactionException e) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"prepare", (Object)new Object[]{"resume threw InvalidTransactionException", e});
                            }
                            this.resume();
                            throw new XAException(-3);
                        }
                        catch (IllegalStateException e) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"prepare", (Object)new Object[]{"resume threw IllegalStateException", e});
                            }
                            this.resume();
                            throw new XAException(-6);
                        }
                        this._txn.getTransactionState().setState(3);
                        this._txn.internalCommit();
                        this._txn.notifyCompletion();
                        break;
                    }
                    catch (HeuristicMixedException e) {
                        this._heuristic = 10;
                        break;
                    }
                    catch (HeuristicHazardException e) {
                        this._heuristic = 11;
                        break;
                    }
                    catch (HeuristicRollbackException e) {
                        this._heuristic = 9;
                        break;
                    }
                    catch (SystemException e) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"commit", (Object)"internalCommit threw SystemException");
                        }
                        throw new XAException(-3);
                    }
                    finally {
                        this.resume();
                    }
                }
                case 7: 
                case 8: {
                    this._heuristic = this._txn.getResources().getHeuristicOutcome();
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("Heuristic was: " + ResourceWrapper.printResourceStatus(this._heuristic)));
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    this._heuristic = 9;
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"commit", (Object)"transaction is not in a prepared state");
                    }
                    throw new XAException(-6);
                }
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit", (Object)"throwing XAER_RMFAIL");
            }
            throw new XAException(-7);
        }
        this.recordHeuristicOnCommit();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commit");
        }
    }

    protected void recordHeuristicOnCommit() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recordHeuristicOnCommit", (Object)this);
        }
        switch (this._heuristic) {
            case 0: {
                break;
            }
            case 8: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Swallowing HEURISTIC_COMMIT");
                }
                this._txn.notifyCompletion();
                break;
            }
            case 9: {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"recordHeuristicOnCommit", (Object)"throwing XA_HEURB");
                }
                throw new XAException(6);
            }
            case 11: {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"recordHeuristicOnCommit", (Object)"throwing XA_HEURHAZ");
                }
                throw new XAException(8);
            }
            default: {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"recordHeuristicOnCommit", (Object)"throwing XA_HEURMIX");
                }
                throw new XAException(5);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recordHeuristicOnCommit");
        }
    }

    @Override
    public void commitOnePhase() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commitOnePhase", (Object)this._txn);
        }
        int state = this._txn.getTransactionState().getState();
        switch (state) {
            case 0: {
                this.suspend();
                try {
                    this._tranManager.resume(this._txn);
                    this._txn.prolongFinish();
                    this._txn.commit_one_phase();
                    this._txn.notifyCompletion();
                    break;
                }
                catch (RollbackException e) {
                    this._txn.notifyCompletion();
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"commitOnePhase", (Object)"commit threw RollbackException");
                    }
                    throw new XAException(100);
                }
                catch (HeuristicMixedException e) {
                    this._heuristic = 10;
                    break;
                }
                catch (HeuristicHazardException e) {
                    this._heuristic = 11;
                    break;
                }
                catch (HeuristicRollbackException e) {
                    this._heuristic = 9;
                    break;
                }
                catch (IllegalStateException e) {
                    this._txn.notifyCompletion();
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"commitOnePhase", (Object)"commit threw IllegalStateException");
                    }
                    throw new XAException(-6);
                }
                catch (InvalidTransactionException e) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"commitOnePhase", (Object)"commit threw InvalidTransactionException");
                    }
                    throw new XAException(-3);
                }
                catch (SystemException e) {
                    this._txn.notifyCompletion();
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"commitOnePhase", (Object)"commit threw SystemException");
                    }
                    throw new XAException(-3);
                }
                finally {
                    this.resume();
                }
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                this._heuristic = 9;
                break;
            }
            case 7: {
                this._heuristic = 8;
                break;
            }
            case -1: {
                break;
            }
            default: {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"commitOnePhase", (Object)"transaction is in an incorrect state");
                }
                throw new XAException(-6);
            }
        }
        this.recordHeuristicOnCommitOnePhase();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commitOnePhase");
        }
    }

    protected void recordHeuristicOnCommitOnePhase() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recordHeuristicOnCommitOnePhase", (Object)this);
        }
        switch (this._heuristic) {
            case 0: {
                break;
            }
            case 9: {
                this._txn.notifyCompletion();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"recordHeuristicOnCommitOnePhase", (Object)"heuristic rollback");
                }
                throw new XAException(100);
            }
            case 10: {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"recordHeuristicOnCommitOnePhase", (Object)"heuristic mixed");
                }
                throw new XAException(5);
            }
            default: {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"recordHeuristicOnCommitOnePhase", (Object)"heuristic hazard");
                }
                throw new XAException(8);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recordHeuristicOnCommitOnePhase");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollback", (Object)this._txn);
        }
        if (this._prepared && !this._tranManager.isReplayComplete()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"throwing XAER_RMFAIL(1)");
            }
            throw new XAException(-7);
        }
        int state = this._txn.getTransactionState().getState();
        switch (state) {
            case 0: 
            case 2: {
                try {
                    this.suspend();
                    try {
                        this._tranManager.resume(this._txn);
                    }
                    catch (InvalidTransactionException e) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"prepare", (Object)new Object[]{"resume threw InvalidTransactionException", e});
                        }
                        this.resume();
                        throw new XAException(-3);
                    }
                    catch (IllegalStateException e) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"prepare", (Object)new Object[]{"resume threw IllegalStateException", e});
                        }
                        this.resume();
                        throw new XAException(-6);
                    }
                    this._txn.getTransactionState().setState(5);
                    this._txn.cancelAlarms();
                    this._txn.internalRollback();
                    this._txn.notifyCompletion();
                    break;
                }
                catch (IllegalStateException e) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"throwing XAER_PROTO(1)");
                    }
                    throw new XAException(-6);
                }
                catch (SystemException e) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"throwing XAER_RMERR");
                    }
                    throw new XAException(-3);
                }
                catch (HeuristicMixedException e) {
                    this._heuristic = 10;
                    break;
                }
                catch (HeuristicHazardException e) {
                    this._heuristic = 11;
                    break;
                }
                catch (HeuristicCommitException e) {
                    this._heuristic = 8;
                    break;
                }
                finally {
                    this.resume();
                }
            }
            case 7: 
            case 8: {
                this._heuristic = this._txn.getResources().getHeuristicOutcome();
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case -1: {
                break;
            }
            default: {
                this._txn.notifyCompletion();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"throwing XAER_PROTO(2)");
                }
                throw new XAException(-6);
            }
        }
        this.recordHeuristicOnRollback();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rollback");
        }
    }

    protected void recordHeuristicOnRollback() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recordHeuristicOnRollback", (Object)this);
        }
        switch (this._heuristic) {
            case 0: {
                break;
            }
            case 9: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Swallowing HEURISTIC_ROLLBACK");
                }
                this._txn.notifyCompletion();
                break;
            }
            case 11: {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"recordHeuristicOnRollback", (Object)"throwing XA_HEURHAZ");
                }
                throw new XAException(8);
            }
            case 8: {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"recordHeuristicOnRollback", (Object)"throwing XA_HEURCOM");
                }
                throw new XAException(7);
            }
            default: {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"recordHeuristicOnRollback", (Object)"throwing XA_HEURMIX");
                }
                throw new XAException(5);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recordHeuristicOnRollback");
        }
    }

    @Override
    public synchronized void forget() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forget", (Object)this._txn);
        }
        if (!this._tranManager.isReplayComplete()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"forget", (Object)"throwing XAER_RMFAIL");
            }
            throw new XAException(-7);
        }
        this._heuristic = 0;
        this._txn.notifyCompletion();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"forget");
        }
    }

    @Override
    public void suspend() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"suspend");
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"suspending (global)");
        }
        this._suspendedUOW = this._tranManager.suspend();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"suspend", (Object)this._suspendedUOWType);
        }
    }

    @Override
    public void resume() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"resume");
            }
            try {
                this._tranManager.resume((Transaction)this._suspendedUOW);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.Transaction.JTA.JCATranWrapperImpl.resume", (String)"733", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Failed to resume", (Object)new Object[]{this._suspendedUOW, e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resume");
        }
    }

    @Override
    public TransactionImpl getTransaction() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTransaction", (Object)this._txn);
        }
        return this._txn;
    }

    @Override
    public boolean isPrepared() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isPrepared", (Object)this._prepared);
        }
        return this._prepared;
    }

    @Override
    public boolean hasAssociation() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"hasAssociation", (Object)this._associated);
        }
        return this._associated;
    }

    @Override
    public void addAssociation() {
        this._associated = true;
    }

    @Override
    public void removeAssociation() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"removeAssociation", (Object)this._associated);
        }
        this._associated = false;
    }

    public String toString() {
        return this._prepared + ":" + this._associated + ":" + this._heuristic + ":" + this._txn.toString();
    }
}

