/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.utils.LoggingUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public final class SessionProperties {
    private static final String methodClassName = "SessionProperties";
    private static final HashMap<String, String> FullyQualifiedPropertiesMap = new HashMap();

    private SessionProperties() {
    }

    public static void setPropertiesInSMC(SessionManagerConfig smc, Map<String, Object> xtpProperties) {
        Boolean booleanProp;
        String methodName = "setPropertiesInSMC";
        String invalidPropFoundMessage = "SessionContext.invalidPropertyFound";
        String invalidCloneSeparatorMessage = "SessionContext.invalidCloneSeparator";
        String strProp = null;
        Integer integerProp = null;
        boolean baseServerLevelConfig = smc.isUsingWebContainerSM();
        SessionProperties.setDefaultConfiguration(smc, xtpProperties);
        String propIdLengthForSys = "HttpSessionIDLength";
        String propIdLength = "idLength";
        int idLength = -1;
        Object propIdLengthValue = xtpProperties.get("idLength");
        if (propIdLengthValue instanceof Integer) {
            integerProp = (Integer)propIdLengthValue;
        } else {
            strProp = (String)propIdLengthValue;
            if (strProp == null && (strProp = SessionProperties.getSystemProperty("idLength")) == null) {
                strProp = SessionProperties.getSystemProperty("HttpSessionIDLength");
            }
        }
        if (integerProp != null || strProp != null) {
            try {
                idLength = integerProp != null ? integerProp : Integer.parseInt(strProp);
                if (idLength < 8 || idLength > 128) {
                    if (idLength < 8) {
                        idLength = 8;
                    }
                    if (idLength > 128) {
                        idLength = 128;
                    }
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, "setPropertiesInSMC", "SessionContext.valueOutOfRange", new Object[]{"idLength", strProp, new Integer(idLength)});
                }
                if (SessionProperties.shouldSetAndDoLogging("idLength", true, baseServerLevelConfig, xtpProperties, new Integer(idLength), new Integer(SessionManagerConfig.getSessionIDLength()), false)) {
                    SessionManagerConfig.setSessionIDLength(idLength);
                }
            }
            catch (NumberFormatException nfe) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, "setPropertiesInSMC", "SessionContext.invalidPropertyFound", new Object[]{"idLength", strProp});
            }
        }
        String propIdReuse = "HttpSessionIdReuse";
        strProp = SessionProperties.getStringProperty("HttpSessionIdReuse", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("HttpSessionIdReuse", true, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), SessionManagerConfig.isIdReuse(), false)) {
            SessionManagerConfig.setIdReuse(booleanProp);
        }
        String propTrackGC = "HttpSessionTrackGC";
        strProp = SessionProperties.getStringProperty("HttpSessionTrackGC", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("HttpSessionTrackGC", false, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), null, false)) {
            smc.setTrackGCCount(booleanProp);
        }
        String propReaperPollInt = "HttpSessionReaperPollInterval";
        strProp = SessionProperties.getStringProperty("HttpSessionReaperPollInterval", xtpProperties);
        long longProp = -1L;
        try {
            if (strProp != null && SessionProperties.shouldSetAndDoLogging("HttpSessionReaperPollInterval", false, baseServerLevelConfig, xtpProperties, strProp, null, false)) {
                longProp = new Long(strProp);
                smc.setReaperPollInterval(longProp);
            }
        }
        catch (NumberFormatException nfe) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.SEVERE, methodClassName, "setPropertiesInSMC", "SessionContext.invalidPropertyFound", new Object[]{"HttpSessionReaperPollInterval", strProp});
        }
        String propUseRecentInvalId = "UseInvalidatedId";
        strProp = SessionProperties.getStringProperty("UseInvalidatedId", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("UseInvalidatedId", false, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), null, false)) {
            smc.setCheckRecentlyInvalidList(booleanProp);
        }
        String propDebugSessCross = "DebugSessionCrossover";
        strProp = SessionProperties.getStringProperty("DebugSessionCrossover", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("DebugSessionCrossover", false, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), null, false)) {
            smc.setDebugSessionCrossover(booleanProp);
            if ((baseServerLevelConfig || xtpProperties.get("DebugSessionCrossover") != null) && booleanProp.booleanValue()) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.INFO, methodClassName, "setPropertiesInSMC", "SessionContext.DebugCrossoverEnabled");
            }
        }
        String propSessRewrite = "SessionRewriteIdentifier";
        strProp = SessionProperties.getStringProperty("SessionRewriteIdentifier", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("SessionRewriteIdentifier", false, baseServerLevelConfig, xtpProperties, strProp, null, false)) {
            smc.setSessUrlRewritePrefix(";" + strProp + "=");
        }
        String propHttpSessionCloneId = "HttpSessionCloneId";
        strProp = SessionProperties.getStringProperty("HttpSessionCloneId", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("HttpSessionCloneId", true, baseServerLevelConfig, xtpProperties, strProp, SessionManagerConfig.getCloneId(), strProp.equals(SessionManagerConfig.getCloneId()))) {
            SessionManagerConfig.setCloneId(strProp);
            SessionManagerConfig.setCloneIdPropertySet(true);
        }
        String propNoAddSessInfo = "NoAdditionalSessionInfo";
        strProp = SessionProperties.getStringProperty("NoAdditionalSessionInfo", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("NoAdditionalSessionInfo", true, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), SessionManagerConfig.isTurnOffCacheId(), false)) {
            SessionManagerConfig.setTurnOffCacheId(booleanProp);
            SessionManagerConfig.setTurnOffCloneId(booleanProp);
            if (smc.isUsingMemory()) {
                SessionManagerConfig.setCacheIdLength(0);
            }
        }
        String propSessIdMax = "SessionIdentifierMaxLength";
        strProp = SessionProperties.getStringProperty("SessionIdentifierMaxLength", xtpProperties);
        if (strProp != null) {
            try {
                int maxLength = Integer.parseInt(strProp);
                if (SessionProperties.shouldSetAndDoLogging("SessionIdentifierMaxLength", true, baseServerLevelConfig, xtpProperties, new Integer(maxLength), new Integer(SessionManagerConfig.getMaxSessionIdentifierLength()), false)) {
                    SessionManagerConfig.setMaxSessionIdentifierLength(maxLength);
                }
            }
            catch (NumberFormatException nfe) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, "setPropertiesInSMC", "SessionContext.invalidPropertyFound", new Object[]{"SessionIdentifierMaxLength", strProp});
            }
        }
        String propCloneSepChange = "CloneSeparatorChange";
        strProp = SessionProperties.getStringProperty("CloneSeparatorChange", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("CloneSeparatorChange", true, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), '+' == SessionManagerConfig.getCloneSeparator(), false) && booleanProp.booleanValue()) {
            SessionManagerConfig.setCloneSeparator('+');
        }
        String propCloneSeparator = "CloneSeparator";
        strProp = SessionProperties.getStringProperty("CloneSeparator", xtpProperties);
        if (strProp != null) {
            if (strProp.length() == 1 && strProp.trim().length() == 1) {
                if (SessionProperties.shouldSetAndDoLogging("CloneSeparator", true, baseServerLevelConfig, xtpProperties, strProp, null, false)) {
                    char charProp = strProp.charAt(0);
                    SessionManagerConfig.setCloneSeparator(charProp);
                }
            } else {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, "setPropertiesInSMC", "SessionContext.invalidCloneSeparator", new Object[]{strProp});
            }
        }
        String propNoAffSwitch = "NoAffinitySwitchBack";
        strProp = SessionProperties.getStringProperty("NoAffinitySwitchBack", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("NoAffinitySwitchBack", true, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), SessionManagerConfig.isNoAffinitySwitchBack(), false)) {
            SessionManagerConfig.setNoAffinitySwitchBack(booleanProp);
        }
        String propUseOracleBlob = "UseOracleBLOB";
        strProp = SessionProperties.getStringProperty("UseOracleBLOB", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("UseOracleBLOB", false, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), null, false)) {
            smc.setUseOracleBlob(booleanProp);
        }
        String propSessionTableSkipIndexCreation = "SessionTableSkipIndexCreation";
        strProp = SessionProperties.getStringProperty("SessionTableSkipIndexCreation", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("SessionTableSkipIndexCreation", false, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), null, false)) {
            smc.setSessionTableSkipIndexCreation(booleanProp);
        }
        String propCheckSessionNewOnIsValidRequest = "CheckSessionNewOnIsValidRequest";
        strProp = SessionProperties.getStringProperty("CheckSessionNewOnIsValidRequest", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("CheckSessionNewOnIsValidRequest", false, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), null, false)) {
            smc.setCheckSessionNewOnIsValidRequest(booleanProp);
        }
        String propUsingCurrentSchemaCustomProperty = "UsingCustomSchemaName";
        strProp = SessionProperties.getStringProperty("UsingCustomSchemaName", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("UsingCustomSchemaName", false, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), null, false)) {
            smc.setUsingCustomSchemaName(booleanProp);
        }
        String propHideSessVals = "HideSessionValues";
        strProp = SessionProperties.getStringProperty("HideSessionValues", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("HideSessionValues", true, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), SessionManagerConfig.isHideSessionValues(), false)) {
            SessionManagerConfig.setHideSessionValues(booleanProp);
            SessionManagerConfig.setHideSessionValuesPropertySet(true);
        }
        String propDoRemoteInval = "DoRemoteInvalidations";
        strProp = SessionProperties.getStringProperty("DoRemoteInvalidations", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("DoRemoteInvalidations", true, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), SessionManagerConfig.isDoRemoteInvalidations(), false)) {
            SessionManagerConfig.setDoRemoteInvalidations(booleanProp);
        }
        String propSessTable = "SessionTableName";
        strProp = SessionProperties.getStringProperty("SessionTableName", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("SessionTableName", false, baseServerLevelConfig, xtpProperties, strProp, null, false)) {
            smc.setTableNameValue(strProp);
        }
        String propZosBaseServerReplication = "HttpSessionEnableUnmanagedServerReplication";
        strProp = SessionProperties.getStringProperty("HttpSessionEnableUnmanagedServerReplication", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("HttpSessionEnableUnmanagedServerReplication", false, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), null, false)) {
            smc.setZosBaseServerReplicationEnabled(booleanProp);
        }
        String propServlet21SessionCompat = "Servlet21SessionCompatibility";
        strProp = SessionProperties.getStringProperty("Servlet21SessionCompatibility", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("Servlet21SessionCompatibility", true, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), SessionManagerConfig.getServlet21SessionCompatibility(), false)) {
            SessionManagerConfig.setServlet21SessionCompatibility(booleanProp);
        }
        String propAlwaysEncode = "AlwaysEncodeURL";
        strProp = SessionProperties.getStringProperty("AlwaysEncodeURL", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("AlwaysEncodeURL", true, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), SessionManagerConfig.isAlwaysEncodeURL(), false)) {
            SessionManagerConfig.setAlwaysEncodeURL(booleanProp);
        }
        String propCheckSessionCookieNameOnEncodeURL = "CheckSessionCookieNameOnEncodeURL";
        strProp = SessionProperties.getStringProperty("CheckSessionCookieNameOnEncodeURL", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("CheckSessionCookieNameOnEncodeURL", true, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), SessionManagerConfig.checkSessionCookieNameOnEncodeURL(), false)) {
            SessionManagerConfig.setCheckSessionCookieNameOnEncodeURL(booleanProp);
        }
        String propOptimizeCacheIdIncrements = "OptimizeCacheIdIncrements";
        strProp = SessionProperties.getStringProperty("OptimizeCacheIdIncrements", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("OptimizeCacheIdIncrements", false, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), null, false)) {
            smc.setOptimizeCacheIdIncrements(booleanProp);
        }
        String propOnlyCheckInCacheDuringPreInvoke = "OnlyCheckInCacheDuringPreInvoke";
        strProp = SessionProperties.getStringProperty("OnlyCheckInCacheDuringPreInvoke", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("OnlyCheckInCacheDuringPreInvoke", false, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), null, false)) {
            smc.setOnlyCheckInCacheDuringPreInvoke(booleanProp);
        }
        String propEnableHotFailover = "EnableHotFailover";
        strProp = SessionProperties.getStringProperty("EnableHotFailover", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("EnableHotFailover", true, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), SessionManagerConfig.isEnableHotFailover(), false)) {
            SessionManagerConfig.setEnableHotFailover(booleanProp);
        }
        String propForceSessionInvalidationMultiple = "ForceSessionInvalidationMultiple";
        strProp = SessionProperties.getStringProperty("ForceSessionInvalidationMultiple", xtpProperties);
        if (strProp != null) {
            try {
                int invalMult = new Integer(strProp);
                if (SessionProperties.shouldSetAndDoLogging("ForceSessionInvalidationMultiple", false, baseServerLevelConfig, xtpProperties, new Integer(invalMult), null, false)) {
                    smc.setForceSessionInvalidationMultiple(invalMult);
                }
            }
            catch (NumberFormatException nfe) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, "setPropertiesInSMC", "SessionContext.invalidPropertyFound", new Object[]{"ForceSessionInvalidationMultiple", strProp});
            }
        }
        String propPersistSessionAfterPassivation = "PersistSessionAfterPassivation";
        strProp = SessionProperties.getStringProperty("PersistSessionAfterPassivation", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("PersistSessionAfterPassivation", false, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), null, false)) {
            smc.setPersistSessionAfterPassivation(booleanProp);
        }
        String propUsingApplicationSessionsAndInvalidateAll = "UsingApplicationSessionsAndInvalidateAll";
        strProp = SessionProperties.getStringProperty("UsingApplicationSessionsAndInvalidateAll", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("UsingApplicationSessionsAndInvalidateAll", true, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), SessionManagerConfig.getUsingApplicationSessionsAndInvalidateAll(), false)) {
            SessionManagerConfig.setUsingApplicationSessionsAndInvalidateAll(booleanProp);
        }
        String propUsingApplicationSessionsAlwaysRetrieve = "UsingApplicationSessionsAlwaysRetrieve";
        strProp = SessionProperties.getStringProperty("UsingApplicationSessionsAlwaysRetrieve", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("UsingApplicationSessionsAlwaysRetrieve", true, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), SessionManagerConfig.getUsingApplicationSessionsAlwaysRetrieve(), false)) {
            SessionManagerConfig.setUsingApplicationSessionsAlwaysRetrieve(booleanProp);
        }
        String propSIPCookieName = "SIPCookieName";
        strProp = SessionProperties.getStringProperty("SIPCookieName", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("SIPCookieName", true, baseServerLevelConfig, xtpProperties, strProp, SessionManagerConfig.getSipSessionCookieName(), strProp.equals(SessionManagerConfig.getSipSessionCookieName()))) {
            SessionManagerConfig.setSipSessionCookieName(strProp);
        }
        String newScheduler = "UseSeparateSessionInvalidatorThreadPool";
        strProp = SessionProperties.getStringProperty("UseSeparateSessionInvalidatorThreadPool", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("UseSeparateSessionInvalidatorThreadPool", false, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), null, false)) {
            smc.setUseSeparateSessionInvalidatorThreadPool(booleanProp);
        }
        String invalidatorAlarmDelay = "DelayInvalidationAlarmDuringServerStartup";
        strProp = SessionProperties.getStringProperty("DelayInvalidationAlarmDuringServerStartup", xtpProperties);
        if (strProp != null) {
            try {
                Integer delayProp = Integer.valueOf(strProp);
                if (SessionProperties.shouldSetAndDoLogging("DelayInvalidationAlarmDuringServerStartup", false, baseServerLevelConfig, xtpProperties, delayProp, null, false)) {
                    smc.setDelayForInvalidationAlarmDuringServerStartup(delayProp);
                }
            }
            catch (NumberFormatException nfe) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, "setPropertiesInSMC", "SessionContext.invalidPropertyFound", new Object[]{"DelayInvalidationAlarmDuringServerStartup", strProp});
            }
        }
        String propForceSessionIdLengthCheck = "ForceSessionIdLengthCheck";
        strProp = SessionProperties.getStringProperty("ForceSessionIdLengthCheck", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("ForceSessionIdLengthCheck", false, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), null, false)) {
            smc.setForceSessionIdLengthCheck(booleanProp);
        }
        String securityUserIgnoreCase = "SecurityUserIgnoreCase";
        strProp = SessionProperties.getStringProperty("SecurityUserIgnoreCase", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("SecurityUserIgnoreCase", false, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), null, false)) {
            smc.setSecurityUserIgnoreCase(booleanProp);
        }
        String throwSecurityExceptionOnGetSessionFalse = "ThrowSecurityExceptionOnGetSessionFalse";
        strProp = SessionProperties.getStringProperty("ThrowSecurityExceptionOnGetSessionFalse", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("ThrowSecurityExceptionOnGetSessionFalse", false, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), null, false)) {
            smc.setThrowSecurityExceptionOnGetSessionFalse(booleanProp);
        }
        String invalidateOnUnauthorizedSessionRequestException = "InvalidateOnUnauthorizedSessionRequestException";
        strProp = SessionProperties.getStringProperty("InvalidateOnUnauthorizedSessionRequestException", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("InvalidateOnUnauthorizedSessionRequestException", false, baseServerLevelConfig, xtpProperties, booleanProp = Boolean.valueOf(strProp), null, false)) {
            smc.setInvalidateOnUnauthorizedSessionRequestException(booleanProp);
        }
        String expectedCloneIds = "ExpectedCloneIds";
        strProp = SessionProperties.getStringProperty("ExpectedCloneIds", xtpProperties);
        if (strProp != null && SessionProperties.shouldSetAndDoLogging("ExpectedCloneIds", true, baseServerLevelConfig, xtpProperties, strProp, null, false)) {
            SessionManagerConfig.setExpectedCloneIds(strProp);
            SessionManagerConfig.setExpectedCloneIdsPropertySet(true);
        }
        String propConnectionRetryCount = "ConnectionRetryCount";
        strProp = SessionProperties.getStringProperty("ConnectionRetryCount", xtpProperties);
        if (strProp != null) {
            try {
                int retryCount = new Integer(strProp);
                if (SessionProperties.shouldSetAndDoLogging("ConnectionRetryCount", false, baseServerLevelConfig, xtpProperties, new Integer(retryCount), null, false)) {
                    smc.setConnectionRetryCount(retryCount);
                }
            }
            catch (NumberFormatException nfe) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, "setPropertiesInSMC", "SessionContext.invalidPropertyFound", new Object[]{"ConnectionRetryCount", strProp});
            }
        }
    }

    private static boolean shouldSetAndDoLogging(String propName, boolean isStatic, boolean isBase, Map<String, Object> xtpProperties, Object myValue, Object baseValue, boolean stringEquals) {
        String methodName = "shouldSetAndDoLogging";
        String propFoundMessage = "SessionContext.propertyFound";
        String serverLevelConfigOnlyMessage = "SessionProperties.serverLevelConfigOnly";
        String propFoundButAlreadySetMessage = "SessionProperties.propertyFoundButAlreadySet";
        boolean rc = false;
        if (isStatic) {
            if (isBase) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "shouldSetAndDoLogging", "SessionContext.propertyFound", new Object[]{propName, myValue});
                rc = true;
            } else if (xtpProperties.get(propName) != null) {
                if (myValue != baseValue && !stringEquals) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, "shouldSetAndDoLogging", "SessionProperties.serverLevelConfigOnly", new Object[]{propName, myValue, baseValue});
                } else {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "shouldSetAndDoLogging", "SessionProperties.propertyFoundButAlreadySet", new Object[]{propName, myValue});
                }
            }
        } else {
            if (isBase || xtpProperties.get(propName) != null) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "shouldSetAndDoLogging", "SessionContext.propertyFound", new Object[]{propName, myValue});
            }
            rc = true;
        }
        return rc;
    }

    private static String getStringProperty(String propName, Map<String, Object> xtpProperties) {
        String propKey = propName;
        if (!xtpProperties.containsKey(propKey) && FullyQualifiedPropertiesMap.containsKey(propKey)) {
            propKey = FullyQualifiedPropertiesMap.get(propKey);
        }
        Object propValue = xtpProperties.get(propKey);
        String strProp = null;
        if (propValue != null) {
            strProp = propValue.toString();
        }
        if (strProp == null) {
            strProp = SessionProperties.getSystemProperty(propName);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "getStringProperty", propName + "=" + strProp);
        }
        return strProp;
    }

    private static String getSystemProperty(String propName) {
        String sysProp = null;
        try {
            sysProp = System.getProperty(propName);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.session.SessionProperties", (String)"285", null);
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.SEVERE, methodClassName, propName, "CommonMessage.exception", th);
        }
        return sysProp;
    }

    private static boolean setDefaultConfiguration(SessionManagerConfig smc, Map<String, Object> xtpProperties) {
        int value;
        Integer iValue;
        Long lValue;
        String sValue;
        String s = "sslTrackingEnabled";
        Boolean bValue = SessionProperties.propertyToBoolean(xtpProperties.get(s));
        if (bValue != null) {
            smc.setUseSLLId(bValue);
        }
        if ((bValue = SessionProperties.propertyToBoolean(xtpProperties.get(s = "urlRewritingEnabled"))) != null) {
            smc.setEnableUrlRewriting(bValue);
        }
        if ((bValue = SessionProperties.propertyToBoolean(xtpProperties.get(s = "protocolSwitchRewritingEnabled"))) != null) {
            smc.setEnableUrlProtocolSwitchRewriting(bValue);
        }
        if ((bValue = SessionProperties.propertyToBoolean(xtpProperties.get(s = "cookiesEnabled"))) != null) {
            smc.setEnableCookies(bValue);
        }
        if ((sValue = SessionProperties.propertyToString(xtpProperties.get(s = "cookieName"))) != null) {
            smc.setSessionCookieName(sValue);
        }
        if ((sValue = SessionProperties.propertyToString(xtpProperties.get(s = "cookieDomain"))) != null) {
            smc.setSessionCookieDomain(sValue);
        }
        if ((lValue = SessionProperties.propertyToLong(xtpProperties.get(s = "cookieMaxAge"))) != null) {
            smc.setSessionCookieMaxAge(lValue.intValue());
        }
        if ((sValue = SessionProperties.propertyToString(xtpProperties.get(s = "cookiePath"))) != null) {
            smc.setSessionCookiePath(sValue);
        }
        if ((bValue = SessionProperties.propertyToBoolean(xtpProperties.get(s = "cookieSecure"))) != null) {
            smc.setSessionCookieSecure(bValue);
        }
        if ((bValue = SessionProperties.propertyToBoolean(xtpProperties.get(s = "cookieHttpOnly"))) != null) {
            smc.setSessionCookieHttpOnly(bValue);
        }
        if ((iValue = SessionProperties.propertyToInteger(xtpProperties.get(s = "maxInMemorySessionCount"))) != null) {
            smc.setInMemorySize(iValue);
        }
        if ((bValue = SessionProperties.propertyToBoolean(xtpProperties.get(s = "allowOverflow"))) != null) {
            smc.setEnableOverflow(bValue);
        }
        if ((lValue = SessionProperties.propertyToLong(xtpProperties.get(s = "invalidationTimeout"))) != null) {
            smc.setSessionInvalidationTime(lValue);
        }
        if ((bValue = SessionProperties.propertyToBoolean(xtpProperties.get(s = "securityIntegrationEnabled"))) != null) {
            smc.setIntegrateSecurity(bValue);
        }
        if ((sValue = SessionProperties.propertyToString(xtpProperties.get(s = "sessionPersistenceMode"))) != null) {
            smc.setPersistenceMode(sValue);
        }
        if ((bValue = SessionProperties.propertyToBoolean(xtpProperties.get(s = "useContextRootAsCookiePath"))) != null) {
            smc.setUseContextRootForSessionCookiePath(bValue);
        }
        if ((bValue = SessionProperties.propertyToBoolean(xtpProperties.get(s = "allowSerializedAccess"))) != null) {
            smc.setAllowSerializedSessionAccess(bValue);
        }
        if ((bValue = SessionProperties.propertyToBoolean(xtpProperties.get(s = "accessOnTimeout"))) != null) {
            smc.setAccessSessionOnTimeout(bValue);
        }
        if ((iValue = SessionProperties.propertyToInteger(xtpProperties.get(s = "maxWaitTime"))) != null) {
            smc.setSerializedSessionAccessMaxWaitTime(iValue);
        }
        if ((sValue = SessionProperties.propertyToString(xtpProperties.get(s = "db2RowSize"))) != null) {
            int rowSize = 4;
            if (sValue.equals("4KB")) {
                rowSize = 4;
            } else if (sValue.equals("8KB")) {
                rowSize = 8;
            } else if (sValue.equals("16KB")) {
                rowSize = 16;
            } else if (sValue.equals("32KB")) {
                rowSize = 32;
            }
            smc.setRowSize(rowSize);
        }
        if ((sValue = SessionProperties.propertyToString(xtpProperties.get(s = "tableSpaceName"))) != null) {
            smc.setTableSpaceName(sValue);
        }
        if ((bValue = SessionProperties.propertyToBoolean(xtpProperties.get(s = "useMultiRowSchema"))) != null) {
            smc.setUsingMultirow(bValue);
        }
        if ((bValue = SessionProperties.propertyToBoolean(xtpProperties.get(s = "scheduleInvalidation"))) != null) {
            smc.setScheduledInvalidation(bValue);
        }
        if ((iValue = SessionProperties.propertyToInteger(xtpProperties.get(s = "scheduleInvalidationFirstHour"))) != null) {
            value = iValue;
            if (value > 23) {
                value = 23;
            } else if (value < 0) {
                value = 0;
            }
            smc.setFirstHour(value);
        }
        if ((iValue = SessionProperties.propertyToInteger(xtpProperties.get(s = "scheduleInvalidationSecondHour"))) != null) {
            value = iValue;
            if (value > 23) {
                value = 23;
            } else if (value < 0) {
                value = 0;
            }
            smc.setSecondHour(value);
        }
        if ("TIME_BASED_WRITE".equals(sValue = SessionProperties.propertyToString(xtpProperties.get(s = "writeFrequency")))) {
            smc.setEnableTimeBasedWrite(true);
        } else if ("MANUAL_UPDATE".equals(sValue)) {
            smc.setEnableManualWrite(true);
        } else {
            smc.setEnableEOSWrite(true);
        }
        s = "writeInterval";
        lValue = SessionProperties.propertyToLong(xtpProperties.get(s));
        if (lValue != null) {
            smc.setPropertyWriterInterval(lValue.intValue());
        }
        if ((sValue = SessionProperties.propertyToString(xtpProperties.get(s = "writeContents"))) != null && sValue.equals("ALL_SESSION_ATTRIBUTES")) {
            smc.setwriteAllProperties();
        }
        return true;
    }

    private static String propertyToString(Object o) {
        String s;
        if (o instanceof String && (s = (String)o).length() > 0) {
            return s;
        }
        return null;
    }

    private static Boolean propertyToBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        String s = SessionProperties.propertyToString(o);
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return null;
    }

    private static Integer propertyToInteger(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        String s = SessionProperties.propertyToString(o);
        if (s != null) {
            return Integer.valueOf(s);
        }
        return null;
    }

    private static Long propertyToLong(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        String s = SessionProperties.propertyToString(o);
        if (s != null) {
            return Long.valueOf(s);
        }
        return null;
    }

    static {
        FullyQualifiedPropertiesMap.put("HttpSessionIdReuse", "idReuse");
        FullyQualifiedPropertiesMap.put("HttpSessionTrackGC", "trackGarbageCollection");
        FullyQualifiedPropertiesMap.put("HttpSessionReaperPollInterval", "reaperPollInterval");
        FullyQualifiedPropertiesMap.put("UseInvalidatedId", "useInvalidatedId");
        FullyQualifiedPropertiesMap.put("DebugSessionCrossover", "debugCrossover");
        FullyQualifiedPropertiesMap.put("SessionRewriteIdentifier", "rewriteId");
        FullyQualifiedPropertiesMap.put("HttpSessionCloneId", "cloneId");
        FullyQualifiedPropertiesMap.put("NoAdditionalSessionInfo", "noAdditionalInfo");
        FullyQualifiedPropertiesMap.put("SessionIdentifierMaxLength", "idMaxLength");
        FullyQualifiedPropertiesMap.put("CloneSeparatorChange", "cloneSeparatorChange");
        FullyQualifiedPropertiesMap.put("CloneSeparator", "cloneSeparator");
        FullyQualifiedPropertiesMap.put("NoAffinitySwitchBack", "noAffinitySwitchBack");
        FullyQualifiedPropertiesMap.put("UseOracleBLOB", "useOracleBlob");
        FullyQualifiedPropertiesMap.put("SessionTableSkipIndexCreation", "skipIndexCreation");
        FullyQualifiedPropertiesMap.put("CheckSessionNewOnIsValidRequest", "checkSessionNewOnIsValidRequest");
        FullyQualifiedPropertiesMap.put("UsingCustomSchemaName", "usingCustomSchemaName");
        FullyQualifiedPropertiesMap.put("HideSessionValues", "hideSessionValues");
        FullyQualifiedPropertiesMap.put("DoRemoteInvalidations", "doRemoteInvalidations");
        FullyQualifiedPropertiesMap.put("SessionTableName", "tableName");
        FullyQualifiedPropertiesMap.put("HttpSessionEnableUnmanagedServerReplication", "unmanagedServerReplication");
        FullyQualifiedPropertiesMap.put("Servlet21SessionCompatibility", "servlet21SessionCompatibility");
        FullyQualifiedPropertiesMap.put("AlwaysEncodeURL", "alwaysEncodeUrl");
        FullyQualifiedPropertiesMap.put("CheckSessionCookieNameOnEncodeURL", "checkSessionCookieNameOnEncodeURL");
        FullyQualifiedPropertiesMap.put("OptimizeCacheIdIncrements", "optimizeCacheIdIncrements");
        FullyQualifiedPropertiesMap.put("OnlyCheckInCacheDuringPreInvoke", "onlyCheckInCacheDuringPreInvoke");
        FullyQualifiedPropertiesMap.put("EnableHotFailover", "hotFailover");
        FullyQualifiedPropertiesMap.put("ForceSessionInvalidationMultiple", "forceInvalidationMultiple");
        FullyQualifiedPropertiesMap.put("PersistSessionAfterPassivation", "persistSessionAfterPassivation");
        FullyQualifiedPropertiesMap.put("UsingApplicationSessionsAndInvalidateAll", "usingApplicationSessionsAndInvalidateAll");
        FullyQualifiedPropertiesMap.put("UsingApplicationSessionsAlwaysRetrieve", "usingApplicationSessionsAlwaysRetrieve");
        FullyQualifiedPropertiesMap.put("SIPCookieName", "sipCookieName");
        FullyQualifiedPropertiesMap.put("DelayInvalidationAlarmDuringServerStartup", "delayInvalidationAlarmDuringServerStartup");
        FullyQualifiedPropertiesMap.put("UseSeparateSessionInvalidatorThreadPool", "useSeparateSessionInvalidatorThreadPool");
        FullyQualifiedPropertiesMap.put("ForceSessionIdLengthCheck", "forceIdLengthCheck");
        FullyQualifiedPropertiesMap.put("SecurityUserIgnoreCase", "securityUserIgnoreCase");
        FullyQualifiedPropertiesMap.put("ThrowSecurityExceptionOnGetSessionFalse", "throwSecurityExceptionOnGetSessionFalse");
        FullyQualifiedPropertiesMap.put("InvalidateOnUnauthorizedSessionRequestException", "invalidateOnUnauthorizedSessionRequestException");
        FullyQualifiedPropertiesMap.put("ExpectedCloneIds", "expectedCloneIds");
        FullyQualifiedPropertiesMap.put("ConnectionRetryCount ", "connectionRetryCount");
    }
}

