/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.filemonitor.internal.watch;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.filemonitor.internal.UpdateMonitor;
import com.ibm.ws.kernel.filemonitor.internal.watch.WatchingDirectoryUpdateMonitor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class WatchingUpdateMonitor
extends UpdateMonitor {
    private static final TraceComponent tc = Tr.register(WatchingUpdateMonitor.class);
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().contains("win");
    static final long serialVersionUID = -8988579330046340723L;

    public static UpdateMonitor getMonitor(File monitoredFile, UpdateMonitor.MonitorType type, String filter) {
        if (monitoredFile == null) {
            throw new NullPointerException("MonitoredFile must be non-null");
        }
        if (type == null) {
            throw new NullPointerException("MonitorType must be non-null");
        }
        switch (type) {
            case DIRECTORY: 
            case DIRECTORY_RECURSE: 
            case DIRECTORY_SELF: 
            case DIRECTORY_RECURSE_SELF: {
                if (IS_WINDOWS) {
                    return UpdateMonitor.getMonitor(monitoredFile, type, filter);
                }
                Path monitoredDir = Paths.get(monitoredFile.getAbsolutePath(), new String[0]);
                try {
                    FileSystem fileSystem = monitoredDir.getFileSystem();
                    WatchService watcher = fileSystem.newWatchService();
                    if (watcher.getClass().getName().contains("Polling")) {
                        watcher.close();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Using scanning monitor rather than polling watcher", (Object[])new Object[0]);
                        }
                        return UpdateMonitor.getMonitor(monitoredFile, type, filter);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Using WatchService: " + watcher), (Object[])new Object[0]);
                    }
                    return new WatchingDirectoryUpdateMonitor(watcher, monitoredDir, type, filter);
                }
                catch (IOException fileSystem) {
                    FFDCFilter.processException((Throwable)fileSystem, (String)"com.ibm.ws.kernel.filemonitor.internal.watch.WatchingUpdateMonitor", (String)"88", null, (Object[])new Object[]{monitoredFile, type, filter});
                    return UpdateMonitor.getMonitor(monitoredFile, type, filter);
                }
            }
            case FILE: {
                return UpdateMonitor.getMonitor(monitoredFile, type, filter);
            }
        }
        throw new IllegalArgumentException("Unknown monitor type: " + (Object)((Object)type));
    }

    protected WatchingUpdateMonitor(File monitoredFile, UpdateMonitor.MonitorType type) {
        super(monitoredFile, type);
    }
}

