/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.filemonitor.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.filemonitor.FileNotification;
import com.ibm.ws.kernel.filemonitor.internal.CoreService;
import com.ibm.ws.kernel.filemonitor.internal.MonitorHolder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class CoreServiceImpl
implements CoreService,
FileNotification {
    static final String MONITOR = "Monitor";
    static final TraceComponent tc = Tr.register(CoreServiceImpl.class);
    private final AtomicReference<WsLocationAdmin> locServiceRef = new AtomicReference<Object>(null);
    private final AtomicReference<ScheduledExecutorService> executorService = new AtomicReference<Object>(null);
    private final ConcurrentHashMap<ServiceReference<FileMonitor>, MonitorHolder> fileMonitors = new ConcurrentHashMap();
    private volatile ComponentContext cContext = null;
    private volatile boolean detailedScanTrace = false;
    static final long serialVersionUID = 2709805739155462906L;

    @Activate
    protected void activate(ComponentContext cContext, Map<String, Object> properties) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"File monitor service activated", (Object[])new Object[]{properties});
        }
        this.cContext = cContext;
        this.modified(properties);
        for (Map.Entry<ServiceReference<FileMonitor>, MonitorHolder> entry : this.fileMonitors.entrySet()) {
            entry.getValue().init();
        }
    }

    @Deactivate
    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"File monitor service deactivated", (Object[])new Object[]{"reason=" + reason, this.fileMonitors});
        }
        for (Map.Entry<ServiceReference<FileMonitor>, MonitorHolder> entry : this.fileMonitors.entrySet()) {
            entry.getValue().destroy();
        }
        this.fileMonitors.clear();
        this.cContext = null;
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        String key = "detailedTraceEnabled";
        if (properties != null) {
            try {
                this.detailedScanTrace = MetatypeUtils.parseBoolean((Object)properties.get("service.pid"), (String)"detailedTraceEnabled", (Object)properties.get("detailedTraceEnabled"), (boolean)false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.kernel.filemonitor.internal.CoreServiceImpl", (String)"109", (Object)this, (Object[])new Object[]{properties});
                this.detailedScanTrace = false;
            }
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setScheduler(ScheduledExecutorService scheduler) {
        ScheduledExecutorService oldService = this.executorService.getAndSet(scheduler);
        if (oldService != null && this.fileMonitors != null) {
            for (MonitorHolder mh : this.fileMonitors.values()) {
                mh.reschedule();
            }
        }
    }

    protected void unsetScheduler(ScheduledExecutorService schedulerRef) {
        this.executorService.compareAndSet(schedulerRef, null);
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        ScheduledExecutorService sRef = this.executorService.get();
        if (sRef == null) {
            throw new IllegalStateException("ScheduledExecutorService service is unavailable");
        }
        return sRef;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setLocation(WsLocationAdmin locRef) {
        this.locServiceRef.set(locRef);
    }

    protected void unsetLocation(WsLocationAdmin locRef) {
        this.locServiceRef.compareAndSet(locRef, null);
    }

    @Override
    public WsLocationAdmin getLocationService() {
        WsLocationAdmin sRef = this.locServiceRef.get();
        if (sRef == null) {
            throw new IllegalStateException("WsLocationAdmin service is unavailable");
        }
        return sRef;
    }

    /*
     * WARNING - void declaration
     */
    @Reference(service=FileMonitor.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, target="(|(monitor.files=*)(monitor.directories=*))")
    protected void setMonitor(ServiceReference<FileMonitor> monitorRef) {
        MonitorHolder holder = this.createMonitorHolder(monitorRef);
        MonitorHolder existing = this.fileMonitors.put(monitorRef, holder);
        if (existing != null) {
            existing.destroy();
        }
        if (this.cContext != null) {
            try {
                holder.init();
            }
            catch (RuntimeException runtimeException) {
                void re;
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.kernel.filemonitor.internal.CoreServiceImpl", (String)"226", (Object)this, (Object[])new Object[]{monitorRef});
                this.fileMonitors.remove(monitorRef);
                throw re;
            }
        }
    }

    protected abstract MonitorHolder createMonitorHolder(ServiceReference<FileMonitor> var1);

    /*
     * WARNING - void declaration
     */
    protected void updatedMonitor(ServiceReference<FileMonitor> monitorRef) {
        MonitorHolder existing;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"CoreServiceImpl updatedMonitor", (Object[])new Object[]{monitorRef});
        }
        if ((existing = this.fileMonitors.get(monitorRef)) == null) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"CoreServiceImpl updatedMonitor, existing found", (Object[])new Object[0]);
        }
        if (this.cContext != null) {
            try {
                File cacheRoot = this.cContext.getBundleContext().getDataFile(Long.toString(monitorRef.getBundle().getBundleId()));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"CoreServiceImpl updatedMonitor, about to refresh", (Object[])new Object[0]);
                }
                existing.refresh(cacheRoot);
            }
            catch (RuntimeException cacheRoot) {
                void re;
                FFDCFilter.processException((Throwable)cacheRoot, (String)"com.ibm.ws.kernel.filemonitor.internal.CoreServiceImpl", (String)"272", (Object)this, (Object[])new Object[]{monitorRef});
                this.fileMonitors.remove(monitorRef);
                throw re;
            }
        }
    }

    protected void unsetMonitor(ServiceReference<FileMonitor> monitorRef) {
        MonitorHolder holder = this.fileMonitors.remove(monitorRef);
        if (holder != null) {
            holder.destroy();
        }
    }

    @Override
    public FileMonitor getReferencedMonitor(ServiceReference<FileMonitor> monitorRef) {
        return (FileMonitor)this.cContext.locateService(MONITOR, monitorRef);
    }

    @Override
    @Trivial
    public boolean isDetailedScanTraceEnabled() {
        return this.detailedScanTrace;
    }

    protected boolean frameworkIsStopping() {
        try {
            Bundle systemBundle = this.cContext.getBundleContext().getBundle(0L);
            return systemBundle.getState() == 16;
        }
        catch (IllegalStateException systemBundle) {
            FFDCFilter.processException((Throwable)systemBundle, (String)"com.ibm.ws.kernel.filemonitor.internal.CoreServiceImpl", (String)"312", (Object)this, (Object[])new Object[0]);
            return true;
        }
    }

    @Override
    public void notifyFileChanges(Collection<String> created, Collection<String> modified, Collection<String> deleted) {
        Set absoluteCreated = PathUtils.getFixedPathFiles(created);
        Set absoluteDeleted = PathUtils.getFixedPathFiles(deleted);
        Set absoluteModified = PathUtils.getFixedPathFiles(modified);
        for (MonitorHolder mh : this.fileMonitors.values()) {
            mh.externalScan(absoluteCreated, absoluteDeleted, absoluteModified);
        }
    }
}

