/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.jpa.annotation.scanning;

import com.ibm.websphere.archive.GenericArchive;
import com.ibm.websphere.ecs.exception.ModuleOpenException;
import com.ibm.websphere.ecs.info.AnnotationInfo;
import com.ibm.websphere.ecs.info.AnnotationValue;
import com.ibm.websphere.ecs.info.Info;
import com.ibm.websphere.ecs.module.Module;
import com.ibm.websphere.ecs.module.ModuleFactoryService;
import com.ibm.websphere.ecs.scan.AnnotationScanner;
import com.ibm.websphere.ecs.target.FieldAnnotationTarget;
import com.ibm.websphere.ecs.target.MethodAnnotationTarget;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.eba.jpa.annotation.scanning.AnnotationSource;
import com.ibm.ws.eba.jpa.annotation.scanning.JPAAnnotation;
import com.ibm.ws.eba.jpa.annotation.scanning.PersistenceContextAnnotation;
import com.ibm.ws.eba.jpa.annotation.scanning.PersistenceUnitAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceProperty;
import javax.persistence.PersistenceUnit;

public class ECSAnnotationSource
implements AnnotationSource {
    private final AnnotationScanner scanner;
    private final Map<String, List<FieldAnnotationTarget>> unitFieldAnnotations;
    private final Map<String, List<FieldAnnotationTarget>> contextFieldAnnotations;
    private final Map<String, List<MethodAnnotationTarget>> unitMethodAnnotations;
    private final Map<String, List<MethodAnnotationTarget>> contextMethodAnnotations;
    private static final TraceComponent tc = Tr.register(ECSAnnotationSource.class, (String)"Aries.jpa", null);

    /*
     * WARNING - void declaration
     */
    public ECSAnnotationSource(ModuleFactoryService moduleFactoryService, GenericArchive genericArchive) throws ModuleOpenException {
        void ga;
        void mfs;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[]{moduleFactoryService, genericArchive});
        }
        Module m = mfs.openModule((GenericArchive)ga, null, null);
        this.scanner = m.getAnnotationScanner();
        this.unitFieldAnnotations = this.scanner.getFieldAnnotationTargets(PersistenceUnit.class);
        this.unitMethodAnnotations = this.scanner.getMethodAnnotationTargets(PersistenceUnit.class);
        this.contextFieldAnnotations = this.scanner.getFieldAnnotationTargets(PersistenceContext.class);
        this.contextMethodAnnotations = this.scanner.getMethodAnnotationTargets(PersistenceContext.class);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<JPAAnnotation> getAnnotations(String string) {
        void className;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getAnnotations", (Object[])new Object[]{string});
        }
        ArrayList<JPAAnnotation> result = new ArrayList<JPAAnnotation>();
        if (this.unitFieldAnnotations.containsKey(className)) {
            for (FieldAnnotationTarget f : this.unitFieldAnnotations.get(className)) {
                result.add(this.convertPersistenceUnitAnnotation((Info)f.getApplicableField()));
            }
        }
        if (this.contextFieldAnnotations.containsKey(className)) {
            for (FieldAnnotationTarget f : this.contextFieldAnnotations.get(className)) {
                result.add(this.convertPersistenceContextAnnotation((Info)f.getApplicableField()));
            }
        }
        if (this.unitMethodAnnotations.containsKey(className)) {
            for (MethodAnnotationTarget m : this.unitMethodAnnotations.get(className)) {
                result.add(this.convertPersistenceUnitAnnotation((Info)m.getApplicableMethod()));
            }
        }
        if (this.contextMethodAnnotations.containsKey(className)) {
            for (MethodAnnotationTarget m : this.contextMethodAnnotations.get(className)) {
                result.add(this.convertPersistenceContextAnnotation((Info)m.getApplicableMethod()));
            }
        }
        ArrayList<JPAAnnotation> arrayList = result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            arrayList = arrayList;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getAnnotations", arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private String getPropertyName(Info info) {
        void info2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getPropertyName", (Object[])new Object[]{info});
        }
        if (info2.isMethod()) {
            String name = info2.getName();
            if (name.startsWith("get") || name.startsWith("set")) {
                if (Character.isUpperCase((name = name.substring(3)).charAt(0)) && (name.length() < 2 || !Character.isUpperCase(name.charAt(1)))) {
                    name = Character.toString(Character.toLowerCase(name.charAt(0))) + name.substring(1);
                }
                String string = name;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    string = string;
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"getPropertyName", (Object)string);
                }
                return string;
            }
            String string = name;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                string = string;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getPropertyName", (Object)string);
            }
            return string;
        }
        String string = info2.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getPropertyName", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private PersistenceUnitAnnotation convertPersistenceUnitAnnotation(Info info) {
        void info2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"convertPersistenceUnitAnnotation", (Object[])new Object[]{info});
        }
        AnnotationInfo anInfo = info2.getAnnotation(PersistenceUnit.class);
        AnnotationValue name = anInfo.getValue("name");
        AnnotationValue unitName = anInfo.getValue("unitName");
        PersistenceUnitAnnotation persistenceUnitAnnotation = new PersistenceUnitAnnotation(name != null ? name.getStringValue() : null, unitName != null ? unitName.getStringValue() : null, info2.isMethod() ? JPAAnnotation.Target.Method : JPAAnnotation.Target.Field, this.getPropertyName((Info)info2));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            persistenceUnitAnnotation = persistenceUnitAnnotation;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"convertPersistenceUnitAnnotation", (Object)persistenceUnitAnnotation);
        }
        return persistenceUnitAnnotation;
    }

    /*
     * WARNING - void declaration
     */
    private PersistenceContextAnnotation convertPersistenceContextAnnotation(Info info) {
        void info2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"convertPersistenceContextAnnotation", (Object[])new Object[]{info});
        }
        AnnotationInfo anInfo = info2.getAnnotation(PersistenceContext.class);
        AnnotationValue name = anInfo.getValue("name");
        AnnotationValue unitName = anInfo.getValue("unitName");
        AnnotationValue context = anInfo.getValue("context");
        PersistenceContextAnnotation.ContextType contextType = PersistenceContextAnnotation.ContextType.TRANSACTION;
        if (context != null && context.getStringValue().equals("EXTENDED")) {
            contextType = PersistenceContextAnnotation.ContextType.EXTENDED;
        }
        AnnotationValue properties = anInfo.getValue("properties");
        HashMap<String, String> props = new HashMap<String, String>();
        if (properties != null) {
            for (AnnotationValue v : properties.getArrayValue()) {
                PersistenceProperty p = (PersistenceProperty)v.getObjectValue();
                props.put(p.name(), p.value());
            }
        }
        PersistenceContextAnnotation persistenceContextAnnotation = new PersistenceContextAnnotation(name != null ? name.getStringValue() : null, unitName != null ? unitName.getStringValue() : null, info2.isMethod() ? JPAAnnotation.Target.Method : JPAAnnotation.Target.Field, this.getPropertyName((Info)info2), contextType, props);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            persistenceContextAnnotation = persistenceContextAnnotation;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"convertPersistenceContextAnnotation", (Object)persistenceContextAnnotation);
        }
        return persistenceContextAnnotation;
    }

    static /* synthetic */ TraceComponent access$0() {
        return tc;
    }
}

