/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.probeExtension;

import java.util.ArrayList;
import java.util.List;

public class FastList<E> {
    private E[] listElements;
    private int addIndex = 0;
    private int count = 0;
    private int maxCount;
    private int capacity;
    private float loadFactor;

    public FastList(int initialCapacity, float loadFactor) {
        if (initialCapacity < 10) {
            initialCapacity = 10;
        }
        if (loadFactor < 0.1f) {
            loadFactor = 0.1f;
        }
        if (loadFactor > 1.0f) {
            loadFactor = 0.5f;
        }
        this.listElements = new Object[initialCapacity];
        this.maxCount = (int)((float)initialCapacity * loadFactor);
        this.capacity = initialCapacity;
        this.loadFactor = loadFactor;
    }

    public FastList() {
        this(10, 0.5f);
    }

    public synchronized int add(E object) {
        if (object == null) {
            throw new NullPointerException("FastList add called with null");
        }
        if (this.count + 1 >= this.maxCount) {
            this.resize(this.capacity * 2);
        }
        int initialAddIndex = this.addIndex;
        while (this.listElements[this.addIndex] != null) {
            ++this.addIndex;
            if (this.addIndex == this.capacity) {
                this.addIndex = 0;
            }
            if (this.addIndex != initialAddIndex) continue;
            throw new RuntimeException("FastList out of space");
        }
        ++this.count;
        this.listElements[this.addIndex] = object;
        return this.addIndex;
    }

    public synchronized E get(int index) {
        return this.listElements[index];
    }

    public synchronized void remove(int index) {
        if (this.listElements[index] != null) {
            --this.count;
            this.listElements[index] = null;
        }
    }

    public synchronized List<E> getAll() {
        ArrayList<E> list = new ArrayList<E>();
        for (E element : this.listElements) {
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }

    public synchronized int size() {
        return this.count;
    }

    private synchronized void resize(int newCapacity) {
        Object[] newListElements = new Object[newCapacity];
        System.arraycopy(this.listElements, 0, newListElements, 0, this.capacity);
        this.listElements = newListElements;
        this.capacity = newCapacity;
        this.maxCount = (int)((float)this.capacity * this.loadFactor);
    }

    synchronized E[] getListElements() {
        return this.listElements;
    }

    public synchronized void clear() {
        int initialCapacity = 10;
        float loadFactor = 0.5f;
        this.listElements = new Object[initialCapacity];
        this.maxCount = (int)((float)initialCapacity * loadFactor);
        this.capacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.addIndex = 0;
        this.count = 0;
    }
}

