/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.local;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class LocalConnectorActivator {
    private static final String JMX_LOCAL_ADDRESS = "com.ibm.ws.jmx.local.address";
    private volatile WsLocationAdmin locationService;
    private volatile WsResource localJMXAddressWorkareaFile;
    private volatile WsResource localJMXAddressStateFile;
    private static final TraceComponent tc = Tr.register(LocalConnectorActivator.class);
    static final long serialVersionUID = 2385826357719053259L;

    protected void activate(ComponentContext compContext) {
    }

    protected void deactivate(ComponentContext compContext) {
        this.removeJMXAddressResource(this.localJMXAddressWorkareaFile);
        this.removeJMXAddressResource(this.localJMXAddressStateFile);
    }

    /*
     * WARNING - void declaration
     */
    private void removeJMXAddressResource(WsResource _localJMXAddressFile) {
        block6: {
            if (_localJMXAddressFile != null) {
                try {
                    if (!_localJMXAddressFile.delete()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Could not delete the JMX local connector address file.", (Object[])new Object[0]);
                        }
                        return;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Successfully deleted the JMX local connector address file.", (Object[])new Object[0]);
                    }
                }
                catch (SecurityException securityException) {
                    void se;
                    FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.jmx.connector.local.LocalConnectorActivator", (String)"132", (Object)this, (Object[])new Object[]{_localJMXAddressFile});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                    Tr.event((TraceComponent)tc, (String)"Received a SecurityException while attemping to delete the JMX local connector address file: ", (Object[])new Object[]{se});
                }
            }
        }
    }

    protected void setLocationService(WsLocationAdmin locationService) {
        this.locationService = locationService;
        if (this.localJMXAddressWorkareaFile == null) {
            this.localJMXAddressWorkareaFile = this.createJMXWorkAreaResource(locationService);
        }
        if (this.localJMXAddressStateFile == null) {
            this.localJMXAddressStateFile = this.createJMXStateResource(locationService);
        }
    }

    protected void unsetLocationService(WsLocationAdmin locationService) {
        if (this.locationService == locationService) {
            this.locationService = null;
        }
    }

    private WsResource createJMXStateResource(WsLocationAdmin locationAdmin) {
        WsResource resource = locationAdmin.resolveResource("${server.state.dir}/com.ibm.ws.jmx.local.address");
        return this.createJmxAddressResource(resource);
    }

    private WsResource createJMXWorkAreaResource(WsLocationAdmin locationAdmin) {
        WsResource resource = locationAdmin.getServerWorkareaResource(JMX_LOCAL_ADDRESS);
        return this.createJmxAddressResource(resource);
    }

    /*
     * WARNING - void declaration
     */
    private WsResource createJmxAddressResource(WsResource resource) {
        String connectorAddress = LocalConnectorHelper.getConnectorAddress();
        if (connectorAddress != null) {
            try {
                if (!resource.exists()) {
                    resource.create();
                }
                OutputStream os = resource.putStream();
                os.write(connectorAddress.getBytes("UTF-8"));
                os.flush();
                os.close();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Successfully printed the JMX local connector address.", (Object[])new Object[0]);
                }
                return resource;
            }
            catch (IOException os) {
                void ioe;
                FFDCFilter.processException((Throwable)os, (String)"com.ibm.ws.jmx.connector.local.LocalConnectorActivator", (String)"191", (Object)this, (Object[])new Object[]{resource});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Received IOException while writting address to file: ", (Object[])new Object[]{ioe});
                }
                FFDCFilter.processException((Throwable)ioe, (String)this.getClass().getName(), (String)"createJMXWorkAreaResourceIO");
            }
            catch (SecurityException ioe) {
                void se;
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.jmx.connector.local.LocalConnectorActivator", (String)"197", (Object)this, (Object[])new Object[]{resource});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Received SecurityException while writting address to file: ", (Object[])new Object[]{se});
                }
                FFDCFilter.processException((Throwable)se, (String)this.getClass().getName(), (String)"createJMXWorkAreaResourceSec");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Connector address was null, so we can't write the address to a file.", (Object[])new Object[0]);
        }
        return null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class LocalConnectorHelper {
        private static final String LOCAL_CONNECTOR_ADDRESS_PROPERTY = "com.sun.management.jmxremote.localConnectorAddress";
        private static final String LOCAL_CONNECTOR_ADDRESS;
        private static final String RMI_SERVER_HOSTNAME_PROPERTY = "java.rmi.server.hostname";
        private static final String LOOPBACK_ADDRESS = "127.0.0.1";
        static final long serialVersionUID = 1098358863265294834L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private static String initConnectorAddress() {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){
                static final long serialVersionUID = -6961869169337658885L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public String run() {
                    try {
                        if (System.getProperty(LocalConnectorHelper.RMI_SERVER_HOSTNAME_PROPERTY) == null) {
                            System.setProperty(LocalConnectorHelper.RMI_SERVER_HOSTNAME_PROPERTY, LocalConnectorHelper.LOOPBACK_ADDRESS);
                        }
                        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                        Class<?> clazz1 = Class.forName("sun.management.Agent", true, systemClassLoader);
                        Method m1 = clazz1.getMethod("agentmain", String.class);
                        m1.invoke(null, new Object[]{null});
                        String localConnectorAddress = System.getProperty(LocalConnectorHelper.LOCAL_CONNECTOR_ADDRESS_PROPERTY);
                        if (localConnectorAddress == null) {
                            Class<?> clazz2 = Class.forName("sun.misc.VMSupport", true, systemClassLoader);
                            Method m2 = clazz2.getMethod("getAgentProperties", new Class[0]);
                            Properties props = (Properties)m2.invoke(null, new Object[0]);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Attempting to retrieve the connector address from agent properties.", (Object[])new Object[0]);
                            }
                            localConnectorAddress = props.getProperty(LocalConnectorHelper.LOCAL_CONNECTOR_ADDRESS_PROPERTY);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Returning localConnectorAddress: " + localConnectorAddress), (Object[])new Object[0]);
                        }
                        if (localConnectorAddress == null) {
                            FFDCFilter.processException((Throwable)new RuntimeException("Received a null connector address."), (String)this.getClass().getName(), (String)"localConnectorInitNull");
                        }
                        return localConnectorAddress;
                    }
                    catch (Exception systemClassLoader) {
                        void e;
                        FFDCFilter.processException((Throwable)systemClassLoader, (String)"com.ibm.ws.jmx.connector.local.LocalConnectorActivator$LocalConnectorHelper$1", (String)"91", (Object)this, (Object[])new Object[0]);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Received exception while retrieving connector address: ", (Object[])new Object[]{e});
                        }
                        FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"localConnectorInit");
                        return null;
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }

        public static String getConnectorAddress() {
            return LOCAL_CONNECTOR_ADDRESS;
        }

        private LocalConnectorHelper() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(LocalConnectorHelper.class);
            LOCAL_CONNECTOR_ADDRESS = LocalConnectorHelper.initConnectorAddress();
        }
    }
}

