/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.common.internal.encoder;

import java.io.UnsupportedEncodingException;

public final class Base64Coder {
    private static final byte[] Base64EncMap;
    private static final byte[] Base64DecMap;
    private static final char[] TOKENS;
    private static final char PAD_TOKEN = '=';
    private static final int TOKEN_MIN = 0;
    private static final int TOKEN_MAX = 127;
    private static final byte INVALID_TOKEN_VALUE = -1;
    private static final byte[] TOKEN_VALUES;

    private Base64Coder() {
    }

    public static final String base64Encode(String str) {
        if (str == null) {
            return null;
        }
        byte[] data = Base64Coder.getBytes(str);
        return Base64Coder.toString(Base64Coder.base64Encode(data));
    }

    public static final String base64EncodeToString(byte[] data) {
        return Base64Coder.toString(Base64Coder.base64Encode(data));
    }

    public static final byte[] base64Encode(byte[] data) {
        int sidx;
        if (data == null) {
            return null;
        }
        byte[] dest = new byte[(data.length + 2) / 3 * 4];
        int didx = 0;
        for (sidx = 0; sidx < data.length - 2; sidx += 3) {
            dest[didx++] = Base64EncMap[data[sidx] >>> 2 & 0x3F];
            dest[didx++] = Base64EncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
            dest[didx++] = Base64EncMap[data[sidx + 2] >>> 6 & 3 | data[sidx + 1] << 2 & 0x3F];
            dest[didx++] = Base64EncMap[data[sidx + 2] & 0x3F];
        }
        if (sidx < data.length) {
            dest[didx++] = Base64EncMap[data[sidx] >>> 2 & 0x3F];
            if (sidx < data.length - 1) {
                dest[didx++] = Base64EncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
                dest[didx++] = Base64EncMap[data[sidx + 1] << 2 & 0x3F];
            } else {
                dest[didx++] = Base64EncMap[data[sidx] << 4 & 0x3F];
            }
        }
        while (didx < dest.length) {
            dest[didx] = 61;
            ++didx;
        }
        return dest;
    }

    public static final byte[] base64Decode(byte[] data) {
        int didx;
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return null;
        }
        if (data.length % 4 != 0) {
            return null;
        }
        int tail = data.length;
        while (data[tail - 1] == 61) {
            --tail;
        }
        byte[] dest = new byte[tail - data.length / 4];
        for (int idx = 0; idx < data.length; ++idx) {
            data[idx] = Base64DecMap[data[idx]];
        }
        int sidx = 0;
        for (didx = 0; didx < dest.length - 2; didx += 3) {
            dest[didx] = (byte)(data[sidx] << 2 & 0xFF | data[sidx + 1] >>> 4 & 3);
            dest[didx + 1] = (byte)(data[sidx + 1] << 4 & 0xFF | data[sidx + 2] >>> 2 & 0xF);
            dest[didx + 2] = (byte)(data[sidx + 2] << 6 & 0xFF | data[sidx + 3] & 0x3F);
            sidx += 4;
        }
        if (didx < dest.length) {
            dest[didx] = (byte)(data[sidx] << 2 & 0xFF | data[sidx + 1] >>> 4 & 3);
        }
        if (++didx < dest.length) {
            dest[didx] = (byte)(data[sidx + 1] << 4 & 0xFF | data[sidx + 2] >>> 2 & 0xF);
        }
        return dest;
    }

    public static String encode(byte[] data) {
        return Base64Coder.encode(data, 0, data.length);
    }

    public static String encode(byte[] data, int offset, int length) {
        int remainder = length % 3;
        int resultSize = (remainder == 0 ? length : length + 3 - remainder) / 3 * 4;
        StringBuffer resultBuff = new StringBuffer(resultSize);
        int groupIndex = 0;
        int previousByte = 0;
        for (int i = offset; i < length; ++i) {
            int currentByte = data[i];
            switch (groupIndex) {
                case 0: {
                    resultBuff.append(TOKENS[(currentByte & 0xFC) >> 2]);
                    groupIndex = 1;
                    break;
                }
                case 1: {
                    resultBuff.append(TOKENS[(previousByte & 3) << 4 | (currentByte & 0xF0) >> 4]);
                    groupIndex = 2;
                    break;
                }
                case 2: {
                    resultBuff.append(TOKENS[(previousByte & 0xF) << 2 | (currentByte & 0xC0) >> 6]);
                    resultBuff.append(TOKENS[currentByte & 0x3F]);
                    groupIndex = 0;
                    break;
                }
            }
            previousByte = currentByte;
        }
        switch (groupIndex) {
            case 1: {
                resultBuff.append(TOKENS[(previousByte & 3) << 4]);
                resultBuff.append('=');
                resultBuff.append('=');
                break;
            }
            case 2: {
                resultBuff.append(TOKENS[(previousByte & 0xF) << 2]);
                resultBuff.append('=');
                break;
            }
        }
        String result = resultBuff.toString();
        return result;
    }

    public static final String base64Decode(String str, String enc) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        byte[] data = Base64Coder.getBytes(str);
        return Base64Coder.base64Decode(new String(data, enc));
    }

    public static final String base64Decode(String str) {
        if (str == null) {
            return null;
        }
        byte[] data = Base64Coder.getBytes(str);
        return Base64Coder.toString(Base64Coder.base64Decode(data));
    }

    public static final byte[] base64DecodeString(String str) {
        return Base64Coder.base64Decode(Base64Coder.getBytes(str));
    }

    public static final String toString(byte[] b) {
        if (b == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int len = b.length;
        for (int i = 0; i < len; ++i) {
            sb.append((char)(b[i] & 0xFF));
        }
        return sb.toString();
    }

    public static final byte[] getBytes(String input) {
        byte[] output = null;
        try {
            if (input != null) {
                output = input.getBytes("UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return output;
    }

    static {
        TOKENS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        TOKEN_VALUES = new byte[128];
        byte[] map = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        Base64EncMap = map;
        Base64DecMap = new byte[128];
        for (int idx = 0; idx < Base64EncMap.length; ++idx) {
            Base64Coder.Base64DecMap[Base64Coder.Base64EncMap[idx]] = (byte)idx;
        }
    }
}

