/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ws.cache.QueueElement;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Queue {
    protected QueueElement head = null;
    protected QueueElement tail = null;
    protected int numElements = 0;

    private static final void checkElementFree(QueueElement qe) {
        if (qe.previous != null || qe.next != null || qe.queue != null) {
            throw new RuntimeException("Queue element in use");
        }
    }

    public void addToHead(QueueElement qe) {
        Queue.checkElementFree(qe);
        if (this.head == null) {
            this.head = qe;
            this.tail = qe;
        } else {
            qe.previous = null;
            qe.next = this.head;
            this.head.previous = qe;
            this.head = qe;
        }
        qe.queue = this;
        ++this.numElements;
    }

    public void addToTail(QueueElement qe) {
        Queue.checkElementFree(qe);
        if (this.head == null) {
            this.head = qe;
            this.tail = qe;
            qe.queue = this;
        } else {
            qe.previous = this.tail;
            qe.next = null;
            this.tail.next = qe;
            this.tail = qe;
        }
        qe.queue = this;
        ++this.numElements;
    }

    public QueueElement removeHead() {
        if (this.head == null) {
            return null;
        }
        QueueElement result = this.head;
        if (result.next == null) {
            this.head = null;
            this.tail = null;
        } else {
            this.head = result.next;
            this.head.previous = null;
        }
        result.previous = null;
        result.next = null;
        result.queue = null;
        --this.numElements;
        return result;
    }

    public QueueElement removeTail() {
        if (this.head == null) {
            return null;
        }
        QueueElement result = this.tail;
        if (result.previous == null) {
            this.head = null;
            this.tail = null;
        } else {
            this.tail = result.previous;
            this.tail.next = null;
        }
        result.previous = null;
        result.next = null;
        result.queue = null;
        --this.numElements;
        return result;
    }

    public void remove(QueueElement qe) {
        if (this.head == qe) {
            this.removeHead();
        } else if (this.tail == qe) {
            this.removeTail();
        } else {
            qe.previous.next = qe.next;
            qe.next.previous = qe.previous;
            qe.previous = null;
            qe.next = null;
            qe.queue = null;
            --this.numElements;
        }
    }

    public int size() {
        return this.numElements;
    }

    public Enumeration elements() {
        return new QueueEnumeration(this.head);
    }

    class QueueEnumeration
    implements Enumeration {
        QueueElement current;

        public QueueEnumeration(QueueElement qe) {
            this.current = qe;
        }

        @Override
        public boolean hasMoreElements() {
            return this.current != null;
        }

        public Object nextElement() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            QueueElement result = this.current;
            this.current = this.current.next;
            return result;
        }
    }
}

