/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.cache.exception.DynamicCacheException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheStatisticsListenerWrapper;
import com.ibm.ws.cache.DCacheBase;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.FreeLruEntryResult;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.InvalidationAuditDaemon;
import com.ibm.ws.cache.NullRemoteServices;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.TimeLimitDaemon;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.intf.ServletCacheUnit;
import com.ibm.wsspi.cache.CacheFeatureSupport;
import com.ibm.wsspi.cache.CacheStatistics;
import com.ibm.wsspi.cache.CoreCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CacheProviderWrapper
extends DCacheBase {
    private static TraceComponent tc = Tr.register(CacheProviderWrapper.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    CacheFeatureSupport featureSupport = null;
    CoreCache coreCache = null;
    String cacheProviderName = "";
    CacheStatistics cacheStatistics = null;
    private static final HashMap EMPTY_MAP = new HashMap(0);
    private static final String CLEAR = "clearCache";

    public CacheProviderWrapper(CacheConfig cacheConfig, CacheFeatureSupport featureSupport, CoreCache coreCache) {
        super(cacheConfig.cacheName, cacheConfig);
        String methodName = "CTOR";
        this.cacheProviderName = cacheConfig.cacheProviderName;
        this.featureSupport = featureSupport;
        this.coreCache = coreCache;
        this.swapToDisk = cacheConfig.enableDiskOffload;
        if (this.swapToDisk && !this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"enableDiskOffload", this.cacheName, this.cacheProviderName});
            this.swapToDisk = false;
            cacheConfig.enableDiskOffload = false;
        }
        if (cacheConfig.enableCacheReplication && !featureSupport.isReplicationSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1065E", (Object[])new Object[]{"enableCacheReplication", this.cacheName, this.cacheProviderName});
            cacheConfig.enableCacheReplication = false;
        }
        this.cacheStatistics = this.coreCache.getCacheStatistics();
        if (this.cacheStatistics == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CTOR cacheName=" + this.cacheName + " **ERROR cacheStatistics object is found to be NULL."), (Object[])new Object[0]);
        }
        this.cacheStatisticsListener = new CacheStatisticsListenerWrapper(this.cacheStatistics);
    }

    @Override
    public boolean containsCacheId(Object cacheId) {
        boolean found = false;
        if (cacheId != null) {
            found = this.coreCache.containsCacheId(cacheId);
        }
        return found;
    }

    @Override
    public void clear(boolean waitOnInvalidation) {
        this.invalidateExternalCaches(null, CLEAR);
        this.coreCache.clear();
    }

    @Override
    public boolean enableListener(boolean enable) {
        boolean success = super.enableListener(enable);
        this.coreCache.setEventSource(this.eventSource);
        return success;
    }

    @Override
    public CacheStatistics getCacheStatistics() {
        return this.cacheStatistics;
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry getEntry(com.ibm.websphere.cache.EntryInfo ei, boolean checkAskPermission) {
        String methodName = "getEntry()";
        com.ibm.websphere.cache.CacheEntry ce = null;
        Object id = null;
        if (ei != null) {
            id = ei.getIdObject();
            ce = this.coreCache.get(id);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getEntry() cacheName=" + this.cacheName + " id=" + id + " cacheEntry=" + ce), (Object[])new Object[0]);
        }
        return ce;
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry getEntry(com.ibm.websphere.cache.EntryInfo ei, boolean checkAskPermission, boolean ignoreCounting) {
        String methodName = "getEntry()";
        com.ibm.websphere.cache.CacheEntry ce = null;
        Object id = null;
        if (ei != null) {
            id = ei.getIdObject();
            ce = this.coreCache.get(id);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getEntry() cacheName=" + this.cacheName + " id=" + id + " cacheEntry=" + ce), (Object[])new Object[0]);
        }
        return ce;
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry getEntry(Object id, int source, boolean ignoreCounting, boolean incrementRefCount) {
        String methodName = "getEntry()";
        com.ibm.websphere.cache.CacheEntry ce = this.coreCache.get(id);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getEntry() cacheName=" + this.cacheName + " id=" + id + " cacheEntry=" + ce), (Object[])new Object[0]);
        }
        return ce;
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry getEntryFromMemory(Object id) {
        String methodName = "getEntryFromMemory()";
        com.ibm.websphere.cache.CacheEntry ce = this.coreCache.get(id);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getEntryFromMemory() cacheName=" + this.cacheName + " id=" + id + " cacheEntry=" + ce), (Object[])new Object[0]);
        }
        return ce;
    }

    @Override
    public Enumeration getAllIds() {
        Set<Object> ids = this.coreCache.getCacheIds();
        ValueSet idvs = new ValueSet(ids.iterator());
        return idvs.elements();
    }

    @Override
    public Set getCacheIds() {
        return this.coreCache.getCacheIds();
    }

    @Override
    public Collection getAllDependencyIds() {
        return this.coreCache.getDependencyIds();
    }

    @Override
    public Set getCacheIdsByDependency(Object dependency) {
        return this.coreCache.getCacheIds(dependency);
    }

    @Override
    public Set getCacheIdsByTemplate(String template) {
        return this.coreCache.getCacheIds(template);
    }

    @Override
    public int getMemoryCacheHashcode(boolean debug, boolean includeValue) {
        String methodName = "getMemoryCacheHashcode()";
        int totalHashcode = 0;
        StringBuffer sb = new StringBuffer();
        int count = 0;
        int totalCount = 0;
        Set<Object> cacheIds = this.coreCache.getCacheIds();
        if (cacheIds != null && !cacheIds.isEmpty()) {
            for (Object cacheId : cacheIds) {
                boolean found = false;
                int id_hc = cacheId.hashCode();
                int value_hc = 0;
                if (includeValue) {
                    com.ibm.websphere.cache.CacheEntry ce = this.coreCache.get(cacheId);
                    if (ce != null) {
                        found = true;
                        value_hc = ce.getValue().hashCode();
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getMemoryCacheHashcode() cacheName=" + this.cacheName + " cacheId=" + cacheId + " ERROR - the cache entry cannot be found"), (Object[])new Object[0]);
                    }
                } else {
                    found = true;
                }
                if (debug && found) {
                    sb.append("\nid=");
                    sb.append(cacheId);
                    sb.append(" id_hashcode=");
                    sb.append(id_hc);
                    if (includeValue) {
                        sb.append(" value_hashcode=");
                        sb.append(value_hc);
                    }
                    if (++count == 100) {
                        Tr.info((TraceComponent)tc, (String)"DYNA1035I", (Object[])new Object[]{String.valueOf(count), this.cacheName, sb.toString()});
                        sb.setLength(0);
                        count = 0;
                    }
                }
                if (!found) continue;
                ++totalCount;
                totalHashcode += id_hc;
                if (!includeValue) continue;
                totalHashcode += value_hc;
            }
        }
        if (debug && count > 0) {
            Tr.info((TraceComponent)tc, (String)"DYNA1035I", (Object[])new Object[]{String.valueOf(count), this.cacheName, sb.toString()});
        }
        Tr.info((TraceComponent)tc, (String)"DYNA1038I", (Object[])new Object[]{String.valueOf(totalCount), this.cacheName});
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getMemoryCacheHashcode():  totalCount=" + totalCount + " totalHashcode=" + totalHashcode), (Object[])new Object[0]);
        }
        return totalHashcode;
    }

    @Override
    public int getNumberCacheEntries() {
        if (this.cacheStatistics != null) {
            return (int)this.cacheStatistics.getMemoryCacheEntriesCount();
        }
        return 0;
    }

    @Override
    public int getNumberCacheEntriesUnsynchronized() {
        return this.getNumberCacheEntries();
    }

    @Override
    public Object getValue(Object id, String template, boolean askPermission, boolean ignoreCounting) {
        String methodName = "getValue()";
        Object value = null;
        com.ibm.websphere.cache.CacheEntry ce = this.coreCache.get(id);
        if (ce != null) {
            value = ce.getValue();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getValue() cacheName=" + this.cacheName + " id=" + id + " value=" + value), (Object[])new Object[0]);
        }
        return value;
    }

    @Override
    public Object invalidateAndSet(EntryInfo ei, Object value, boolean coordinate) {
        String methodName = "invalidateAndSet()";
        Object oldValue = null;
        Object id = null;
        if (ei != null && value != null) {
            id = ei.getIdObject();
            com.ibm.websphere.cache.CacheEntry oldCacheEntry = this.coreCache.put(ei, value);
            if (oldCacheEntry != null) {
                oldValue = oldCacheEntry.getValue();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("invalidateAndSet() cacheName=" + this.cacheName + " id=" + id + " value=" + value), (Object[])new Object[0]);
        }
        return oldValue;
    }

    @Override
    public void internalInvalidateByDepId(Object id, int causeOfInvalidation, int source, boolean bFireIL) {
        String methodName = "internalInvalidateByDepId()";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("internalInvalidateByDepId() cacheName=" + this.cacheName + " id=" + id), (Object[])new Object[0]);
        }
        this.invalidateExternalCaches(id, null);
        this.coreCache.invalidateByDependency(id, true);
    }

    @Override
    public void invalidateById(Object id, int causeOfInvalidation, boolean waitOnInvalidation, boolean checkPreInvalidationListener) {
        String methodName = "invalidateById()-1";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("invalidateById()-1 cacheName=" + this.cacheName + " id=" + id), (Object[])new Object[0]);
        }
        this.invalidateExternalCaches(id, null);
        this.coreCache.invalidate(id, waitOnInvalidation);
    }

    @Override
    public void invalidateById(Object id, int causeOfInvalidation, int sourceOfInvalidation, boolean waitOnInvalidation, boolean invokeInternalInvalidateById, boolean invokeDRSRenounce) {
        String methodName = "invalidateById()-2";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("invalidateById()-2 cacheName=" + this.cacheName + " id=" + id), (Object[])new Object[0]);
        }
        this.invalidateExternalCaches(id, null);
        this.coreCache.invalidate(id, waitOnInvalidation);
    }

    @Override
    public void invalidateByTemplate(String template, boolean waitOnInvalidation) {
        String methodName = "invalidateByTemplate()";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("invalidateByTemplate() cacheName=" + this.cacheName + " template=" + template), (Object[])new Object[0]);
        }
        this.invalidateExternalCaches(null, template);
        this.coreCache.invalidateByTemplate(template, waitOnInvalidation);
    }

    private void invalidateExternalCaches(Object id, String template) {
        ServletCacheUnit su = ServerCache.cacheUnit.getServletCacheUnit();
        if (this.cacheConfig.enableServletSupport) {
            if (null != id) {
                HashMap<Object, Object> invalidateIDMap = new HashMap<Object, Object>(1);
                invalidateIDMap.put(id, null);
                su.invalidateExternalCaches(invalidateIDMap, EMPTY_MAP);
            }
            if (null != template && 0 != template.trim().length()) {
                InvalidateByTemplateEvent ite = new InvalidateByTemplateEvent(template, -1);
                HashMap<String, InvalidateByTemplateEvent> invalidateTemplateMap = new HashMap<String, InvalidateByTemplateEvent>(1);
                if (template.equals(CLEAR)) {
                    ite.setCacheCommand_Clear();
                } else {
                    ValueSet removedIds = new ValueSet(this.coreCache.getCacheIds(template).iterator());
                    ite.addRemovedIds(removedIds);
                }
                invalidateTemplateMap.put(template, ite);
                su.invalidateExternalCaches(EMPTY_MAP, invalidateTemplateMap);
            }
        }
    }

    @Override
    public boolean isValid(String id) {
        return this.coreCache.containsCacheId(id);
    }

    @Override
    public void refreshEntry(com.ibm.websphere.cache.CacheEntry cacheEntry) {
        String methodName = "refreshEntry()";
        Object id = null;
        if (cacheEntry != null) {
            id = cacheEntry.getIdObject();
            this.coreCache.refreshEntry(id);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("refreshEntry() cacheName=" + this.cacheName + " id=" + id), (Object[])new Object[0]);
        }
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry setEntry(CacheEntry cacheEntry, int source, boolean ignoreCounting, boolean coordinate, boolean incRefcount) {
        String methodName = "setEntry()";
        Object id = null;
        com.ibm.websphere.cache.CacheEntry newEntry = null;
        if (cacheEntry != null) {
            id = cacheEntry.getIdObject();
            EntryInfo ei = new EntryInfo();
            ei.copyMetadata(cacheEntry);
            this.coreCache.put(ei, cacheEntry.getValue());
            if (incRefcount) {
                newEntry = this.coreCache.get(id);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setEntry() cacheName=" + this.cacheName + " id=" + id), (Object[])new Object[0]);
        }
        return newEntry;
    }

    @Override
    public void setValue(EntryInfo entryInfo, Object value, boolean coordinate, boolean directive) {
        String methodName = "setValue()";
        Object id = null;
        if (entryInfo != null) {
            id = entryInfo.getIdObject();
        }
        if (!directive) {
            this.coreCache.put(entryInfo, value);
        } else {
            this.coreCache.touch(entryInfo.id, entryInfo.validatorExpirationTime, entryInfo.expirationTime);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setValue() cacheName=" + this.cacheName + " id=" + id + " directive=" + directive), (Object[])new Object[0]);
        }
    }

    @Override
    public void start() {
        this.coreCache.start();
    }

    @Override
    public void stop() {
        this.coreCache.stop();
    }

    @Override
    public void addAlias(Object key, Object[] aliasArray, boolean askPermission, boolean coordinate) {
        String methodName = "addAlias()";
        if (this.featureSupport.isAliasSupported()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addAlias() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA1063E", (Object[])new Object[]{"addAlias()", this.cacheName, this.cacheProviderName});
        }
    }

    @Override
    public void removeAlias(Object alias, boolean askPermission, boolean coordinate) {
        String methodName = "removeAlias()";
        if (this.featureSupport.isAliasSupported()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("removeAlias() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA1063E", (Object[])new Object[]{"removeAlias()", this.cacheName, this.cacheProviderName});
        }
    }

    @Override
    public int getCacheIdsHashcodeInPushPullTable(boolean debug) {
        String methodName = "getCacheIdsHashcodeInPushPullTable()";
        if (this.featureSupport.isReplicationSupported()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getCacheIdsHashcodeInPushPullTable() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA1065E", (Object[])new Object[]{"getCacheIdsHashcodeInPushPullTable()", this.cacheName, this.cacheProviderName});
        }
        return 0;
    }

    @Override
    public List getCacheIdsInPushPullTable() {
        String methodName = "getCacheIdsInPushPullTable()";
        ArrayList list = new ArrayList();
        if (this.featureSupport.isReplicationSupported()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getCacheIdsInPushPullTable() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA1065E", (Object[])new Object[]{"getCacheIdsInPushPullTable()", this.cacheName, this.cacheProviderName});
        }
        return list;
    }

    @Override
    public int getPushPullTableSize() {
        String methodName = "getPushPullTableSize()";
        if (this.featureSupport.isReplicationSupported()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getPushPullTableSize() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA1065E", (Object[])new Object[]{"getPushPullTableSize()", this.cacheName, this.cacheProviderName});
        }
        return 0;
    }

    @Override
    public boolean shouldPull(int share, Object id) {
        String methodName = "shouldPull()";
        boolean shouldPull = false;
        if (this.featureSupport.isReplicationSupported()) {
            // empty if block
        }
        return shouldPull;
    }

    @Override
    public void clearDisk() {
        String methodName = "clearDisk()";
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("clearDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"clearDisk()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("clearDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
    }

    @Override
    public boolean containsKeyDisk(Object key) {
        String methodName = "containsKeyDisk()";
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("containsKeyDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"containsKeyDisk()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("containsKeyDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return false;
    }

    @Override
    public int getActualIdsSizeDisk() {
        String methodName = "getActualIdsSizeDisk()";
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getActualIdsSizeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getActualIdsSizeDisk()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getActualIdsSizeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return 0;
    }

    @Override
    public long getCacheSizeInBytesDisk() {
        String methodName = "getCacheSizeInBytesDisk()";
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getCacheSizeInBytesDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getCacheSizeInBytesDisk()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCacheSizeInBytesDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return 0L;
    }

    @Override
    public Set getCacheIdsByDependencyDisk(Object depId) {
        String methodName = "getCacheIdsByDependencyDisk()";
        HashSet ids = new HashSet();
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getCacheIdsByDependencyDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getCacheIdsByDependencyDisk()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCacheIdsByDependencyDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return ids;
    }

    @Override
    public Set getCacheIdsByTemplateDisk(String template) {
        String methodName = "getCacheIdsByTemplateDisk()";
        HashSet ids = new HashSet();
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getCacheIdsByTemplateDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getCacheIdsByTemplateDisk()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCacheIdsByTemplateDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return ids;
    }

    @Override
    public int getDepIdsBufferedSizeDisk() {
        String methodName = "getDepIdsBufferedSizeDisk()";
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getDepIdsBufferedSizeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getDepIdsBufferedSizeDisk()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getDepIdsBufferedSizeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return 0;
    }

    @Override
    public Set getDepIdsByRangeDisk(int index, int length) {
        String methodName = "getDepIdsByRangeDisk()";
        HashSet ids = new HashSet();
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getDepIdsByRangeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getDepIdsByRangeDisk()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getDepIdsByRangeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return ids;
    }

    @Override
    public int getDepIdsSizeDisk() {
        String methodName = "getDepIdsSizeDisk()";
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getDepIdsSizeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getDepIdsSizeDisk()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getDepIdsSizeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return 0;
    }

    @Override
    public Exception getDiskCacheException() {
        String methodName = "getDiskCacheException()";
        Exception ex = null;
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getDiskCacheException() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getDiskCacheException()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getDiskCacheException() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return ex;
    }

    @Override
    public int getDiskCacheHashcode(boolean debug, boolean includeValue) throws DynamicCacheException {
        String methodName = "getDiskCacheHashcode()";
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getDiskCacheHashcode() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getDiskCacheHashcode()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getDiskCacheHashcode() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return 0;
    }

    @Override
    public float getDiskCacheSizeInMBs() {
        String methodName = "getDiskCacheSizeInMBs()";
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getDiskCacheSizeInMBs() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getDiskCacheSizeInMBs()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getDiskCacheSizeInMBs() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return 0.0f;
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry getEntryDisk(Object cacheId) {
        String methodName = "getEntryDisk()";
        com.ibm.websphere.cache.CacheEntry ce = null;
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getEntryDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getEntryDisk()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getEntryDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return ce;
    }

    @Override
    public Set getIdsByRangeDisk(int index, int length) {
        String methodName = "getIdsByRangeDisk()";
        HashSet ids = new HashSet();
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getIdsByRangeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getIdsByRangeDisk()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getIdsByRangeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return ids;
    }

    @Override
    public int getIdsSizeDisk() {
        String methodName = "getIdsSizeDisk()";
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getIdsSizeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getIdsSizeDisk()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getIdsSizeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return 0;
    }

    @Override
    public int getPendingRemovalSizeDisk() {
        String methodName = "getPendingRemovalSizeDisk()";
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getPendingRemovalSizeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getPendingRemovalSizeDisk()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getPendingRemovalSizeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return 0;
    }

    @Override
    public int getTemplatesBufferedSizeDisk() {
        String methodName = "getTemplatesBufferedSizeDisk()";
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getTemplatesBufferedSizeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getTemplatesBufferedSizeDisk()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTemplatesBufferedSizeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return 0;
    }

    @Override
    public Set getTemplatesByRangeDisk(int index, int length) {
        String methodName = "getTemplatesByRangeDisk()";
        HashSet ids = new HashSet();
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getTemplatesByRangeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getTemplatesByRangeDisk()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTemplatesByRangeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return ids;
    }

    @Override
    public int getTemplatesSizeDisk() {
        String methodName = "getTemplatesSizeDisk()";
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getTemplatesSizeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"getTemplatesSizeDisk()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTemplatesSizeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return 0;
    }

    @Override
    public void invokeDiskCleanup(boolean scan) {
        String methodName = "invokeDiskCleanup()";
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("invokeDiskCleanup() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"invokeDiskCleanup()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("invokeDiskCleanup() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isDiskCleanupRunning() {
        String methodName = "isDiskCleanupRunning()";
        boolean diskCleanupRunning = false;
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isDiskCleanupRunning() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"isDiskCleanupRunning()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isDiskCleanupRunning() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return diskCleanupRunning;
    }

    @Override
    public boolean isDiskInvalidationBufferFull() {
        String methodName = "isDiskInvalidationBufferFull()";
        boolean diskInvalidationBufferFull = false;
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isDiskInvalidationBufferFull() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"isDiskInvalidationBufferFull()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isDiskInvalidationBufferFull() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
        return diskInvalidationBufferFull;
    }

    @Override
    public void releaseDiskCacheUnusedPools() {
        String methodName = "releaseDiskCacheUnusedPools()";
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("releaseDiskCacheUnusedPools() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"releaseDiskCacheUnusedPools()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("releaseDiskCacheUnusedPools() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
    }

    @Override
    public void setEnableDiskCacheSizeInBytesChecking(boolean enableDiskCacheSizeInBytesChecking) {
        String methodName = "setEnableDiskCacheSizeInBytesChecking()";
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setEnableDiskCacheSizeInBytesChecking() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"setEnableDiskCacheSizeInBytesChecking()", this.cacheName, this.cacheProviderName});
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setEnableDiskCacheSizeInBytesChecking() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled"), (Object[])new Object[0]);
        }
    }

    @Override
    public void setSwapToDisk(boolean enable) {
        String methodName = "setSwapToDisk()";
        if (enable) {
            if (this.featureSupport.isDiskCacheSupported()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setSwapToDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet"), (Object[])new Object[0]);
                }
                this.swapToDisk = false;
            } else {
                Tr.error((TraceComponent)tc, (String)"DYNA1064E", (Object[])new Object[]{"setSwapToDisk()", this.cacheName, this.cacheProviderName});
                this.swapToDisk = false;
            }
        } else {
            this.swapToDisk = false;
        }
    }

    @Override
    public void refreshCachePerf() {
    }

    @Override
    public void resetPMICounters() {
        String methodName = "resetPMICounters()";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("resetPMICounters() cacheName=" + this.cacheName), (Object[])new Object[0]);
        }
    }

    @Override
    public void updateStatisticsForVBC(com.ibm.websphere.cache.CacheEntry cacheEntry, boolean directive) {
        String methodName = "updateStatisticsForVBC()";
        Object id = null;
        if (cacheEntry != null) {
            id = cacheEntry.getIdObject();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateStatisticsForVBC() cacheName=" + this.cacheName + " id=" + id + " directive=" + directive), (Object[])new Object[0]);
        }
    }

    @Override
    public void setBatchUpdateDaemon(BatchUpdateDaemon batchUpdateDaemon) {
        String methodName = "setBatchUpdateDaemon()";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBatchUpdateDaemon() cacheName=" + this.cacheName), (Object[])new Object[0]);
        }
    }

    @Override
    public void addToTimeLimitDaemon(Object id, long expirationTime, int inactivity) {
        String methodName = "addToTimeLimitDaemon()";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addToTimeLimitDaemon() cacheName=" + this.cacheName + " ERROR because it should not be called"), (Object[])new Object[0]);
        }
    }

    @Override
    public void batchUpdate(HashMap invalidateIdEvents, HashMap invalidateTemplateEvents, ArrayList pushEntryEvents) {
        String methodName = "batchUpdate()";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("batchUpdate() cacheName=" + this.cacheName + " ERROR because it should not be called"), (Object[])new Object[0]);
        }
    }

    @Override
    public RemoteServices getRemoteServices() {
        return new NullRemoteServices();
    }

    @Override
    public FreeLruEntryResult freeLruEntry() {
        String methodName = "freeLruEntry()";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("freeLruEntry() cacheName=" + this.cacheName + " ERROR because it should not be called"), (Object[])new Object[0]);
        }
        return new FreeLruEntryResult();
    }

    @Override
    public void setRemoteServices(RemoteServices remoteServices) {
        String methodName = "setRemoteServices(remoteServices)";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setRemoteServices(remoteServices) cacheName=" + this.cacheName + " ERROR because it should not be called"), (Object[])new Object[0]);
        }
    }

    @Override
    public void setTimeLimitDaemon(TimeLimitDaemon timeLimitDaemon) {
        String methodName = "setTimeLimitDaemon(timeLimitDaemon)";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTimeLimitDaemon(timeLimitDaemon) cacheName=" + this.cacheName + " ERROR because it should not be called"), (Object[])new Object[0]);
        }
    }

    @Override
    public void trimCache() {
        String methodName = "trimCache()";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("trimCache() cacheName=" + this.cacheName + " ERROR because it should not be called"), (Object[])new Object[0]);
        }
    }

    @Override
    public void clearMemory(boolean clearDisk) {
        String methodName = "clearDisk";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("clearDisk cacheName=" + this.cacheName + " ERROR because it should not be called"), (Object[])new Object[0]);
        }
    }

    @Override
    public void setInvalidationAuditDaemon(InvalidationAuditDaemon iad) {
        String methodName = "setInvalidationAuditDaemon(iad)";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setInvalidationAuditDaemon(iad) cacheName=" + this.cacheName + " ERROR because it should not be called"), (Object[])new Object[0]);
        }
    }
}

