/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.metadata.EndpointInfo;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleInfo;
import com.ibm.ws.jaxrs20.utils.JaxRsUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInjectionClassListCollaborator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.jaxrs20.web.JaxRsInjectionClassListCollaborator", service={WebAppInjectionClassListCollaborator.class}, immediate=true, property={"service.vendor=IBM"})
public class JaxRsInjectionClassListCollaborator
implements WebAppInjectionClassListCollaborator {
    private static final TraceComponent tc = Tr.register(JaxRsInjectionClassListCollaborator.class);
    static final long serialVersionUID = 5463049711956265703L;

    public List<String> getInjectionClasses(Container moduleContainer) {
        try {
            JaxRsModuleInfo jaxRsModuleInfo = (JaxRsModuleInfo)moduleContainer.adapt(JaxRsModuleInfo.class);
            if (jaxRsModuleInfo != null && jaxRsModuleInfo.endpointInfoSize() > 0) {
                HashSet<String> retClassNames = new HashSet<String>();
                for (EndpointInfo endpointInfo : jaxRsModuleInfo.getEndpointInfos()) {
                    retClassNames.add(endpointInfo.getAppClassName());
                }
                return new ArrayList<String>(retClassNames);
            }
            if (!JaxRsUtils.isWebModule((Container)moduleContainer)) {
                return Collections.emptyList();
            }
            return InjectionUtils.getJaxRsInjectionClasses((Container)moduleContainer);
        }
        catch (UnableToAdaptException jaxRsModuleInfo) {
            FFDCFilter.processException((Throwable)jaxRsModuleInfo, (String)"com.ibm.ws.jaxrs20.web.JaxRsInjectionClassListCollaborator", (String)"62", (Object)this, (Object[])new Object[]{moduleContainer});
            return Collections.emptyList();
        }
    }

    private List<String> getAllHandlerClassNames(JaxRsModuleInfo jaxRsModuleInfo) {
        ArrayList<String> handlerClassNames = new ArrayList<String>();
        for (EndpointInfo edpInfo : jaxRsModuleInfo.getEndpointInfos()) {
        }
        return handlerClassNames;
    }
}

