/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.InterruptedResolutionException;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.FileUtil;
import org.apache.felix.bundlerepository.impl.LocalRepositoryImpl;
import org.apache.felix.bundlerepository.impl.LocalResourceImpl;
import org.apache.felix.bundlerepository.impl.ReasonImpl;
import org.apache.felix.bundlerepository.impl.ResourceCapability;
import org.apache.felix.bundlerepository.impl.ResourceCapabilityImpl;
import org.apache.felix.bundlerepository.impl.ResourceImpl;
import org.apache.felix.bundlerepository.impl.SystemRepositoryImpl;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class ResolverImpl
implements Resolver {
    private final BundleContext m_context;
    private final Logger m_logger;
    private final Repository[] m_repositories;
    private final Set m_addedSet = new HashSet();
    private final Set m_addedRequirementSet = new HashSet();
    private final Set m_globalCapabilities = new HashSet();
    private final Set m_failedSet = new HashSet();
    private final Set m_resolveSet = new HashSet();
    private final Set m_requiredSet = new HashSet();
    private final Set m_optionalSet = new HashSet();
    private final Map m_reasonMap = new HashMap();
    private final Set m_unsatisfiedSet = new HashSet();
    private boolean m_resolved = false;
    private long m_resolveTimeStamp;
    private int m_resolutionFlags;
    private int m_deployFlags;

    public ResolverImpl(BundleContext context, Repository[] repositories, Logger logger) {
        this.m_context = context;
        this.m_logger = logger;
        this.m_repositories = repositories;
    }

    public synchronized void add(Resource resource) {
        this.m_resolved = false;
        this.m_addedSet.add(resource);
    }

    public synchronized Resource[] getAddedResources() {
        return this.m_addedSet.toArray(new Resource[this.m_addedSet.size()]);
    }

    public synchronized void add(Requirement requirement) {
        this.m_resolved = false;
        this.m_addedRequirementSet.add(requirement);
    }

    public synchronized Requirement[] getAddedRequirements() {
        return this.m_addedRequirementSet.toArray(new Requirement[this.m_addedRequirementSet.size()]);
    }

    public void addGlobalCapability(Capability capability) {
        this.m_globalCapabilities.add(capability);
    }

    public Capability[] getGlobalCapabilities() {
        return this.m_globalCapabilities.toArray(new Capability[this.m_globalCapabilities.size()]);
    }

    public synchronized Resource[] getRequiredResources() {
        if (this.m_resolved) {
            return this.m_requiredSet.toArray(new Resource[this.m_requiredSet.size()]);
        }
        throw new IllegalStateException("The resources have not been resolved.");
    }

    public synchronized Resource[] getOptionalResources() {
        if (this.m_resolved) {
            return this.m_optionalSet.toArray(new Resource[this.m_optionalSet.size()]);
        }
        throw new IllegalStateException("The resources have not been resolved.");
    }

    public synchronized Reason[] getReason(Resource resource) {
        if (this.m_resolved) {
            List l = (List)this.m_reasonMap.get(resource);
            return l != null ? l.toArray(new Reason[l.size()]) : null;
        }
        throw new IllegalStateException("The resources have not been resolved.");
    }

    public synchronized Reason[] getUnsatisfiedRequirements() {
        if (this.m_resolved) {
            return this.m_unsatisfiedSet.toArray(new Reason[this.m_unsatisfiedSet.size()]);
        }
        throw new IllegalStateException("The resources have not been resolved.");
    }

    private Resource[] getResources(boolean local) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (int repoIdx = 0; this.m_repositories != null && repoIdx < this.m_repositories.length; ++repoIdx) {
            boolean isLocal = this.m_repositories[repoIdx] instanceof LocalRepositoryImpl;
            boolean isSystem = this.m_repositories[repoIdx] instanceof SystemRepositoryImpl;
            if (isLocal && (this.m_resolutionFlags & 2) != 0 || isSystem && (this.m_resolutionFlags & 4) != 0) continue;
            Resource[] res = this.m_repositories[repoIdx].getResources();
            for (int resIdx = 0; res != null && resIdx < res.length; ++resIdx) {
                if (res[resIdx].isLocal() != local) continue;
                resources.add(res[resIdx]);
            }
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    public synchronized boolean resolve() {
        return this.resolve(0);
    }

    public synchronized boolean resolve(int flags) {
        Resource[] locals = this.getResources(true);
        Resource[] remotes = this.getResources(false);
        this.m_resolveTimeStamp = 0L;
        for (int repoIdx = 0; this.m_repositories != null && repoIdx < this.m_repositories.length; ++repoIdx) {
            this.m_resolveTimeStamp = Math.max(this.m_resolveTimeStamp, this.m_repositories[repoIdx].getLastModified());
        }
        this.m_failedSet.clear();
        this.m_resolveSet.clear();
        this.m_requiredSet.clear();
        this.m_optionalSet.clear();
        this.m_reasonMap.clear();
        this.m_unsatisfiedSet.clear();
        this.m_resolved = true;
        this.m_resolutionFlags = flags;
        boolean result = true;
        if (!this.m_addedRequirementSet.isEmpty() || !this.m_globalCapabilities.isEmpty()) {
            ResourceImpl fake = new ResourceImpl();
            Iterator iter = this.m_globalCapabilities.iterator();
            while (iter.hasNext()) {
                Capability cap = (Capability)iter.next();
                fake.addCapability(cap);
            }
            iter = this.m_addedRequirementSet.iterator();
            while (iter.hasNext()) {
                Requirement req = (Requirement)iter.next();
                fake.addRequire(req);
            }
            if (!this.resolve(fake, locals, remotes, false)) {
                result = false;
            }
        }
        Iterator iter = this.m_addedSet.iterator();
        while (iter.hasNext()) {
            if (this.resolve((Resource)iter.next(), locals, remotes, false)) continue;
            result = false;
        }
        this.m_requiredSet.removeAll(this.m_addedSet);
        if ((flags & 2) == 0) {
            this.m_requiredSet.removeAll(Arrays.asList(locals));
        }
        this.m_optionalSet.removeAll(this.m_addedSet);
        this.m_optionalSet.removeAll(this.m_requiredSet);
        if ((flags & 2) == 0) {
            this.m_optionalSet.removeAll(Arrays.asList(locals));
        }
        return result;
    }

    private boolean resolve(Resource resource, Resource[] locals, Resource[] remotes, boolean optional) {
        boolean result = true;
        if (this.m_resolveSet.contains(resource) || this.m_requiredSet.contains(resource) || this.m_optionalSet.contains(resource)) {
            return true;
        }
        if (this.m_failedSet.contains(resource)) {
            return false;
        }
        this.m_resolveSet.add(resource);
        Requirement[] reqs = resource.getRequirements();
        if (reqs != null) {
            for (int reqIdx = 0; reqIdx < reqs.length; ++reqIdx) {
                if ((this.m_resolutionFlags & 1) != 0 && reqs[reqIdx].isOptional()) continue;
                Resource candidate = this.searchResources(reqs[reqIdx], this.m_addedSet);
                if (candidate == null) {
                    candidate = this.searchResources(reqs[reqIdx], this.m_requiredSet);
                }
                if (candidate == null) {
                    candidate = this.searchResources(reqs[reqIdx], this.m_optionalSet);
                }
                if (candidate == null) {
                    candidate = this.searchResources(reqs[reqIdx], this.m_resolveSet);
                }
                if (candidate == null) {
                    List candidateCapabilities = this.searchResources(reqs[reqIdx], locals);
                    candidateCapabilities.addAll(this.searchResources(reqs[reqIdx], remotes));
                    while (candidate == null && !candidateCapabilities.isEmpty()) {
                        ResourceCapability bestCapability = this.getBestCandidate(candidateCapabilities);
                        if (this.resolve(bestCapability.getResource(), locals, remotes, optional || reqs[reqIdx].isOptional())) {
                            candidate = bestCapability.getResource();
                            continue;
                        }
                        candidateCapabilities.remove(bestCapability);
                    }
                }
                if (candidate == null && !reqs[reqIdx].isOptional()) {
                    result = false;
                    this.m_unsatisfiedSet.add(new ReasonImpl(resource, reqs[reqIdx]));
                    continue;
                }
                if (candidate == null) continue;
                if (this.resolve(candidate, locals, remotes, optional || reqs[reqIdx].isOptional())) {
                    if (optional || reqs[reqIdx].isOptional()) {
                        this.m_optionalSet.add(candidate);
                        this.m_resolveSet.remove(candidate);
                    } else {
                        this.m_requiredSet.add(candidate);
                        this.m_optionalSet.remove(candidate);
                        this.m_resolveSet.remove(candidate);
                    }
                    ArrayList<ReasonImpl> reasons = (ArrayList<ReasonImpl>)this.m_reasonMap.get(candidate);
                    if (reasons == null) {
                        reasons = new ArrayList<ReasonImpl>();
                        this.m_reasonMap.put(candidate, reasons);
                    }
                    reasons.add(new ReasonImpl(resource, reqs[reqIdx]));
                    continue;
                }
                result = false;
            }
        }
        if (!result) {
            this.m_resolveSet.remove(resource);
            this.m_failedSet.add(resource);
        }
        return result;
    }

    private Resource searchResources(Requirement req, Set resourceSet) {
        Iterator iter = resourceSet.iterator();
        while (iter.hasNext()) {
            this.checkInterrupt();
            Resource resource = (Resource)iter.next();
            Capability[] caps = resource.getCapabilities();
            for (int capIdx = 0; caps != null && capIdx < caps.length; ++capIdx) {
                if (!req.isSatisfied(caps[capIdx])) continue;
                return resource;
            }
        }
        return null;
    }

    private List searchResources(Requirement req, Resource[] resources) {
        ArrayList<ResourceCapabilityImpl> matchingCapabilities = new ArrayList<ResourceCapabilityImpl>();
        for (int resIdx = 0; resources != null && resIdx < resources.length; ++resIdx) {
            this.checkInterrupt();
            if (this.m_failedSet.contains(resources[resIdx])) continue;
            Capability[] caps = resources[resIdx].getCapabilities();
            for (int capIdx = 0; caps != null && capIdx < caps.length; ++capIdx) {
                if (!req.isSatisfied(caps[capIdx])) continue;
                matchingCapabilities.add(new ResourceCapabilityImpl(resources[resIdx], caps[capIdx]));
            }
        }
        return matchingCapabilities;
    }

    private ResourceCapability getBestCandidate(List caps) {
        Version bestVersion = null;
        ResourceCapability best = null;
        boolean bestLocal = false;
        for (int capIdx = 0; capIdx < caps.size(); ++capIdx) {
            Object v;
            ResourceCapability current = (ResourceCapability)caps.get(capIdx);
            boolean isCurrentLocal = current.getResource().isLocal();
            if (best == null) {
                best = current;
                bestLocal = isCurrentLocal;
                v = current.getCapability().getPropertiesAsMap().get("version");
                if (v == null || !(v instanceof Version)) continue;
                bestVersion = (Version)v;
                continue;
            }
            if ((this.m_resolutionFlags & 8) == 0 && bestLocal && !isCurrentLocal) continue;
            v = current.getCapability().getPropertiesAsMap().get("version");
            if (v == null && bestVersion == null && best.getResource().getCapabilities().length < current.getResource().getCapabilities().length) {
                best = current;
                bestLocal = isCurrentLocal;
                bestVersion = null;
                continue;
            }
            if (v == null || !(v instanceof Version)) continue;
            if (bestVersion == null || bestVersion.compareTo(v) < 0) {
                best = current;
                bestLocal = isCurrentLocal;
                bestVersion = (Version)v;
                continue;
            }
            if (bestVersion == null || bestVersion.compareTo(v) != 0) continue;
            if (best.getResource().getSymbolicName() != null && best.getResource().getSymbolicName().equals(current.getResource().getSymbolicName())) {
                if (best.getResource().getVersion().compareTo((Object)current.getResource().getVersion()) >= 0) continue;
                best = current;
                bestLocal = isCurrentLocal;
                bestVersion = (Version)v;
                continue;
            }
            if (best.getResource().getCapabilities().length >= current.getResource().getCapabilities().length) continue;
            best = current;
            bestLocal = isCurrentLocal;
            bestVersion = (Version)v;
        }
        return best == null ? null : best;
    }

    private void checkInterrupt() {
        if (Thread.interrupted()) {
            throw new InterruptedResolutionException();
        }
    }

    public synchronized void deploy(int flags) {
        int i;
        int i2;
        this.m_deployFlags = flags;
        if (!this.m_resolved && !this.resolve(flags)) {
            this.m_logger.log(1, "Resolver: Cannot resolve target resources.");
            return;
        }
        for (int repoIdx = 0; this.m_repositories != null && repoIdx < this.m_repositories.length; ++repoIdx) {
            if (this.m_repositories[repoIdx].getLastModified() <= this.m_resolveTimeStamp) continue;
            throw new IllegalStateException("Framework state has changed, must resolve again.");
        }
        HashMap<Resource, Resource> deployMap = new HashMap<Resource, Resource>();
        Resource[] resources = this.getAddedResources();
        for (i2 = 0; resources != null && i2 < resources.length; ++i2) {
            deployMap.put(resources[i2], resources[i2]);
        }
        resources = this.getRequiredResources();
        for (i2 = 0; resources != null && i2 < resources.length; ++i2) {
            deployMap.put(resources[i2], resources[i2]);
        }
        if ((flags & 1) == 0) {
            resources = this.getOptionalResources();
            for (i2 = 0; resources != null && i2 < resources.length; ++i2) {
                deployMap.put(resources[i2], resources[i2]);
            }
        }
        Resource[] deployResources = deployMap.keySet().toArray(new Resource[deployMap.size()]);
        ArrayList<Bundle> startList = new ArrayList<Bundle>();
        for (i = 0; i < deployResources.length; ++i) {
            Bundle bundle;
            LocalResourceImpl localResource = this.findUpdatableLocalResource(deployResources[i]);
            if (localResource != null && this.isResourceUpdatable(localResource, deployResources[i], deployResources)) {
                if (localResource.equals(deployResources[i])) continue;
                try {
                    boolean doStartBundle;
                    boolean bl = doStartBundle = (flags & 0x10) != 0;
                    if (localResource.getBundle().getState() == 32) {
                        doStartBundle = true;
                        localResource.getBundle().stop();
                    }
                    localResource.getBundle().update(FileUtil.openURL(new URL(deployResources[i].getURI())));
                    if (!doStartBundle || this.isFragmentBundle(bundle = localResource.getBundle())) continue;
                    startList.add(bundle);
                    continue;
                }
                catch (Exception ex) {
                    this.m_logger.log(1, "Resolver: Update error - " + ResolverImpl.getBundleName(localResource.getBundle()), ex);
                    return;
                }
            }
            try {
                URL url = new URL(deployResources[i].getURI());
                if (url == null) continue;
                bundle = this.m_context.installBundle("obr://" + deployResources[i].getSymbolicName() + "/-" + System.currentTimeMillis(), FileUtil.openURL(url));
                if ((flags & 0x10) == 0 || this.isFragmentBundle(bundle)) continue;
                startList.add(bundle);
                continue;
            }
            catch (Exception ex) {
                this.m_logger.log(1, "Resolver: Install error - " + deployResources[i].getSymbolicName(), ex);
                return;
            }
        }
        for (i = 0; i < startList.size(); ++i) {
            try {
                ((Bundle)startList.get(i)).start();
                continue;
            }
            catch (BundleException ex) {
                this.m_logger.log(1, "Resolver: Start error - " + ((Bundle)startList.get(i)).getSymbolicName(), ex);
            }
        }
    }

    private boolean isFragmentBundle(Bundle bundle) {
        return bundle.getHeaders().get("Fragment-Host") != null;
    }

    private LocalResourceImpl findUpdatableLocalResource(Resource resource) {
        Resource[] localResources = this.findLocalResources(resource.getSymbolicName());
        if (localResources != null) {
            for (int i = 0; i < localResources.length; ++i) {
                if (!this.isResourceUpdatable(localResources[i], resource, localResources)) continue;
                return (LocalResourceImpl)localResources[i];
            }
        }
        return null;
    }

    private Resource[] findLocalResources(String symName) {
        Resource[] localResources = this.getResources(true);
        ArrayList<Resource> matchList = new ArrayList<Resource>();
        for (int i = 0; i < localResources.length; ++i) {
            String localSymName = localResources[i].getSymbolicName();
            if (localSymName == null || !localSymName.equals(symName)) continue;
            matchList.add(localResources[i]);
        }
        return matchList.toArray(new Resource[matchList.size()]);
    }

    private boolean isResourceUpdatable(Resource oldVersion, Resource newVersion, Resource[] resources) {
        Requirement[] reqs = this.getResolvableRequirements(oldVersion, resources);
        if (reqs == null) {
            return true;
        }
        Capability[] caps = newVersion.getCapabilities();
        if (caps == null) {
            return false;
        }
        for (int reqIdx = 0; reqIdx < reqs.length; ++reqIdx) {
            boolean satisfied = false;
            for (int capIdx = 0; !satisfied && capIdx < caps.length; ++capIdx) {
                if (!reqs[reqIdx].isSatisfied(caps[capIdx])) continue;
                satisfied = true;
            }
            if (satisfied) continue;
            return false;
        }
        return true;
    }

    private Requirement[] getResolvableRequirements(Resource resource, Resource[] resources) {
        Capability[] caps = resource.getCapabilities();
        if (caps != null && caps.length > 0) {
            ArrayList<Requirement> reqList = new ArrayList<Requirement>();
            for (int capIdx = 0; capIdx < caps.length; ++capIdx) {
                boolean added = false;
                for (int resIdx = 0; !added && resIdx < resources.length; ++resIdx) {
                    Requirement[] reqs = resources[resIdx].getRequirements();
                    for (int reqIdx = 0; reqs != null && reqIdx < reqs.length; ++reqIdx) {
                        if (!reqs[reqIdx].isSatisfied(caps[capIdx])) continue;
                        added = true;
                        reqList.add(reqs[reqIdx]);
                    }
                }
            }
            return reqList.toArray(new Requirement[reqList.size()]);
        }
        return null;
    }

    public static String getBundleName(Bundle bundle) {
        String name = (String)bundle.getHeaders().get("Bundle-Name");
        return name == null ? "Bundle " + Long.toString(bundle.getBundleId()) : name;
    }
}

