/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.blueprint.aries.impl;

import java.util.Arrays;
import java.util.Collections;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableReferenceMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFServiceRefFactory {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.blueprint.aries");
    private static final String ACTIVATION_EAGER = "EAGER";

    ComponentMetadata create(boolean isPersistenceUnit, ParserContext ctx, String unitName) {
        MutableReferenceMetadata refMetadata = (MutableReferenceMetadata)ctx.createMetadata(MutableReferenceMetadata.class);
        refMetadata.setActivation(ACTIVATION_EAGER.equalsIgnoreCase(ctx.getDefaultActivation()) ? 1 : 2);
        refMetadata.setAvailability(1);
        refMetadata.setInterface(EntityManagerFactory.class.getName());
        String filter = this.createEMFServiceFilter(isPersistenceUnit, unitName);
        refMetadata.setFilter(filter);
        refMetadata.setTimeout((long)Integer.parseInt(ctx.getDefaultTimeout()));
        refMetadata.setDependsOn(Collections.EMPTY_LIST);
        refMetadata.setId(ctx.generateId());
        MutableReferenceMetadata target = isPersistenceUnit ? refMetadata : this.createInjectionBeanMetedata(ctx, refMetadata);
        return target;
    }

    private String createEMFServiceFilter(boolean isPersistenceUnit, String unitName) {
        StringBuilder filter = new StringBuilder("(&");
        if (isPersistenceUnit) {
            filter.append("(!(org.apache.aries.jpa.proxy.factory=*))");
        } else {
            filter.append("(org.apache.aries.jpa.proxy.factory=true)");
        }
        if (!"".equals(unitName)) {
            filter.append("(osgi.unit.name=" + unitName + ")");
        } else {
            filter.append("(org.apache.aries.jpa.default.unit.name=true)");
        }
        filter.append(")");
        return filter.toString();
    }

    private ComponentMetadata createInjectionBeanMetedata(ParserContext ctx, MutableReferenceMetadata factory) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Creating a managed persistence context definition for injection");
        }
        factory.setProxyChildBeanClasses(Arrays.asList(EntityManager.class));
        ctx.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)factory);
        MutableBeanMetadata meta = (MutableBeanMetadata)ctx.createMetadata(MutableBeanMetadata.class);
        MutableRefMetadata ref = (MutableRefMetadata)ctx.createMetadata(MutableRefMetadata.class);
        ref.setComponentId(factory.getId());
        meta.setFactoryComponent((Target)ref);
        meta.setActivation(factory.getActivation());
        meta.setFactoryMethod("createEntityManager");
        meta.setScope("prototype");
        meta.setDestroyMethod("internalClose");
        return meta;
    }
}

