/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class NLS {
    private static TraceComponent tc = Tr.register(NLS.class);
    private static NLS messages = null;
    static final String baseClassPackage = "com.ibm.ejs.resources";
    private String bundleName;
    private ResourceBundle bundle;
    static final long serialVersionUID = 4833185310292480317L;

    private static NLS getMessages() {
        if (messages == null) {
            messages = new NLS("messages");
        }
        return messages;
    }

    public NLS(String bundleName) {
        this(bundleName, Locale.getDefault());
    }

    @ManualTrace
    public NLS(String bundleName, Locale locale) {
        block6: {
            this.bundle = null;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("NLS, " + bundleName + '/' + locale), (Object[])new Object[0]);
            }
            this.bundleName = bundleName;
            try {
                String fullBundleName = bundleName;
                this.bundle = TraceNLS.getResourceBundle((String)fullBundleName, (Locale)locale);
            }
            catch (MissingResourceException e) {
                try {
                    String fullBundleName = "com.ibm.ejs.resources." + bundleName;
                    this.bundle = TraceNLS.getResourceBundle((String)fullBundleName, (Locale)locale);
                }
                catch (MissingResourceException ex) {
                    if (!tc.isEventEnabled()) break block6;
                    String msg = NLS.getMessages().getString("NLS.resourceBundleError", "Encountered an error while loading class PropertyResourceBundle from a JAR file {0}");
                    Tr.warning((TraceComponent)tc, (String)msg, (Object[])new Object[]{ex});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"NLS");
        }
    }

    public NLS(String bundleName, boolean fullyQualified) {
        this(bundleName, Locale.getDefault(), fullyQualified, true);
    }

    public NLS(String bundleName, Locale locale, boolean fullyQualified) {
        this(bundleName, locale, fullyQualified, true);
    }

    @ManualTrace
    public NLS(String bundleName, Locale locale, boolean fullyQualified, boolean logFFDC) {
        block4: {
            this.bundle = null;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("NLS, " + bundleName + '/' + locale), (Object[])new Object[0]);
            }
            this.bundleName = bundleName;
            try {
                String fullBundleName = fullyQualified ? bundleName : "com.ibm.ejs.resources." + bundleName;
                this.bundle = TraceNLS.getResourceBundle((String)fullBundleName, (Locale)locale);
            }
            catch (MissingResourceException ex) {
                if (!logFFDC || !tc.isEventEnabled()) break block4;
                String msg = NLS.getMessages().getString("NLS.resourceBundleError", "Encountered an error while loading class PropertyResourceBundle from a JAR file {0}");
                Tr.warning((TraceComponent)tc, (String)msg, (Object[])new Object[]{ex});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"NLS");
        }
    }

    @ManualTrace
    public NLS(String bundleName, Locale locale, ClassLoader cl) {
        block6: {
            this.bundle = null;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("NLS, " + bundleName + '/' + locale), (Object[])new Object[0]);
            }
            this.bundleName = bundleName;
            try {
                this.bundle = ResourceBundle.getBundle(bundleName, locale, cl);
            }
            catch (Exception ex) {
                try {
                    this.bundle = TraceNLS.getResourceBundle((String)bundleName, (Locale)locale);
                }
                catch (Exception ex2) {
                    if (!tc.isEventEnabled()) break block6;
                    String msg = NLS.getMessages().getString("NLS.resourceBundleError", "Encountered an error while loading class PropertyResourceBundle from a JAR file {0}");
                    Tr.warning((TraceComponent)tc, (String)msg, (Object[])new Object[]{ex});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"NLS");
        }
    }

    public String getString(String key) throws MissingResourceException {
        if (key == null) {
            if (tc.isEventEnabled()) {
                String msg = NLS.getMessages().getString("NLS.nullKey", "Null lookup key passed to NLS");
                Tr.warning((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            }
            return null;
        }
        if (this.bundle == null) {
            if (tc.isEventEnabled()) {
                String msg = NLS.getMessages().getString("NLS.noBundles", "Encountered an internal error. No valid bundles.");
                Tr.warning((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            }
            throw new MissingResourceException(this.bundleName, this.bundleName, key);
        }
        String rtn = null;
        rtn = this.bundle.getString(key);
        return rtn;
    }

    public String getString(String key, String defaultString) {
        if (key == null) {
            return defaultString;
        }
        try {
            String result = this.getString(key);
            return result;
        }
        catch (MissingResourceException e) {
            return defaultString;
        }
    }

    public String getFormattedMessage(String key, Object[] args, String defaultString) {
        try {
            String result = this.getString(key);
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            return MessageFormat.format(defaultString, args);
        }
    }

    public int getInteger(String key, int defaultValue) {
        int result = defaultValue;
        try {
            if (key != null) {
                result = this.getInteger(key);
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return result;
    }

    public int getInteger(String key) throws MissingResourceException {
        String result = this.getString(key);
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException nfe) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unable to parse " + result + " as Integer."), (Object[])new Object[0]);
            }
            String msg = NLS.getMessages().getString("NLS.integerParseError", "Unable to parse as integer.");
            throw new MissingResourceException(msg, this.bundleName, key);
        }
    }

    public Locale getLocale() {
        return this.bundle.getLocale();
    }

    public String getName() {
        return this.bundleName;
    }

    public String getKey(String key) throws MissingResourceException {
        return this.getString(key);
    }

    public String getKey(String key, String defaultString) {
        return this.getString(key, defaultString);
    }

    public boolean isResourceLoaded() {
        return this.bundle != null;
    }
}

