/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal.bci;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.monitor.internal.MonitoringProxyActivator;
import com.ibm.ws.monitor.internal.ProbeImpl;
import com.ibm.ws.monitor.internal.ProbeListener;
import com.ibm.ws.monitor.internal.ProbeManagerImpl;
import com.ibm.ws.monitor.internal.bci.MethodInfo;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class ProbeMethodAdapter
extends MethodVisitor {
    private static final Object THIS;
    private static final Object OTHER;
    public static final String FIRE_PROBE_METHOD_NAME = "fireProbe";
    public static final String FIRE_PROBE_METHOD_DESC;
    private boolean waitingForSuper = false;
    private boolean observedFirstInstruction = false;
    private List<Object> currentStack;
    private Map<Label, List<Object>> branchTargets;
    private final MethodVisitor visitor;
    private ProbeMethodAdapter probeMethodAdapter;
    private boolean probeInProgress = false;
    private final MethodInfo methodInfo;
    private final Map<ProbeImpl, Set<ProbeListener>> enabledProbes = new HashMap<ProbeImpl, Set<ProbeListener>>();
    static final long serialVersionUID = -2701543340856513808L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ProbeMethodAdapter(MethodVisitor visitor, MethodInfo methodInfo) {
        super(327680, visitor);
        this.visitor = visitor;
        this.methodInfo = methodInfo;
    }

    protected ProbeMethodAdapter(ProbeMethodAdapter probeMethodAdapter, MethodInfo methodInfo) {
        super(327680, (MethodVisitor)probeMethodAdapter);
        this.probeMethodAdapter = probeMethodAdapter;
        this.visitor = probeMethodAdapter.getVisitor();
        this.methodInfo = methodInfo;
        if (this.isConstructor()) {
            this.waitingForSuper = true;
            this.currentStack = new ArrayList<Object>();
            this.branchTargets = new HashMap<Label, List<Object>>();
        }
    }

    protected void setProbeListeners(ProbeImpl probe, Collection<ProbeListener> listeners) {
        Set<ProbeListener> enabled = this.enabledProbes.get(probe);
        if (enabled == null) {
            enabled = new HashSet<ProbeListener>();
            this.enabledProbes.put(probe, enabled);
        }
        enabled.addAll(listeners);
    }

    protected Set<ProbeImpl> getEnabledProbes() {
        return this.enabledProbes.keySet();
    }

    protected Set<ProbeListener> getProbeListeners(ProbeImpl probe) {
        Set<ProbeListener> listeners = this.enabledProbes.get(probe);
        if (listeners == null) {
            listeners = Collections.emptySet();
        }
        return listeners;
    }

    protected ProbeManagerImpl getProbeManager() {
        return this.methodInfo.getClassAdapter().getProbeManager();
    }

    protected Class<?> getProbedClass() {
        return this.methodInfo.getClassAdapter().getProbedClass();
    }

    protected ProbeImpl getProbe(String probeKey) {
        ProbeImpl probeImpl = this.getProbeManager().getProbe(this.getProbedClass(), probeKey);
        if (probeImpl == null) {
            Class<?> probedClass = this.getProbedClass();
            Constructor<?> ctor = this.methodInfo.getClassAdapter().getConstructor(this.getMethodName(), this.getDescriptor());
            Method method = this.methodInfo.getClassAdapter().getMethod(this.getMethodName(), this.getDescriptor());
            probeImpl = this.getProbeManager().createProbe(probedClass, probeKey, ctor, method);
        }
        return probeImpl;
    }

    protected String getMethodName() {
        return this.methodInfo.getMethodName();
    }

    protected String getDescriptor() {
        return this.methodInfo.getDescriptor();
    }

    protected boolean isConstructor() {
        return "<init>".equals(this.getMethodName());
    }

    protected boolean isStaticInitializer() {
        return this.isStatic() && "<clinit>".equals(this.getMethodName());
    }

    protected int getAccessFlags() {
        return this.methodInfo.getAccessFlags();
    }

    protected boolean isStatic() {
        return (this.getAccessFlags() & 8) != 0;
    }

    protected String getSignature() {
        return this.methodInfo.getSignature();
    }

    protected Type[] getArgumentTypes() {
        return Type.getArgumentTypes((String)this.getDescriptor());
    }

    protected Type getReturnType() {
        return Type.getReturnType((String)this.getDescriptor());
    }

    protected Set<Type> getDeclaredExceptions() {
        HashSet<Type> exceptionSet = new HashSet<Type>();
        for (String exception : this.methodInfo.getDeclaredExceptions()) {
            exceptionSet.add(Type.getType((String)exception));
        }
        return exceptionSet;
    }

    protected void visitFireProbeInvocation() {
        this.visitMethodInsn(184, MonitoringProxyActivator.PROBE_PROXY_CLASS_INTERNAL_NAME, FIRE_PROBE_METHOD_NAME, FIRE_PROBE_METHOD_DESC, false);
    }

    protected void box(Type type) {
        switch (type.getSort()) {
            case 1: {
                this.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                break;
            }
            case 3: {
                this.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                break;
            }
            case 2: {
                this.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                break;
            }
            case 8: {
                this.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                break;
            }
            case 6: {
                this.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                break;
            }
            case 5: {
                this.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                break;
            }
            case 7: {
                this.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                break;
            }
            case 4: {
                this.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
    }

    protected void unbox(Type type) {
        switch (type.getSort()) {
            case 1: {
                this.visitTypeInsn(192, "java/lang/Boolean");
                this.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                break;
            }
            case 3: {
                this.visitTypeInsn(192, "java/lang/Byte");
                this.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
                break;
            }
            case 2: {
                this.visitTypeInsn(192, "java/lang/Character");
                this.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
                break;
            }
            case 8: {
                this.visitTypeInsn(192, "java/lang/Double");
                this.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
                break;
            }
            case 6: {
                this.visitTypeInsn(192, "java/lang/Float");
                this.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
                break;
            }
            case 5: {
                this.visitTypeInsn(192, "java/lang/Integer");
                this.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                break;
            }
            case 7: {
                this.visitTypeInsn(192, "java/lang/Long");
                this.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
                break;
            }
            case 4: {
                this.visitTypeInsn(192, "java/lang/Short");
                this.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
                break;
            }
            case 9: 
            case 10: {
                this.visitTypeInsn(192, type.getInternalName());
                break;
            }
        }
    }

    protected void createParameterArray() {
        int localVarOffset = this.isStatic() ? 0 : 1;
        Type[] argTypes = this.getArgumentTypes();
        this.createObjectArray(argTypes.length);
        for (int i = 0; i < argTypes.length; ++i) {
            int j = i + localVarOffset;
            this.visitInsn(89);
            this.visitLdcInsn(i);
            this.visitVarInsn(argTypes[i].getOpcode(21), j);
            this.box(argTypes[i]);
            this.visitInsn(83);
            localVarOffset += argTypes[i].getSize() - 1;
        }
    }

    void replaceArgsWithArray(String desc) {
        Type[] methodArgs = Type.getArgumentTypes((String)desc);
        this.createObjectArray(methodArgs.length);
        for (int i = methodArgs.length - 1; i >= 0; --i) {
            if (methodArgs[i].getSize() == 2) {
                this.visitInsn(91);
                this.visitLdcInsn(i);
                this.visitInsn(94);
                this.visitInsn(88);
            } else {
                this.visitInsn(90);
                this.visitInsn(95);
                this.visitLdcInsn(i);
                this.visitInsn(95);
            }
            this.box(methodArgs[i]);
            this.visitInsn(83);
        }
    }

    void restoreArgsFromArray(String desc) {
        Type[] methodArgs = Type.getArgumentTypes((String)desc);
        for (int i = 0; i < methodArgs.length; ++i) {
            this.visitInsn(89);
            this.visitLdcInsn(i);
            this.visitInsn(50);
            this.unbox(methodArgs[i]);
            if (methodArgs[i].getSize() == 2) {
                this.visitInsn(93);
                this.visitInsn(88);
                continue;
            }
            this.visitInsn(95);
        }
        this.visitInsn(87);
    }

    protected void createObjectArray(int capacity) {
        this.visitLdcInsn(capacity);
        this.visitTypeInsn(189, "java/lang/Object");
    }

    protected void setProbeInProgress(boolean inProgress) {
        if (inProgress && !this.probeInProgress) {
            this.probeInProgress = true;
            if (this.probeMethodAdapter != null) {
                this.mv = this.visitor;
            }
        } else if (!inProgress && this.probeInProgress) {
            this.probeInProgress = false;
            this.mv = this.probeMethodAdapter != null ? this.probeMethodAdapter : this.visitor;
        }
    }

    private MethodVisitor getVisitor() {
        return this.visitor;
    }

    protected boolean isProbeInProgress() {
        return this.probeInProgress;
    }

    protected Class<?> getOwningClass(String owner) {
        try {
            Class<?> probedClass = this.getProbedClass();
            ClassLoader loader = probedClass.getClassLoader();
            Type ownerType = Type.getObjectType((String)owner);
            int arrayDimensions = 0;
            if (ownerType.getSort() == 9) {
                arrayDimensions = ownerType.getDimensions();
                ownerType = ownerType.getElementType();
            }
            Class<?> clazz = loader.loadClass(ownerType.getClassName());
            while (arrayDimensions > 0) {
                Object o = Array.newInstance(clazz, 0);
                clazz = o.getClass();
                --arrayDimensions;
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    protected Method getTargetMethod(Class<?> targetClass, String targetName, String desc) {
        for (Class<?> clazz = targetClass; clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods;
            for (Method m : methods = clazz.getDeclaredMethods()) {
                if (!m.getName().equals(targetName) || !Type.getMethodDescriptor((Method)m).equals(desc)) continue;
                return m;
            }
        }
        return null;
    }

    protected Constructor<?> getTargetConstructor(Class<?> targetClass, String desc) {
        for (Class<?> clazz = targetClass; clazz != null; clazz = clazz.getSuperclass()) {
            Constructor<?>[] ctors;
            for (Constructor<?> ctor : ctors = clazz.getDeclaredConstructors()) {
                if (!Type.getConstructorDescriptor(ctor).equals(desc)) continue;
                return ctor;
            }
        }
        return null;
    }

    protected Field getTargetField(Class<?> targetClass, String name, String desc) {
        for (Field f : targetClass.getDeclaredFields()) {
            if (!f.getName().equals(name) || !Type.getDescriptor(f.getType()).equals(desc)) continue;
            f.setAccessible(true);
            return f;
        }
        return null;
    }

    protected void onFirstInstruction() {
    }

    protected void onMethodEntry() {
    }

    protected void onMethodExit(int opcode) {
    }

    private void push(Object stackElement, int count) {
        for (int i = 0; i < count; ++i) {
            this.currentStack.add(stackElement);
        }
    }

    private void fireFirstInstruction() {
        if (!this.observedFirstInstruction) {
            this.observedFirstInstruction = true;
            if (this.isConstructor()) {
                this.onFirstInstruction();
            } else {
                this.onMethodEntry();
            }
        }
    }

    private void fireMethodEntry() {
        if (!this.waitingForSuper) {
            this.onMethodEntry();
        }
    }

    private void fireMethodExit(int opcode) {
        this.onMethodExit(opcode);
    }

    private Object pop(int count) {
        Object popped = null;
        for (int i = count; i > 0; --i) {
            popped = this.currentStack.remove(this.currentStack.size() - 1);
        }
        return popped;
    }

    private void addBranchTarget(Label target) {
        if (!this.branchTargets.containsKey(target)) {
            this.branchTargets.put(target, new ArrayList<Object>(this.currentStack));
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (!this.observedFirstInstruction) {
            this.fireFirstInstruction();
        }
        super.visitFieldInsn(opcode, owner, name, desc);
        if (this.waitingForSuper) {
            Type type = Type.getType((String)desc);
            switch (opcode) {
                case 178: {
                    this.push(OTHER, type.getSize());
                    break;
                }
                case 180: {
                    this.push(OTHER, type.getSize() - 1);
                    break;
                }
                case 179: {
                    this.pop(type.getSize());
                    break;
                }
                case 181: {
                    this.pop(type.getSize() + 1);
                    break;
                }
            }
        }
    }

    public void visitIincInsn(int var, int increment) {
        if (!this.observedFirstInstruction) {
            this.fireFirstInstruction();
        }
        super.visitIincInsn(var, increment);
    }

    public void visitInsn(int opcode) {
        if (!this.observedFirstInstruction) {
            this.fireFirstInstruction();
        }
        if (this.waitingForSuper) {
            switch (opcode) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: {
                    this.push(OTHER, 1);
                    break;
                }
                case 9: 
                case 10: 
                case 14: 
                case 15: {
                    this.push(OTHER, 2);
                    break;
                }
                case 46: 
                case 48: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    this.pop(1);
                    break;
                }
                case 47: 
                case 49: {
                    break;
                }
                case 79: 
                case 81: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    this.pop(3);
                    break;
                }
                case 80: 
                case 82: {
                    this.pop(4);
                    break;
                }
                case 87: {
                    this.pop(1);
                    break;
                }
                case 88: {
                    this.pop(2);
                    break;
                }
                case 89: {
                    Object top = this.currentStack.get(this.currentStack.size() - 1);
                    this.push(top, 1);
                    break;
                }
                case 90: {
                    Object top = this.currentStack.get(this.currentStack.size() - 1);
                    int addPosition = this.currentStack.size() - 2;
                    this.currentStack.add(addPosition, top);
                    break;
                }
                case 91: {
                    Object top = this.currentStack.get(this.currentStack.size() - 1);
                    int addPosition = this.currentStack.size() - 3;
                    this.currentStack.add(addPosition, top);
                    break;
                }
                case 92: {
                    int position = this.currentStack.size() - 2;
                    this.currentStack.add(this.currentStack.get(position));
                    this.currentStack.add(this.currentStack.get(position + 1));
                    break;
                }
                case 93: {
                    int addPosition = this.currentStack.size() - 3;
                    this.currentStack.add(addPosition, this.currentStack.get(this.currentStack.size() - 1));
                    this.currentStack.add(addPosition, this.currentStack.get(this.currentStack.size() - 2));
                    break;
                }
                case 94: {
                    int addPosition = this.currentStack.size() - 4;
                    this.currentStack.add(addPosition, this.currentStack.get(this.currentStack.size() - 1));
                    this.currentStack.add(addPosition, this.currentStack.get(this.currentStack.size() - 2));
                    break;
                }
                case 95: {
                    Object o = this.currentStack.remove(this.currentStack.size() - 2);
                    this.currentStack.add(o);
                    break;
                }
                case 96: 
                case 98: 
                case 100: 
                case 102: 
                case 104: 
                case 106: 
                case 108: 
                case 110: 
                case 112: 
                case 114: 
                case 116: 
                case 118: 
                case 120: 
                case 122: 
                case 124: 
                case 126: 
                case 128: 
                case 130: {
                    this.pop(1);
                    break;
                }
                case 97: 
                case 99: 
                case 101: 
                case 103: 
                case 105: 
                case 107: 
                case 109: 
                case 111: 
                case 113: 
                case 115: 
                case 117: 
                case 119: 
                case 121: 
                case 123: 
                case 125: 
                case 127: 
                case 129: 
                case 131: {
                    this.pop(2);
                    break;
                }
                case 133: 
                case 135: 
                case 140: 
                case 141: {
                    this.push(OTHER, 1);
                    break;
                }
                case 134: 
                case 139: 
                case 145: 
                case 146: 
                case 147: {
                    break;
                }
                case 136: 
                case 137: 
                case 142: 
                case 144: {
                    this.pop(1);
                    break;
                }
                case 138: 
                case 143: {
                    break;
                }
                case 148: 
                case 151: 
                case 152: {
                    this.pop(3);
                    break;
                }
                case 149: 
                case 150: {
                    this.pop(1);
                    break;
                }
                case 172: 
                case 174: 
                case 176: {
                    this.pop(1);
                    break;
                }
                case 173: 
                case 175: {
                    this.pop(2);
                    break;
                }
                case 177: {
                    break;
                }
                case 191: {
                    this.pop(1);
                    break;
                }
                case 190: {
                    break;
                }
                case 194: 
                case 195: {
                    this.pop(1);
                    break;
                }
                default: {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Unexpected opcode ");
                    sb.append(Integer.toHexString(opcode));
                    sb.append(" for class ");
                    sb.append(this.methodInfo.getClassAdapter().getProbedClass());
                    throw new IllegalArgumentException(sb.toString());
                }
            }
        }
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                this.fireMethodExit(opcode);
                break;
            }
        }
        super.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        if (!this.observedFirstInstruction) {
            this.fireFirstInstruction();
        }
        super.visitIntInsn(opcode, operand);
        if (this.waitingForSuper) {
            switch (opcode) {
                case 16: 
                case 17: {
                    this.push(OTHER, 1);
                    break;
                }
                case 188: {
                    break;
                }
            }
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (!this.observedFirstInstruction) {
            this.fireFirstInstruction();
        }
        super.visitJumpInsn(opcode, label);
        if (this.waitingForSuper) {
            switch (opcode) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: {
                    this.pop(1);
                    break;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    this.pop(2);
                    break;
                }
                case 167: {
                    break;
                }
                case 168: {
                    this.push(OTHER, 1);
                    break;
                }
                case 198: 
                case 199: {
                    this.pop(1);
                    break;
                }
            }
            this.addBranchTarget(label);
        }
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        if (this.waitingForSuper && this.branchTargets.containsKey(label)) {
            this.currentStack = this.branchTargets.get(label);
        }
    }

    public void visitLdcInsn(Object cst) {
        if (!this.observedFirstInstruction) {
            this.fireFirstInstruction();
        }
        super.visitLdcInsn(cst);
        if (this.waitingForSuper) {
            if (cst instanceof Long || cst instanceof Double) {
                this.push(OTHER, 2);
            } else {
                this.push(OTHER, 1);
            }
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        if (!this.observedFirstInstruction) {
            this.fireFirstInstruction();
        }
        super.visitLookupSwitchInsn(dflt, keys, labels);
        if (this.waitingForSuper) {
            this.pop(1);
            this.addBranchTarget(dflt);
            for (Label label : labels) {
                this.addBranchTarget(label);
            }
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (!this.observedFirstInstruction) {
            this.fireFirstInstruction();
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        if (this.waitingForSuper) {
            for (Type arg : Type.getArgumentTypes((String)desc)) {
                this.pop(arg.getSize());
            }
            switch (opcode) {
                case 184: {
                    break;
                }
                case 182: 
                case 185: {
                    this.pop(1);
                    break;
                }
                case 183: {
                    Object top = this.pop(1);
                    if (top != THIS) break;
                    this.waitingForSuper = false;
                    this.fireMethodEntry();
                    break;
                }
            }
            Type returnType = Type.getReturnType((String)desc);
            if (returnType != Type.VOID_TYPE) {
                this.push(OTHER, returnType.getSize());
            }
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        if (!this.observedFirstInstruction) {
            this.fireFirstInstruction();
        }
        super.visitMultiANewArrayInsn(desc, dims);
        if (this.waitingForSuper) {
            this.pop(dims);
            this.push(OTHER, 1);
        }
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        if (!this.observedFirstInstruction) {
            this.fireFirstInstruction();
        }
        super.visitTableSwitchInsn(min, max, dflt, labels);
        if (this.waitingForSuper) {
            this.pop(1);
            this.addBranchTarget(dflt);
            for (Label label : labels) {
                this.addBranchTarget(label);
            }
        }
    }

    public void visitTypeInsn(int opcode, String type) {
        if (!this.observedFirstInstruction) {
            this.fireFirstInstruction();
        }
        super.visitTypeInsn(opcode, type);
        if (this.waitingForSuper) {
            switch (opcode) {
                case 187: {
                    this.push(OTHER, 1);
                    break;
                }
            }
        }
    }

    public void visitVarInsn(int opcode, int var) {
        if (!this.observedFirstInstruction) {
            this.fireFirstInstruction();
        }
        super.visitVarInsn(opcode, var);
        if (this.waitingForSuper) {
            switch (opcode) {
                case 25: {
                    this.push(var == 0 ? THIS : OTHER, 1);
                    break;
                }
                case 21: 
                case 23: {
                    this.push(OTHER, 1);
                    break;
                }
                case 22: 
                case 24: {
                    this.push(OTHER, 2);
                    break;
                }
                case 54: 
                case 56: 
                case 58: {
                    this.pop(1);
                    break;
                }
                case 55: 
                case 57: {
                    this.pop(2);
                    break;
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ProbeMethodAdapter.class);
        THIS = new Object(){
            static final long serialVersionUID = 4837973738716663245L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public String toString() {
                return "this";
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
        OTHER = new Object(){
            static final long serialVersionUID = -4040161207185539035L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public String toString() {
                return "other";
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        };
        FIRE_PROBE_METHOD_DESC = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.LONG_TYPE, Type.getType(Object.class), Type.getType(Object.class), Type.getType(Object.class)});
    }
}

