/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal.bci;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.monitor.internal.ProbeListener;
import com.ibm.ws.monitor.internal.ProbeManagerImpl;
import com.ibm.ws.monitor.internal.bci.ProbeInjectionClassAdapter;
import com.ibm.ws.monitor.internal.bci.RedefineClassWriter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.util.ASMifier;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceClassVisitor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class ProbeClassFileTransformer
implements ClassFileTransformer {
    private static final TraceComponent tc = Tr.register(ProbeClassFileTransformer.class);
    final ProbeManagerImpl probeManagerImpl;
    final Instrumentation instrumentation;
    final boolean includeBootstrap;
    static final long serialVersionUID = 8128779371346106699L;

    public ProbeClassFileTransformer(ProbeManagerImpl probeManagerImpl, Instrumentation instrumentation, boolean includeBootstrap) {
        this.probeManagerImpl = probeManagerImpl;
        this.instrumentation = instrumentation;
        this.includeBootstrap = includeBootstrap;
    }

    public void instrumentWithProbes(Collection<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            try {
                this.instrumentation.retransformClasses(clazz);
            }
            catch (Throwable t) {}
        }
    }

    @Override
    @Sensitive
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, @Sensitive byte[] classfileBuffer) throws IllegalClassFormatException {
        if (loader == null && !this.includeBootstrap) {
            return null;
        }
        if (classBeingRedefined == null) {
            return null;
        }
        if (!this.probeManagerImpl.isMonitorable(classBeingRedefined)) {
            return null;
        }
        try {
            return this.transformWithProbes(classBeingRedefined, classfileBuffer);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Sensitive
    byte[] transformWithProbes(Class<?> clazz, @Sensitive byte[] classfileBuffer) {
        RedefineClassWriter writer;
        Set<ProbeListener> listeners = this.probeManagerImpl.getInterestedByClass(clazz);
        if (listeners.isEmpty()) {
            return null;
        }
        ClassReader reader = new ClassReader(classfileBuffer);
        short majorVersion = reader.readShort(6);
        int writerFlags = majorVersion >= 50 ? 2 : 1;
        Object visitor = writer = new RedefineClassWriter(clazz, reader, writerFlags);
        ProbeInjectionClassAdapter probeAdapter = new ProbeInjectionClassAdapter((ClassVisitor)visitor, this.probeManagerImpl, clazz);
        visitor = probeAdapter;
        int readerFlags = majorVersion >= 50 ? 8 : 4;
        reader.accept((ClassVisitor)visitor, readerFlags);
        if (probeAdapter.isModifiedClass()) {
            if (tc.isDumpEnabled()) {
                StringWriter stringWriter = new StringWriter();
                stringWriter.write("=== Original Code ===\n");
                ProbeClassFileTransformer.dumpClass(stringWriter, classfileBuffer);
                stringWriter.write("\n");
                stringWriter.write("=== Modified Code ===\n");
                ProbeClassFileTransformer.dumpClass(stringWriter, writer.toByteArray());
                Tr.dump((TraceComponent)tc, (String)"Bytecode", (Object[])new Object[]{stringWriter});
            }
            return writer.toByteArray();
        }
        return null;
    }

    @Trivial
    public static void dumpClass(StringWriter stringWriter, byte[] classfileBuffer) {
        block2: {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(classfileBuffer);
                ClassReader reader = new ClassReader((InputStream)inputStream);
                reader.accept((ClassVisitor)new TraceClassVisitor(null, (Printer)new ASMifier(), new PrintWriter(stringWriter)), 0);
                ((InputStream)inputStream).close();
            }
            catch (Throwable t) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.error((TraceComponent)tc, (String)"PMI9999E", (Object[])new Object[]{t.getMessage()});
            }
        }
    }
}

