/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.ldap;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.Constants;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SSLSocketFactory
extends javax.net.ssl.SSLSocketFactory {
    private static final TraceComponent tc = Tr.register(SSLSocketFactory.class);
    private static JSSEHelper jssehelper = null;
    protected Properties props;
    private javax.net.ssl.SSLSocketFactory default_factory = null;
    private javax.net.ssl.SSLSocketFactory factory = null;
    protected boolean default_constructor = true;
    private static SSLSocketFactory thisClass = null;
    static final long serialVersionUID = -4701638002635207680L;

    public static JSSEHelper getJssehelper() {
        return jssehelper;
    }

    public static void setJssehelper(JSSEHelper jssehelper) {
        SSLSocketFactory.jssehelper = jssehelper;
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory() {
        try {
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            if (this.props == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Getting default SSL properties from WebSphere configuration.", (Object[])new Object[0]);
                }
                this.props = jssehelper != null ? jssehelper.getProperties(null, connectionInfo, null) : JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Getting javax.net.ssl.* SSL System properties.", (Object[])new Object[0]);
                }
                this.default_constructor = false;
            }
            this.default_factory = jssehelper != null ? jssehelper.getSSLSocketFactory(connectionInfo, this.props) : JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, this.props);
        }
        catch (Exception connectionInfo) {
            FFDCFilter.processException((Throwable)connectionInfo, (String)"com.ibm.ws.security.wim.adapter.ldap.SSLSocketFactory", (String)"86", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"SSLSocketFactory exception getting default SSL properties.", (Object[])new Object[]{new Object[]{e}});
            }
            this.props = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(String alias) {
        try {
            this.default_constructor = false;
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            if (jssehelper != null) {
                this.props = jssehelper.getProperties(alias, connectionInfo, null);
                this.default_factory = jssehelper.getSSLSocketFactory(connectionInfo, this.props);
            } else {
                this.props = JSSEHelper.getInstance().getProperties(alias, connectionInfo, null);
                this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, this.props);
            }
        }
        catch (Exception connectionInfo) {
            FFDCFilter.processException((Throwable)connectionInfo, (String)"com.ibm.ws.security.wim.adapter.ldap.SSLSocketFactory", (String)"114", (Object)this, (Object[])new Object[]{alias});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"SSLSocketFactory exception getting SSL properties from alias.", (Object[])new Object[]{new Object[]{e}});
            }
            this.props = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(Properties sslprops) {
        try {
            this.default_constructor = false;
            this.props = sslprops;
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            this.default_factory = jssehelper != null ? jssehelper.getSSLSocketFactory(connectionInfo, this.props) : JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, this.props);
        }
        catch (Exception connectionInfo) {
            FFDCFilter.processException((Throwable)connectionInfo, (String)"com.ibm.ws.security.wim.adapter.ldap.SSLSocketFactory", (String)"139", (Object)this, (Object[])new Object[]{sslprops});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"SSLSocketFactory exception getting SSL properties from properties.", (Object[])new Object[]{new Object[]{e}});
            }
            this.props = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(String alias, Map<String, Object> connectionInfo) {
        try {
            this.default_constructor = false;
            if (jssehelper != null) {
                this.props = jssehelper.getProperties(alias, connectionInfo, null);
                this.default_factory = jssehelper.getSSLSocketFactory(connectionInfo, this.props);
            } else {
                this.props = JSSEHelper.getInstance().getProperties(alias, connectionInfo, null);
                this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, this.props);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.wim.adapter.ldap.SSLSocketFactory", (String)"165", (Object)this, (Object[])new Object[]{alias, connectionInfo});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"SSLSocketFactory exception getting SSL properties from selections.", (Object[])new Object[]{new Object[]{e}});
            }
            this.props = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static SocketFactory getDefault() {
        block3: {
            if (thisClass == null) {
                try {
                    thisClass = new SSLSocketFactory();
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.wim.adapter.ldap.SSLSocketFactory", (String)"181", null, (Object[])new Object[0]);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"SSLSocketFactory exception getting default socket factory.", (Object[])new Object[]{new Object[]{e}});
                }
            }
        }
        return thisClass;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("default_factory: " + this.default_factory), (Object[])new Object[0]);
        }
        String[] output = null;
        if (this.default_factory != null) {
            output = this.default_factory.getDefaultCipherSuites();
        }
        return output;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("default_factory: " + this.default_factory), (Object[])new Object[0]);
        }
        String[] output = null;
        if (this.default_factory != null) {
            output = this.default_factory.getSupportedCipherSuites();
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket createSocket() throws IOException {
        javax.net.ssl.SSLSocketFactory currentFactory = this.default_factory;
        SSLSocket socket = null;
        Properties sslProps = this.props;
        if (this.default_constructor) {
            try {
                HashMap<String, String> currentConnectionInfo;
                Properties sslPropsOnThread;
                if (jssehelper != null) {
                    sslPropsOnThread = jssehelper.getSSLPropertiesOnThread();
                    currentConnectionInfo = jssehelper.getOutboundConnectionInfo();
                } else {
                    sslPropsOnThread = JSSEHelper.getInstance().getSSLPropertiesOnThread();
                    currentConnectionInfo = JSSEHelper.getInstance().getOutboundConnectionInfo();
                }
                if (sslPropsOnThread != null || currentConnectionInfo != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"either SSLProperties on thread or connectionInfo is available.", (Object[])new Object[0]);
                    }
                    if (currentConnectionInfo == null) {
                        currentConnectionInfo = new HashMap<String, String>();
                        currentConnectionInfo.put("com.ibm.ssl.direction", "outbound");
                    }
                    if (jssehelper != null) {
                        sslProps = jssehelper.getProperties(null, currentConnectionInfo, null);
                        currentFactory = jssehelper.getSSLSocketFactory(currentConnectionInfo, sslProps);
                    } else {
                        sslProps = JSSEHelper.getInstance().getProperties(null, currentConnectionInfo, null);
                        currentFactory = JSSEHelper.getInstance().getSSLSocketFactory(currentConnectionInfo, sslProps);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Getting SSLSocketFactory", (Object[])new Object[0]);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Got SSLSocketFactory", (Object[])new Object[]{new Object[]{currentFactory}});
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Use default SSLSocketFactory - Neither SSLProperties nor outboundConnectionInfo is set", (Object[])new Object[0]);
                    }
                    if (sslProps == null) {
                        sslProps = jssehelper != null ? jssehelper.getProperties(null, null, null) : JSSEHelper.getInstance().getProperties(null, null, null);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"default sslProps is null, load a default", (Object[])new Object[0]);
                        }
                    }
                }
            }
            catch (Exception sslPropsOnThread) {
                FFDCFilter.processException((Throwable)sslPropsOnThread, (String)"com.ibm.ws.security.wim.adapter.ldap.SSLSocketFactory", (String)"270", (Object)this, (Object[])new Object[0]);
                if (tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory. Fall back to the default SSLSocketFactory", (Object[])new Object[]{new Object[]{e}});
                }
                currentFactory = this.default_factory;
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Use default SSLSocketFactory - the default constructor was not used", (Object[])new Object[0]);
        }
        if (currentFactory == null) {
            throw new SSLException("SSLSocketFactory is null. This can occur if javax.net.ssl.SSLSocketFactory.getDefault() is called to create a socket and javax.net.ssl.* properties are not set.");
        }
        socket = (SSLSocket)currentFactory.createSocket();
        socket = this.setCipherListOnSocket(sslProps, socket);
        return socket;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", host);
            connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            if (jssehelper != null) {
                if (this.default_constructor) {
                    sslprops = jssehelper.getProperties(null, connectionInfo, null);
                }
                this.factory = jssehelper.getSSLSocketFactory(connectionInfo, sslprops);
            } else {
                if (this.default_constructor) {
                    sslprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
                }
                this.factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, sslprops);
            }
        }
        catch (Exception connectionInfo) {
            FFDCFilter.processException((Throwable)connectionInfo, (String)"com.ibm.ws.security.wim.adapter.ldap.SSLSocketFactory", (String)"313", (Object)this, (Object[])new Object[]{s, host, port, autoClose});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory.", (Object[])new Object[]{new Object[]{e}});
            }
            this.factory = this.default_factory;
        }
        if (this.factory == null) {
            throw new SSLException("SSLSocketFactory is null. This can occur if javax.net.ssl.SSLSocketFactory.getDefault() is called to create a socket and javax.net.ssl.* properties are not set.");
        }
        socket = (SSLSocket)this.factory.createSocket(s, host, port, autoClose);
        socket = this.setCipherListOnSocket(sslprops, socket);
        return socket;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            String remoteHostName;
            block12: {
                remoteHostName = null;
                if (host != null) {
                    try {
                        remoteHostName = host.getHostName();
                        if (remoteHostName == null) {
                            remoteHostName = host.getCanonicalHostName();
                        }
                    }
                    catch (Throwable throwable) {
                        void e;
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.wim.adapter.ldap.SSLSocketFactory", (String)"347", (Object)this, (Object[])new Object[]{host, port});
                        remoteHostName = host.getHostAddress();
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug((TraceComponent)tc, (String)"Exception getting hostname from socket.", (Object[])new Object[]{new Object[]{e}});
                    }
                }
            }
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", remoteHostName);
            connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            if (jssehelper != null) {
                if (this.default_constructor) {
                    sslprops = jssehelper.getProperties(null, connectionInfo, null);
                }
                this.factory = jssehelper.getSSLSocketFactory(connectionInfo, sslprops);
            } else {
                if (this.default_constructor) {
                    sslprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
                }
                this.factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, sslprops);
            }
        }
        catch (Exception remoteHostName) {
            FFDCFilter.processException((Throwable)remoteHostName, (String)"com.ibm.ws.security.wim.adapter.ldap.SSLSocketFactory", (String)"369", (Object)this, (Object[])new Object[]{host, port});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory.", (Object[])new Object[]{new Object[]{e}});
            }
            this.factory = this.default_factory;
        }
        if (this.factory == null) {
            throw new SSLException("SSLSocketFactory is null. This can occur if javax.net.ssl.SSLSocketFactory.getDefault() is called to create a socket and javax.net.ssl.* properties are not set.");
        }
        socket = (SSLSocket)this.factory.createSocket(host, port);
        socket = this.setCipherListOnSocket(sslprops, socket);
        return socket;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            String remoteHostName;
            block12: {
                remoteHostName = null;
                if (address != null) {
                    try {
                        remoteHostName = address.getHostName();
                        if (remoteHostName == null) {
                            remoteHostName = address.getCanonicalHostName();
                        }
                    }
                    catch (Throwable throwable) {
                        void e;
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.wim.adapter.ldap.SSLSocketFactory", (String)"403", (Object)this, (Object[])new Object[]{address, port, localAddress, localPort});
                        remoteHostName = address.getHostAddress();
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug((TraceComponent)tc, (String)"Exception getting hostname from socket.", (Object[])new Object[]{new Object[]{e}});
                    }
                }
            }
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", remoteHostName);
            connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            if (jssehelper != null) {
                if (this.default_constructor) {
                    sslprops = jssehelper.getProperties(null, connectionInfo, null);
                }
                this.factory = jssehelper.getSSLSocketFactory(connectionInfo, sslprops);
            } else {
                if (this.default_constructor) {
                    sslprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
                }
                this.factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, sslprops);
            }
        }
        catch (Exception remoteHostName) {
            FFDCFilter.processException((Throwable)remoteHostName, (String)"com.ibm.ws.security.wim.adapter.ldap.SSLSocketFactory", (String)"425", (Object)this, (Object[])new Object[]{address, port, localAddress, localPort});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory.", (Object[])new Object[]{new Object[]{e}});
            }
            this.factory = this.default_factory;
        }
        if (this.factory == null) {
            throw new SSLException("SSLSocketFactory is null. This can occur if javax.net.ssl.SSLSocketFactory.getDefault() is called to create a socket and javax.net.ssl.* properties are not set.");
        }
        socket = (SSLSocket)this.factory.createSocket(address, port, localAddress, localPort);
        socket = this.setCipherListOnSocket(sslprops, socket);
        return socket;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", host);
            connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            if (jssehelper != null) {
                if (this.default_constructor) {
                    sslprops = jssehelper.getProperties(null, connectionInfo, null);
                }
                this.factory = jssehelper.getSSLSocketFactory(connectionInfo, sslprops);
            } else {
                if (this.default_constructor) {
                    sslprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
                }
                this.factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, sslprops);
            }
        }
        catch (Exception connectionInfo) {
            FFDCFilter.processException((Throwable)connectionInfo, (String)"com.ibm.ws.security.wim.adapter.ldap.SSLSocketFactory", (String)"466", (Object)this, (Object[])new Object[]{host, port});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory.", (Object[])new Object[]{new Object[]{e}});
            }
            this.factory = this.default_factory;
        }
        if (this.factory == null) {
            throw new SSLException("SSLSocketFactory is null. This can occur if javax.net.ssl.SSLSocketFactory.getDefault() is called to create a socket and javax.net.ssl.* properties are not set.");
        }
        socket = (SSLSocket)this.factory.createSocket(host, port);
        socket = this.setCipherListOnSocket(sslprops, socket);
        return socket;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", host);
            connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            if (jssehelper != null) {
                if (this.default_constructor) {
                    sslprops = jssehelper.getProperties(null, connectionInfo, null);
                }
                this.factory = jssehelper.getSSLSocketFactory(connectionInfo, sslprops);
            } else {
                if (this.default_constructor) {
                    sslprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
                }
                this.factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, sslprops);
            }
        }
        catch (Exception connectionInfo) {
            FFDCFilter.processException((Throwable)connectionInfo, (String)"com.ibm.ws.security.wim.adapter.ldap.SSLSocketFactory", (String)"507", (Object)this, (Object[])new Object[]{host, port, localHost, localPort});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory.", (Object[])new Object[]{new Object[]{e}});
            }
            this.factory = this.default_factory;
        }
        if (this.factory == null) {
            throw new SSLException("SSLSocketFactory is null. This can occur if javax.net.ssl.SSLSocketFactory.getDefault() is called to create a socket and javax.net.ssl.* properties are not set.");
        }
        socket = (SSLSocket)this.factory.createSocket(host, port, localHost, localPort);
        socket = this.setCipherListOnSocket(sslprops, socket);
        return socket;
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocket setCipherListOnSocket(Properties props, SSLSocket socket) {
        block9: {
            if (props == null) {
                return socket;
            }
            String[] ciphers = null;
            String cipherString = props.getProperty("com.ibm.ssl.enabledCipherSuites");
            if (socket != null) {
                try {
                    if (cipherString != null) {
                        ciphers = cipherString.split("\\s");
                    } else {
                        String securityLevel = props.getProperty("com.ibm.ssl.securityLevel");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("securityLevel from properties is " + securityLevel), (Object[])new Object[0]);
                        }
                        if (securityLevel == null) {
                            securityLevel = "HIGH";
                        }
                        String[] supportedCiphers = socket.getSupportedCipherSuites();
                        ciphers = Constants.adjustSupportedCiphersToSecurityLevel((String[])supportedCiphers, (String)securityLevel);
                    }
                    if (ciphers != null) {
                        socket.setEnabledCipherSuites(ciphers);
                    }
                }
                catch (Exception securityLevel) {
                    void e;
                    FFDCFilter.processException((Throwable)securityLevel, (String)"com.ibm.ws.security.wim.adapter.ldap.SSLSocketFactory", (String)"558", (Object)this, (Object[])new Object[]{props, socket});
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)tc, (String)"Exception setting ciphers in SSL Socket Factory.", (Object[])new Object[]{new Object[]{e}});
                }
            }
        }
        return socket;
    }
}

