/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.ldap;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.websphere.security.wim.ras.WIMTraceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.adapter.ldap.LdapAttribute;
import com.ibm.ws.security.wim.adapter.ldap.LdapURL;
import com.ibm.ws.security.wim.util.StringUtil;
import com.ibm.wsspi.security.wim.exception.CertificateMapperException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.exception.WIMSystemException;
import com.ibm.wsspi.security.wim.model.Entity;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LdapHelper {
    private static final TraceComponent tc = Tr.register(LdapHelper.class);
    private static String sdformatMillisec = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static SoftReference<Map<?, ?>> softDnCache = new SoftReference(new ConcurrentHashMap());
    static final long serialVersionUID = 1468147646274079314L;

    @Trivial
    public static String getOctetString(byte[] bytesArr) {
        StringBuffer retVal = new StringBuffer();
        String dblByte = "";
        for (int i = 0; i < bytesArr.length; ++i) {
            dblByte = Integer.toHexString(bytesArr[i] & 0xFF);
            if (dblByte.length() == 1) {
                dblByte = "0" + dblByte;
            }
            retVal.append(dblByte);
        }
        return retVal.toString();
    }

    public static String getDateString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(sdformatMillisec);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuffer dateBuffer = new StringBuffer(sdf.format(date));
        dateBuffer.insert(dateBuffer.length() - 2, ":");
        return dateBuffer.toString();
    }

    public static String prepareDN(String DN, String searchRoot) {
        int pos2;
        boolean parsed;
        if (DN == null || DN.trim().length() == 0) {
            return searchRoot;
        }
        DN = LdapHelper.unescapeDoubleBackslash(DN);
        DN = LdapHelper.unescapeSingleQuote(DN);
        int length = DN.length();
        if (DN.charAt(0) == '\"' && DN.charAt(length - 1) == '\"') {
            DN = DN.substring(1, length - 1);
        }
        if (DN.startsWith("/")) {
            int pos22;
            int pos1 = DN.indexOf(58);
            if (pos1 > -1 && (pos22 = DN.indexOf(47, pos1)) > 0) {
                DN = DN.substring(pos22 + 1);
            }
        } else if (DN.toLowerCase().startsWith("ldap://")) {
            int pos1;
            parsed = false;
            try {
                LdapURL ldapURL = new LdapURL(DN);
                if (ldapURL.parsedOK()) {
                    DN = ldapURL.get_dn();
                    parsed = true;
                }
            }
            catch (Exception ldapURL) {
                FFDCFilter.processException((Throwable)ldapURL, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapHelper", (String)"154", null, (Object[])new Object[]{DN, searchRoot});
            }
            if (!parsed && (pos1 = DN.indexOf(58, "ldap://".length())) > 0 && (pos2 = DN.indexOf("/", pos1)) > 0) {
                DN = DN.substring(pos2 + 1);
            }
        } else if (DN.toLowerCase().startsWith("ldaps://")) {
            int pos1;
            parsed = false;
            try {
                LdapURL ldapURL = new LdapURL(DN);
                if (ldapURL.parsedOK()) {
                    DN = ldapURL.get_dn();
                    parsed = true;
                }
            }
            catch (Exception ldapURL) {
                FFDCFilter.processException((Throwable)ldapURL, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapHelper", (String)"175", null, (Object[])new Object[]{DN, searchRoot});
            }
            if (!parsed && (pos1 = DN.indexOf(58, "ldaps://".length())) > 0 && (pos2 = DN.indexOf("/", pos1)) > 0) {
                DN = DN.substring(pos2 + 1);
            }
        }
        if (searchRoot == null || searchRoot.trim().length() == 0) {
            return DN;
        }
        StringTokenizer stDN = new StringTokenizer(DN, ",");
        StringTokenizer stSearchRoot = new StringTokenizer(searchRoot, ",");
        String lastDNToken = null;
        String lastSearchRootToken = null;
        while (stDN.hasMoreTokens()) {
            lastDNToken = stDN.nextToken();
        }
        while (stSearchRoot.hasMoreTokens()) {
            lastSearchRootToken = stSearchRoot.nextToken();
        }
        if (!(lastDNToken = lastDNToken != null ? lastDNToken.trim() : "").equalsIgnoreCase(lastSearchRootToken = lastSearchRootToken != null ? lastSearchRootToken.trim() : "")) {
            DN = DN.length() > 0 ? DN + "," + searchRoot : searchRoot;
        }
        return DN;
    }

    public static String unescapeDoubleBackslash(String in) {
        char[] chars = in.toCharArray();
        int end = chars.length;
        StringBuffer out = new StringBuffer(in.length());
        for (int i = 0; i < end; ++i) {
            if (chars[i] == '\\' && i + 1 < end && chars[i + 1] == '\\') {
                ++i;
            }
            out.append(chars[i]);
        }
        return new String(out);
    }

    public static String unescapeSingleQuote(String in) {
        char[] chars = in.toCharArray();
        int end = chars.length;
        StringBuffer out = new StringBuffer(in.length());
        for (int i = 0; i < end; ++i) {
            if (chars[i] == '\\' && i + 1 < end && chars[i + 1] == '\'') {
                ++i;
            }
            out.append(chars[i]);
        }
        return new String(out);
    }

    public static String[] getRDNAttributes(String dn) {
        String rdnstr = LdapHelper.getRDN(dn);
        StringTokenizer st = new StringTokenizer(rdnstr.toLowerCase(), "+");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String rdn = st.nextToken();
            int index = rdn.indexOf(61);
            if (index <= -1) continue;
            list.add(rdn.substring(0, index));
        }
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static String getRDN(String DN) {
        if (DN == null || DN.trim().length() == 0) {
            return DN;
        }
        String RDN = null;
        try {
            LdapName name = new LdapName(DN);
            if (name.size() == 0) {
                return DN;
            }
            RDN = name.get(name.size() - 1);
        }
        catch (InvalidNameException name) {
            void e;
            FFDCFilter.processException((Throwable)name, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapHelper", (String)"287", null, (Object[])new Object[]{DN});
            e.getMessage();
            DN = DN.trim();
            int pos1 = DN.indexOf(44);
            if (DN.charAt(pos1 - 1) == '\\') {
                pos1 = DN.indexOf(pos1, 44);
            }
            RDN = pos1 > -1 ? DN.substring(0, pos1).trim() : DN;
        }
        return RDN;
    }

    public static String replaceRDN(String DN, String[] RDNAttrTypes, String[] RDNAttrValues) {
        String parentDN = LdapHelper.getParentDN(DN);
        if (RDNAttrTypes == null || RDNAttrValues == null || RDNAttrTypes.length != RDNAttrValues.length || RDNAttrTypes.length == 0) {
            return DN;
        }
        StringBuffer RDN = new StringBuffer();
        String[] oldRDNValues = LdapHelper.getRDNValues(DN);
        for (int i = 0; i < RDNAttrTypes.length; ++i) {
            String newRDNValue;
            if (i != 0) {
                RDN.append("+");
            }
            if ((newRDNValue = RDNAttrValues[i]) == null) {
                newRDNValue = oldRDNValues[i];
            }
            RDN.append(RDNAttrTypes[i] + "=" + Rdn.escapeValue(newRDNValue));
        }
        DN = parentDN.length() == 0 ? RDN.toString() : RDN.append("," + parentDN).toString();
        return DN;
    }

    /*
     * WARNING - void declaration
     */
    public static String getParentDN(String DN) {
        String parentDN = null;
        if (DN == null || DN.trim().length() == 0) {
            parentDN = "";
        }
        try {
            LdapName name = new LdapName(DN);
            if (name.size() == 0) {
                parentDN = "";
            }
            name.remove(name.size() - 1);
            parentDN = name.toString();
        }
        catch (InvalidNameException name) {
            void e;
            FFDCFilter.processException((Throwable)name, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapHelper", (String)"343", null, (Object[])new Object[]{DN});
            e.getMessage();
            DN = DN.trim();
            int pos1 = DN.indexOf(44);
            if (DN.charAt(pos1 - 1) == '\\') {
                pos1 = DN.indexOf(pos1, 44);
            }
            parentDN = pos1 > -1 ? DN.substring(pos1 + 1).trim() : "";
        }
        return parentDN;
    }

    public static String[] getRDNValues(String rdnStr) {
        StringTokenizer st = new StringTokenizer(rdnStr.toLowerCase(), "+");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String rdn = st.nextToken();
            int index = rdn.indexOf(61);
            if (index <= -1) continue;
            list.add(rdn.substring(index + 1));
        }
        return list.toArray(new String[0]);
    }

    public static boolean isUnderBases(String dn, String[] bases) {
        if ((dn = LdapHelper.getValidDN(dn)) != null) {
            dn = dn.toLowerCase();
            for (int i = 0; i < bases.length; ++i) {
                if (bases[i].trim().length() != 0 && !dn.endsWith(bases[i].toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static String getValidDN(String dn) {
        Map<?, ?> dnCache = null;
        if (dn == null) {
            return null;
        }
        if (softDnCache.get() == null) {
            softDnCache = new SoftReference(new ConcurrentHashMap());
        }
        dnCache = softDnCache.get();
        String sDomainName = "default";
        if (dnCache != null && dnCache.get(sDomainName) == null) {
            dnCache.put(sDomainName, new ConcurrentHashMap(256));
        }
        String result = null;
        if (dnCache != null) {
            result = (String)((Map)dnCache.get(sDomainName)).get(dn);
        }
        if (result == null) {
            try {
                LdapName name = new LdapName(dn);
                result = name.getPrefix(name.size()).toString();
                ((Map)dnCache.get(sDomainName)).put(dn, result);
            }
            catch (InvalidNameException name) {
                void e;
                FFDCFilter.processException((Throwable)name, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapHelper", (String)"426", null, (Object[])new Object[]{dn});
                e.getMessage();
                result = null;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static LdapURL[] getLdapURLs(Attribute attr) throws WIMException {
        String METHODNAME = "getLdapURLs";
        LdapURL[] ldapURLs = new LdapURL[]{};
        if (attr != null) {
            ArrayList<LdapURL> ldapURLList = new ArrayList<LdapURL>(attr.size());
            try {
                NamingEnumeration<?> enu = attr.getAll();
                while (enu.hasMoreElements()) {
                    LdapURL ldapURL = new LdapURL((String)enu.nextElement());
                    if (ldapURL.parsedOK()) {
                        ldapURLList.add(ldapURL);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("getLdapURLs Member URL query: " + ldapURL.get_url() + " is invalid and ingored."), (Object[])new Object[0]);
                }
            }
            catch (NamingException enu) {
                void e;
                FFDCFilter.processException((Throwable)enu, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapHelper", (String)"458", null, (Object[])new Object[]{attr});
                throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
            }
            ldapURLs = ldapURLList.toArray(ldapURLs);
        }
        return ldapURLs;
    }

    public static boolean isEntityTypeInList(String entityType, List<String> entityTypes) throws WIMException {
        if (entityTypes != null && entityTypes.size() > 0) {
            for (int i = 0; i < entityTypes.size(); ++i) {
                String thisType = entityTypes.get(i);
                HashSet hs = Entity.getSubEntityTypes((String)thisType);
                if (!thisType.equals(entityType) && (Entity.getSubEntityTypes((String)thisType) == null || !Entity.getSubEntityTypes((String)thisType).contains(entityType))) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static String getDNFromAttributes(Attributes attrs) throws WIMSystemException {
        try {
            Attribute attr = attrs.remove("distinguishedName");
            if (attr != null) {
                return (String)attr.get();
            }
            return null;
        }
        catch (NamingException attr) {
            void e;
            FFDCFilter.processException((Throwable)attr, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapHelper", (String)"494", null, (Object[])new Object[]{attrs});
            throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
        }
    }

    public static String encodeAttribute(String attributeValue, String encoding) {
        char[] str = attributeValue.toCharArray();
        int size = str.length;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            char c = str[i];
            if (Character.toLowerCase(c) != Character.toLowerCase(Character.toUpperCase(c))) {
                byte[] bytes = null;
                try {
                    bytes = ("" + c).getBytes(encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapHelper", (String)"516", null, (Object[])new Object[]{attributeValue, encoding});
                }
                if (bytes == null) continue;
                for (int j = 0; j < bytes.length; ++j) {
                    byte b = bytes[j];
                    result.append("\\");
                    String hexString = Integer.toHexString(b);
                    result.append(hexString.substring(hexString.length() - 2));
                }
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static Attribute getIngoreCaseAttribute(Attributes attrs, String attrName) {
        if (attrs == null || attrName == null) {
            return null;
        }
        NamingEnumeration<String> neu = attrs.getIDs();
        while (neu.hasMoreElements()) {
            String cachedAttr = (String)neu.nextElement();
            boolean findAttr = false;
            if (attrName.equalsIgnoreCase(cachedAttr)) {
                findAttr = true;
            } else {
                int pos = cachedAttr.indexOf(";");
                if (pos > 0 && attrName.equalsIgnoreCase(cachedAttr.substring(0, pos))) {
                    findAttr = true;
                }
            }
            if (!findAttr) continue;
            return attrs.get(cachedAttr);
        }
        return null;
    }

    public static String printSearchControls(SearchControls searchControls) {
        StringBuffer result = new StringBuffer();
        result.append("[searchScope: ").append(searchControls.getSearchScope());
        result.append(", timeLimit: ").append(searchControls.getTimeLimit());
        result.append(", countLimit: ").append(searchControls.getCountLimit());
        result.append(", returningObjFlag: ").append(searchControls.getReturningObjFlag());
        result.append(", returningAttributes: ").append(WIMTraceHelper.printObjectArray((Object[])searchControls.getReturningAttributes())).append("]");
        return result.toString();
    }

    public static boolean isUnderBases(String dn, String base) {
        return (dn = LdapHelper.getValidDN(dn)) != null && (dn = dn.toLowerCase()).endsWith(base.toLowerCase());
    }

    public static String getUniqueKey(X509Certificate cert) {
        StringBuffer key = new StringBuffer("subjectDN:");
        key.append(cert.getSubjectX500Principal().getName()).append("issuerDN:").append(cert.getIssuerX500Principal().getName());
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static String getDigest(String input) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapHelper", (String)"613", null, (Object[])new Object[]{input});
            e.getMessage();
            return null;
        }
        md.update(StringUtil.getBytes((String)input));
        return StringUtil.toString((byte[])md.digest());
    }

    /*
     * WARNING - void declaration
     */
    static String getDNSubField(String varName, String DN) throws CertificateMapperException {
        block4: {
            String value;
            String name;
            if (varName.equals("DN")) {
                return DN;
            }
            StringTokenizer st = new StringTokenizer(DN);
            do {
                try {
                    name = st.nextToken(",= ");
                    value = st.nextToken(",");
                    if (value == null) continue;
                    value = value.substring(1);
                }
                catch (NoSuchElementException noSuchElementException) {
                    void e;
                    FFDCFilter.processException((Throwable)noSuchElementException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapHelper", (String)"638", null, (Object[])new Object[]{varName, DN});
                    e.getMessage();
                    break block4;
                }
            } while (!name.equals(varName));
            return value;
        }
        throw new CertificateMapperException("UNKNOWN_DN_FIELD", Tr.formatMessage((TraceComponent)tc, (String)"UNKNOWN_DN_FIELD", (Object[])WIMMessageHelper.generateMsgParms((Object)varName)));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containIgnorecaseValue(Attribute attr, String value) throws WIMSystemException {
        if (attr == null || value == null) {
            return false;
        }
        try {
            NamingEnumeration<?> neu = attr.getAll();
            while (neu.hasMoreElements()) {
                String thisValue = (String)neu.nextElement();
                if (!value.equalsIgnoreCase(thisValue)) continue;
                return true;
            }
        }
        catch (NamingException neu) {
            void e;
            FFDCFilter.processException((Throwable)neu, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapHelper", (String)"666", null, (Object[])new Object[]{attr, value});
            throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
        }
        return false;
    }

    public static String toUpperCase(String dn) {
        if (dn == null) {
            return null;
        }
        String newDN = null;
        if (dn.indexOf(223) != -1) {
            char[] chars = new char[dn.length()];
            for (int index = 0; index < dn.length(); ++index) {
                char c = dn.charAt(index);
                chars[index] = c == '\u00df' ? c : Character.toUpperCase(c);
            }
            newDN = new String(chars);
        } else {
            newDN = dn.toUpperCase();
        }
        return newDN;
    }

    /*
     * WARNING - void declaration
     */
    public static Object getStringLdapValue(Object value, LdapAttribute ldapAttr, String ldapType) throws WIMSystemException {
        Object ldapValue = null;
        String strValue = (String)value;
        String syntax = "string";
        if (ldapAttr != null) {
            syntax = ldapAttr.getSyntax();
        }
        if ("unicodePwd".equalsIgnoreCase(syntax)) {
            ldapValue = LdapHelper.encodePassword(strValue);
        } else if ("octetString".equalsIgnoreCase(syntax)) {
            try {
                ldapValue = LdapHelper.getOctetString(strValue);
            }
            catch (NumberFormatException numberFormatException) {
                void nfe;
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapHelper", (String)"722", null, (Object[])new Object[]{value, ldapAttr, ldapType});
                throw new WIMSystemException("SYSTEM_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"SYSTEM_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)nfe.getMessage())));
            }
        } else {
            ldapValue = strValue;
        }
        return ldapValue;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] encodePassword(String password) throws WIMSystemException {
        byte[] encodedPassword = null;
        try {
            String ATTRIBUTE_ENCODING = "Unicode";
            String tempPassword = "\"" + password + "\"";
            byte[] bytes = tempPassword.getBytes(ATTRIBUTE_ENCODING);
            encodedPassword = new byte[bytes.length - 2];
            System.arraycopy(bytes, 2, encodedPassword, 0, bytes.length - 2);
            if (!(System.getProperty("os.arch").equals("x86") || System.getProperty("os.arch").equals("ia64") || System.getProperty("os.arch").equals("amd64"))) {
                for (int i = 0; i < encodedPassword.length; i += 2) {
                    byte temp = encodedPassword[i];
                    encodedPassword[i] = encodedPassword[i + 1];
                    encodedPassword[i + 1] = temp;
                }
            }
        }
        catch (Exception ATTRIBUTE_ENCODING) {
            void e;
            FFDCFilter.processException((Throwable)ATTRIBUTE_ENCODING, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapHelper", (String)"765", null, (Object[])new Object[]{password});
            throw new WIMSystemException("GENERIC", Tr.formatMessage((TraceComponent)tc, (String)"GENERIC", (Object[])WIMMessageHelper.generateMsgParms((Object)e.getMessage())));
        }
        return encodedPassword;
    }

    public static byte[] getOctetString(String hexStr) {
        byte[] byteArr = new byte[hexStr.length() / 2];
        int count = 0;
        for (int i = 0; i < hexStr.length() - 1; i += 2) {
            String retVal = hexStr.substring(i, i + 2);
            int intVal = Integer.parseInt(retVal, 16);
            byteArr[count] = (byte)intVal;
            ++count;
        }
        return byteArr;
    }

    /*
     * WARNING - void declaration
     */
    public static Object getDateLdapValue(Object value, LdapAttribute ldapAttr, String ldapType) throws WIMSystemException {
        try {
            String vStr = value.toString();
            Date date = null;
            boolean isUTCDate = vStr.indexOf("Z") != -1;
            boolean containsMillisec = vStr.indexOf(".") != -1;
            String ldapValue = null;
            if (isUTCDate) {
                date = containsMillisec ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(vStr) : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").parse(vStr);
            } else {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd't'HH:mm:ss");
                date = format.parse(vStr);
                date = LdapHelper.convertDatetoGMT(date);
                isUTCDate = true;
            }
            if ("IBM Tivoli Directory Server".equalsIgnoreCase(ldapType)) {
                ldapValue = isUTCDate ? new SimpleDateFormat("yyyyMMddHHmmss.SSSSSS'Z'").format(date) : new SimpleDateFormat("yyyyMMddHHmmss.SSSSSSZ").format(date);
            } else if ("Sun Java System Directory Server".equalsIgnoreCase(ldapType) || "IBM Lotus Domino".equalsIgnoreCase(ldapType) || "Novell eDirectory".equalsIgnoreCase(ldapType)) {
                ldapValue = isUTCDate ? new SimpleDateFormat("yyyyMMddHHmmss'Z'").format(date) : new SimpleDateFormat("yyyyMMddHHmmssZ").format(date);
            } else {
                if (isUTCDate) {
                    return new SimpleDateFormat("yyyyMMddHHmmss.S'Z'").format(date);
                }
                return new SimpleDateFormat("yyyyMMddHHmmss.SZ").format(date);
            }
            return ldapValue;
        }
        catch (ParseException vStr) {
            void e;
            FFDCFilter.processException((Throwable)vStr, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapHelper", (String)"840", null, (Object[])new Object[]{value, ldapAttr, ldapType});
            throw new WIMSystemException("SYSTEM_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"SYSTEM_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString())));
        }
    }

    private static Date convertDatetoGMT(Date date) {
        Date dstDate;
        Date ret;
        TimeZone tz = TimeZone.getDefault();
        if (tz.inDaylightTime(ret = new Date(date.getTime() - (long)tz.getRawOffset())) && tz.inDaylightTime(dstDate = new Date(ret.getTime() - (long)tz.getDSTSavings()))) {
            ret = dstDate;
        }
        return ret;
    }

    public static Object getIntLdapValue(Object value, LdapAttribute ldapAttr, String ldapType) {
        String ldapValue = null;
        if (value instanceof Integer) {
            ldapValue = value.toString();
        }
        ldapValue = value.toString();
        return ldapValue;
    }

    public static String[] parseFilterDescriptor(String mapDesc) throws CertificateMapperException {
        ArrayList<String> list = new ArrayList<String>();
        int cur_idx = 0;
        int prev_idx = 0;
        int end_idx = mapDesc.length();
        while (cur_idx < end_idx) {
            boolean isSquareBrace = false;
            if (mapDesc.contains("$[")) {
                isSquareBrace = true;
                cur_idx = mapDesc.indexOf("$[", prev_idx);
            } else {
                cur_idx = mapDesc.indexOf("${", prev_idx);
            }
            if (cur_idx == -1) {
                if (prev_idx >= end_idx) break;
                list.add(mapDesc.substring(prev_idx));
                break;
            }
            if (prev_idx < cur_idx) {
                list.add(mapDesc.substring(prev_idx, cur_idx));
            }
            prev_idx = cur_idx;
            cur_idx = isSquareBrace ? mapDesc.indexOf("]", prev_idx) : mapDesc.indexOf("}", prev_idx);
            if (cur_idx == -1) {
                throw new CertificateMapperException("INVALID_CERTIFICATE_FILTER", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_CERTIFICATE_FILTER", (Object[])WIMMessageHelper.generateMsgParms((Object)mapDesc)));
            }
            list.add(mapDesc.substring(prev_idx, ++cur_idx));
            prev_idx = cur_idx;
        }
        String[] mapDescEles = new String[list.size()];
        for (int idx = 0; idx < list.size(); ++idx) {
            mapDescEles[idx] = (String)list.get(idx);
        }
        return mapDescEles;
    }

    public static short getMembershipScope(String scope) {
        if (scope != null) {
            if ("direct".equalsIgnoreCase(scope = scope.trim())) {
                return 0;
            }
            if ("nested".equalsIgnoreCase(scope)) {
                return 1;
            }
            if ("all".equalsIgnoreCase(scope)) {
                return 2;
            }
            return 0;
        }
        return 0;
    }

    public static String[] getRDNs(String rdnStr) {
        StringTokenizer st = new StringTokenizer(rdnStr.toLowerCase(), "+");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String rdn = st.nextToken();
            list.add(rdn);
        }
        return list.toArray(new String[0]);
    }

    public static boolean isIPv6Addr(String host) {
        if (host != null) {
            if (host.contains("[") && host.contains("]")) {
                host = host.substring(host.indexOf("[") + 1, host.indexOf("]"));
            }
            host = host.toLowerCase();
            Pattern p1 = Pattern.compile("^(?:(?:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){7})|(?:(?!(?:.*[a-f0-9](?::|$)){7,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?)))|(?:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){5}:)|(?:(?!(?:.*[a-f0-9]:){5,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3}:)?))?(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))(?:\\.(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))){3}))$");
            Pattern p2 = Pattern.compile("^(\\d{1,3}\\.){3}\\d{1,3}$");
            Matcher m1 = p1.matcher(host);
            boolean b1 = m1.matches();
            Matcher m2 = p2.matcher(host);
            boolean b2 = !m2.matches();
            return b1 && b2;
        }
        return false;
    }

    public static String formatIPv6Addr(String host) {
        if (host == null) {
            return null;
        }
        return "[" + host + "]";
    }

    public static boolean inAttributes(String attrName, Attributes attrs) {
        NamingEnumeration<String> neu = attrs.getIDs();
        while (neu.hasMoreElements()) {
            String attrId = (String)neu.nextElement();
            if (!attrId.equalsIgnoreCase(attrName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static Attribute cloneAttribute(String newAttrName, Attribute attr) throws WIMSystemException {
        BasicAttribute newAttr = new BasicAttribute(newAttrName);
        try {
            NamingEnumeration<?> neu = attr.getAll();
            while (neu.hasMoreElements()) {
                newAttr.add(neu.nextElement());
            }
        }
        catch (NamingException neu) {
            void e;
            FFDCFilter.processException((Throwable)neu, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapHelper", (String)"1037", null, (Object[])new Object[]{newAttrName, attr});
            throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
        }
        return newAttr;
    }

    public static String convertToDashedString(byte[] objectGUID) {
        StringBuilder displayStr = new StringBuilder();
        displayStr.append(LdapHelper.prefixZeros(objectGUID[3] & 0xFF));
        displayStr.append(LdapHelper.prefixZeros(objectGUID[2] & 0xFF));
        displayStr.append(LdapHelper.prefixZeros(objectGUID[1] & 0xFF));
        displayStr.append(LdapHelper.prefixZeros(objectGUID[0] & 0xFF));
        displayStr.append("-");
        displayStr.append(LdapHelper.prefixZeros(objectGUID[5] & 0xFF));
        displayStr.append(LdapHelper.prefixZeros(objectGUID[4] & 0xFF));
        displayStr.append("-");
        displayStr.append(LdapHelper.prefixZeros(objectGUID[7] & 0xFF));
        displayStr.append(LdapHelper.prefixZeros(objectGUID[6] & 0xFF));
        displayStr.append("-");
        displayStr.append(LdapHelper.prefixZeros(objectGUID[8] & 0xFF));
        displayStr.append(LdapHelper.prefixZeros(objectGUID[9] & 0xFF));
        displayStr.append("-");
        displayStr.append(LdapHelper.prefixZeros(objectGUID[10] & 0xFF));
        displayStr.append(LdapHelper.prefixZeros(objectGUID[11] & 0xFF));
        displayStr.append(LdapHelper.prefixZeros(objectGUID[12] & 0xFF));
        displayStr.append(LdapHelper.prefixZeros(objectGUID[13] & 0xFF));
        displayStr.append(LdapHelper.prefixZeros(objectGUID[14] & 0xFF));
        displayStr.append(LdapHelper.prefixZeros(objectGUID[15] & 0xFF));
        return displayStr.toString();
    }

    private static String prefixZeros(int value) {
        if (value <= 15) {
            StringBuilder sb = new StringBuilder("0");
            sb.append(Integer.toHexString(value));
            return sb.toString();
        }
        return Integer.toHexString(value);
    }
}

