/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.service.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.OsgiPropertyUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TimestampUtils {
    protected static final long startTime;
    protected static final long startTimeNano;
    static final long serialVersionUID = 266696210487293339L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTimeToFile(File file, long timestamp) {
        FileWriter fstream;
        String stamp;
        block6: {
            if (file == null) {
                return;
            }
            stamp = Long.toString(timestamp);
            fstream = null;
            if (FileUtils.ensureDirExists(file.getParentFile())) break block6;
            TimestampUtils.tryToClose(fstream);
            return;
        }
        try {
            fstream = new FileWriter(file);
            fstream.write(stamp, 0, stamp.length());
        }
        catch (IOException iOException) {
            try {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.wsspi.kernel.service.utils.TimestampUtils", (String)"57", null, (Object[])new Object[]{file, timestamp});
            }
            catch (Throwable throwable) {
                TimestampUtils.tryToClose(fstream);
                throw throwable;
            }
            TimestampUtils.tryToClose(fstream);
        }
        TimestampUtils.tryToClose(fstream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={FileNotFoundException.class, NumberFormatException.class})
    public static long readTimeFromFile(File file) {
        long timestamp = 0L;
        FileReader fstream = null;
        BufferedReader in = null;
        try {
            fstream = new FileReader(file);
            in = new BufferedReader(fstream, 32);
            timestamp = Long.parseLong(in.readLine());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.wsspi.kernel.service.utils.TimestampUtils", (String)"78", null, (Object[])new Object[]{file});
        }
        finally {
            if (!TimestampUtils.tryToClose(in)) {
                TimestampUtils.tryToClose(fstream);
            }
        }
        return timestamp;
    }

    public static void auditElapsedTime(TraceComponent callingTc, String msgKey) {
        if (callingTc.isAuditEnabled()) {
            Tr.audit((TraceComponent)callingTc, (String)msgKey, (Object[])new Object[]{TimestampUtils.getElapsedTime()});
        }
    }

    public static String getElapsedTime() {
        return TimestampUtils.getElapsedTimeNanos(startTimeNano);
    }

    @Deprecated
    public static String getElapsedTime(long startTime) {
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        return TimestampUtils.getElapsedTimeAsStringFromMilliInterval(elapsedTime);
    }

    static String getElapsedTimeAsStringFromMilliInterval(long elapsedTime) {
        return String.format("%.3f", (double)elapsedTime / 1000.0);
    }

    public static String getElapsedTimeNanos(long startTime) {
        long endTime = System.nanoTime();
        long elapsedTime = (endTime - startTime) / 1000000L;
        return TimestampUtils.getElapsedTimeAsStringFromMilliInterval(elapsedTime);
    }

    @FFDCIgnore(value={IOException.class})
    private static boolean tryToClose(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static final long getStartTimeNano() {
        return startTimeNano;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.kernel.service.utils.TimestampUtils", TimestampUtils.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        long start = OsgiPropertyUtils.getLong("kernel.launch.time", 0L);
        if (start == 0L) {
            start = System.nanoTime();
        }
        startTime = System.currentTimeMillis();
        startTimeNano = start;
    }
}

