/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.util;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.crypto.util.AESKeyManager;
import com.ibm.ws.crypto.util.HashedData;
import com.ibm.ws.crypto.util.InvalidPasswordCipherException;
import com.ibm.ws.crypto.util.MessageUtils;
import com.ibm.ws.crypto.util.PasswordHashGenerator;
import com.ibm.ws.crypto.util.UnsupportedConfigurationException;
import com.ibm.ws.crypto.util.custom.CustomManifest;
import com.ibm.ws.crypto.util.custom.CustomUtils;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.crypto.CustomPasswordEncryption;
import com.ibm.wsspi.security.crypto.EncryptedInfo;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={PasswordCipherUtil.class}, name="com.ibm.ws.crypto.util.PasswordCipherUtil", configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class PasswordCipherUtil {
    private static final Class<?> CLASS_NAME = PasswordCipherUtil.class;
    private static final Logger logger = Logger.getLogger(CLASS_NAME.getCanonicalName(), "com.ibm.ws.crypto.util.internal.resources.Messages");
    private static final String CUSTOM = "custom";
    private static final String CUSTOM_COLON = "custom:";
    private static final String XOR = "xor";
    private static final String AES = "aes";
    private static final String HASH = "hash";
    private static final byte XOR_MASK = 95;
    private static final String[] SUPPORTED_CRYPTO_ALGORITHMS_DEFAULT = new String[]{"xor", "aes", "hash"};
    private static final String[] SUPPORTED_CRYPTO_ALGORITHMS_CUSTOM = new String[]{"xor", "aes", "hash", "custom"};
    private static String[] SUPPORTED_CRYPTO_ALGORITHMS = SUPPORTED_CRYPTO_ALGORITHMS_DEFAULT;
    private static String[] SUPPORTED_HASH_ALGORITHMS = new String[]{"hash"};
    static final String KEY_ENCRYPTION_SERVICE = "customPasswordEncryption";
    private static AtomicServiceReference<CustomPasswordEncryption> customPasswordEncryption = new AtomicServiceReference("customPasswordEncryption");
    private static CustomPasswordEncryption cpeImpl = null;
    private static List<CustomManifest> cms = null;

    protected static void initialize() throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (CustomUtils.isCommandLine() && (cms = CustomUtils.findCustomEncryption("ws-customPasswordEncryption")) != null && cms.size() == 1) {
            Class<?> c = Class.forName(cms.get(0).getImplClass());
            cpeImpl = (CustomPasswordEncryption)c.newInstance();
            SUPPORTED_CRYPTO_ALGORITHMS = SUPPORTED_CRYPTO_ALGORITHMS_CUSTOM;
        }
    }

    public static String listCustom() throws UnsupportedConfigurationException {
        String output = null;
        if (cms != null && !cms.isEmpty()) {
            if (cms.size() != 1) {
                String message = PasswordCipherUtil.composeMultipleCustomErrorMessage(cms);
                throw new UnsupportedConfigurationException(message);
            }
            output = CustomUtils.toJSON(cms);
        }
        return output;
    }

    protected void initializeCustomEncryption() {
        if (customPasswordEncryption.getService() != null) {
            logger.log(Level.INFO, "PASSWORDUTIL_CUSTOM_SERVICE_STARTED", ((CustomPasswordEncryption)customPasswordEncryption.getService()).getClass().getName());
            SUPPORTED_CRYPTO_ALGORITHMS = SUPPORTED_CRYPTO_ALGORITHMS_CUSTOM;
        } else {
            SUPPORTED_CRYPTO_ALGORITHMS = SUPPORTED_CRYPTO_ALGORITHMS_DEFAULT;
        }
    }

    @Activate
    protected void activate(ComponentContext cc) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("activate : customPasswordEncryption : " + customPasswordEncryption);
        }
        customPasswordEncryption.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("deactivate : customPasswordEncryption : " + customPasswordEncryption);
        }
        customPasswordEncryption.deactivate(cc);
    }

    @Reference(service=CustomPasswordEncryption.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY, name="customPasswordEncryption")
    protected void setCustomPasswordEncryption(ServiceReference<CustomPasswordEncryption> reference) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("setCustomPasswordEncryption : customPasswordEncryption : " + customPasswordEncryption);
        }
        customPasswordEncryption.setReference(reference);
        this.initializeCustomEncryption();
    }

    protected void unsetCustomPasswordEncryption(ServiceReference<CustomPasswordEncryption> reference) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("unsetCustomPasswordEncryption : customPasswordEncryption : " + customPasswordEncryption);
        }
        if (customPasswordEncryption.getService() != null) {
            logger.log(Level.INFO, "PASSWORDUTIL_CUSTOM_SERVICE_STOPPED", ((CustomPasswordEncryption)customPasswordEncryption.getService()).getClass().getName());
        }
        customPasswordEncryption.unsetReference(reference);
        this.initializeCustomEncryption();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decipher(byte[] encrypted_bytes, String crypto_algorithm) throws InvalidPasswordCipherException, UnsupportedCryptoAlgorithmException {
        if (crypto_algorithm == null) {
            logger.logp(Level.SEVERE, PasswordCipherUtil.class.getName(), "decipher", "PASSWORDUTIL_UNKNOWN_ALGORITHM", new Object[]{"null", PasswordCipherUtil.formatSupportedCryptoAlgorithms()});
            throw new UnsupportedCryptoAlgorithmException();
        }
        byte[] decrypted_bytes = null;
        if (AES.equalsIgnoreCase(crypto_algorithm)) {
            decrypted_bytes = PasswordCipherUtil.aesDecipher(encrypted_bytes, decrypted_bytes);
        } else if (XOR.equalsIgnoreCase(crypto_algorithm)) {
            decrypted_bytes = PasswordCipherUtil.xor(encrypted_bytes);
        } else {
            if (HASH.equalsIgnoreCase(crypto_algorithm)) {
                throw new InvalidPasswordCipherException(MessageUtils.getMessage("PASSWORDUTIL_ERROR_UNSUPPORTED_OPERATION", crypto_algorithm));
            }
            if (!CUSTOM.equalsIgnoreCase(crypto_algorithm) && !crypto_algorithm.startsWith(CUSTOM_COLON)) {
                logger.logp(Level.SEVERE, PasswordCipherUtil.class.getName(), "decipher", "PASSWORDUTIL_UNKNOWN_ALGORITHM", new Object[]{crypto_algorithm, PasswordCipherUtil.formatSupportedCryptoAlgorithms()});
                throw new UnsupportedCryptoAlgorithmException();
            }
            CustomPasswordEncryption cpe = PasswordCipherUtil.getCustomImpl();
            if (cpe == null) {
                logger.logp(Level.SEVERE, PasswordCipherUtil.class.getName(), "decipher", "PASSWORDUTIL_CUSTOM_SERVICE_DOES_NOT_EXIST");
                throw new UnsupportedCryptoAlgorithmException();
            }
            int index = crypto_algorithm.indexOf(58);
            String keyAlias = null;
            if (index != -1) {
                keyAlias = crypto_algorithm.substring(index + 1);
            }
            try {
                decrypted_bytes = cpe.decrypt(new EncryptedInfo(encrypted_bytes, keyAlias));
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Successfully decrypted password using custom encryption plug point.");
                }
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, PasswordCipherUtil.class.getName(), "decipher", "PASSWORDUTIL_CUSTOM_DECRYPTION_ERROR", e);
                throw (InvalidPasswordCipherException)new InvalidPasswordCipherException(e.getMessage()).initCause(e);
            }
        }
        if (decrypted_bytes == null) {
            throw new InvalidPasswordCipherException("The output is null.");
        }
        return decrypted_bytes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] aesDecipher(byte[] encrypted_bytes, byte[] decrypted_bytes) throws UnsupportedCryptoAlgorithmException, InvalidPasswordCipherException {
        if (encrypted_bytes[0] != 0) throw new InvalidPasswordCipherException();
        try {
            Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
            c.init(2, AESKeyManager.getKey(null), AESKeyManager.getIV(null));
            byte[] decrypted = c.doFinal(encrypted_bytes, 1, encrypted_bytes.length - 1);
            if (decrypted == null) return decrypted_bytes;
            decrypted_bytes = new byte[decrypted.length - decrypted[0] - 1];
            System.arraycopy(decrypted, decrypted[0] + 1, decrypted_bytes, 0, decrypted_bytes.length);
            return decrypted_bytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw (UnsupportedCryptoAlgorithmException)new UnsupportedCryptoAlgorithmException().initCause(e);
        }
        catch (NoSuchPaddingException e) {
            throw (UnsupportedCryptoAlgorithmException)new UnsupportedCryptoAlgorithmException().initCause(e);
        }
        catch (InvalidKeyException e) {
            throw (InvalidPasswordCipherException)new InvalidPasswordCipherException().initCause(e);
        }
        catch (IllegalBlockSizeException e) {
            throw (UnsupportedCryptoAlgorithmException)new UnsupportedCryptoAlgorithmException().initCause(e);
        }
        catch (BadPaddingException e) {
            throw (UnsupportedCryptoAlgorithmException)new UnsupportedCryptoAlgorithmException().initCause(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw (InvalidPasswordCipherException)new InvalidPasswordCipherException().initCause(e);
        }
    }

    public static byte[] encipher(byte[] decrypted_bytes, String crypto_algorithm) throws InvalidPasswordCipherException, UnsupportedCryptoAlgorithmException {
        EncryptedInfo info = PasswordCipherUtil.encipher_internal(decrypted_bytes, crypto_algorithm, (String)null);
        return info.getEncryptedBytes();
    }

    public static EncryptedInfo encipher_internal(byte[] decrypted_bytes, String crypto_algorithm, String cryptoKey) throws InvalidPasswordCipherException, UnsupportedCryptoAlgorithmException {
        HashMap<String, String> props = new HashMap<String, String>();
        if (cryptoKey != null) {
            props.put("crypto.key", cryptoKey);
        }
        return PasswordCipherUtil.encipher_internal(decrypted_bytes, crypto_algorithm, props);
    }

    /*
     * Unable to fully structure code
     */
    public static EncryptedInfo encipher_internal(byte[] decrypted_bytes, String crypto_algorithm, Map<String, String> properties) throws InvalidPasswordCipherException, UnsupportedCryptoAlgorithmException {
        block10: {
            block12: {
                block11: {
                    block9: {
                        info = null;
                        encrypted_bytes = null;
                        if (!"aes".equalsIgnoreCase(crypto_algorithm)) break block9;
                        cryptoKey = null;
                        if (properties != null) {
                            cryptoKey = properties.get("crypto.key");
                        }
                        info = PasswordCipherUtil.aesEncipher(decrypted_bytes, cryptoKey, info, encrypted_bytes);
                        break block10;
                    }
                    if (!"xor".equalsIgnoreCase(crypto_algorithm)) break block11;
                    encrypted_bytes = PasswordCipherUtil.xor(decrypted_bytes);
                    if (encrypted_bytes != null) {
                        info = new EncryptedInfo(encrypted_bytes, "");
                    }
                    break block10;
                }
                if (!"hash".equalsIgnoreCase(crypto_algorithm)) break block12;
                decrypted_chars = null;
                try {
                    originalString = new String(decrypted_bytes, "UTF-8");
                    decrypted_chars = originalString.toCharArray();
                }
                catch (Exception e) {
                    throw new InvalidPasswordCipherException();
                }
                info = PasswordCipherUtil.generateHash(decrypted_chars, properties);
                break block10;
            }
            if (crypto_algorithm == null || !crypto_algorithm.equalsIgnoreCase("custom")) ** GOTO lbl40
            cpe = PasswordCipherUtil.getCustomImpl();
            if (cpe != null) {
                try {
                    info = cpe.encrypt(decrypted_bytes);
                    if (!PasswordCipherUtil.logger.isLoggable(Level.FINE)) ** GOTO lbl42
                    PasswordCipherUtil.logger.fine("Successfully encrypted password using custom encryption plug point.");
                }
                catch (Exception e) {
                    PasswordCipherUtil.logger.logp(Level.SEVERE, PasswordCipherUtil.class.getName(), "encipher", "PASSWORDUTIL_CUSTOM_ENCRYPTION_ERROR", e);
                    throw (InvalidPasswordCipherException)new InvalidPasswordCipherException(e.getMessage()).initCause(e);
                }
            } else {
                PasswordCipherUtil.logger.logp(Level.SEVERE, PasswordCipherUtil.class.getName(), "encipher", "PASSWORDUTIL_CUSTOM_SERVICE_DOES_NOT_EXIST");
                throw new UnsupportedCryptoAlgorithmException();
lbl40:
                // 1 sources

                PasswordCipherUtil.logger.logp(Level.SEVERE, PasswordCipherUtil.class.getName(), "encipher", "PASSWORDUTIL_UNKNOWN_ALGORITHM", new Object[]{crypto_algorithm, PasswordCipherUtil.formatSupportedCryptoAlgorithms()});
                throw new UnsupportedCryptoAlgorithmException();
            }
        }
        if (info == null) {
            throw new InvalidPasswordCipherException("The output is null.");
        }
        return info;
    }

    private static EncryptedInfo generateHash(char[] plainBytes, Map<String, String> properties) throws InvalidPasswordCipherException {
        EncryptedInfo info = null;
        String algorithm = null;
        String saltString = null;
        String encodedString = null;
        int iteration = -1;
        int length = -1;
        byte[] salt = null;
        byte[] output = null;
        boolean saltSet = false;
        if (properties != null) {
            String value;
            encodedString = properties.get("hash.encoded");
            if (encodedString != null && PasswordUtil.isHashed(encodedString)) {
                try {
                    value = PasswordUtil.removeCryptoAlgorithmTag(encodedString);
                    HashedData dd = new HashedData(Base64Coder.base64Decode((byte[])value.getBytes("UTF-8")));
                    algorithm = dd.getAlgorithm();
                    iteration = dd.getIteration();
                    length = dd.getOutputLength();
                    salt = dd.getSalt();
                    saltSet = true;
                }
                catch (Exception e) {
                    throw (InvalidPasswordCipherException)new InvalidPasswordCipherException(e.getMessage()).initCause(e);
                }
            }
            if (algorithm == null) {
                algorithm = properties.get("hash.algorithm");
            }
            if (algorithm == null) {
                algorithm = PasswordHashGenerator.getDefaultAlgorithm();
            }
            if (!saltSet) {
                saltString = properties.get("hash.salt");
                salt = PasswordHashGenerator.generateSalt(saltString);
            }
            if (iteration < 0 && (value = properties.get("hash.iteration")) != null) {
                iteration = Integer.parseInt(value);
            }
            if (iteration < 0) {
                iteration = PasswordHashGenerator.getDefaultIteration();
            }
            if (length < 0 && (value = properties.get("hash.length")) != null) {
                length = Integer.parseInt(value);
            }
            if (length < 0) {
                length = PasswordHashGenerator.getDefaultOutputLength();
            }
        }
        try {
            HashedData dd = new HashedData(plainBytes, algorithm, salt, iteration, length, null);
            output = dd.toBytes();
        }
        catch (InvalidPasswordCipherException ipce) {
            throw ipce;
        }
        catch (Exception e) {
            throw (InvalidPasswordCipherException)new InvalidPasswordCipherException(e.getMessage()).initCause(e);
        }
        if (output != null) {
            info = new EncryptedInfo(output, "");
        }
        return info;
    }

    private static EncryptedInfo aesEncipher(byte[] decrypted_bytes, String cryptoKey, EncryptedInfo info, byte[] encrypted_bytes) throws UnsupportedCryptoAlgorithmException, InvalidPasswordCipherException {
        SecureRandom rand = new SecureRandom();
        byte[] seed = rand.generateSeed(20);
        byte[] preEncrypted = new byte[decrypted_bytes.length + 21];
        preEncrypted[0] = 20;
        System.arraycopy(seed, 0, preEncrypted, 1, 20);
        System.arraycopy(decrypted_bytes, 0, preEncrypted, 21, decrypted_bytes.length);
        try {
            Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
            c.init(1, AESKeyManager.getKey(cryptoKey), AESKeyManager.getIV(cryptoKey));
            encrypted_bytes = c.doFinal(preEncrypted);
            if (encrypted_bytes != null) {
                byte[] updatedBytes = new byte[encrypted_bytes.length + 1];
                updatedBytes[0] = 0;
                System.arraycopy(encrypted_bytes, 0, updatedBytes, 1, encrypted_bytes.length);
                info = new EncryptedInfo(updatedBytes, "");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw (UnsupportedCryptoAlgorithmException)new UnsupportedCryptoAlgorithmException().initCause(e);
        }
        catch (NoSuchPaddingException e) {
            throw (UnsupportedCryptoAlgorithmException)new UnsupportedCryptoAlgorithmException().initCause(e);
        }
        catch (InvalidKeyException e) {
            throw (InvalidPasswordCipherException)new InvalidPasswordCipherException().initCause(e);
        }
        catch (IllegalBlockSizeException e) {
            throw (UnsupportedCryptoAlgorithmException)new UnsupportedCryptoAlgorithmException().initCause(e);
        }
        catch (BadPaddingException e) {
            throw (UnsupportedCryptoAlgorithmException)new UnsupportedCryptoAlgorithmException().initCause(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw (InvalidPasswordCipherException)new InvalidPasswordCipherException().initCause(e);
        }
        return info;
    }

    public static String[] getSupportedCryptoAlgorithms() {
        return (String[])SUPPORTED_CRYPTO_ALGORITHMS.clone();
    }

    public static String getFailSafeCryptoAlgorithm() {
        return XOR;
    }

    public static String[] getSupportedHashAlgorithms() {
        return (String[])SUPPORTED_HASH_ALGORITHMS.clone();
    }

    private static byte[] xor(byte[] bytes) {
        byte[] xor_bytes = null;
        if (bytes != null) {
            xor_bytes = new byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                xor_bytes[i] = (byte)(0x5F ^ bytes[i]);
            }
        }
        return xor_bytes;
    }

    private static String formatSupportedCryptoAlgorithms() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < SUPPORTED_CRYPTO_ALGORITHMS.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(SUPPORTED_CRYPTO_ALGORITHMS[i]);
        }
        return sb.toString();
    }

    private static CustomPasswordEncryption getCustomImpl() {
        CustomPasswordEncryption cpe = (CustomPasswordEncryption)customPasswordEncryption.getService();
        if (cpe == null) {
            cpe = cpeImpl;
        }
        return cpe;
    }

    private static String composeMultipleCustomErrorMessage(List<CustomManifest> list) {
        StringBuffer sb = new StringBuffer(MessageUtils.getMessage("PASSWORDUTIL_DUPLICATE_CUSTOM_ENCRYPTION", new Object[0]));
        for (CustomManifest cm : list) {
            sb.append("\n").append(cm.getLocation());
        }
        return sb.toString();
    }

    static {
        try {
            PasswordCipherUtil.initialize();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

