/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AcidReference<T> {
    private final AtomicReference<Ref<T>> atomicReference = new AtomicReference<Ref>(() -> initial);
    static final long serialVersionUID = 5598114621309293442L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AcidReference(T initial) {
    }

    public AcidReference() {
        this(null);
    }

    public T get() {
        return this.getWithWait().get();
    }

    private Ref<T> getWithWait() {
        Ref<T> ref;
        int contention = -1;
        do {
            ref = this.atomicReference.get();
            ++contention;
        } while (ref.isTransitional());
        if (contention > 0) {
            System.out.println("### contention: " + contention);
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(Function<T, Supplier<T>> updaterSupplier) {
        Supplier<T> neededUpdate;
        TransitionalRef tranRef;
        Ref ref;
        do {
            if (null != (neededUpdate = updaterSupplier.apply((ref = this.getWithWait()).get()))) continue;
            return false;
        } while (!this.atomicReference.compareAndSet(ref, tranRef = new TransitionalRef()));
        try {
            Object newT = neededUpdate.get();
            ref = () -> newT;
            boolean bl = true;
            return bl;
        }
        finally {
            this.atomicReference.set(ref);
            tranRef.markTransitioned();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.transport.iiop.internal.AcidReference", AcidReference.class, (String)"IIOP", (String)"com.ibm.ws.transport.iiop.resources.IiopMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class TransitionalRef<T>
    implements Ref<T> {
        private final CountDownLatch latch = new CountDownLatch(1);
        static final long serialVersionUID = -81284617058733544L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private TransitionalRef() {
        }

        @Override
        public boolean isTransitional() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.transport.iiop.internal.AcidReference$TransitionalRef", (String)"39", (Object)this, (Object[])new Object[0]);
            }
            return true;
        }

        public void markTransitioned() {
            this.latch.countDown();
        }

        @Override
        public T get() {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.transport.iiop.internal.AcidReference$TransitionalRef", TransitionalRef.class, (String)"IIOP", (String)"com.ibm.ws.transport.iiop.resources.IiopMessages");
        }
    }

    private static interface Ref<T>
    extends Supplier<T> {
        default public boolean isTransitional() {
            return false;
        }
    }
}

