/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaspi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.WebSecurityContext;
import com.ibm.ws.webcontainer.security.metadata.LoginConfiguration;
import com.ibm.ws.webcontainer.security.util.WebConfigUtils;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.List;
import javax.security.auth.message.MessageInfo;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaspiRequest {
    private WebRequest webRequest = null;
    private MessageInfo msgInfo = null;
    private boolean isLogoutMethod = false;
    private String userid = null;
    @Sensitive
    private String password = null;
    private String appContext = null;
    private String appName = null;
    private String moduleName = null;
    private WebAppConfig wac = null;
    static final long serialVersionUID = -4924912915438343197L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JaspiRequest(WebRequest webRequest, WebAppConfig wac) {
        this.webRequest = webRequest;
        this.wac = wac;
    }

    public String getAppContext() {
        if (this.appContext == null) {
            String vHost = null;
            String contextRoot = null;
            WebAppConfig appCfg = WebConfigUtils.getWebAppConfig();
            if (appCfg != null) {
                vHost = appCfg.getVirtualHostName();
                contextRoot = appCfg.getContextRoot();
                this.appContext = vHost + " " + contextRoot;
            } else if (this.wac != null) {
                vHost = this.wac.getVirtualHostName();
                contextRoot = this.wac.getContextRoot();
                this.appContext = vHost + " " + contextRoot;
            }
        }
        return this.appContext;
    }

    public WebSecurityContext getWebSecurityContext() {
        return this.webRequest.getWebSecurityContext();
    }

    public MessageInfo getMessageInfo() {
        return this.msgInfo;
    }

    public void setMessageInfo(MessageInfo messageInfo) {
        this.msgInfo = messageInfo;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.webRequest.getHttpServletRequest();
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.webRequest.getHttpServletResponse();
    }

    public boolean isLogoutMethod() {
        return this.isLogoutMethod;
    }

    public void setLogoutMethod(boolean isLogout) {
        this.isLogoutMethod = isLogout;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String id) {
        this.userid = id;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(@Sensitive String pwd) {
        this.password = pwd;
    }

    public LoginConfiguration getLoginConfig() {
        return this.webRequest.getLoginConfig();
    }

    public boolean isProtected() {
        List requiredRoles = null;
        return !this.webRequest.isUnprotectedURI() && this.webRequest.getMatchResponse() != null && (requiredRoles = this.webRequest.getRequiredRoles()) != null && !requiredRoles.isEmpty();
    }

    public boolean isMandatory() {
        return this.isProtected() || this.webRequest.isRequestAuthenticate();
    }

    public String getApplicationName() {
        if (this.appName == null) {
            WebAppConfig appCfg = WebConfigUtils.getWebAppConfig();
            if (appCfg != null) {
                this.appName = appCfg.getModuleName();
            } else if (this.wac != null) {
                this.appName = this.wac.getModuleName();
            }
        }
        return this.appName;
    }

    public String getModuleName() {
        if (this.moduleName == null) {
            WebAppConfig appCfg = WebConfigUtils.getWebAppConfig();
            if (appCfg != null) {
                this.moduleName = appCfg.getModuleName();
            } else if (this.wac != null) {
                this.moduleName = this.wac.getModuleName();
            }
        }
        return this.moduleName;
    }

    public WebRequest getWebRequest() {
        return this.webRequest;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jaspi.JaspiRequest", JaspiRequest.class, (String)"security", (String)"com.ibm.ws.security.jaspi.internal.resources.JaspiMessages");
    }
}

