/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.InstallLicense;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.repository.common.enums.LicenseType;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryBadDataException;
import com.ibm.ws.repository.exceptions.RepositoryResourceException;
import com.ibm.ws.repository.resources.AttachmentResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.SelfExtractUtils;

public class InstallLicenseImpl
implements InstallLicense {
    private static final Logger logger = Logger.getLogger("com.ibm.ws.install");
    private static final String PROGRAM_NAME = "Program Name:";
    private final String id;
    private final LicenseType type;
    private String name;
    private String programName;
    private String information = "";
    private String agreement = "";
    private final Collection<String> features = new ArrayList<String>();

    public InstallLicenseImpl(String id, LicenseType type, AttachmentResource licenseAgreement, AttachmentResource licenseInformation, AttachmentResource enLicenseInformation) throws RepositoryBackendException, RepositoryResourceException {
        this.id = id;
        this.type = type;
        if (licenseAgreement != null) {
            this.agreement = this.getLicense(licenseAgreement.getInputStream(), true);
        }
        if (licenseInformation != null) {
            this.information = this.getLicense(licenseInformation.getInputStream(), false);
        }
        if (this.programName == null && enLicenseInformation != null) {
            this.getProgramName(enLicenseInformation.getInputStream());
        }
    }

    public InstallLicenseImpl(String id, LicenseType type, LicenseProvider licenseProvider) {
        this(id, type, licenseProvider, true);
    }

    public InstallLicenseImpl(String id, LicenseType type, LicenseProvider licenseProvider, boolean wordWrap) {
        this.id = id;
        Object object = type == null ? (id.equalsIgnoreCase("http://www.ibm.com/licenses/wlp-featureterms-v1") ? LicenseType.UNSPECIFIED : null) : (this.type = type);
        if (licenseProvider != null) {
            this.agreement = this.getLicense(licenseProvider.getLicenseAgreement(), true, wordWrap);
            this.information = this.getLicense(licenseProvider.getLicenseInformation(), false, wordWrap);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type == null ? "" : this.type.toString();
    }

    @Override
    public String getName() {
        return this.name == null ? "" : this.name;
    }

    @Override
    public String getProgramName() {
        return this.programName == null ? "" : this.programName;
    }

    @Override
    public String getInformation() {
        return this.information;
    }

    @Override
    public String getAgreement() {
        return this.agreement;
    }

    @Override
    public Collection<String> getFeatures() {
        return this.features;
    }

    public String toString() {
        return "(" + this.id + "," + (this.information.length() > 16 ? this.information.substring(0, 15) + "..." : this.information) + "," + (this.agreement.length() > 16 ? this.agreement.substring(0, 15) + "..." : this.agreement) + ")";
    }

    private String getLicense(InputStream in, boolean isAgreement) {
        return this.getLicense(in, isAgreement, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getLicense(InputStream in, boolean isAgreement, boolean wordWrap) {
        String string;
        if (in == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in, "UTF-16"));
            int i = 0;
            while ((line = reader.readLine()) != null) {
                if (isAgreement) {
                    if (isAgreement && this.name == null) {
                        this.name = line;
                    }
                } else if (this.programName == null && i < 6 && line.startsWith(PROGRAM_NAME)) {
                    this.programName = line.substring(PROGRAM_NAME.length() + 1);
                }
                if (wordWrap) {
                    InstallUtils.wordWrap(sb, line, "");
                } else {
                    sb.append(line);
                    sb.append("\n");
                }
                ++i;
            }
            sb.append("\n");
            string = sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.FINEST, "InstallLicenseImpl.getLicense failed", e);
            String string2 = "";
            SelfExtractUtils.tryToClose((Reader)reader);
            return string2;
        }
        catch (IOException e2) {
            logger.log(Level.FINEST, "InstallLicenseImpl.getLicense failed", e2);
            String string3 = "";
            {
                catch (Throwable throwable) {
                    SelfExtractUtils.tryToClose(reader);
                    throw throwable;
                }
            }
            SelfExtractUtils.tryToClose((Reader)reader);
            return string3;
        }
        SelfExtractUtils.tryToClose((Reader)reader);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getProgramName(InputStream in) {
        BufferedReader reader;
        block9: {
            reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(in, "UTF-16"));
                int i = 0;
                while ((line = reader.readLine()) != null) {
                    if (i < 6 && line.startsWith(PROGRAM_NAME)) {
                        this.programName = line.substring(PROGRAM_NAME.length() + 1);
                        break block9;
                    }
                    ++i;
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.FINEST, "InstallLicenseImpl.getProgramName failed", e);
                {
                    catch (Throwable throwable) {
                        SelfExtractUtils.tryToClose(reader);
                        throw throwable;
                    }
                }
                SelfExtractUtils.tryToClose((Reader)reader);
                return;
                catch (IOException e2) {
                    logger.log(Level.FINEST, "InstallLicenseImpl.getProgramName failed", e2);
                    SelfExtractUtils.tryToClose((Reader)reader);
                    return;
                }
            }
            SelfExtractUtils.tryToClose((Reader)reader);
            return;
        }
        SelfExtractUtils.tryToClose((Reader)reader);
    }

    public void addFeature(String featureName) {
        this.features.add(featureName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLicense(AttachmentResource ar) throws RepositoryBadDataException, RepositoryBackendException {
        InputStream is = ar.getInputStream();
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(is, "UTF-16"));
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            SelfExtractUtils.tryToClose((Reader)reader);
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
        finally {
            SelfExtractUtils.tryToClose(reader);
        }
        return sb.toString();
    }
}

