/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.CancelException;
import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallEventListener;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallLicense;
import com.ibm.ws.install.InstalledFeature;
import com.ibm.ws.install.InstalledFeatureCollection;
import com.ibm.ws.install.ReapplyFixException;
import com.ibm.ws.install.internal.AbstractDirector;
import com.ibm.ws.install.internal.ChecksumsManager;
import com.ibm.ws.install.internal.Engine;
import com.ibm.ws.install.internal.EventManager;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallLicenseImpl;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.Product;
import com.ibm.ws.install.internal.ResolveDirector;
import com.ibm.ws.install.internal.Resolver;
import com.ibm.ws.install.internal.UninstallDirector;
import com.ibm.ws.install.internal.asset.ESAAsset;
import com.ibm.ws.install.internal.asset.FixAsset;
import com.ibm.ws.install.internal.asset.InstallAsset;
import com.ibm.ws.install.internal.asset.InstalledAssetImpl;
import com.ibm.ws.install.internal.asset.JarAsset;
import com.ibm.ws.install.internal.asset.OpenSourceAsset;
import com.ibm.ws.install.internal.asset.SampleAsset;
import com.ibm.ws.install.internal.asset.ServerAsset;
import com.ibm.ws.install.internal.asset.ServerPackageAsset;
import com.ibm.ws.install.internal.asset.ServerPackageJarAsset;
import com.ibm.ws.install.internal.asset.ServerPackageZipAsset;
import com.ibm.ws.install.internal.cmdline.ExeInstallAction;
import com.ibm.ws.install.internal.platform.InstallPlatformUtils;
import com.ibm.ws.install.repository.download.RepositoryDownloadUtil;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.feature.internal.cmdline.FeatureToolException;
import com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.extension.ValidateCommandTask;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.enums.Visibility;
import com.ibm.ws.repository.connections.ProductDefinition;
import com.ibm.ws.repository.connections.RepositoryConnectionList;
import com.ibm.ws.repository.connections.RestRepositoryConnectionProxy;
import com.ibm.ws.repository.connections.liberty.ProductInfoProductDefinition;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.resources.AttachmentResource;
import com.ibm.ws.repository.resources.EsaResource;
import com.ibm.ws.repository.resources.IfixResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.SampleResource;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.zip.ZipException;
import wlp.lib.extract.ExtractProgress;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.SelfExtractUtils;
import wlp.lib.extract.SelfExtractor;

public class Director
extends AbstractDirector {
    private List<List<InstallAsset>> installAssets;
    private final Engine engine = new Engine(this.product);
    private boolean setScriptsPermission = false;
    private boolean firePublicAssetOnly = true;
    private ResolveDirector resolveDirector;
    private UninstallDirector uninstallDirector;

    public Director(File installRoot) {
        super(new Product(installRoot), new EventManager(), InstallLogUtils.getInstallLogger());
        this.logger.setUseParentHandlers(false);
        this.logger.setLevel(Level.FINEST);
    }

    public Director() {
        this(null);
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.getResolveDirector().setRepositoryUrl(repositoryUrl);
    }

    public void setRepositoryProperties(Properties repoProperties) {
        this.getResolveDirector().setRepositoryProperties(repoProperties);
    }

    public void setLoginInfo(RepositoryConnectionList repositoryConnectionList) {
        this.getResolveDirector().setRepositoryConnectionList(repositoryConnectionList);
    }

    public void addListener(InstallEventListener listener, String notificationType) {
        this.eventManager.addListener(listener, notificationType);
    }

    public void removeListener(InstallEventListener listener) {
        this.eventManager.removeListener(listener);
    }

    private void fireProgressEvent(int state, int progress, String messageKey, RepositoryResource installResource) throws InstallException {
        SampleResource sr;
        String resourceName = null;
        if (installResource instanceof EsaResource) {
            EsaResource esar = (EsaResource)installResource;
            if (esar.getVisibility().equals((Object)Visibility.PUBLIC) || esar.getVisibility().equals((Object)Visibility.INSTALL)) {
                resourceName = esar.getShortName() == null ? installResource.getName() : esar.getShortName();
            } else if (!this.firePublicAssetOnly && messageKey.equals("STATE_DOWNLOADING")) {
                messageKey = "STATE_DOWNLOADING_DEPENDENCY";
                resourceName = "";
            } else {
                return;
            }
        }
        resourceName = installResource instanceof SampleResource ? ((sr = (SampleResource)installResource).getShortName() == null ? installResource.getName() : sr.getShortName()) : installResource.getName();
        this.fireProgressEvent(state, progress, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(messageKey, resourceName));
    }

    public void fireInstallProgressEvent(int progress, InstallAsset installAsset) throws InstallException {
        if (installAsset.isServerPackage()) {
            this.fireProgressEvent(96, progress, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_DEPLOYING", installAsset.toString()), true);
        } else if (installAsset.isFeature()) {
            ESAAsset esaa = (ESAAsset)installAsset;
            if (esaa.isPublic()) {
                String resourceName = esaa.getShortName() == null ? esaa.getDisplayName() : esaa.getShortName();
                this.fireProgressEvent(64, progress, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_INSTALLING", resourceName), true);
            } else if (!this.firePublicAssetOnly) {
                this.fireProgressEvent(64, progress, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_INSTALLING_DEPENDENCY", new Object[0]), true);
            }
        } else {
            this.fireProgressEvent(64, progress, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_INSTALLING", installAsset.toString()), true);
        }
    }

    public void fireDownloadProgressEvent(int progress, RepositoryResource installResource) throws InstallException {
        if (installResource.getType().equals((Object)ResourceType.FEATURE)) {
            Visibility v = ((EsaResource)installResource).getVisibility();
            if (v.equals((Object)Visibility.PUBLIC) || v.equals((Object)Visibility.INSTALL)) {
                EsaResource esar = (EsaResource)installResource;
                String resourceName = esar.getShortName() == null ? installResource.getName() : esar.getShortName();
                this.fireProgressEvent(32, progress, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_DOWNLOADING", resourceName), true);
            } else if (!this.firePublicAssetOnly) {
                this.fireProgressEvent(32, progress, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_DOWNLOADING_DEPENDENCY", new Object[0]), true);
            }
        } else if (installResource.getType().equals((Object)ResourceType.PRODUCTSAMPLE) || installResource.getType().equals((Object)ResourceType.OPENSOURCE)) {
            this.fireProgressEvent(32, progress, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_DOWNLOADING", installResource.getName()), true);
        }
    }

    private Collection<String> getFeaturesToBeInstalled() {
        HashSet<String> features = new HashSet<String>();
        for (List<InstallAsset> iaList : this.installAssets) {
            for (InstallAsset installAsset : iaList) {
                if (!installAsset.isFeature()) continue;
                features.add(((ESAAsset)installAsset).getProvideFeature());
            }
        }
        return features;
    }

    public void installFeatures(Collection<String> featureNames, String toExtension, boolean acceptLicense, String userId, String password) throws InstallException {
        this.installFeatures(featureNames, toExtension, acceptLicense, userId, password, 1);
    }

    public void installFeatures(Collection<String> featureNames, String toExtension, boolean acceptLicense, String userId, String password, int checkProgress) throws InstallException {
        this.installFeatures(featureNames, toExtension, acceptLicense, false, userId, password, checkProgress);
    }

    public void installFeatures(Collection<String> featureNames, String toExtension, boolean acceptLicense, boolean allowAlreadyInstalled, String userId, String password, int checkProgress) throws InstallException {
        this.fireProgressEvent(16, checkProgress, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CHECKING", new Object[0]));
        if (featureNames == null || featureNames.isEmpty()) {
            throw ExceptionUtils.createByKey("ERROR_FEATURES_LIST_INVALID", new Object[0]);
        }
        List<List<RepositoryResource>> installResources = this.getResolveDirector().resolve(featureNames, InstallConstants.DownloadOption.required, userId, password);
        if (this.isEmpty(installResources)) {
            if (allowAlreadyInstalled) {
                return;
            }
            throw ExceptionUtils.createByKey(22, "ALREADY_INSTALLED", InstallUtils.getShortNames(this.product.getFeatureDefinitions(), featureNames).toString());
        }
        if (!acceptLicense) {
            throw ExceptionUtils.createByKey("ERROR_LICENSES_NOT_ACCEPTED", new Object[0]);
        }
        this.installAssets = new ArrayList<List<InstallAsset>>(installResources.size());
        int progress = 10;
        int interval1 = installResources.size() == 0 ? 40 : 40 / installResources.size();
        for (List<RepositoryResource> mrList : installResources) {
            ArrayList<InstallAsset> iaList = new ArrayList<InstallAsset>(mrList.size());
            this.installAssets.add(iaList);
            int interval2 = mrList.size() == 0 ? interval1 : interval1 / mrList.size();
            for (RepositoryResource installResource : mrList) {
                this.fireDownloadProgressEvent(progress, installResource);
                progress += interval2;
                File d = null;
                try {
                    Visibility v;
                    d = InstallUtils.download(this.product.getInstallTempDir(), installResource);
                    if (d != null && installResource.getType().equals((Object)ResourceType.FEATURE) && ((v = ((EsaResource)installResource).getVisibility()).equals((Object)Visibility.PUBLIC) || v.equals((Object)Visibility.INSTALL))) {
                        this.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_DOWNLOAD_SUCCESS", installResource.getName()));
                    }
                    this.log(Level.FINEST, d == null ? installResource.getName() + " is an unsupported type " + installResource.getType() + " to be downloaded." : "Downloaded " + installResource.getName() + " to " + d.getAbsolutePath());
                }
                catch (InstallException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ExceptionUtils.createFailedToDownload(installResource, e, d == null ? this.product.getInstallTempDir() : d);
                }
                if (installResource.getType().equals((Object)ResourceType.FEATURE)) {
                    EsaResource esa = (EsaResource)installResource;
                    try {
                        ESAAsset esaAsset = new ESAAsset(esa.getName(), esa.getProvideFeature(), toExtension, d, true);
                        if (esaAsset.getSubsystemEntry() == null) {
                            throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.content.no.subsystem.manifest", new Object[0]), 23);
                        }
                        ProvisioningFeatureDefinition fd = esaAsset.getProvisioningFeatureDefinition();
                        if (!fd.isSupportedFeatureVersion()) {
                            throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("UNSUPPORTED_FEATURE_VERSION", fd.getFeatureName(), fd.getIbmFeatureVersion()), 23);
                        }
                        iaList.add(esaAsset);
                        continue;
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.createByKey(e, "ERROR_INVALID_ESA", esa.getName());
                    }
                }
                if (!installResource.getType().equals((Object)ResourceType.IFIX)) continue;
                try {
                    iaList.add(new FixAsset(installResource.getName(), d, true));
                }
                catch (Exception e) {
                    throw ExceptionUtils.createByKey(e, "ERROR_INVALID_IFIX", installResource.getName());
                }
            }
        }
    }

    public void installFeature(String esaLocation, String toExtension, boolean acceptLicense) throws InstallException {
        this.fireProgressEvent(16, 1, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CHECKING", new Object[0]));
        ArrayList<InstallAsset> installAssets = new ArrayList<InstallAsset>();
        String feature = this.getResolveDirector().resolve(esaLocation, toExtension, this.product.getInstalledFeatures(), installAssets, 10, 40);
        if (installAssets.isEmpty()) {
            throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.feature.exists", feature), 22);
        }
        this.installAssets = new ArrayList<List<InstallAsset>>(1);
        this.installAssets.add(installAssets);
    }

    public void installFeatureNoResolve(String esaLocation, String toExtension, boolean acceptLicense) throws InstallException {
        this.fireProgressEvent(16, 1, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CHECKING", new Object[0]));
        ArrayList<ESAAsset> singleFeatureInstall = new ArrayList<ESAAsset>();
        ESAAsset esa = null;
        try {
            esa = new ESAAsset(new File(esaLocation), toExtension, false);
        }
        catch (ZipException e) {
            throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.download.esa", esaLocation, e.getMessage()), 20);
        }
        catch (IOException e) {
            throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.download.esa", esaLocation, e.getMessage()), 20);
        }
        singleFeatureInstall.add(esa);
        this.installAssets = new ArrayList<List<InstallAsset>>(1);
        this.installAssets.add(singleFeatureInstall);
    }

    public void installFeature(Collection<String> featureIds, File fromDir, String toExtension, boolean acceptLicense, boolean offlineOnly) throws InstallException {
        this.installAssets = new ArrayList<List<InstallAsset>>();
        ArrayList<InstallAsset> installAssets = new ArrayList<InstallAsset>();
        ArrayList<String> unresolvedFeatures = new ArrayList<String>();
        Collection<ESAAsset> autoFeatures = this.getResolveDirector().getAutoFeature(fromDir, toExtension);
        this.getResolveDirector().resolve(featureIds, fromDir, toExtension, offlineOnly, installAssets, unresolvedFeatures);
        if (!offlineOnly && !unresolvedFeatures.isEmpty()) {
            this.log(Level.FINEST, "installFeature() determined unresolved features: " + unresolvedFeatures.toString() + " from " + fromDir.getAbsolutePath());
            this.installFeatures(unresolvedFeatures, toExtension, acceptLicense, null, null, 5);
        }
        if (!installAssets.isEmpty()) {
            this.getResolveDirector().resolveAutoFeatures(autoFeatures, installAssets);
            this.installAssets.add(installAssets);
        }
        if (this.installAssets.isEmpty()) {
            throw ExceptionUtils.createByKey(22, "ALREADY_INSTALLED", featureIds.toString());
        }
    }

    public ServerPackageAsset resolveServerPackage(File archiveFile) throws InstallException {
        InstallAsset spa = ServerPackageJarAsset.validType(archiveFile.getAbsolutePath().toLowerCase()) ? new ServerPackageJarAsset(archiveFile, false) : new ServerPackageZipAsset(archiveFile, false);
        this.installAssets = new ArrayList<List<InstallAsset>>();
        this.installAssets.add(Arrays.asList(spa));
        return spa;
    }

    public Collection<String> getServerFeaturesToInstall(Set<ServerAsset> servers, boolean offlineOnly) throws InstallException, IOException {
        TreeSet<String> features = new TreeSet<String>();
        HashSet<String> serverNames = new HashSet<String>(servers.size());
        HashSet<String> allServerNames = new HashSet<String>(servers.size());
        for (ServerAsset sa : servers) {
            File serverXmlFile = sa.getServerXmlFile();
            Set<String> requiredFeatures = InstallUtils.getFeatures(serverXmlFile.getAbsolutePath(), serverXmlFile.getName(), new HashSet<String>());
            File serverDirectory = sa.getServerDirectory();
            File overridesFolder = new File(serverDirectory, "/configDropins/overrides");
            File defaultsFolder = new File(serverDirectory, "/configDropins/defaults");
            List<File> folders = Arrays.asList(defaultsFolder, overridesFolder);
            folders.stream().filter(folder -> folder.exists() && folder.isDirectory()).forEach(folder -> {
                try {
                    this.logger.fine("Processing " + folder);
                    Files.newDirectoryStream(Paths.get(folder.toURI()), path -> path.toString().endsWith(".xml")).forEach(path -> {
                        try {
                            requiredFeatures.addAll(InstallUtils.getFeatures(path.toString(), path.getFileName().toString(), new HashSet<String>()));
                        }
                        catch (IOException e) {
                            this.logger.fine("Could not process " + path);
                        }
                    });
                }
                catch (IOException e) {
                    this.logger.fine("Could not process " + folder);
                }
            });
            if (!requiredFeatures.isEmpty()) {
                this.logger.log(Level.FINEST, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_DEPLOY_SERVER_FEATURES", sa.getServerName(), InstallUtils.getFeatureListOutput(requiredFeatures)));
                features.addAll(requiredFeatures);
                serverNames.add(sa.getServerName());
            }
            allServerNames.add(sa.getServerName());
        }
        Collection<String> featuresToInstall = this.getFeaturesToInstall(features, offlineOnly);
        if (!featuresToInstall.isEmpty()) {
            this.logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_DEPLOY_ADDITIONAL_FEATURES_REQUIRED", serverNames, featuresToInstall));
            InstallUtils.setServerXmlInstallTrue();
        } else {
            this.logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_DEPLOY_NO_ADDITIONAL_FEATURES_REQUIRED", allServerNames));
        }
        return featuresToInstall;
    }

    public void installFixes(Collection<String> fixes, String userId, String password) throws InstallException {
        this.fireProgressEvent(16, 1, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CHECKING", new Object[0]));
        ArrayList<String> fixesToInstall = new ArrayList<String>(fixes.size());
        for (String fix : fixes) {
            fixesToInstall.add(fix);
        }
        RepositoryConnectionList loginInfo = this.getResolveDirector().getRepositoryConnectionList(null, userId, password, this.getClass().getCanonicalName() + ".installFixes");
        Resolver resolver = new Resolver(loginInfo);
        List<IfixResource> ifixResources = resolver.resolveFixResources(fixesToInstall);
        if (ifixResources.isEmpty()) {
            throw ExceptionUtils.createByKey("ERROR_FAILED_TO_RESOLVE_IFIX", InstallUtils.getFeatureListOutput(fixes));
        }
        ArrayList<FixAsset> installAssets = new ArrayList<FixAsset>();
        int progress = 10;
        int interval = 40 / ifixResources.size();
        for (IfixResource fix : ifixResources) {
            File d;
            this.fireProgressEvent(32, progress, "STATE_DOWNLOADING", (RepositoryResource)fix);
            progress += interval;
            try {
                d = InstallUtils.download(this.product.getInstallTempDir(), (RepositoryResource)fix);
            }
            catch (InstallException e) {
                throw e;
            }
            catch (Exception e) {
                throw ExceptionUtils.createByKey(e, "ERROR_FAILED_TO_DOWNLOAD_IFIX", fix.getName(), this.product.getInstallTempDir().getAbsolutePath());
            }
            try {
                installAssets.add(new FixAsset(fix.getName(), d, true));
            }
            catch (Exception e) {
                throw ExceptionUtils.createByKey(e, "ERROR_INVALID_IFIX", fix.getName());
            }
        }
        this.installAssets = new ArrayList<List<InstallAsset>>(1);
        this.installAssets.add(installAssets);
    }

    public Set<InstallLicense> getFeatureLicense(Collection<String> featureIds, File fromDir, String toExtension, boolean offlineOnly, Locale locale) throws InstallException {
        Set<InstallLicense> licenses = new HashSet<InstallLicense>();
        ArrayList<InstallAsset> installAssets = new ArrayList<InstallAsset>();
        ArrayList<String> unresolvedFeatures = new ArrayList<String>();
        Collection<ESAAsset> autoFeatures = this.getResolveDirector().getAutoFeature(fromDir, toExtension);
        this.getResolveDirector().resolve(featureIds, fromDir, toExtension, offlineOnly, installAssets, unresolvedFeatures);
        if (!offlineOnly && !unresolvedFeatures.isEmpty()) {
            this.log(Level.FINEST, "getFeatureLicense() determined unresolved features: " + unresolvedFeatures.toString() + " from " + fromDir.getAbsolutePath());
            licenses = this.getFeatureLicense(unresolvedFeatures, locale, null, null);
        }
        if (installAssets.isEmpty()) {
            return licenses;
        }
        this.getResolveDirector().resolveAutoFeatures(autoFeatures, installAssets);
        HashMap<String, InstallLicenseImpl> licenseIds = new HashMap<String, InstallLicenseImpl>();
        for (InstallAsset installAsset : installAssets) {
            if (!installAsset.isFeature()) continue;
            ESAAsset esa = (ESAAsset)installAsset;
            if (esa.isPublic()) {
                ExeInstallAction.incrementNumOfLocalFeatures();
            }
            LicenseProvider lp = esa.getLicenseProvider(locale);
            String licenseId = esa.getLicenseId();
            if (licenseId == null || licenseId.isEmpty()) continue;
            InstallLicenseImpl ili = (InstallLicenseImpl)licenseIds.get(licenseId);
            if (ili == null) {
                ili = new InstallLicenseImpl(licenseId, null, lp);
                licenseIds.put(licenseId, ili);
            }
            ili.addFeature(esa.getProvideFeature());
        }
        licenses.addAll(licenseIds.values());
        return licenses;
    }

    public Set<InstallLicense> getFeatureLicense(String esaLocation, Locale locale) throws InstallException {
        HashSet<InstallLicense> licenses = new HashSet<InstallLicense>();
        ArrayList<InstallAsset> installAssets = new ArrayList<InstallAsset>();
        this.getResolveDirector().resolve(esaLocation, "", this.product.getInstalledFeatures(), installAssets, 10, 40);
        if (installAssets.isEmpty()) {
            return licenses;
        }
        HashMap<String, InstallLicenseImpl> licenseIds = new HashMap<String, InstallLicenseImpl>();
        for (InstallAsset installAsset : installAssets) {
            if (!installAsset.isFeature()) continue;
            ESAAsset esa = (ESAAsset)installAsset;
            LicenseProvider lp = esa.getLicenseProvider(locale);
            String licenseId = esa.getLicenseId();
            if (licenseId == null || licenseId.isEmpty()) continue;
            InstallLicenseImpl ili = (InstallLicenseImpl)licenseIds.get(licenseId);
            if (ili == null) {
                ili = new InstallLicenseImpl(licenseId, null, lp);
                licenseIds.put(licenseId, ili);
            }
            ili.addFeature(esa.getProvideFeature());
        }
        licenses.addAll(licenseIds.values());
        return licenses;
    }

    public Set<InstallLicense> getFeatureLicense(Collection<String> featureNames, Locale locale, String userId, String password) throws InstallException {
        HashSet<InstallLicense> licenses = new HashSet<InstallLicense>();
        if (featureNames == null || featureNames.isEmpty()) {
            return licenses;
        }
        Map<String, List<List<RepositoryResource>>> installResources = this.getResolveDirector().resolveMap(featureNames, InstallConstants.DownloadOption.required, userId, password);
        if (this.isEmpty(installResources)) {
            this.installAssets = new ArrayList<List<InstallAsset>>(0);
            return licenses;
        }
        return this.getFeatureLicense(locale, installResources);
    }

    private Set<InstallLicense> getFeatureLicense(Locale locale, Map<String, List<List<RepositoryResource>>> installResources) throws InstallException {
        HashSet<InstallLicense> licenses = new HashSet<InstallLicense>();
        HashMap<String, InstallLicenseImpl> licenseIds = new HashMap<String, InstallLicenseImpl>();
        this.getFeatureLicenseFromInstallResources(locale, licenseIds, installResources);
        licenses.addAll(licenseIds.values());
        return licenses;
    }

    private void getFeatureLicenseFromInstallResources(Locale locale, Map<String, InstallLicenseImpl> licenseIds, Map<String, List<List<RepositoryResource>>> installResources) throws InstallException {
        if (installResources == null) {
            return;
        }
        for (List<List<RepositoryResource>> targetList : installResources.values()) {
            for (List<RepositoryResource> mrList : targetList) {
                for (RepositoryResource installResource : mrList) {
                    if (!installResource.getType().equals((Object)ResourceType.FEATURE)) continue;
                    try {
                        AttachmentResource enLi;
                        Visibility v = ((EsaResource)installResource).getVisibility();
                        if (v.equals((Object)Visibility.PUBLIC) || v.equals((Object)Visibility.INSTALL)) {
                            ExeInstallAction.incrementNumOfRemoteFeatures();
                        }
                        AttachmentResource la = installResource.getLicenseAgreement(locale);
                        AttachmentResource li = installResource.getLicenseInformation(locale);
                        AttachmentResource attachmentResource = enLi = locale.getLanguage().equalsIgnoreCase("en") ? null : installResource.getLicenseInformation(Locale.ENGLISH);
                        String licenseId = installResource.getLicenseId();
                        if (licenseId == null || licenseId.isEmpty()) continue;
                        InstallLicenseImpl ili = licenseIds.get(licenseId);
                        if (ili == null) {
                            ili = new InstallLicenseImpl(licenseId, installResource.getLicenseType(), la, li, enLi);
                            licenseIds.put(licenseId, ili);
                        }
                        ili.addFeature(((EsaResource)installResource).getProvideFeature());
                    }
                    catch (RepositoryException e) {
                        throw ExceptionUtils.createByKey((Exception)((Object)e), "ERROR_FAILED_TO_GET_FEATURE_LICENSE", installResource.getName());
                    }
                }
            }
        }
    }

    public Set<InstallLicense> getServerPackageFeatureLicense(File archive, boolean offlineOnly, Locale locale) throws InstallException {
        String aName = archive.getAbsolutePath().toLowerCase();
        InstallAsset spa = null;
        if (ServerPackageZipAsset.validType(aName)) {
            spa = new ServerPackageZipAsset(archive, false);
        } else if (ServerPackageJarAsset.validType(aName)) {
            spa = new ServerPackageJarAsset(archive, false);
        } else {
            return new HashSet<InstallLicense>();
        }
        return this.getFeatureLicense(spa.getRequiredFeatures(), locale, null, null);
    }

    public Set<InstallLicense> getServerFeatureLicense(File serverXML, boolean offlineOnly, Locale locale) throws InstallException, IOException {
        if (null != serverXML) {
            return this.getFeatureLicense(new ServerAsset(serverXML).getRequiredFeatures(), locale, null, null);
        }
        return new HashSet<InstallLicense>();
    }

    public Set<String> getInstalledLicense() {
        return this.product.getAcceptedLicenses();
    }

    public List<String> getExtensionNames() {
        return this.product.getExtensionNames();
    }

    private void checkSetScriptsPermission(List<File> filesInstalled) {
        if (this.setScriptsPermission) {
            return;
        }
        this.setScriptsPermission = this.containScript(filesInstalled);
    }

    private void download(int progress, InstallAsset installAsset) throws InstallException {
        RepositoryResource rr = installAsset.getRepositoryResource();
        if (rr != null) {
            installAsset.download(this.product.getInstallTempDir());
            this.fireDownloadProgressEvent(progress, rr);
        }
    }

    public void install(InstallConstants.ExistsAction existsAction, boolean rollbackAll, boolean downloadDependencies) throws InstallException {
        if (this.installAssets.isEmpty()) {
            return;
        }
        int progress = 50;
        int interval1 = this.installAssets.size() == 0 ? 40 : 40 / this.installAssets.size();
        ArrayList<File> filesInstalled = new ArrayList<File>();
        ChecksumsManager checksumsManager = new ChecksumsManager();
        for (List<InstallAsset> iaList : this.installAssets) {
            int interval2;
            int n = interval2 = iaList.size() == 0 ? interval1 : interval1 / (iaList.size() * 2);
            if (!rollbackAll) {
                filesInstalled = new ArrayList();
            }
            HashSet<String> executableFiles = new HashSet<String>();
            HashMap<String, Set<String>> extattrFilesMap = new HashMap<String, Set<String>>();
            for (InstallAsset installAsset : iaList) {
                progress += interval2;
                try {
                    this.download(progress, installAsset);
                }
                catch (InstallException e) {
                    InstallUtils.delete(filesInstalled);
                    installAsset.cleanup();
                    throw e;
                }
                try {
                    this.fireInstallProgressEvent(progress, installAsset);
                }
                catch (CancelException e) {
                    InstallUtils.delete(filesInstalled);
                    installAsset.cleanup();
                    throw e;
                }
                progress += interval2;
                try {
                    this.engine.install(installAsset, filesInstalled, this.getFeaturesToBeInstalled(), existsAction, executableFiles, extattrFilesMap, downloadDependencies, this.getResolveDirector().getProxy(), checksumsManager);
                    if (installAsset.isFeature() || installAsset.isAddon()) {
                        ESAAsset esaa = (ESAAsset)installAsset;
                        if (!esaa.isPublic()) continue;
                        this.log(Level.FINE, installAsset.installedLogMsg());
                        continue;
                    }
                    this.log(Level.FINE, installAsset.installedLogMsg());
                }
                catch (InstallException e) {
                    this.log(Level.SEVERE, e.getMessage(), e);
                    throw e;
                }
                catch (IOException e) {
                    throw ExceptionUtils.create(e);
                }
                finally {
                    installAsset.cleanup();
                }
            }
            try {
                InstallPlatformUtils.setExecutePermissionAccordingToUmask(executableFiles.toArray(new String[executableFiles.size()]));
            }
            catch (Exception e) {
                this.log(Level.WARNING, e.getMessage());
                if (null != e.getCause()) {
                    this.log(Level.SEVERE, null, e);
                }
                this.log(Level.WARNING, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNABLE_TO_SET_EXECUTE_PERMISSIONS", ((Object)executableFiles).toString()));
            }
            try {
                InstallPlatformUtils.setExtendedAttributes(extattrFilesMap);
            }
            catch (Exception e) {
                this.log(Level.WARNING, e.getMessage());
                if (null != e.getCause()) {
                    this.log(Level.SEVERE, null, e);
                }
                for (Map.Entry entry : extattrFilesMap.entrySet()) {
                    String attr = (String)entry.getKey();
                    this.log(Level.WARNING, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNABLE_TO_SET_EXT_ATTR", attr, ((Set)entry.getValue()).toString()));
                }
            }
            this.checkSetScriptsPermission(filesInstalled);
        }
        checksumsManager.updateChecksums();
    }

    public void install(InstallConstants.ExistsAction existsAction, boolean rollbackAll, boolean downloadDependencies, boolean skipDependencyCheck) throws InstallException {
        if (this.installAssets.isEmpty()) {
            return;
        }
        int progress = 50;
        int interval1 = this.installAssets.size() == 0 ? 40 : 40 / this.installAssets.size();
        ArrayList<File> filesInstalled = new ArrayList<File>();
        ChecksumsManager checksumsManager = new ChecksumsManager();
        for (List<InstallAsset> iaList : this.installAssets) {
            int interval2;
            int n = interval2 = iaList.size() == 0 ? interval1 : interval1 / (iaList.size() * 2);
            if (!rollbackAll) {
                filesInstalled = new ArrayList();
            }
            HashSet<String> executableFiles = new HashSet<String>();
            HashMap<String, Set<String>> extattrFilesMap = new HashMap<String, Set<String>>();
            for (InstallAsset installAsset : iaList) {
                progress += interval2;
                try {
                    this.download(progress, installAsset);
                }
                catch (InstallException e) {
                    InstallUtils.delete(filesInstalled);
                    installAsset.cleanup();
                    throw e;
                }
                try {
                    this.fireInstallProgressEvent(progress, installAsset);
                }
                catch (CancelException e) {
                    InstallUtils.delete(filesInstalled);
                    installAsset.cleanup();
                    throw e;
                }
                progress += interval2;
                try {
                    if (skipDependencyCheck) {
                        this.engine.installFeatureNoDependencyCheck(installAsset, filesInstalled, this.getFeaturesToBeInstalled(), existsAction, executableFiles, extattrFilesMap, downloadDependencies, this.getResolveDirector().getProxy(), checksumsManager);
                    } else {
                        this.engine.install(installAsset, filesInstalled, this.getFeaturesToBeInstalled(), existsAction, executableFiles, extattrFilesMap, downloadDependencies, this.getResolveDirector().getProxy(), checksumsManager);
                    }
                    if (installAsset.isFeature() || installAsset.isAddon()) {
                        ESAAsset esaa = (ESAAsset)installAsset;
                        if (!esaa.isPublic()) continue;
                        this.log(Level.FINE, installAsset.installedLogMsg());
                        continue;
                    }
                    this.log(Level.FINE, installAsset.installedLogMsg());
                }
                catch (InstallException e) {
                    this.log(Level.SEVERE, e.getMessage(), e);
                    throw e;
                }
                catch (IOException e) {
                    throw ExceptionUtils.create(e);
                }
                finally {
                    installAsset.cleanup();
                }
            }
            try {
                InstallPlatformUtils.setExecutePermissionAccordingToUmask(executableFiles.toArray(new String[executableFiles.size()]));
            }
            catch (Exception e) {
                this.log(Level.WARNING, e.getMessage());
                if (null != e.getCause()) {
                    this.log(Level.SEVERE, null, e);
                }
                this.log(Level.WARNING, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNABLE_TO_SET_EXECUTE_PERMISSIONS", ((Object)executableFiles).toString()));
            }
            try {
                InstallPlatformUtils.setExtendedAttributes(extattrFilesMap);
            }
            catch (Exception e) {
                this.log(Level.WARNING, e.getMessage());
                if (null != e.getCause()) {
                    this.log(Level.SEVERE, null, e);
                }
                for (Map.Entry entry : extattrFilesMap.entrySet()) {
                    String attr = (String)entry.getKey();
                    this.log(Level.WARNING, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNABLE_TO_SET_EXT_ATTR", attr, ((Set)entry.getValue()).toString()));
                }
            }
            this.checkSetScriptsPermission(filesInstalled);
        }
        checksumsManager.updateChecksums();
    }

    public void cleanUp() {
        boolean del;
        this.fireProgressEvent(224, 98, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CLEANING", new Object[0]));
        if (this.installAssets != null) {
            for (List<InstallAsset> iaList : this.installAssets) {
                for (InstallAsset asset : iaList) {
                    asset.delete();
                }
            }
        }
        if (!(del = InstallUtils.deleteDirectory(this.product.getInstallTempDir()))) {
            this.product.getInstallTempDir().deleteOnExit();
        }
        this.installAssets = null;
        this.setScriptsPermission = false;
        if (this.resolveDirector != null) {
            this.resolveDirector.cleanUp();
        }
        if (this.uninstallDirector != null) {
            this.uninstallDirector.cleanUp();
        }
        this.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_CLEANUP_SUCCESS", new Object[0]));
    }

    public Collection<String> getInstalledFeatureNames() {
        if (this.installAssets == null) {
            return null;
        }
        ArrayList<String> installed = new ArrayList<String>();
        for (List<InstallAsset> iaList : this.installAssets) {
            for (InstallAsset asset : iaList) {
                ESAAsset esa;
                if (!asset.isFeature() || !(esa = (ESAAsset)asset).isPublic()) continue;
                String esaName = esa.getShortName();
                if (esaName == null || esaName.isEmpty()) {
                    esaName = esa.getFeatureName();
                }
                installed.add(esaName);
            }
        }
        return installed;
    }

    public Set<String> getInstalledFeatures(String installedBy) {
        return this.product.getInstalledFeatures(installedBy);
    }

    public void refresh() {
        this.product.refresh();
    }

    public void enableConsoleLog(Level level, boolean verbose) {
        InstallLogUtils.enableConsoleLogging(level, verbose);
        InstallLogUtils.enableConsoleErrorLogging(verbose);
    }

    public void reapplyFixIfNeeded() throws ReapplyFixException {
        BundleRepositoryRegistry.initializeDefaults(null, (boolean)false);
        Set fixesToReapply = ValidateCommandTask.getFixesToReapply((ManifestFileProcessor)this.product.getManifestFileProcessor(), (CommandConsole)new InstallUtils.InstallCommandConsole());
        try {
            this.fireProgressEvent(16, 90, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_VALIDATING_FIXES", fixesToReapply.toString()));
            this.enableEvent = false;
            if (fixesToReapply.isEmpty()) {
                this.log(Level.FINEST, "No fix is required to be reapplied.");
            } else {
                this.installFixes(fixesToReapply, null, null);
                this.install(InstallConstants.ExistsAction.replace, false, false);
                this.log(Level.FINEST, "Successfully reapplied the following fixes: " + fixesToReapply.toString());
            }
        }
        catch (InstallException e) {
            this.log(Level.FINEST, "Failed to reapply the following fixes: " + fixesToReapply.toString());
            throw new ReapplyFixException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_REINSTALL_FIXES_WARNING", fixesToReapply.toString()).trim(), e, 21);
        }
        finally {
            this.enableEvent = true;
        }
    }

    public void setScriptsPermission(int event) {
        if (event == 176 ? this.setScriptsPermission : this.getUninstallDirector().needToSetScriptsPermission()) {
            this.fireProgressEvent(event, 95, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_SET_SCRIPTS_PERMISSION", new Object[0]));
            try {
                SelfExtractUtils.fixScriptPermissions((ExtractProgress)new SelfExtractor.NullExtractProgress(), (File)this.product.getInstallDir(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setUserAgent(String kernelUser) {
        this.getResolveDirector().setUserAgent(kernelUser);
    }

    public List<EsaResource> queryFeatures(String searchStr) throws InstallException {
        ArrayList<EsaResource> features = new ArrayList<EsaResource>();
        RepositoryConnectionList loginInfo = this.getResolveDirector().getRepositoryConnectionList(null, null, null, this.getClass().getCanonicalName() + ".queryFeatures");
        try {
            for (ProductInfo productInfo : ProductInfo.getAllProductInfo().values()) {
                this.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_SEARCHING_FEATURES", new Object[0]));
                features.addAll(loginInfo.findMatchingEsas(searchStr, (ProductDefinition)new ProductInfoProductDefinition(productInfo), Visibility.PUBLIC));
                this.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_SEARCHING_ADDONS", new Object[0]));
                features.addAll(loginInfo.findMatchingEsas(searchStr, (ProductDefinition)new ProductInfoProductDefinition(productInfo), Visibility.INSTALL));
            }
            this.log(Level.FINE, " ");
        }
        catch (ProductInfoParseException pipe) {
            throw ExceptionUtils.create((Exception)((Object)pipe));
        }
        catch (DuplicateProductInfoException dpie) {
            throw ExceptionUtils.create((Exception)((Object)dpie));
        }
        catch (ProductInfoReplaceException pire) {
            throw ExceptionUtils.create((Exception)((Object)pire));
        }
        catch (RepositoryException re) {
            throw ExceptionUtils.create(re, re.getCause(), this.getResolveDirector().getProxy(), this.getResolveDirector().defaultRepo());
        }
        return features;
    }

    public Map<ResourceType, List<RepositoryResource>> queryAssets(String searchStr, InstallConstants.AssetType type) throws InstallException {
        HashMap<ResourceType, List<RepositoryResource>> results = new HashMap<ResourceType, List<RepositoryResource>>();
        ArrayList addOns = new ArrayList();
        ArrayList features = new ArrayList();
        ArrayList samples = new ArrayList();
        ArrayList openSources = new ArrayList();
        RepositoryConnectionList loginInfo = this.getResolveDirector().getRepositoryConnectionList(null, null, null, this.getClass().getCanonicalName() + ".queryAssets");
        try {
            ArrayList<ResourceType> tList;
            ArrayList<ProductInfoProductDefinition> pdList = new ArrayList<ProductInfoProductDefinition>();
            for (ProductInfo pi : ProductInfo.getAllProductInfo().values()) {
                pdList.add(new ProductInfoProductDefinition(pi));
            }
            if (type.equals((Object)InstallConstants.AssetType.all) || type.equals((Object)InstallConstants.AssetType.addon)) {
                this.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_SEARCHING_ADDONS", new Object[0]));
                tList = new ArrayList<ResourceType>(1);
                tList.add(ResourceType.FEATURE);
                addOns.addAll(loginInfo.findResources(searchStr, pdList, tList, Visibility.INSTALL));
            }
            if (type.equals((Object)InstallConstants.AssetType.all) || type.equals((Object)InstallConstants.AssetType.feature)) {
                this.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_SEARCHING_FEATURES", new Object[0]));
                tList = new ArrayList(1);
                tList.add(ResourceType.FEATURE);
                features.addAll(loginInfo.findResources(searchStr, pdList, tList, Visibility.PUBLIC));
            }
            if (type.equals((Object)InstallConstants.AssetType.all) || type.equals((Object)InstallConstants.AssetType.sample)) {
                this.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_SEARCHING_SAMPLES", new Object[0]));
                tList = new ArrayList(1);
                tList.add(ResourceType.PRODUCTSAMPLE);
                samples.addAll(loginInfo.findResources(searchStr, pdList, tList, Visibility.PUBLIC));
            }
            if (type.equals((Object)InstallConstants.AssetType.all) || type.equals((Object)InstallConstants.AssetType.opensource)) {
                this.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_SEARCHING_OPENSOURCE", new Object[0]));
                tList = new ArrayList(1);
                tList.add(ResourceType.OPENSOURCE);
                openSources.addAll(loginInfo.findResources(searchStr, pdList, tList, Visibility.PUBLIC));
            }
            this.log(Level.FINE, "");
        }
        catch (ProductInfoParseException pipe) {
            throw ExceptionUtils.create((Exception)((Object)pipe));
        }
        catch (DuplicateProductInfoException dpie) {
            throw ExceptionUtils.create((Exception)((Object)dpie));
        }
        catch (ProductInfoReplaceException pire) {
            throw ExceptionUtils.create((Exception)((Object)pire));
        }
        catch (RepositoryException re) {
            throw ExceptionUtils.create(re, re.getCause(), this.getResolveDirector().getProxy(), this.getResolveDirector().defaultRepo());
        }
        if (!addOns.isEmpty()) {
            results.put(ResourceType.ADDON, addOns);
        }
        if (!features.isEmpty()) {
            results.put(ResourceType.FEATURE, features);
        }
        if (!samples.isEmpty()) {
            results.put(ResourceType.PRODUCTSAMPLE, samples);
        }
        if (!openSources.isEmpty()) {
            results.put(ResourceType.OPENSOURCE, openSources);
        }
        return results;
    }

    public Collection<String> downloadFeatureFeatureManager(Set<String> featureNames, File toDir, InstallConstants.DownloadOption downloadOption, InstallConstants.ExistsAction action, String user, String password) throws InstallException {
        this.fireProgressEvent(16, 1, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CHECKING", new Object[0]));
        if (featureNames == null || featureNames.isEmpty()) {
            throw ExceptionUtils.createByKey("ERROR_FEATURES_LIST_INVALID", new Object[0]);
        }
        List<List<RepositoryResource>> installResources = this.getResolveDirector().resolve(featureNames, downloadOption, user, password);
        if (this.isEmpty(installResources)) {
            if (downloadOption == InstallConstants.DownloadOption.required) {
                throw ExceptionUtils.createByKey(22, "ERROR_DOWNLOAD_ALREADY_INSTALLED", InstallUtils.getShortNames(this.product.getFeatureDefinitions(), featureNames).toString());
            }
            throw ExceptionUtils.createByKey("ERROR_FAILED_TO_RESOLVE_FEATURES", InstallUtils.getFeatureListOutput(featureNames));
        }
        ArrayList<String> downloaded = new ArrayList<String>(installResources.size());
        int progress = 10;
        int interval1 = installResources.size() == 0 ? 90 : 90 / installResources.size();
        for (List<RepositoryResource> mrList : installResources) {
            int interval2 = mrList.size() == 0 ? interval1 : interval1 / mrList.size();
            for (RepositoryResource installResource : mrList) {
                this.fireDownloadProgressEvent(progress, installResource);
                progress += interval2;
                if (installResource.getType().equals((Object)ResourceType.FEATURE)) {
                    File d;
                    String name = ((EsaResource)installResource).getProvideFeature();
                    File targetFile = new File(toDir, name + ".esa");
                    if (targetFile.exists()) {
                        if (action == InstallConstants.ExistsAction.ignore) {
                            this.log(Level.FINEST, "Existing file " + name + ".esa is found in the directory " + toDir.getAbsolutePath() + ", the feature is skipped for download.");
                            continue;
                        }
                        if (action == InstallConstants.ExistsAction.replace) {
                            if (targetFile.delete()) {
                                try {
                                    d = InstallUtils.download(installResource, toDir);
                                    downloaded.add(d.getAbsolutePath());
                                    this.log(Level.FINEST, "Downloaded " + installResource.getName() + " to " + d.getAbsolutePath());
                                    continue;
                                }
                                catch (InstallException e) {
                                    throw e;
                                }
                                catch (Exception e) {
                                    throw ExceptionUtils.createByKey(25, e, "ERROR_FAILED_TO_DOWNLOAD_FEATURE", installResource.getName(), toDir.getAbsolutePath());
                                }
                            }
                            throw ExceptionUtils.createByKey(25, "ERROR_FAILED_TO_DOWNLOAD_FEATURE", name, targetFile.getAbsolutePath());
                        }
                        throw new InstallException(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.file.exists", targetFile), 25);
                    }
                    try {
                        d = InstallUtils.download(installResource, toDir);
                        downloaded.add(d.getAbsolutePath());
                        this.log(Level.FINEST, "Downloaded " + installResource.getName() + " to " + d.getAbsolutePath());
                        continue;
                    }
                    catch (InstallException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.createByKey(25, e, "ERROR_FAILED_TO_DOWNLOAD_FEATURE", installResource.getName(), toDir.getAbsolutePath());
                    }
                }
                this.log(Level.FINEST, installResource.getName() + " is an unsupported type " + installResource.getType() + " to be downloaded.");
            }
        }
        return downloaded;
    }

    public Map<String, Collection<String>> downloadAssetsInstallUtility(Set<String> assetsNames, File toDir, InstallConstants.DownloadOption downloadOption, String user, String password, boolean isOverride) throws InstallException {
        this.fireProgressEvent(16, 1, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CHECKING", new Object[0]));
        this.createRepoConfig(toDir, assetsNames);
        if (assetsNames == null || assetsNames.isEmpty()) {
            throw ExceptionUtils.createByKey("ERROR_ASSETS_LIST_INVALID", new Object[0]);
        }
        HashMap<String, Collection<String>> downloaded = new HashMap<String, Collection<String>>();
        RepositoryDownloadUtil.writeResourcesToDiskRepo(downloaded, toDir, this.getResolveDirector().getInstallResources(), this.product.getProductVersion(), this.eventManager, this.getResolveDirector().defaultRepo());
        return downloaded;
    }

    private void createRepoConfig(File toDir, Set<String> featureNames) throws InstallException {
        try {
            File repoConfigFile = new File(toDir, "repository.config");
            if (repoConfigFile.exists()) {
                return;
            }
            FileWriter fileWriter = new FileWriter(repoConfigFile);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("LayoutPolicy=P1\n");
            bufferedWriter.write("LayoutPolicyVersion=0.0.0.1\n");
            bufferedWriter.write("# repository.type=liberty.directory");
            bufferedWriter.close();
        }
        catch (Exception e) {
            this.log(Level.SEVERE, e.getMessage(), e);
            throw ExceptionUtils.createByKey(25, "ERROR_FAILED_TO_DOWNLOAD_FEATURE", featureNames, toDir.getAbsolutePath());
        }
    }

    public Map<String, InstalledFeature> getInstalledCoreFeatures() {
        try {
            TreeMap<String, InstalledFeature> installedFeatures = new TreeMap<String, InstalledFeature>();
            Map<String, ProvisioningFeatureDefinition> fdMap = this.product.getCoreFeatureDefinitions();
            for (Map.Entry<String, ProvisioningFeatureDefinition> entry : fdMap.entrySet()) {
                installedFeatures.put(entry.getKey(), new InstalledAssetImpl(entry.getValue()));
            }
            return installedFeatures;
        }
        catch (FeatureToolException rte) {
            this.log(Level.FINEST, "Director.getInstalledCoreFeatures() got exception.", (Exception)((Object)rte));
            return null;
        }
    }

    public Map<String, InstalledFeatureCollection> getInstalledFeatureCollections() {
        try {
            TreeMap<String, InstalledFeatureCollection> installedFeatureCollections = new TreeMap<String, InstalledFeatureCollection>();
            Map<String, ProvisioningFeatureDefinition> fdMap = this.product.getFeatureCollectionDefinitions();
            for (Map.Entry<String, ProvisioningFeatureDefinition> entry : fdMap.entrySet()) {
                installedFeatureCollections.put(entry.getKey(), new InstalledAssetImpl(entry.getValue()));
            }
            return installedFeatureCollections;
        }
        catch (FeatureToolException rte) {
            this.log(Level.FINEST, "Director.getInstalledFeatureCollections() got exception.", (Exception)((Object)rte));
            return null;
        }
    }

    public void installAssets(Collection<String> assetIds, File fromDir, RepositoryConnectionList loginInfo) throws InstallException {
        this.installAssets = new ArrayList<List<InstallAsset>>();
        ArrayList<InstallAsset> installAssets = new ArrayList<InstallAsset>();
        ArrayList<String> unresolvedFeatures = new ArrayList<String>();
        Collection<ESAAsset> autoFeatures = this.getResolveDirector().getAutoFeature(fromDir, "usr");
        this.getResolveDirector().resolve(assetIds, fromDir, "usr", false, installAssets, unresolvedFeatures);
        if (!unresolvedFeatures.isEmpty()) {
            this.log(Level.FINEST, "installAssets() determined unresolved features: " + unresolvedFeatures.toString() + " from " + fromDir.getAbsolutePath());
            this.installAssets(unresolvedFeatures, loginInfo);
        }
        if (!installAssets.isEmpty()) {
            this.getResolveDirector().resolveAutoFeatures(autoFeatures, installAssets);
            this.installAssets.add(installAssets);
        }
        if (this.installAssets.isEmpty()) {
            throw ExceptionUtils.createByKey(22, "ASSETS_ALREADY_INSTALLED", assetIds.toString());
        }
    }

    public void installAssets(Collection<String> assetIds, RepositoryConnectionList loginInfo) throws InstallException {
        this.fireProgressEvent(16, 1, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CHECKING_ASSETS", new Object[0]));
        if (assetIds == null || assetIds.isEmpty()) {
            throw ExceptionUtils.createByKey("ERROR_ASSETS_LIST_INVALID", new Object[0]);
        }
        RepositoryConnectionList li = loginInfo == null ? this.getResolveDirector().getRepositoryConnectionList(null, null, null, this.getClass().getCanonicalName() + ".installAssets") : loginInfo;
        Map<String, List<List<RepositoryResource>>> installResources = this.getResolveDirector().resolveMap(assetIds, li, false);
        if (this.isEmpty(installResources)) {
            throw ExceptionUtils.createByKey(22, "ASSETS_ALREADY_INSTALLED", InstallUtils.getShortNames(this.product.getFeatureDefinitions(), assetIds).toString());
        }
        this.downloadAssets(installResources, "usr");
    }

    private void downloadAssets(Map<String, List<List<RepositoryResource>>> installResources, String toExtension) throws InstallException {
        if (installResources == null || installResources.isEmpty()) {
            this.installAssets = new ArrayList<List<InstallAsset>>(1);
            return;
        }
        this.installAssets = new ArrayList<List<InstallAsset>>(installResources.size());
        int progress = 10;
        int interval1 = installResources.size() == 0 ? 40 : 40 / installResources.size();
        for (Map.Entry<String, List<List<RepositoryResource>>> targetList : installResources.entrySet()) {
            int interval2 = targetList.getValue().size() == 0 ? interval1 : interval1 / targetList.getValue().size();
            for (List<RepositoryResource> mrList : targetList.getValue()) {
                ArrayList<InstallAsset> iaList = new ArrayList<InstallAsset>(mrList.size());
                this.installAssets.add(iaList);
                int interval3 = mrList.size() == 0 ? interval2 : interval2 / mrList.size();
                for (RepositoryResource installResource : mrList) {
                    if (InstallUtils.isDirectoryBasedRepository(installResource)) {
                        this.fireDownloadProgressEvent(progress, installResource);
                    }
                    progress += interval3;
                    File d = InstallUtils.getFileDirectoryBasedRepository(installResource);
                    if (installResource.getType().equals((Object)ResourceType.FEATURE)) {
                        EsaResource esa = (EsaResource)installResource;
                        String target = targetList.getKey();
                        try {
                            ESAAsset esaAsset;
                            if (d != null) {
                                esaAsset = new ESAAsset(esa.getName(), esa.getProvideFeature(), InstallUtils.toExtension(target, toExtension), d, false);
                                if (esaAsset.getSubsystemEntry() == null) {
                                    throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.content.no.subsystem.manifest", new Object[0]), 23);
                                }
                                ProvisioningFeatureDefinition fd = esaAsset.getProvisioningFeatureDefinition();
                                if (!fd.isSupportedFeatureVersion()) {
                                    throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("UNSUPPORTED_FEATURE_VERSION", fd.getFeatureName(), fd.getIbmFeatureVersion()), 23);
                                }
                            } else {
                                esaAsset = new ESAAsset(esa.getName(), esa.getProvideFeature(), InstallUtils.toExtension(target, toExtension), esa);
                            }
                            iaList.add(esaAsset);
                            continue;
                        }
                        catch (Exception e) {
                            throw ExceptionUtils.createByKey(e, "ERROR_INVALID_ESA", esa.getName());
                        }
                    }
                    if (installResource.getType().equals((Object)ResourceType.IFIX)) {
                        try {
                            if (d != null) {
                                iaList.add(new FixAsset(installResource.getName(), d, false));
                                continue;
                            }
                            iaList.add(new FixAsset(installResource.getName(), (IfixResource)installResource));
                            continue;
                        }
                        catch (Exception e) {
                            throw ExceptionUtils.createByKey(e, "ERROR_INVALID_IFIX", installResource.getName());
                        }
                    }
                    if (installResource.getType().equals((Object)ResourceType.PRODUCTSAMPLE)) {
                        try {
                            if (d != null) {
                                iaList.add(new SampleAsset(installResource.getName(), ((SampleResource)installResource).getShortName(), d, false));
                                continue;
                            }
                            iaList.add(new SampleAsset((SampleResource)installResource));
                            continue;
                        }
                        catch (Exception e) {
                            throw ExceptionUtils.createByKey(e, "ERROR_INVALID_SAMPLE", installResource.getName());
                        }
                    }
                    if (!installResource.getType().equals((Object)ResourceType.OPENSOURCE)) continue;
                    try {
                        if (d != null) {
                            iaList.add(new OpenSourceAsset(installResource.getName(), ((SampleResource)installResource).getShortName(), d, false));
                            continue;
                        }
                        iaList.add(new OpenSourceAsset((SampleResource)installResource));
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.createByKey(e, "ERROR_INVALID_OPENSOURCE", installResource.getName());
                    }
                }
            }
        }
    }

    public void checkResources() throws InstallException {
        this.getResolveDirector().checkResources();
        if (this.installAssets != null) {
            for (List<InstallAsset> iaList : this.installAssets) {
                for (InstallAsset ia : iaList) {
                    this.checkResource(ia);
                }
            }
        }
        long required = this.getResolveDirector().getInstallResourcesMainAttachmentSize();
        String requiredSpace = this.castToPrintableMessage(required);
        this.logger.log(Level.FINEST, "Total required space for installation is " + requiredSpace + " including temporary files.");
        File wlpDir = this.product.getInstallDir();
        long free = wlpDir.getFreeSpace();
        String wlpDirSpace = this.castToPrintableMessage(wlpDir.getFreeSpace());
        this.logger.log(Level.FINEST, "Total available space is " + wlpDirSpace + ".");
        if (free < required) {
            try {
                throw ExceptionUtils.createByKey("ERROR_WLP_DIR_NO_SPACE", wlpDir.getCanonicalPath(), wlpDirSpace, requiredSpace);
            }
            catch (IOException e) {
                throw ExceptionUtils.create(e);
            }
        }
    }

    public String castToPrintableMessage(long number) {
        long i = number / 0x100000L;
        if (i > 0L) {
            return String.valueOf(i) + " MB";
        }
        long l = number / 1024L;
        return String.valueOf(l) + " KB";
    }

    private void checkResource(InstallAsset installAsset) throws InstallException {
        File serverDir;
        JarAsset ja;
        String serverName;
        if ((installAsset.isSample() || installAsset.isOpenSource()) && (serverName = (ja = (JarAsset)installAsset).getShortName()) != null && (serverDir = new File(Utils.getUserDir(), "servers/" + serverName)).exists()) {
            String msgId = installAsset.isSample() ? "ERROR_SAMPLE_SERVER_ALREADY_INSTALLED" : "ERROR_OPENSOURCE_SERVER_ALREADY_INSTALLED";
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(msgId, ja.toString(), serverName));
        }
    }

    public int getInstallResourcesSize() {
        return this.getResolveDirector().getInstallResourcesSize();
    }

    public int getLocalInstallAssetsSize() {
        return this.getResolveDirector().getLocalInstallAssetsSize();
    }

    public int getPublicInstallResourcesSize() {
        return this.getResolveDirector().getPublicInstallResourcesSize();
    }

    public int getPublicLocalInstallAssetsSize() {
        return this.getResolveDirector().getPublicLocalInstallAssetsSize();
    }

    public Map<String, Collection<String>> getInstalledAssetNames() {
        if (this.installAssets == null) {
            return null;
        }
        HashMap<String, Collection<String>> installed = new HashMap<String, Collection<String>>();
        ArrayList<String> installedAddons = new ArrayList<String>();
        ArrayList<String> installedFeatures = new ArrayList<String>();
        ArrayList<String> installedFixes = new ArrayList<String>();
        ArrayList<String> installedSamples = new ArrayList<String>();
        ArrayList<String> installedOpenSources = new ArrayList<String>();
        for (List<InstallAsset> iaList : this.installAssets) {
            for (InstallAsset asset : iaList) {
                if (asset.isFeature()) {
                    ESAAsset esa = (ESAAsset)asset;
                    if (!esa.isPublic()) continue;
                    String esaName = esa.getShortName();
                    if (esaName == null || esaName.isEmpty()) {
                        esaName = esa.getFeatureName();
                    }
                    if (esa.isAddon()) {
                        installedAddons.add(esaName);
                        continue;
                    }
                    installedFeatures.add(esaName);
                    continue;
                }
                if (asset.isFix()) {
                    installedFixes.add(asset.toString());
                    continue;
                }
                if (asset.isSample()) {
                    installedSamples.add(asset.toString());
                    continue;
                }
                if (!asset.isOpenSource()) continue;
                installedOpenSources.add(asset.toString());
            }
        }
        installed.put("addon", installedAddons);
        installed.put("feature", installedFeatures);
        installed.put("ifix", installedFixes);
        installed.put("sample", installedSamples);
        installed.put("opensource", installedOpenSources);
        return installed;
    }

    public Set<InstallLicense> getFeatureLicense(Locale locale) throws InstallException {
        HashMap<String, InstallLicenseImpl> licenseIds = new HashMap<String, InstallLicenseImpl>();
        this.getFeatureLicenseFromInstallAssets(locale, licenseIds, this.getResolveDirector().getLocalInstallAssets());
        this.getFeatureLicenseFromInstallResources(locale, licenseIds, this.getResolveDirector().getInstallResources());
        HashSet<InstallLicense> licenses = new HashSet<InstallLicense>();
        licenses.addAll(licenseIds.values());
        return licenses;
    }

    private void getFeatureLicenseFromInstallAssets(Locale locale, Map<String, InstallLicenseImpl> licenseIds, List<InstallAsset> installAssets) {
        if (installAssets == null) {
            return;
        }
        for (InstallAsset installAsset : installAssets) {
            if (!installAsset.isFeature()) continue;
            ESAAsset esa = (ESAAsset)installAsset;
            if (esa.isPublic()) {
                ExeInstallAction.incrementNumOfLocalFeatures();
            }
            LicenseProvider lp = esa.getLicenseProvider(locale);
            String licenseId = esa.getLicenseId();
            if (licenseId == null || licenseId.isEmpty()) continue;
            InstallLicenseImpl ili = licenseIds.get(licenseId);
            if (ili == null) {
                ili = new InstallLicenseImpl(licenseId, null, lp);
                licenseIds.put(licenseId, ili);
            }
            ili.addFeature(esa.getProvideFeature());
        }
    }

    public Collection<String> getSampleLicense(Locale locale) throws InstallException {
        ArrayList<String> licenses = new ArrayList<String>();
        for (List<List<RepositoryResource>> targetList : this.getResolveDirector().getInstallResources().values()) {
            for (List<RepositoryResource> mrList : targetList) {
                for (RepositoryResource mr : mrList) {
                    ResourceType type = mr.getType();
                    if (!type.equals((Object)ResourceType.PRODUCTSAMPLE) && !type.equals((Object)ResourceType.OPENSOURCE)) continue;
                    try {
                        AttachmentResource lar = mr.getLicenseAgreement(locale);
                        if (lar == null) continue;
                        licenses.add(InstallLicenseImpl.getLicense(lar));
                    }
                    catch (RepositoryException e) {
                        throw ExceptionUtils.createByKey((Exception)((Object)e), "ERROR_FAILED_TO_GET_ASSET_LICENSE", mr.getName());
                    }
                }
            }
        }
        return licenses;
    }

    public Collection<String> getSamplesOrOpenSources() {
        ArrayList<String> samplesOrOpenSources = new ArrayList<String>();
        Map<String, List<List<RepositoryResource>>> installResources = this.getResolveDirector().getInstallResources();
        if (installResources != null) {
            for (List<List<RepositoryResource>> targetList : installResources.values()) {
                for (List<RepositoryResource> mrList : targetList) {
                    for (RepositoryResource mr : mrList) {
                        ResourceType type = mr.getType();
                        if (!type.equals((Object)ResourceType.PRODUCTSAMPLE) && !type.equals((Object)ResourceType.OPENSOURCE)) continue;
                        samplesOrOpenSources.add(InstallUtils.getResourceId(mr));
                    }
                }
            }
        }
        return samplesOrOpenSources;
    }

    public void downloadAssets(String toExtension) throws InstallException {
        this.downloadAssets(this.getResolveDirector().getInstallResources(), toExtension);
        if (this.getResolveDirector().getLocalInstallAssetsSize() > 0) {
            this.installAssets.add(this.getResolveDirector().getLocalInstallAssets());
        }
    }

    public void setFirePublicAssetOnly(boolean firePublicAssetOnly) {
        this.firePublicAssetOnly = firePublicAssetOnly;
    }

    public RepositoryConnectionList getRepositoryConnectionList() throws InstallException {
        return this.getResolveDirector().getRepositoryConnectionList(null, null, null, this.getClass().getCanonicalName());
    }

    public void setProxy(RestRepositoryConnectionProxy proxy) {
        this.getResolveDirector().setProxy(proxy);
    }

    private ResolveDirector getResolveDirector() {
        if (this.resolveDirector == null) {
            this.resolveDirector = new ResolveDirector(this.product, this.eventManager, this.logger);
        }
        return this.resolveDirector;
    }

    public void resolve(Collection<String> assetIds, boolean download) throws InstallException {
        this.getResolveDirector().resolve(assetIds, download);
    }

    public void resolve(String feature, File esaFile, String toExtension) throws InstallException {
        this.getResolveDirector().resolve(feature, esaFile, toExtension);
    }

    public boolean resolveExistingAssetsFromDirectoryRepo(Collection<String> featureNames, File repoDir, boolean isOverwrite) throws InstallException {
        return this.getResolveDirector().resolveExistingAssetsFromDirectoryRepo(featureNames, repoDir, isOverwrite);
    }

    private UninstallDirector getUninstallDirector() {
        if (this.uninstallDirector == null) {
            this.uninstallDirector = new UninstallDirector(this.product, this.engine, this.eventManager, this.logger);
        }
        return this.uninstallDirector;
    }

    public void uninstall(Collection<String> ids, boolean force) throws InstallException {
        this.getUninstallDirector().uninstall(ids, force);
    }

    public void uninstallFeatures(Collection<String> featureNames, Collection<String> uninstallInstallFeatures) {
        this.getUninstallDirector().uninstallFeatures(featureNames, uninstallInstallFeatures, false);
    }

    public void uninstallFix(String fixId) throws InstallException {
        this.getUninstallDirector().uninstallFix(fixId);
    }

    public void uninstallFix(Collection<String> fixNames) throws InstallException {
        this.getUninstallDirector().uninstallFix(fixNames);
    }

    public void uninstall(boolean checkDependency, String productId, Collection<File> toBeDeleted) throws InstallException {
        String[] productIds = new String[]{productId};
        this.uninstall(checkDependency, productIds, toBeDeleted);
    }

    public void uninstall(boolean checkDependency, String[] productIds, Collection<File> toBeDeleted) throws InstallException {
        this.getUninstallDirector().uninstall(checkDependency, productIds, toBeDeleted);
    }

    public void uninstallFeaturesPrereqChecking(Collection<String> featureNames, boolean allowUninstallAll, boolean force) throws InstallException {
        this.getUninstallDirector().uninstallFeaturesPrereqChecking(featureNames, allowUninstallAll, force);
    }

    public void uninstallFeaturesByProductId(String productId, boolean exceptPlatformFeatures) throws InstallException {
        String[] productIds = new String[]{productId};
        this.uninstallFeaturesByProductId(productIds, exceptPlatformFeatures);
    }

    public void uninstallFeaturesByProductId(String[] productIds, boolean exceptPlatformFeatures) throws InstallException {
        this.getUninstallDirector().uninstallFeaturesByProductId(productIds, exceptPlatformFeatures);
    }

    public void checkAssetsNotInstalled(Collection<String> assetIds) throws InstallException {
        this.getResolveDirector().checkAssetsNotInstalled(assetIds);
    }
}

