/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

final class SibRaStringGenerator {
    private final StringBuffer _buffer = new StringBuffer("[");
    private boolean _completed = false;

    SibRaStringGenerator(Object object) {
        this.addObjectIdentity(object);
    }

    void addParent(String name, Object value) throws IllegalStateException {
        this.checkNotCompleted();
        this._buffer.append(" <");
        this._buffer.append(name);
        this._buffer.append("=");
        this.addObjectIdentity(value);
        this._buffer.append(">");
    }

    void addField(String name, Object value) throws IllegalStateException {
        this.checkNotCompleted();
        this._buffer.append(" <");
        this._buffer.append(name);
        this._buffer.append("=");
        this._buffer.append(value);
        this._buffer.append(">");
    }

    void addField(String name, boolean value) throws IllegalStateException {
        this.addField(name, Boolean.toString(value));
    }

    void addPasswordField(String name, String value) throws IllegalStateException {
        this.addField(name, value == null ? null : "*****");
    }

    void addField(String name, long value) throws IllegalStateException {
        this.addField(name, Long.toString(value));
    }

    String getStringRepresentation() {
        this._completed = true;
        this._buffer.append("]");
        return this._buffer.toString();
    }

    private void checkNotCompleted() throws IllegalStateException {
        if (this._completed) {
            throw new IllegalStateException();
        }
    }

    private void addObjectIdentity(Object object) {
        if (object == null) {
            this._buffer.append("null");
        } else {
            this._buffer.append(object.getClass().getName());
            this._buffer.append("@");
            this._buffer.append(Integer.toHexString(System.identityHashCode(object)));
        }
    }
}

