/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.transactions.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.ExternalXAResource;
import com.ibm.ws.sib.msgstore.transactions.impl.MSAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.MSDelegatingLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.MSDelegatingLocalTransactionSynchronization;
import com.ibm.ws.sib.msgstore.transactions.impl.MSDelegatingXAResource;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistenceManager;
import com.ibm.ws.sib.transactions.TransactionFactory;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class MSTransactionFactory
implements TransactionFactory {
    private static TraceComponent tc = SibTr.register(MSTransactionFactory.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private int _maximumSize = 100;
    private MessageStoreImpl _ms;
    private PersistenceManager _persistence;
    private boolean _persistenceSupports1PCOptimisation;

    public MSTransactionFactory(MessageStoreImpl ms, PersistenceManager persistence) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MSTransactionFactory", (Object)("MessageStore=" + (Object)((Object)ms) + ", Persistence=" + persistence));
        }
        this._ms = ms;
        this._persistence = persistence;
        this._persistenceSupports1PCOptimisation = this._persistence.supports1PCOptimisation();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MSTransactionFactory");
        }
    }

    public ExternalAutoCommitTransaction createAutoCommitTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createAutoCommitTransaction");
        }
        MSAutoCommitTransaction instance = new MSAutoCommitTransaction(this._ms, this._persistence, this.getMaximumTransactionSize());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createAutoCommitTransaction", (Object)("return=" + instance));
        }
        return instance;
    }

    public ExternalLocalTransaction createLocalTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createLocalTransaction");
        }
        MSDelegatingLocalTransaction instance = this._persistenceSupports1PCOptimisation ? new MSDelegatingLocalTransactionSynchronization(this._ms, this._persistence, this.getMaximumTransactionSize()) : new MSDelegatingLocalTransaction(this._ms, this._persistence, this.getMaximumTransactionSize());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createLocalTransaction", (Object)("return=" + instance));
        }
        return instance;
    }

    public ExternalXAResource createXAResource() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createXAResource");
        }
        MSDelegatingXAResource instance = new MSDelegatingXAResource(this._ms, this._persistence, this.getMaximumTransactionSize());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createXAResource", (Object)("return=" + instance));
        }
        return instance;
    }

    public final int getMaximumTransactionSize() {
        return this._maximumSize;
    }

    public final void setMaximumTransactionSize(int maximumSize) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMaximumTransactionSize", (Object)("MaximumTranSize=" + maximumSize));
        }
        this._maximumSize = maximumSize;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMaximumTransactionSize");
        }
    }
}

