/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udpchannel.internal;

import com.ibm.websphere.channelfw.ChannelFactoryData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.channelfw.exception.ChannelFactoryException;
import java.util.Map;

public class UDPChannelFactoryConfiguration {
    private static final TraceComponent tc = Tr.register(UDPChannelFactoryConfiguration.class, (String)"UDPChannel", (String)"com.ibm.ws.udpchannel.internal.resources.UDPMessages");
    private ChannelFactoryData myConfig = null;
    private boolean uniqueWorkerThreads = true;

    public UDPChannelFactoryConfiguration(ChannelFactoryData config) throws ChannelFactoryException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"UDPChannelFactoryConfiguration", (Object[])new Object[0]);
        }
        this.myConfig = config;
        this.setValues();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"UDPChannelFactoryConfiguration");
        }
    }

    private void setValues() throws ChannelFactoryException {
        for (Map.Entry<Object, Object> entry : this.myConfig.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            try {
                if (!key.equalsIgnoreCase("uniqueWorkerThreads")) continue;
                this.setUniqueWorkerThreads(Boolean.parseBoolean((String)entry.getValue()));
            }
            catch (Exception x) {
                ChannelFactoryException e = new ChannelFactoryException("UDP Channel Factory Caught an Exception processing property:  name: " + key + " value: " + entry.getValue(), x);
                throw e;
            }
        }
    }

    public Map<Object, Object> getProperties() {
        return this.myConfig.getProperties();
    }

    public boolean isUniqueWorkerThreads() {
        return this.uniqueWorkerThreads;
    }

    public void setUniqueWorkerThreads(boolean flag) {
        this.uniqueWorkerThreads = flag;
    }
}

