/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.ws.tcpchannel.internal.FilterList;
import com.ibm.wsspi.tcpchannel.TCPConfigConstants;

public class ValidateUtils
implements TCPConfigConstants {
    protected static final int VALIDATE_OK = 0;
    protected static final int VALIDATE_ERROR = 1;
    protected static final int VALIDATE_NOT_EQUAL = 2;
    protected static final int LINGER_MIN = -1;
    protected static final int LINGER_MAX = 3600;
    protected static final int ACCEPT_THREAD_MIN = 0;
    protected static final int ACCEPT_THREAD_MAX = 1;
    protected static final int NEW_BUFF_SIZE_MIN = 32;
    protected static final int NEW_BUFF_SIZE_MAX = 65536;
    protected static final int LISTEN_BACKLOG_MIN = 0;
    protected static final int LISTEN_BACKLOG_MAX = 512;
    protected static final int KEYS_PER_SELECTOR_MIN = 1;
    protected static final int KEYS_PER_SELECTOR_MAX = 20000;
    protected static final int CHANNEL_SELECTOR_IDLE_TIMEOUT_MIN = 0;
    protected static final int CHANNEL_SELECTOR_IDLE_TIMEOUT_MAX = 3600000;
    protected static final int PORT_OPEN_RETRIES_MIN = 0;
    protected static final int PORT_OPEN_RETRIES_MAX = 100000;
    protected static final int CHANNEL_SELECTOR_WAIT_TO_TERMINATE_MIN = 0;
    protected static final int CHANNEL_SELECTOR_WAIT_TO_TERMINATE_MAX = 3600;
    protected static final int NUMBER_NONBLOCKING_ACCEPT_THREADS_MIN = 1;
    protected static final int NUMBER_NONBLOCKING_ACCEPT_THREADS_MAX = 100;
    protected static final int SELECTOR_WAKEUP_OPTION_MIN = 1;
    protected static final int SELECTOR_WAKEUP_OPTION_MAX = 3;
    protected static final int SELECTOR_WAKEUP_WHEN_NEEDED = 1;
    protected static final int SELECTOR_WAKEUP_NEVER = 2;
    protected static final int SELECTOR_WAKEUP_IF_NO_FORCE_QUEUE = 3;
    protected static final int MIN_SELECTOR_THREADS = 1;
    protected static final int MAX_SELECTOR_THREADS = 1000;
    protected static final int MIN_CONNECTION_THRESHOLD = 1;
    protected static final int MAX_CONNECTION_THRESHOLD = 5000;
    protected static final int INACTIVITY_TIMEOUT_NO_TIMEOUT = 0;
    protected static final int MIN_INBOUND_READ_SELECTORS_TO_START = 1;
    protected static final int MAX_INBOUND_READ_SELECTORS_TO_START = 1000;
    protected static final int KEY_TYPE_INT = 0;
    protected static final int KEY_TYPE_STRING = 1;
    protected static final int KEY_TYPE_BOOLEAN = 2;
    protected static final int KEY_TYPE_ACCESS_LIST = 3;
    protected static final int KEY_OBJECT = 4;
    protected static final int COMM_OPTION_MIN = 0;
    protected static final int COMM_OPTION_MAX = 1;
    protected static final int DUMP_STATS_INTERVAL_MIN = 0;
    protected static final int DUMP_STATS_INTERVAL_MAX = 3600;

    public static int testInt(int value, int min, int max) {
        if (value < min || value > max) {
            return 1;
        }
        return 0;
    }

    public static int testLong(long value, long min, long max) {
        if (value < min || value > max) {
            return 1;
        }
        return 0;
    }

    public static int testStringAsInt(String value, int min, int max) {
        int number;
        try {
            number = Integer.parseInt(value);
        }
        catch (NumberFormatException x) {
            return 1;
        }
        if (number < min || number > max) {
            return 1;
        }
        return 0;
    }

    public static int testPort(int value) {
        return ValidateUtils.testInt(value, 0, 65535);
    }

    public static int testMaxConnections(int value) {
        return ValidateUtils.testInt(value, 1, 1280000);
    }

    public static int testMaxConnections(String value) {
        return ValidateUtils.testStringAsInt(value, 1, 1280000);
    }

    public static int testLinger(int value) {
        return ValidateUtils.testInt(value, -1, 3600);
    }

    public static int testLinger(String value) {
        return ValidateUtils.testStringAsInt(value, -1, 3600);
    }

    public static int testAcceptThread(int value) {
        return ValidateUtils.testInt(value, 0, 1);
    }

    public static int testAcceptThread(String value) {
        return ValidateUtils.testStringAsInt(value, 0, 1);
    }

    public static int testNewBuffSize(int value) {
        return ValidateUtils.testInt(value, 32, 65536);
    }

    public static int testPortOpenRetries(int value) {
        return ValidateUtils.testInt(value, 0, 100000);
    }

    public static int testNewBuffSize(String value) {
        return ValidateUtils.testStringAsInt(value, 32, 65536);
    }

    public static int testListenBacklog(int value) {
        return ValidateUtils.testInt(value, 0, 512);
    }

    public static int testListenBacklog(String value) {
        return ValidateUtils.testStringAsInt(value, 0, 512);
    }

    public static int testReceiveBufferSize(int value) {
        return ValidateUtils.testInt(value, 4, 0x1000000);
    }

    public static int testReceiveBufferSize(String value) {
        return ValidateUtils.testStringAsInt(value, 4, 0x1000000);
    }

    public static int testSendBufferSize(int value) {
        return ValidateUtils.testInt(value, 4, 0x1000000);
    }

    public static int testSendBufferSize(String value) {
        return ValidateUtils.testStringAsInt(value, 4, 0x1000000);
    }

    public static int testInactivityTimeout(long value) {
        return ValidateUtils.testLong(value, 0L, 3600000L);
    }

    public static int testKeysPerSelector(int value) {
        return ValidateUtils.testInt(value, 1, 20000);
    }

    public static int testKeysPerSelector(String value) {
        return ValidateUtils.testStringAsInt(value, 1, 20000);
    }

    public static int testChannelSelectorIdleTimeout(long value) {
        return ValidateUtils.testLong(value, 0L, 3600000L);
    }

    public static int testChannelSelectorIdleTimeout(String value) {
        return ValidateUtils.testStringAsInt(value, 0, 3600000);
    }

    public static int testChannelSelectorWaitToTerminate(long value) {
        return ValidateUtils.testLong(value, 0L, 3600L);
    }

    public static int testChannelSelectorWaitToTerminate(String value) {
        return ValidateUtils.testStringAsInt(value, 0, 3600);
    }

    public static int testChannelSelectorWakeupOption(int value) {
        return ValidateUtils.testInt(value, 1, 3);
    }

    public static int testChannelSelectorWakeupOption(String value) {
        return ValidateUtils.testStringAsInt(value, 1, 3);
    }

    public static int testMaxSelectorThreads(int value) {
        return ValidateUtils.testInt(value, 1, 1000);
    }

    public static int testMaxSelectorThreads(String value) {
        return ValidateUtils.testStringAsInt(value, 1, 1000);
    }

    public static int testConnectionThreshold(int value) {
        return ValidateUtils.testInt(value, 1, 5000);
    }

    public static int testConnectionThreshold(String value) {
        return ValidateUtils.testStringAsInt(value, 1, 5000);
    }

    public static int testInboundReadSelectorsToStart(int value) {
        return ValidateUtils.testInt(value, 1, 1000);
    }

    public static int testInboundReadSelectorsToStart(String value) {
        return ValidateUtils.testStringAsInt(value, 1, 1000);
    }

    public static int testAuditLevel(String value) {
        if (value.equalsIgnoreCase("INFO")) {
            return 0;
        }
        if (value.equalsIgnoreCase("FINE")) {
            return 0;
        }
        return 1;
    }

    public static int testCommOption(int value) {
        return ValidateUtils.testInt(value, 0, 1);
    }

    public static int testCommOption(String value) {
        return ValidateUtils.testStringAsInt(value, 0, 1);
    }

    public static int testDumpStatsInterval(int value) {
        return ValidateUtils.testInt(value, 0, 3600);
    }

    public static int testDumpStatsInterval(String value) {
        return ValidateUtils.testStringAsInt(value, 0, 3600);
    }

    public static int testIsStringIPAddressesValid(String[] value) {
        FilterList f = new FilterList();
        try {
            if (value != null) {
                f.buildData(value, true);
            }
        }
        catch (NumberFormatException x) {
            return 1;
        }
        return 0;
    }
}

