/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.util.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.channels.Channels;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class UtilImpl_FileUtils {
    private static final String CLASS_NAME = "UtilImpl_FileUtils";
    private static final Logger logger = Logger.getLogger("com.ibm.ws.annocache.util");
    public static final File[] EMPTY_FILES = new File[0];
    public static final String[] EMPTY_FILE_NAMES = new String[0];
    public static final boolean DO_APPEND = true;
    public static final boolean DO_NOT_APPEND = false;
    static final long serialVersionUID = 1232048903113089887L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UtilImpl_FileUtils() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isFile(final File target) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "isFile", new Object[]{target});
        }
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = -5250406574544052491L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return target.isFile();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$1", 1.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        boolean bl = result;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "isFile", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isDirectory(final File target) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "isDirectory", new Object[]{target});
        }
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = -5218554276244796596L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return target.isDirectory();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$2", 2.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        boolean bl = result;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "isDirectory", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean exists(final File target) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "exists", new Object[]{target});
        }
        Boolean exists = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 1345152825197557204L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return target.exists();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$3", 3.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        boolean bl = exists;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "exists", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static File validateDir(final File dir) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "validateDir", new Object[]{dir});
        }
        File file = AccessController.doPrivileged(new PrivilegedAction<File>(){
            static final long serialVersionUID = -1854597904082756384L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public File run() {
                if (!dir.exists()) {
                    throw new IllegalArgumentException("Target location [ " + dir.getPath() + " ] does not exist.");
                }
                if (!dir.isDirectory()) {
                    throw new IllegalArgumentException("Target location [ " + dir.getPath() + " ] is not a directory.");
                }
                return dir;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$4", 4.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        if (logger != null && logger.isLoggable(Level.FINER)) {
            file = file;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "validateDir", file);
        }
        return file;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getAbsolutePath(final File target) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "getAbsolutePath", new Object[]{target});
        }
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 1277234863571275784L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return target.getAbsolutePath();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$5", 5.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "getAbsolutePath", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getCanonicalPath(final File target) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "getCanonicalPath", new Object[]{target});
        }
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -3310518127373196455L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                try {
                    return target.getCanonicalPath();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$6", (String)"104", (Object)this, (Object[])new Object[0]);
                    return target.getAbsolutePath();
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$6", 6.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "getCanonicalPath", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static File[] listFiles(final File target) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "listFiles", new Object[]{target});
        }
        File[] fileArray = AccessController.doPrivileged(new PrivilegedAction<File[]>(){
            static final long serialVersionUID = 7975845652122117248L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public File[] run() {
                File[] fileList = target.listFiles();
                return fileList == null ? EMPTY_FILES : fileList;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$7", 7.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        if (logger != null && logger.isLoggable(Level.FINER)) {
            fileArray = fileArray;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "listFiles", fileArray);
        }
        return fileArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static File[] listFiles(final File target, final FilenameFilter filter) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "listFiles", new Object[]{target, filter});
        }
        File[] fileArray = AccessController.doPrivileged(new PrivilegedAction<File[]>(){
            static final long serialVersionUID = -273249927241333962L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public File[] run() {
                File[] fileList = target.listFiles(filter);
                return fileList == null ? EMPTY_FILES : fileList;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$8", 8.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        if (logger != null && logger.isLoggable(Level.FINER)) {
            fileArray = fileArray;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "listFiles", fileArray);
        }
        return fileArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String[] list(final File target) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "list", new Object[]{target});
        }
        String[] stringArray = AccessController.doPrivileged(new PrivilegedAction<String[]>(){
            static final long serialVersionUID = -1142801020654185376L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String[] run() {
                String[] fileNames = target.list();
                return fileNames == null ? EMPTY_FILE_NAMES : fileNames;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$9", 9.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stringArray = stringArray;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "list", stringArray);
        }
        return stringArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String[] list(final File target, final FilenameFilter filter) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "list", new Object[]{target, filter});
        }
        String[] stringArray = AccessController.doPrivileged(new PrivilegedAction<String[]>(){
            static final long serialVersionUID = -6754692796895598109L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String[] run() {
                String[] fileNames = target.list(filter);
                return fileNames == null ? EMPTY_FILE_NAMES : fileNames;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$10", 10.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stringArray = stringArray;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "list", stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static FileOutputStream createFileOutputStream(final File target) throws IOException {
        FileOutputStream fileOutputStream;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "createFileOutputStream", new Object[]{target});
            }
            try {
                fileOutputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){
                    static final long serialVersionUID = -6967645142452994553L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public FileOutputStream run() throws IOException {
                        return new FileOutputStream(target);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$11", 11.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                    }
                });
                if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", (String)"166", null, (Object[])new Object[]{target});
                Exception innerException = e.getException();
                if (innerException instanceof IOException) {
                    throw (IOException)innerException;
                }
                if (innerException instanceof RuntimeException) {
                    throw (RuntimeException)innerException;
                }
                throw new UndeclaredThrowableException((Throwable)e);
            }
            fileOutputStream = fileOutputStream;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "createFileOutputStream", fileOutputStream);
        }
        return fileOutputStream;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static OutputStream createOverwriteOutputStream(final File target) throws IOException {
        OutputStream outputStream;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "createOverwriteOutputStream", new Object[]{target});
            }
            try {
                outputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){
                    static final long serialVersionUID = 7586889926411757365L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public OutputStream run() throws IOException {
                        RandomAccessFile randomAccessFile = new RandomAccessFile(target, "rw");
                        return Channels.newOutputStream(randomAccessFile.getChannel());
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$12", 12.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                    }
                });
                if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", (String)"188", null, (Object[])new Object[]{target});
                Exception innerException = e.getException();
                if (innerException instanceof IOException) {
                    throw (IOException)innerException;
                }
                if (innerException instanceof RuntimeException) {
                    throw (RuntimeException)innerException;
                }
                throw new UndeclaredThrowableException((Throwable)e);
            }
            outputStream = outputStream;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "createOverwriteOutputStream", outputStream);
        }
        return outputStream;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static FileOutputStream createFileOutputStream(final File target, final boolean append) throws IOException {
        FileOutputStream fileOutputStream;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "createFileOutputStream", new Object[]{target, append});
            }
            try {
                fileOutputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){
                    static final long serialVersionUID = 5038309163788971027L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public FileOutputStream run() throws IOException {
                        return new FileOutputStream(target, append);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$13", 13.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                    }
                });
                if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", (String)"211", null, (Object[])new Object[]{target, append});
                Exception innerException = e.getException();
                if (innerException instanceof IOException) {
                    throw (IOException)innerException;
                }
                if (innerException instanceof RuntimeException) {
                    throw (RuntimeException)innerException;
                }
                throw new UndeclaredThrowableException((Throwable)e);
            }
            fileOutputStream = fileOutputStream;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "createFileOutputStream", fileOutputStream);
        }
        return fileOutputStream;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static FileInputStream createFileInputStream(final File target) throws IOException {
        FileInputStream fileInputStream;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "createFileInputStream", new Object[]{target});
            }
            try {
                fileInputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){
                    static final long serialVersionUID = -2620522860227400131L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public FileInputStream run() throws IOException {
                        return new FileInputStream(target);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$14", 14.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                    }
                });
                if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", (String)"231", null, (Object[])new Object[]{target});
                Exception innerException = e.getException();
                if (innerException instanceof IOException) {
                    throw (IOException)innerException;
                }
                if (innerException instanceof RuntimeException) {
                    throw (RuntimeException)innerException;
                }
                throw new UndeclaredThrowableException((Throwable)e);
            }
            fileInputStream = fileInputStream;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "createFileInputStream", fileInputStream);
        }
        return fileInputStream;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static RandomAccessFile createRandomInputFile(final File target) throws IOException {
        RandomAccessFile randomAccessFile;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "createRandomInputFile", new Object[]{target});
            }
            try {
                randomAccessFile = AccessController.doPrivileged(new PrivilegedExceptionAction<RandomAccessFile>(){
                    static final long serialVersionUID = 6157478799544798148L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public RandomAccessFile run() throws IOException {
                        return new RandomAccessFile(target, "r");
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$15", 15.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                    }
                });
                if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", (String)"251", null, (Object[])new Object[]{target});
                Exception innerException = e.getException();
                if (innerException instanceof IOException) {
                    throw (IOException)innerException;
                }
                if (innerException instanceof RuntimeException) {
                    throw (RuntimeException)innerException;
                }
                throw new UndeclaredThrowableException((Throwable)e);
            }
            randomAccessFile = randomAccessFile;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "createRandomInputFile", randomAccessFile);
        }
        return randomAccessFile;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static JarFile createJarFile(final String jarPath) throws IOException {
        JarFile jarFile;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "createJarFile", new Object[]{jarPath});
            }
            try {
                jarFile = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){
                    static final long serialVersionUID = -7189362367244380897L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public JarFile run() throws IOException {
                        return new JarFile(jarPath);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$16", 16.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                    }
                });
                if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", (String)"271", null, (Object[])new Object[]{jarPath});
                Exception innerException = e.getException();
                if (innerException instanceof IOException) {
                    throw (IOException)innerException;
                }
                if (innerException instanceof RuntimeException) {
                    throw (RuntimeException)innerException;
                }
                throw new UndeclaredThrowableException((Throwable)e);
            }
            jarFile = jarFile;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "createJarFile", jarFile);
        }
        return jarFile;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean mkdirs(final File file) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "mkdirs", new Object[]{file});
        }
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = -8892085063328925370L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return file.mkdirs();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$17", 17.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        boolean bl = result;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "mkdirs", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean ensureDir(final Logger useLogger, final File file) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "ensureDir", new Object[]{useLogger, file});
        }
        Boolean existsAsDir = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = -2879415182109315086L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return UtilImpl_FileUtils.unprotectedEnsureDir(useLogger, file);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$18", 18.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        boolean bl = existsAsDir;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "ensureDir", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean unprotectedEnsureDir(Logger useLogger, File file) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "unprotectedEnsureDir", new Object[]{useLogger, file});
        }
        String methodName = "unprotectedEnsureDir";
        if (file.exists()) {
            if (!file.isDirectory()) {
                if (useLogger != null) {
                    useLogger.logp(Level.WARNING, CLASS_NAME, methodName, "Target [ {0} ] already exists as a simple file", file.getPath());
                } else {
                    System.out.println("Target [ " + file.getPath() + " ] already exists as a simple file");
                }
                boolean bl = false;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "unprotectedEnsureDir", bl);
                }
                return bl;
            }
            if (useLogger != null && useLogger.isLoggable(Level.FINER)) {
                useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Target [ {0} ] already exists as directory", file.getPath());
            }
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "unprotectedEnsureDir", bl);
            }
            return bl;
        }
        boolean didMake = file.mkdirs();
        if (!file.exists()) {
            if (useLogger != null) {
                useLogger.logp(Level.WARNING, CLASS_NAME, methodName, "Target [ {0} ] could not be created", file.getPath());
            } else {
                System.out.println("Target [ " + file.getPath() + " ] could not be created");
            }
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "unprotectedEnsureDir", bl);
            }
            return bl;
        }
        if (!file.isDirectory()) {
            if (useLogger != null) {
                useLogger.logp(Level.WARNING, CLASS_NAME, methodName, "Target [ {0} ] was created, but is not a directory", file.getPath());
            } else {
                System.out.println("Target [ " + file.getPath() + " ] was created, but is not a directory");
            }
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "unprotectedEnsureDir", bl);
            }
            return bl;
        }
        if (useLogger != null && useLogger.isLoggable(Level.FINER)) {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Target [ {0} ] was created as a directory", file.getPath());
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "unprotectedEnsureDir", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean remove(final Logger useLogger, final File file) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "remove", new Object[]{useLogger, file});
        }
        String methodName = "remove";
        final Logger innerLogger = useLogger;
        Boolean failedRemoval = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 3550379239788802460L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                String innerMethodName = "remove.run";
                boolean didDelete = file.delete();
                if (file.exists()) {
                    if (useLogger != null) {
                        innerLogger.logp(Level.WARNING, UtilImpl_FileUtils.CLASS_NAME, "remove.run", "Failed to delete [ {0} ]", file.getPath());
                    } else {
                        System.out.println("Failed to delete [ " + file.getPath() + " ]");
                    }
                    return Boolean.TRUE;
                }
                if (innerLogger != null && innerLogger.isLoggable(Level.FINER)) {
                    innerLogger.logp(Level.FINER, UtilImpl_FileUtils.CLASS_NAME, "remove.run", "Deleted [ {0} ]", file.getPath());
                }
                return Boolean.FALSE;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$19", 19.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        boolean bl = failedRemoval;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "remove", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static int removeAll(final Logger useLogger, final File file) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "removeAll", new Object[]{useLogger, file});
        }
        Integer failedRemovals = AccessController.doPrivileged(new PrivilegedAction<Integer>(){
            static final long serialVersionUID = -4379911783736070146L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Integer run() {
                return UtilImpl_FileUtils.unprotectedRemoveAll(useLogger, file);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils$20", 20.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        int n = failedRemovals;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "removeAll", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static int unprotectedRemoveAll(Logger useLogger, File file) {
        File[] childFiles;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "unprotectedRemoveAll", new Object[]{useLogger, file});
        }
        String methodName = "unprotectedRemoveAll";
        int failedRemovals = 0;
        if (file.isDirectory() && (childFiles = file.listFiles()) != null) {
            for (File childFile : childFiles) {
                failedRemovals += UtilImpl_FileUtils.unprotectedRemoveAll(useLogger, childFile);
            }
        }
        file.delete();
        if (file.exists()) {
            ++failedRemovals;
            if (useLogger != null) {
                useLogger.logp(Level.WARNING, CLASS_NAME, methodName, "Failed to delete [ {0} ]", file.getPath());
            } else {
                System.out.println("Failed to delete [ " + file.getPath() + " ]");
            }
        } else if (useLogger != null && useLogger.isLoggable(Level.FINER)) {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Deleted [ {0} ]", file.getPath());
        }
        int n = failedRemovals;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils", "unprotectedRemoveAll", n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static byte[] readFully(File file) throws IOException {
        long rawFileLength = file.length();
        if (rawFileLength > Integer.MAX_VALUE) {
            throw new IOException("File length [ " + rawFileLength + " ] greater than [ " + Integer.MAX_VALUE + " ] for [ " + file.getAbsolutePath() + " ]");
        }
        int bufferFill = (int)rawFileLength;
        byte[] buffer = new byte[bufferFill];
        try (FileInputStream inputStream = new FileInputStream(file);){
            int bytesRead = ((InputStream)inputStream).read(buffer);
            if (bytesRead != bufferFill) {
                throw new IOException("Incomplete read [ " + file.getAbsolutePath() + " ] expected [ " + bufferFill + " ] but read [ " + bytesRead + " ]");
            }
        }
        return buffer;
    }
}

