/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.annocache.targets.internal.AnnotationTargetsImpl_Factory;
import com.ibm.ws.annocache.targets.internal.AnnotationTargetsImpl_Targets;
import com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableClassesMultiImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableImpl;
import com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl;
import com.ibm.ws.annocache.util.internal.UtilImpl_IdentityStringSet;
import com.ibm.ws.annocache.util.internal.UtilImpl_InternMap;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.util.Util_InternMap;
import com.ibm.wsspi.annocache.classsource.ClassSource;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.classsource.ClassSource_Options;
import com.ibm.wsspi.annocache.targets.AnnotationTargets_Exception;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TargetsScannerBaseImpl {
    private static final TraceComponent tc = Tr.register(TargetsScannerBaseImpl.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    public static final String CLASS_NAME = TargetsScannerBaseImpl.class.getSimpleName();
    protected final String hashText;
    protected final AnnotationTargetsImpl_Targets targets;
    protected final AnnotationTargetsImpl_Factory factory;
    protected final UtilImpl_InternMap classNameInternMap;
    protected final UtilImpl_InternMap fieldNameInternMap;
    protected final UtilImpl_InternMap methodSignatureInternMap;
    protected final ClassSource_Aggregate rootClassSource;
    protected final Map<String, TargetsTableImpl> targetsTables;
    protected TargetsTableClassesMultiImpl classTable;
    protected final int[] policyCounts;
    protected final TargetsTableImpl[] resultTables;
    protected boolean FORCE_SEED_RESULTS = true;
    static final long serialVersionUID = 8205740927415790202L;

    private static String nlsFormat(String msgKey, Object ... msgParms) {
        return Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])msgParms);
    }

    @Trivial
    public String getHashText() {
        return this.hashText;
    }

    public TargetsScannerBaseImpl(AnnotationTargetsImpl_Targets targets, ClassSource_Aggregate rootClassSource) {
        String methodName = "<init>";
        this.hashText = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        if (targets == null) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ": " + this.hashText + " created with null targets");
        }
        if (rootClassSource == null) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ": " + this.hashText + " created with null class source");
        }
        this.targets = targets;
        this.factory = targets.getFactory();
        this.classNameInternMap = targets.getClassNameInternMap();
        this.fieldNameInternMap = targets.getFieldNameInternMap();
        this.methodSignatureInternMap = targets.getMethodSignatureInternMap();
        this.rootClassSource = rootClassSource;
        this.policyCounts = this.createPolicyCounts(rootClassSource);
        this.targetsTables = new HashMap<String, TargetsTableImpl>();
        this.resultTables = this.createResultTables();
        this.classTable = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] on [ {1} ]", new Object[]{this.hashText, rootClassSource.getHashText()});
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] for [ {1} ]", new Object[]{this.hashText, targets.getHashText()});
        }
    }

    @Trivial
    public AnnotationTargetsImpl_Targets getTargets() {
        return this.targets;
    }

    @Trivial
    public AnnotationTargetsImpl_Factory getFactory() {
        return this.factory;
    }

    @Trivial
    public UtilImpl_InternMap getClassNameInternMap() {
        return this.classNameInternMap;
    }

    @Trivial
    public UtilImpl_InternMap getFieldNameInternMap() {
        return this.fieldNameInternMap;
    }

    @Trivial
    public UtilImpl_InternMap getMethodSignatureInternMap() {
        return this.methodSignatureInternMap;
    }

    public UtilImpl_IdentityStringSet createIdentityStringSet() {
        return this.getFactory().getUtilFactory().createIdentityStringSet();
    }

    public Set<String> createIdentityStringSet(int size) {
        return this.getFactory().getUtilFactory().createIdentityStringSet(size);
    }

    public Set<String> createIdentityStringSet(Set<String> initialElements) {
        return this.getFactory().getUtilFactory().createIdentityStringSet(initialElements);
    }

    public UtilImpl_InternMap createInternMap(Util_InternMap.ValueType valueType, String mapName) {
        return this.getFactory().getUtilFactory().createInternMap(valueType, mapName);
    }

    protected TargetsTableImpl createResultTargetsTable(ClassSource_Aggregate.ScanPolicy scanPolicy) {
        TargetsTableImpl resultTable = new TargetsTableImpl(this.getFactory(), this.getClassNameInternMap(), this.getFieldNameInternMap(), this.getMethodSignatureInternMap(), scanPolicy.name(), false);
        resultTable.setStamp("** UNRECORDED **");
        return resultTable;
    }

    protected TargetsTableImpl createTargetsTable(ClassSource classSource) {
        TargetsTableImpl targetsTable = new TargetsTableImpl(this.getFactory(), this.getClassNameInternMap(), this.getFieldNameInternMap(), this.getMethodSignatureInternMap(), classSource.getCanonicalName(), this.getUseJandexFormat());
        targetsTable.setStamp(classSource.getStamp());
        return targetsTable;
    }

    public TargetsTableClassesMultiImpl createClassTable() {
        return new TargetsTableClassesMultiImpl(this.getFactory().getUtilFactory(), this.getClassNameInternMap());
    }

    protected TargetsTableContainersImpl createContainerTable() {
        return new TargetsTableContainersImpl(this.getFactory());
    }

    protected TargetsTableContainersImpl createContainerTable(ClassSource_Aggregate classSource) {
        TargetsTableContainersImpl useContainerTable = this.createContainerTable();
        useContainerTable.addNames(classSource);
        return useContainerTable;
    }

    public String internClassName(String className) {
        return this.getClassNameInternMap().intern(className);
    }

    public String internClassName(String className, boolean doForce) {
        return this.getClassNameInternMap().intern(className, doForce);
    }

    public Set<String> internClassNames(Set<String> uninternedClassNames) {
        Set<String> internedClassNames = this.createIdentityStringSet(uninternedClassNames.size());
        for (String uninternedClassName : uninternedClassNames) {
            internedClassNames.add(this.internClassName(uninternedClassName));
        }
        return internedClassNames;
    }

    @Trivial
    public ClassSource_Aggregate getRootClassSource() {
        return this.rootClassSource;
    }

    public ClassSource_Options getScanOptions() {
        return this.getRootClassSource().getOptions();
    }

    public int getScanThreads() {
        return this.getScanOptions().getScanThreads();
    }

    public boolean isScanSingleThreaded() {
        int useScanThreads = this.getScanThreads();
        return useScanThreads == 0 || useScanThreads == 1;
    }

    public boolean isScanSingleSource() {
        return this.rootClassSource.getInternalSourceCount() <= 1;
    }

    public boolean getUseJandex() {
        return this.getScanOptions().getUseJandex();
    }

    public boolean getUseJandexFormat() {
        return false;
    }

    protected void displayCoverage() {
        String methodName = "displayCoverage";
        ClassSource_Aggregate useRootClassSource = this.getRootClassSource();
        String appName = useRootClassSource.getApplicationName();
        String modName = useRootClassSource.getModuleName();
        int sourceCount = 0;
        int jandexSourceCount = 0;
        int cacheSourceCount = 0;
        int classCount = 0;
        int jandexClassCount = 0;
        int cacheClassCount = 0;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Coverage for module {0} in application {1}:", new Object[]{modName, appName});
        }
        for (ClassSource classSource : useRootClassSource.getClassSources()) {
            String scanType;
            ClassSource_Aggregate.ScanPolicy nextScanPolicy = useRootClassSource.getScanPolicy(classSource);
            if (nextScanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) continue;
            ++sourceCount;
            int nextClassCount = classSource.getProcessCount();
            classCount += nextClassCount;
            if (classSource.isProcessedUsingJandex()) {
                scanType = "jandex";
                ++jandexSourceCount;
                jandexClassCount += nextClassCount;
            } else if (classSource.isReadFromCache()) {
                scanType = "cache";
                ++cacheSourceCount;
                cacheClassCount += nextClassCount;
            } else {
                scanType = "scan";
            }
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Location {0}: Classes {1}: Scan type {2}", new Object[]{classSource.getCanonicalName(), nextClassCount, scanType});
        }
        if (this.getUseJandex()) {
            String coverageMsg = TargetsScannerBaseImpl.nlsFormat("ANNOCACHE_JANDEX_USAGE", appName, modName, sourceCount, jandexSourceCount, classCount, jandexClassCount);
            logger.logp(Level.INFO, CLASS_NAME, methodName, coverageMsg);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Cache coverage for module {0} in application {1}: {2} of {3} module locations were read from cache; {4} of {5} module classes were read from cache.", new Object[]{modName, appName, cacheSourceCount, sourceCount, cacheClassCount, classCount});
        }
    }

    @Trivial
    public TargetsTableImpl scanInternal(ClassSource classSource, Set<String> i_useResolvedClassNames, Set<String> i_useUnresolvedClassNames) {
        TargetsTableImpl useTargetsTable = this.createTargetsTable(classSource);
        this.scanInternal(classSource, i_useResolvedClassNames, i_useUnresolvedClassNames, useTargetsTable);
        return useTargetsTable;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public void scanInternal(ClassSource classSource, Set<String> i_useResolvedClassNames, Set<String> i_useUnresolvedClassNames, TargetsTableImpl targetsTable) {
        Object[] logParms;
        String methodName = "scanInternal";
        if (logger.isLoggable(Level.FINER)) {
            logParms = new Object[]{this.getHashText(), classSource.getCanonicalName()};
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class source [ {1} ]", logParms);
            if (i_useResolvedClassNames != null) {
                logParms[1] = i_useResolvedClassNames.size();
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Initial resolved [ {1} ]", logParms);
            }
            if (i_useUnresolvedClassNames != null) {
                logParms[1] = i_useUnresolvedClassNames.size();
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Initial unresolved [ {1} ]", logParms);
            }
        } else {
            logParms = null;
        }
        try {
            targetsTable.scanInternal(classSource, TargetsVisitorClassImpl.DONT_RECORD_NEW_RESOLVED, i_useResolvedClassNames, TargetsVisitorClassImpl.DONT_RECORD_NEW_UNRESOLVED, i_useUnresolvedClassNames, TargetsVisitorClassImpl.SELECT_ALL_ANNOTATIONS);
        }
        catch (AnnotationTargets_Exception annotationTargets_Exception) {
            void e;
            FFDCFilter.processException((Throwable)annotationTargets_Exception, (String)"com.ibm.ws.annocache.targets.internal.TargetsScannerBaseImpl", (String)"472", (Object)this, (Object[])new Object[]{classSource, i_useResolvedClassNames, i_useUnresolvedClassNames, targetsTable});
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_TARGETS_SCAN_EXCEPTION [ {1} ]", new Object[]{this.getHashText(), e});
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "Scan error", (Throwable)e);
        }
        if (logParms != null) {
            if (i_useResolvedClassNames != null) {
                logParms[1] = i_useResolvedClassNames.size();
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Final resolved [ {1} ]", logParms);
            }
            if (i_useUnresolvedClassNames != null) {
                logParms[1] = i_useUnresolvedClassNames.size();
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Final unresolved [ {1} ]", logParms);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public TargetsTableImpl scanExternal(ClassSource classSource, Set<String> i_useResolvedClassNames, Set<String> i_useUnresolvedClassNames) {
        Object[] logParms;
        String methodName = "scanExternal";
        if (logger.isLoggable(Level.FINER)) {
            logParms = new Object[]{this.getHashText(), classSource.getCanonicalName()};
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class source [ {1} ]", logParms);
            if (i_useResolvedClassNames != null) {
                logParms[1] = i_useResolvedClassNames.size();
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Initial resolved [ {1} ]", logParms);
            }
            if (i_useUnresolvedClassNames != null) {
                logParms[1] = i_useUnresolvedClassNames.size();
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Initial unresolved [ {1} ]", logParms);
            }
        } else {
            logParms = null;
        }
        TargetsTableImpl targetsTable = this.createTargetsTable(classSource);
        try {
            targetsTable.scanExternal(classSource, i_useResolvedClassNames, i_useUnresolvedClassNames);
        }
        catch (AnnotationTargets_Exception annotationTargets_Exception) {
            void e;
            FFDCFilter.processException((Throwable)annotationTargets_Exception, (String)"com.ibm.ws.annocache.targets.internal.TargetsScannerBaseImpl", (String)"520", (Object)this, (Object[])new Object[]{classSource, i_useResolvedClassNames, i_useUnresolvedClassNames});
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_TARGETS_SCAN_EXCEPTION [ {1} ]", new Object[]{this.getHashText(), e});
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "Scan error", (Throwable)e);
        }
        if (logParms != null) {
            if (i_useResolvedClassNames != null) {
                logParms[1] = i_useResolvedClassNames.size();
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Final resolved [ {1} ]", logParms);
            }
            if (i_useUnresolvedClassNames != null) {
                logParms[1] = i_useUnresolvedClassNames.size();
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Final unresolved [ {1} ]", logParms);
            }
        }
        return targetsTable;
    }

    @Trivial
    public Map<String, TargetsTableImpl> getTargetsTables() {
        return this.targetsTables;
    }

    public TargetsTableImpl getTargetsTable(String classSourceName) {
        return this.getTargetsTables().get(classSourceName);
    }

    public void putTargetsTable(String classSourceName, TargetsTableImpl targetsTable) {
        this.getTargetsTables().put(classSourceName, targetsTable);
    }

    public TargetsTableImpl getTargetsTable(ClassSource classSource) {
        return this.getTargetsTables().get(classSource.getCanonicalName());
    }

    public void putTargetsTable(ClassSource classSource, TargetsTableImpl targetsTable) {
        this.getTargetsTables().put(classSource.getCanonicalName(), targetsTable);
    }

    public void setClassTable(TargetsTableClassesMultiImpl classTable) {
        this.classTable = classTable;
    }

    public TargetsTableClassesMultiImpl getClassTable() {
        return this.classTable;
    }

    protected int[] createPolicyCounts(ClassSource_Aggregate useRootClassSource) {
        int[] usePolicyCounts = new int[ClassSource_Aggregate.ScanPolicy.values().length];
        for (ClassSource classSource : useRootClassSource.getClassSources()) {
            ClassSource_Aggregate.ScanPolicy scanPolicy = useRootClassSource.getScanPolicy(classSource);
            int n = scanPolicy.ordinal();
            usePolicyCounts[n] = usePolicyCounts[n] + 1;
        }
        return usePolicyCounts;
    }

    public int getPolicyCount(ClassSource_Aggregate.ScanPolicy scanPolicy) {
        return this.policyCounts[scanPolicy.ordinal()];
    }

    public TargetsTableImpl[] createResultTables() {
        return new TargetsTableImpl[ClassSource_Aggregate.ScanPolicy.values().length];
    }

    public void putResultTables(TargetsTableImpl[] useResultTables) {
        for (ClassSource_Aggregate.ScanPolicy scanPolicy : ClassSource_Aggregate.ScanPolicy.values()) {
            this.resultTables[scanPolicy.ordinal()] = useResultTables[scanPolicy.ordinal()];
        }
    }

    public void putExternalResults(TargetsTableImpl externalResults) {
        this.resultTables[ClassSource_Aggregate.ScanPolicy.EXTERNAL.ordinal()] = externalResults;
    }

    public TargetsTableImpl[] getResultTables() {
        return this.resultTables;
    }

    public TargetsTableImpl getResultTable(ClassSource_Aggregate.ScanPolicy scanPolicy) {
        return this.resultTables[scanPolicy.ordinal()];
    }

    public TargetsTableImpl getSeedTable() {
        return this.getResultTable(ClassSource_Aggregate.ScanPolicy.SEED);
    }

    public TargetsTableImpl getPartialTable() {
        return this.getResultTable(ClassSource_Aggregate.ScanPolicy.PARTIAL);
    }

    public TargetsTableImpl getExcludedTable() {
        return this.getResultTable(ClassSource_Aggregate.ScanPolicy.EXCLUDED);
    }

    public TargetsTableImpl getExternalTable() {
        return this.getResultTable(ClassSource_Aggregate.ScanPolicy.EXTERNAL);
    }

    protected void mergeInternalResults(TargetsTableImpl[] useResultTables, boolean forceSeedResults) {
        UtilImpl_IdentityStringSet i_addedPackageNames = this.createIdentityStringSet();
        UtilImpl_IdentityStringSet i_addedClassNames = this.createIdentityStringSet();
        ClassSource_Aggregate useRootClassSource = this.getRootClassSource();
        for (ClassSource classSource : useRootClassSource.getClassSources()) {
            TargetsTableImpl targetsTable;
            ClassSource_Aggregate.ScanPolicy scanPolicy = useRootClassSource.getScanPolicy(classSource);
            if (forceSeedResults) {
                scanPolicy = ClassSource_Aggregate.ScanPolicy.SEED;
            }
            if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL || (targetsTable = this.getTargetsTable(classSource)) == null) continue;
            TargetsTableImpl resultTable = useResultTables[scanPolicy.ordinal()];
            if (resultTable == null) {
                TargetsTableImpl targetsTableImpl = this.createResultTargetsTable(scanPolicy);
                useResultTables[scanPolicy.ordinal()] = targetsTableImpl;
                resultTable = targetsTableImpl;
            }
            resultTable.restrictedAdd(targetsTable, i_addedPackageNames, i_addedClassNames);
        }
        for (ClassSource_Aggregate.ScanPolicy scanPolicy : ClassSource_Aggregate.ScanPolicy.values()) {
            if (useResultTables[scanPolicy.ordinal()] != null) continue;
            useResultTables[scanPolicy.ordinal()] = this.createResultTargetsTable(scanPolicy);
        }
    }

    public void mergeClasses(TargetsTableClassesMultiImpl useClassTable) {
        String methodName = "mergeClasses";
        UtilImpl_IdentityStringSet i_addedPackageNames = this.createIdentityStringSet();
        UtilImpl_IdentityStringSet i_addedClassNames = this.createIdentityStringSet();
        for (ClassSource classSource : this.getRootClassSource().getClassSources()) {
            TargetsTableImpl targetsTable;
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] on [ {1} ]", new Object[]{this.hashText, classSource.getHashText()});
            }
            if ((targetsTable = this.getTargetsTable(classSource)) == null) {
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] on [ {1} ]: Null Data", new Object[]{this.hashText, classSource.getHashText()});
                continue;
            }
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] on [ {1} ]: Merging", new Object[]{this.hashText, classSource.getHashText()});
            TargetsTableClassesImpl targetsClassData = targetsTable.getClassTable();
            UtilImpl_IdentityStringSet i_newlyAddedPackageNames = this.createIdentityStringSet();
            UtilImpl_IdentityStringSet i_newlyAddedClassNames = this.createIdentityStringSet();
            useClassTable.restrictedAdd(targetsClassData, i_newlyAddedPackageNames, i_addedPackageNames, i_newlyAddedClassNames, i_addedClassNames);
        }
    }

    public void mergeClasses(TargetsTableClassesMultiImpl useClassTable, TargetsTableImpl targetsTable) {
        UtilImpl_IdentityStringSet i_addedPackageNames = this.createIdentityStringSet();
        UtilImpl_IdentityStringSet i_addedClassNames = this.createIdentityStringSet();
        UtilImpl_IdentityStringSet i_newlyAddedPackageNames = this.createIdentityStringSet();
        UtilImpl_IdentityStringSet i_newlyAddedClassNames = this.createIdentityStringSet();
        TargetsTableClassesImpl targetsClassData = targetsTable.getClassTable();
        useClassTable.restrictedAdd(targetsClassData, i_newlyAddedPackageNames, i_addedPackageNames, i_newlyAddedClassNames, i_addedClassNames);
    }
}

