/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.info.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.info.internal.InfoImpl;
import com.ibm.ws.annocache.info.internal.InfoStoreImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.info.PackageInfo;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class PackageInfoImpl
extends InfoImpl
implements PackageInfo {
    private static final Logger logger = Logger.getLogger("com.ibm.ws.annocache.info");
    private static final String CLASS_NAME = PackageInfoImpl.class.getSimpleName();
    public static final String PACKAGE_INFO_CLASS_NAME = "package-info";
    protected boolean isArtificial;
    protected boolean forFailedLoad;
    static final long serialVersionUID = 2752204806689003701L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isPackageName(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "isPackageName", new Object[]{className});
        }
        boolean bl = className.endsWith(PACKAGE_INFO_CLASS_NAME);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "isPackageName", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String stripPackageNameFromClassName(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "stripPackageNameFromClassName", new Object[]{className});
        }
        String string = className.substring(0, className.length() - (PACKAGE_INFO_CLASS_NAME.length() + 1));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "stripPackageNameFromClassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String addClassNameToPackageName(String packageName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "addClassNameToPackageName", new Object[]{packageName});
        }
        String string = packageName + "." + PACKAGE_INFO_CLASS_NAME;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "addClassNameToPackageName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String getHashSuffix(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "getHashSuffix", new Object[]{name});
        }
        String string = name;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "getHashSuffix", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PackageInfoImpl(String name, int modifiers, InfoStoreImpl infoStore) {
        super(name, modifiers, infoStore, PackageInfoImpl.getHashSuffix(name));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "<init>", new Object[]{name, modifiers, infoStore});
        }
        String methodName = "<init>";
        this.isArtificial = false;
        this.forFailedLoad = false;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Created [ {0} ]", this.getHashText());
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String internName(String packageName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "internName", new Object[]{packageName});
        }
        String string = this.getInfoStore().internPackageName(packageName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "internName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getQualifiedName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "getQualifiedName", new Object[0]);
        }
        String string = this.getName();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "getQualifiedName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(Logger useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "log", new Object[]{useLogger});
        }
        String methodName = "log";
        if (!useLogger.isLoggable(Level.FINER)) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "log");
            }
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, " Package [ {0} ]", this.getHashText());
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  isArtifical [ {0} ]", this.getIsArtificial());
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  forFailedLoad [ {0} ]", this.getForFailedLoad());
        this.logAnnotations(useLogger);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "log");
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(TraceComponent tc) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format(" Package [ {0} ]", this.getHashText()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("  isArtifical [ {0} ]", this.getIsArtificial()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("  forFailedLoad [ {0} ]", this.getForFailedLoad()), (Object[])new Object[0]);
            this.logAnnotations(tc);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean getIsArtificial() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "getIsArtificial", new Object[0]);
        }
        boolean bl = this.isArtificial;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "getIsArtificial", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setIsArtificial(boolean isArtificial) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "setIsArtificial", new Object[]{isArtificial});
        }
        this.isArtificial = isArtificial;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "setIsArtificial");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean getForFailedLoad() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "getForFailedLoad", new Object[0]);
        }
        boolean bl = this.forFailedLoad;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "getForFailedLoad", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setForFailedLoad(boolean forFailedLoad) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "setForFailedLoad", new Object[]{forFailedLoad});
        }
        this.forFailedLoad = forFailedLoad;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.PackageInfoImpl", "setForFailedLoad");
        }
    }
}

