/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.config;

import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.ws.security.common.jwk.impl.JWKSet;
import com.ibm.ws.security.jwt.config.ConsumerUtils;
import java.util.List;

public interface JwtConsumerConfig {
    public String getId();

    public String getIssuer();

    @Sensitive
    public String getSharedKey();

    public List<String> getAudiences();

    public boolean ignoreAudClaimIfNotConfigured();

    public String getSignatureAlgorithm();

    public String getTrustStoreRef();

    public String getKeyStoreRef();

    public String getTrustedAlias();

    public long getClockSkew();

    public boolean getJwkEnabled();

    public String getJwkEndpointUrl();

    public ConsumerUtils getConsumerUtils();

    public boolean isValidationRequired();

    public boolean isHostNameVerificationEnabled();

    public String getSslRef();

    public JWKSet getJwkSet();

    public boolean getTokenReuse();

    public boolean getUseSystemPropertiesForHttpClientConnections();

    public List<String> getAMRClaim();

    public String getKeyManagementKeyAlias();
}

