/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.http.welcome.page;

import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.transport.http.welcome.page.WelcomeRequirementImpl;
import com.ibm.wsspi.http.WelcomePage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collection;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={WelcomePage.class}, property={"service.vendor=IBM", "service.ranking:Integer=100"})
public class WebSphereWelcomePage
implements WelcomePage {
    private Bundle bundle;
    private Bundle systemBundle;
    private String version;
    private String kind = "ga";
    private static final String KC_URL_GA = "https://www.ibm.com/support/knowledgecenter/SSAW57_liberty/com.ibm.websphere.wlp.nd.multiplatform.doc/ae/cwlp_about.html";
    private static final String KC_URL_BETA = "https://www.ibm.com/support/knowledgecenter/was_beta/com.ibm.websphere.wlp.nd.multiplatform.doc/ae/cwlp_about.html";
    private String kcUrl = "https://www.ibm.com/support/knowledgecenter/SSAW57_liberty/com.ibm.websphere.wlp.nd.multiplatform.doc/ae/cwlp_about.html";
    private BundleContext bundleContext;

    @Activate
    protected void activate(BundleContext context) {
        this.bundleContext = context;
        this.bundle = context.getBundle();
        if (this.bundleContext != null) {
            this.systemBundle = this.bundleContext.getBundle("System Bundle");
        }
        try {
            int index;
            ProductInfo info = (ProductInfo)ProductInfo.getAllProductInfo().get("com.ibm.websphere.appserver");
            if (info != null) {
                this.version = info.getVersion();
            }
            if (this.version != null && (index = this.version.indexOf(".")) > 2) {
                this.kind = "beta";
                this.kcUrl = KC_URL_BETA;
            }
        }
        catch (DuplicateProductInfoException | ProductInfoParseException | ProductInfoReplaceException throwable) {
            // empty catch block
        }
    }

    public InputStream openWelcomePage(String url) {
        if ("/".equals(url)) {
            url = "/index.html";
        }
        if ("/version.js".equals(url)) {
            StringBuilder versionJs = new StringBuilder();
            versionJs.append("var current = {\r\n");
            versionJs.append(" version: \"");
            if (this.version != null) {
                versionJs.append(this.version);
            }
            versionJs.append("\"\r\n");
            versionJs.append("}");
            return this.getInputStream(versionJs.toString());
        }
        if ("/index.html".equals(url)) {
            InputStream in = this.safeOpen("/OSGI-INF/welcome/index.html");
            if (in != null) {
                InputStream inputStream;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                try {
                    String line;
                    StringBuilder builder = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        builder.append(line.replace("{VERSION}", this.version).replace("{KIND}", this.kind).replace("{KC_URL}", this.kcUrl));
                        builder.append("\r\n");
                    }
                    inputStream = this.getInputStream(builder.toString());
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                }
                reader.close();
                return inputStream;
            }
        } else {
            return this.safeOpen("/OSGI-INF/welcome" + url);
        }
        return null;
    }

    public InputStream openNotFoundPage() {
        return this.safeOpen("/OSGI-INF/notFound/index.html");
    }

    private InputStream getInputStream(String text) {
        try {
            return new ByteArrayInputStream(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private InputStream openUrl(URL url) {
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private InputStream safeOpen(String file) {
        if (!file.endsWith("/OSGI-INF/welcome/js/externalize-string.js")) {
            URL url = this.bundle.getEntry(file);
            return this.openUrl(url);
        }
        if (this.systemBundle != null) {
            FrameworkWiring fw = (FrameworkWiring)this.systemBundle.adapt(FrameworkWiring.class);
            Collection caps = fw.findProviders((Requirement)new WelcomeRequirementImpl());
            if (!caps.isEmpty()) {
                BundleCapability bc = (BundleCapability)caps.iterator().next();
                Bundle b = bc.getRevision().getBundle();
                URL url = b.getEntry(file);
                return this.openUrl(url);
            }
            throw new IllegalStateException("Open liberty welcome bundle can not be located from its capability");
        }
        return null;
    }
}

