/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Map;
import org.apache.yoko.rmi.impl.ArrayDescriptor;
import org.apache.yoko.rmi.impl.CopyRecursionException;
import org.apache.yoko.rmi.impl.CopyRecursionResolver;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

class ValueArrayDescriptor
extends ArrayDescriptor<Object[]> {
    ValueArrayDescriptor(Class type, Class elemType, TypeRepository rep) {
        super(type, elemType, rep);
    }

    @Override
    public void writeValue(org.omg.CORBA.portable.OutputStream out, Serializable value) {
        Object[] arr = (Object[])value;
        out.write_long(arr.length);
        Serializable[] sarr = (Serializable[])arr;
        OutputStream _out = (OutputStream)out;
        for (int i = 0; i < sarr.length; ++i) {
            _out.write_value(sarr[i], this.getElementRepositoryID());
        }
    }

    @Override
    public Serializable readValue(org.omg.CORBA.portable.InputStream in, Map<Integer, Serializable> offsetMap, Integer key) {
        Object[] arr = (Object[])this.createArray(in, offsetMap, key);
        InputStream _in = (InputStream)in;
        for (int i = 0; i < arr.length; ++i) {
            try {
                arr[i] = _in.read_value(this.elementType);
                continue;
            }
            catch (IndirectionException ex) {
                arr[i] = offsetMap.get(new Integer(ex.offset));
            }
        }
        return arr;
    }

    @Override
    Object copyObject(Object value, CopyState state) {
        Object[] orig = (Object[])value;
        final Object[] result = (Object[])Array.newInstance(value.getClass().getComponentType(), orig.length);
        state.put(value, result);
        for (int i = 0; i < orig.length; ++i) {
            try {
                result[i] = state.copy(orig[i]);
                continue;
            }
            catch (CopyRecursionException e) {
                final int idx = i;
                state.registerRecursion(new CopyRecursionResolver(orig[i]){

                    @Override
                    public void resolve(Object value) {
                        result[idx] = value;
                    }
                });
            }
        }
        return result;
    }

    @Override
    void printFields(PrintWriter pw, Map recurse, Object val) {
        Object[] arr = (Object[])val;
        TypeDescriptor desc = this.repo.getDescriptor(this.elementType);
        pw.print("length=" + arr.length + "; ");
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                pw.print(", ");
            }
            desc.print(pw, recurse, arr[i]);
        }
    }
}

