/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.server.RMIClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.UtilDelegate;
import javax.rmi.CORBA.ValueHandler;
import javax.rmi.PortableRemoteObject;
import org.apache.yoko.osgi.ProviderLocator;
import org.apache.yoko.rmi.impl.CopyRecursionException;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.PortableRemoteObjectImpl;
import org.apache.yoko.rmi.impl.RMIState;
import org.apache.yoko.rmi.impl.RMIStub;
import org.apache.yoko.rmi.impl.RemoteDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.ValueHandlerImpl;
import org.apache.yoko.rmi.util.GetSystemPropertyAction;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class UtilImpl
implements UtilDelegate {
    private static final Logger logger = Logger.getLogger(UtilImpl.class.getName());
    private static final SecMan _secman = UtilImpl.getSecMan();
    private static final ClassLoader BEST_GUESS_AT_EXTENSION_CLASS_LOADER;
    static boolean copy_with_corba;
    static final java.lang.Object READ_SERIALIZABLE_KEY;

    private static ClassLoader findFirstNonNullLoader(String ... classNames) {
        for (String className : classNames) {
            try {
                Class<?> c = Class.forName(className);
                ClassLoader cl = UtilImpl.getClassLoader(c);
                if (cl == null) continue;
                return cl;
            }
            catch (Exception | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public RemoteException mapSystemException(SystemException theException) {
        SystemException ex = theException;
        if (ex instanceof UnknownException) {
            Throwable orig = ((UnknownException)((java.lang.Object)ex)).originalEx;
            if (orig instanceof Error) {
                return new ServerError("Error occurred in server thread", (Error)orig);
            }
            if (orig instanceof RemoteException) {
                return new ServerException("RemoteException occurred in server thread", (Exception)orig);
            }
            if (orig instanceof RuntimeException) {
                throw (RuntimeException)orig;
            }
        }
        Class<?> exclass = ((java.lang.Object)((java.lang.Object)ex)).getClass();
        String name = exclass.getName();
        StringBuffer buf = new StringBuffer("CORBA ");
        String prefix = "org.omg.CORBA";
        if (name.startsWith("org.omg.CORBA")) {
            buf.append(name.substring("org.omg.CORBA".length() + 1));
        } else {
            buf.append(name);
        }
        buf.append(" ");
        buf.append(ex.minor);
        switch (ex.completed.value()) {
            case 0: {
                buf.append(" Yes");
                break;
            }
            case 1: {
                buf.append(" No");
                break;
            }
            case 2: {
                buf.append(" Maybe");
            }
        }
        String exceptionMessage = buf.toString();
        return this.createRemoteException(ex, exceptionMessage);
    }

    private RemoteException createRemoteException(SystemException sysEx, String s) {
        RemoteException result;
        try {
            throw sysEx;
        }
        catch (BAD_PARAM | COMM_FAILURE | MARSHAL e) {
            result = new MarshalException(s);
        }
        catch (INV_OBJREF | NO_IMPLEMENT | OBJECT_NOT_EXIST e) {
            result = new NoSuchObjectException(s);
        }
        catch (NO_PERMISSION e) {
            result = new AccessException(s);
        }
        catch (TRANSACTION_REQUIRED e) {
            result = UtilImpl.createRemoteException("javax.transaction.TransactionRequiredException", s);
        }
        catch (TRANSACTION_ROLLEDBACK e) {
            result = UtilImpl.createRemoteException("javax.transaction.TransactionRolledbackException", s);
        }
        catch (INVALID_TRANSACTION e) {
            result = UtilImpl.createRemoteException("javax.transaction.InvalidTransactionException", s);
        }
        catch (SystemException catchAll) {
            result = new RemoteException(s);
        }
        result.detail = sysEx;
        return result;
    }

    private static RemoteException createRemoteException(String className, String s) {
        RemoteException result;
        try {
            Class clazz = Util.loadClass((String)className, null, null);
            Constructor ctor = clazz.getConstructor(String.class);
            result = (RemoteException)ctor.newInstance(s);
        }
        catch (Throwable t) {
            result = new RemoteException(s);
            result.addSuppressed(t);
        }
        return result;
    }

    static SystemException mapRemoteException(RemoteException rex) {
        if (rex.detail instanceof SystemException) {
            return (SystemException)rex.detail;
        }
        if (rex.detail instanceof RemoteException) {
            rex = (RemoteException)rex.detail;
        }
        Throwable sysEx = rex instanceof NoSuchObjectException ? new INV_OBJREF(rex.getMessage()) : (rex instanceof AccessException ? new NO_PERMISSION(rex.getMessage()) : (rex instanceof MarshalException ? new MARSHAL(rex.getMessage()) : UtilImpl.createSystemException(rex)));
        sysEx.initCause((Throwable)rex);
        throw sysEx;
    }

    private static SystemException createSystemException(RemoteException rex) {
        return UtilImpl.createSystemException(rex, rex.getClass());
    }

    private static SystemException createSystemException(RemoteException rex, Class<?> fromClass) {
        switch (fromClass.getName()) {
            case "java.lang.Object": 
            case "java.lang.Throwable": 
            case "java.lang.Exception": 
            case "java.lang.RuntimeException": 
            case "java.lang.Error": 
            case "java.io.IOException": 
            case "java.rmi.RemoteException": {
                return new UnknownException((Throwable)rex);
            }
            case "javax.transaction.InvalidTransactionException": {
                return new INVALID_TRANSACTION(rex.getMessage());
            }
            case "javax.transaction.TransactionRolledbackException": {
                return new TRANSACTION_ROLLEDBACK(rex.getMessage());
            }
            case "javax.transaction.TransactionRequiredException": {
                return new TRANSACTION_REQUIRED(rex.getMessage());
            }
        }
        return UtilImpl.createSystemException(rex, fromClass.getSuperclass());
    }

    public void writeAny(org.omg.CORBA.portable.OutputStream out, java.lang.Object obj) throws SystemException {
        ORB orb = ORB.init();
        Any any = orb.create_any();
        if (obj == null) {
            any.insert_Value(null);
        } else if (obj instanceof String) {
            any.insert_Value((Serializable)((java.lang.Object)((String)obj)));
        } else if (obj instanceof Object) {
            any.insert_Object((Object)obj);
        } else if (obj instanceof Any) {
            any.insert_any((Any)obj);
        } else if (obj instanceof IDLEntity) {
            any.insert_Value((Serializable)obj);
        } else if (obj instanceof Remote) {
            Object corba_obj;
            Remote ro = (Remote)obj;
            try {
                corba_obj = (Object)PortableRemoteObject.toStub((Remote)ro);
            }
            catch (NoSuchObjectException ex) {
                throw (MARSHAL)new MARSHAL("object not exported " + ro).initCause((Throwable)ex);
            }
            any.insert_Object(corba_obj);
        } else if (obj instanceof Serializable || obj instanceof Externalizable) {
            any.insert_Value((Serializable)obj);
        } else {
            throw new MARSHAL("cannot write as " + obj.getClass() + " to an Any");
        }
        out.write_any(any);
    }

    public java.lang.Object readAny(org.omg.CORBA.portable.InputStream in) throws SystemException {
        Any any = in.read_any();
        TypeCode typecode = any.type();
        switch (typecode.kind().value()) {
            case 0: 
            case 1: {
                return null;
            }
            case 29: 
            case 30: {
                return any.extract_Value();
            }
            case 32: {
                InputStream in23 = (InputStream)any.create_input_stream();
                return in23.read_abstract_interface();
            }
            case 18: {
                return any.extract_string();
            }
            case 14: {
                Object ref = any.extract_Object();
                return ref;
            }
            case 11: {
                return any.extract_any();
            }
        }
        String id = "<unknown>";
        try {
            id = typecode.id();
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        throw new MARSHAL("cannot extract " + id + " (" + typecode.kind().value() + ") value from Any");
    }

    public void writeRemoteObject(org.omg.CORBA.portable.OutputStream out, java.lang.Object obj) throws SystemException {
        Object objref = null;
        if (obj == null) {
            out.write_Object(null);
            return;
        }
        if (obj instanceof Object) {
            objref = (Object)obj;
        } else if (obj instanceof Remote) {
            try {
                objref = (Stub)PortableRemoteObject.toStub((Remote)((Remote)obj));
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            if (objref == null) {
                try {
                    PortableRemoteObject.exportObject((Remote)((Remote)obj));
                    objref = (Stub)PortableRemoteObject.toStub((Remote)((Remote)obj));
                }
                catch (RemoteException ex) {
                    throw (MARSHAL)new MARSHAL("cannot convert Remote to Object").initCause((Throwable)ex);
                }
            }
        } else {
            throw new MARSHAL("object is neither Remote nor org.omg.CORBA.Object: " + obj.getClass().getName());
        }
        out.write_Object(objref);
    }

    public void writeAbstractObject(org.omg.CORBA.portable.OutputStream out, java.lang.Object obj) {
        logger.finer("writeAbstractObject.1  out=" + out);
        if (!(obj instanceof Object) && !(obj instanceof Serializable) && obj instanceof Remote) {
            Object objref = null;
            try {
                objref = (Object)PortableRemoteObject.toStub((Remote)((Remote)obj));
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            if (objref == null) {
                try {
                    PortableRemoteObject.exportObject((Remote)((Remote)obj));
                    objref = (Object)PortableRemoteObject.toStub((Remote)((Remote)obj));
                }
                catch (RemoteException ex) {
                    throw (MARSHAL)new MARSHAL("unable to export object").initCause((Throwable)ex);
                }
            }
            obj = objref;
        }
        OutputStream out_ = (OutputStream)out;
        logger.finer("writeAbstractObject.2  out=" + out);
        out_.write_abstract_interface(obj);
    }

    protected Map<Remote, Tie> tie_map() {
        return RMIState.current().tie_map;
    }

    public void registerTarget(Tie tie, Remote obj) {
        if (obj == null) {
            throw new IllegalArgumentException("remote object is null");
        }
        tie.setTarget(obj);
        this.tie_map().put(obj, tie);
    }

    public Tie getTie(Remote obj) {
        if (obj == null) {
            return null;
        }
        return this.tie_map().get(obj);
    }

    public ValueHandler createValueHandler() {
        return ValueHandlerImpl.get();
    }

    public String getCodebase(Class clz) {
        if (clz == null) {
            return null;
        }
        if (clz.isArray()) {
            return this.getCodebase(clz.getComponentType());
        }
        if (clz.isPrimitive()) {
            return null;
        }
        ClassLoader theLoader = clz.getClassLoader();
        if (theLoader == null) {
            return null;
        }
        if (theLoader == java.lang.Object.class.getClassLoader()) {
            return null;
        }
        if (theLoader == BEST_GUESS_AT_EXTENSION_CLASS_LOADER) {
            return null;
        }
        RMIState state = RMIState.current();
        ClassLoader stateLoader = state.getClassLoader();
        try {
            URL codebaseURL;
            if (clz.equals(stateLoader.loadClass(clz.getName())) && (codebaseURL = state.getCodeBase()) != null) {
                logger.finer("class " + clz.getName() + " => " + codebaseURL);
                return codebaseURL.toString();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return AccessController.doPrivileged(new GetSystemPropertyAction("java.rmi.server.codebase"));
    }

    private static SecMan getSecMan() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<SecMan>(){

                @Override
                public SecMan run() {
                    return new SecMan();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
    }

    public Class loadClass(String name, String codebase, ClassLoader loader) throws ClassNotFoundException {
        try {
            return UtilImpl.loadClass0(name, codebase, loader);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.FINER, "cannot load from " + codebase + " " + ex.getMessage(), ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Class<?> loadClass0(String name, String codebase, ClassLoader loader) throws ClassNotFoundException {
        try {
            return ProviderLocator.loadClass((String)name, null, (ClassLoader)loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader thisLoader;
            ClassLoader stackLoader = UtilImpl.getStackLoader();
            if (stackLoader != null) {
                try {
                    Class<?> result2 = stackLoader.loadClass(name);
                    if (result2 != null) {
                        return result2;
                    }
                }
                catch (ClassNotFoundException result2) {
                    // empty catch block
                }
            }
            if ((thisLoader = Util.class.getClassLoader()) != null) {
                try {
                    Class<?> result3 = thisLoader.loadClass(name);
                    if (result3 != null) {
                        return result3;
                    }
                }
                catch (ClassNotFoundException result3) {
                    // empty catch block
                }
            }
            if (codebase != null && !"".equals(codebase) && !Boolean.getBoolean("java.rmi.server.useCodeBaseOnly")) {
                logger.finer("trying RMIClassLoader");
                try (URLClassLoader url_loader = new URLClassLoader(new URL[]{new URL(codebase)}, loader);){
                    Class<?> result4 = url_loader.loadClass(name);
                    if (result4 != null) {
                        Class<?> clazz = result4;
                        return clazz;
                    }
                }
                catch (ClassNotFoundException ex) {
                    logger.log(Level.FINER, "RMIClassLoader says " + ex.getMessage(), ex);
                }
                catch (MalformedURLException ex) {
                    logger.log(Level.FINER, "RMIClassLoader says " + ex.getMessage(), ex);
                    logger.finer("FAILED class download " + name + " from " + codebase + " " + ex.getMessage());
                }
                catch (RuntimeException ex) {
                    logger.log(Level.FINER, "FAILED class download " + name + " from " + codebase + " " + ex.getMessage(), ex);
                }
                catch (IOException ex) {}
            } else {
                codebase = AccessController.doPrivileged(new GetSystemPropertyAction("java.rmi.server.codebase"));
                if (codebase != null) {
                    try {
                        Class<?> result5 = RMIClassLoader.loadClass(codebase, name);
                        if (result5 != null) {
                            return result5;
                        }
                    }
                    catch (ClassNotFoundException | MalformedURLException result5) {
                        // empty catch block
                    }
                }
            }
            if (loader == null) {
                loader = UtilImpl.getContextClassLoader();
            }
            try {
                Class<?> result = loader.loadClass(name);
                if (result == null) throw new ClassNotFoundException(name);
                return result;
            }
            catch (ClassNotFoundException ex) {
                logger.log(Level.FINER, "LocalLoader says " + ex.getMessage(), ex);
            }
            throw new ClassNotFoundException(name);
        }
    }

    private static ClassLoader getStackLoader() {
        ClassLoader thisLoader = Util.class.getClassLoader();
        for (Class candidateContextClass : _secman.getClassContext()) {
            ClassLoader candidateLoader = candidateContextClass.getClassLoader();
            if (null == candidateLoader || thisLoader == candidateLoader) continue;
            return candidateLoader;
        }
        return null;
    }

    public boolean isLocal(Stub stub) throws RemoteException {
        try {
            if (stub instanceof RMIStub) {
                return true;
            }
            return stub._is_local();
        }
        catch (SystemException ex) {
            throw this.mapSystemException(ex);
        }
    }

    public RemoteException wrapException(Throwable ex) {
        if (ex instanceof Error) {
            return new ServerError(ex.getMessage(), (Error)ex);
        }
        if (ex instanceof RemoteException) {
            return new ServerException(ex.getMessage(), (Exception)ex);
        }
        if (ex instanceof UnknownException) {
            UnknownException uex = (UnknownException)ex;
            return new ServerError(ex.getMessage(), uex.originalEx instanceof Error ? (Error)uex.originalEx : new Error("[OTHER EXCEPTION] " + ex.getMessage()));
        }
        if (ex instanceof SystemException) {
            return this.mapSystemException((SystemException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        return new RemoteException(ex.getMessage(), ex);
    }

    static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static ClassLoader getClassLoader(final Class<?> clz) {
        if (System.getSecurityManager() == null) {
            return clz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clz.getClassLoader();
            }
        });
    }

    static java.lang.Object copyRMIStub(RMIStub stub) throws RemoteException {
        Class targetClass;
        ClassLoader loader = UtilImpl.getContextClassLoader();
        if (UtilImpl.getClassLoader(stub._descriptor.type) == loader) {
            return stub;
        }
        RemoteDescriptor desc = stub._descriptor;
        try {
            targetClass = Util.loadClass((String)desc.type.getName(), (String)stub._get_codebase(), (ClassLoader)loader);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.FINER, "copyRMIStub exception (current loader is: " + loader + ") " + ex.getMessage(), ex);
            throw new RemoteException("Class not found", ex);
        }
        return PortableRemoteObjectImpl.narrow1(RMIState.current(), (ObjectImpl)stub, targetClass);
    }

    public java.lang.Object copyObject(java.lang.Object obj, ORB orb) throws RemoteException {
        if (obj == null) {
            return null;
        }
        if (orb == null) {
            throw new NullPointerException();
        }
        if (obj instanceof String || obj instanceof Number) {
            return obj;
        }
        if (obj instanceof RMIStub) {
            return UtilImpl.copyRMIStub((RMIStub)((java.lang.Object)obj));
        }
        try {
            TypeRepository rep = RMIState.current().repo;
            CopyState state = new CopyState(rep);
            return state.copy(obj);
        }
        catch (CopyRecursionException ex) {
            throw new MarshalException("unable to resolve recursion", ex);
        }
        catch (SystemException ex) {
            throw this.mapSystemException(ex);
        }
    }

    public java.lang.Object[] copyObjects(java.lang.Object[] objs, ORB orb) throws RemoteException {
        if (objs == null || orb == null) {
            throw new NullPointerException();
        }
        if (objs.length == 0) {
            return objs;
        }
        try {
            TypeRepository rep = RMIState.current().repo;
            CopyState state = new CopyState(rep);
            try {
                return (java.lang.Object[])state.copy(objs);
            }
            catch (CopyRecursionException ex) {
                throw new MarshalException("unable to resolve recursion", ex);
            }
        }
        catch (SystemException ex) {
            throw this.mapSystemException(ex);
        }
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        if (obj == null) {
            return;
        }
        Map<Remote, Tie> tie_map = this.tie_map();
        if (tie_map == null) {
            return;
        }
        Tie tie = tie_map.remove(obj);
        if (tie == null) {
            logger.fine("unexporting unknown instance of " + obj.getClass().getName() + " from " + RMIState.current().getName());
            return;
        }
        logger.finer("unexporting instance of " + obj.getClass().getName() + " from " + RMIState.current().getName());
        tie.deactivate();
    }

    static {
        ClassLoader candidateLoader = UtilImpl.getClassLoader(UtilImpl.class);
        if (candidateLoader == null) {
            candidateLoader = UtilImpl.findFirstNonNullLoader("sun.net.spi.nameservice.dns.DNSNameService", "javax.transaction.UserTransaction");
        }
        for (ClassLoader l = candidateLoader; l != null; l = l.getParent()) {
            candidateLoader = l;
        }
        BEST_GUESS_AT_EXTENSION_CLASS_LOADER = candidateLoader;
        copy_with_corba = false;
        READ_SERIALIZABLE_KEY = new java.lang.Object();
    }

    static class SecMan
    extends RMISecurityManager {
        SecMan() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

