/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.FieldDescriptor;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ObjectWriter;
import org.apache.yoko.rmi.impl.TypeRepository;

class BooleanFieldDescriptor
extends FieldDescriptor {
    BooleanFieldDescriptor(Class owner, Class type, String name, Field f, TypeRepository repository) {
        super(owner, type, name, f, repository);
    }

    @Override
    public void read(ObjectReader reader, Object obj) throws IOException {
        if (this.field == null) {
            throw new IOException("cannot read/write using serialPersistentFields");
        }
        try {
            boolean value = reader.readBoolean();
            this.field.setBoolean(obj, value);
        }
        catch (IllegalAccessException ex) {
            throw (IOException)new IOException(ex.getMessage()).initCause(ex);
        }
    }

    @Override
    public void write(ObjectWriter writer, Object obj) throws IOException {
        if (this.field == null) {
            throw new IOException("cannot read/write using serialPersistentFields");
        }
        try {
            writer.writeBoolean(this.field.getBoolean(obj));
        }
        catch (IllegalAccessException ex) {
            throw (IOException)new IOException(ex.getMessage()).initCause(ex);
        }
    }

    @Override
    void copyState(Object orig, Object copy, CopyState state) {
        try {
            this.field.setBoolean(copy, this.field.getBoolean(orig));
        }
        catch (IllegalAccessException ex) {
            throw (InternalError)new InternalError(ex.getMessage()).initCause(ex);
        }
    }

    @Override
    void print(PrintWriter pw, Map recurse, Object val) {
        try {
            pw.print(this.java_name);
            pw.print("=");
            pw.print(this.field.getBoolean(val));
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    void readFieldIntoMap(ObjectReader reader, Map map) throws IOException {
        Boolean value = new Boolean(reader.readBoolean());
        map.put(this.java_name, value);
    }

    @Override
    void writeFieldFromMap(ObjectWriter writer, Map map) throws IOException {
        Boolean value = (Boolean)map.get(this.java_name);
        if (value == null) {
            writer.writeBoolean(false);
        } else {
            writer.writeBoolean(value);
        }
    }
}

