/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.jwk.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.jose4j.json.JsonUtil;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JsonUtils {
    private static final TraceComponent tc = Tr.register(JsonUtils.class, (String)"SecurityCommon", (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages");
    public static final String CFG_KEY_ID = "id";
    public static final String CFG_KEY_ISSUER = "issuer";
    public static final String CFG_KEY_JWK_ENABLED = "jwkEnabled";
    public static final String CFG_KEY_VALID = "expiry";
    public static final String CFG_KEY_JTI = "jti";
    public static final String CFG_KEY_SCOPE = "scope";
    public static final String CFG_KEY_AUDIENCES = "audiences";
    public static final String CFG_KEY_SIGNATURE_ALGORITHM = "signatureAlgorithm";
    public static final String CFG_KEY_CLAIMS = "claims";
    public static final String CFG_KEY_KEYSTORE_REF = "keyStoreRef";
    public static final String CFG_KEY_KEY_ALIAS_NAME = "keyAlias";
    public static final String CFG_KEY_TRUSTSTORE_REF = "trustStoreRef";
    public static final String CFG_KEY_TRUSTED_ALIAS = "trustedAlias";
    public static final String CFG_KEY_SHARED_KEY = "sharedKey";
    public static final String CFG_KEY_JWK_ROTATION_TIME = "jwkRotationTime";
    public static final String CFG_KEY_JWK_SIGNING_KEY_SIZE = "jwkSigningKeySize";
    public static final String CFG_KEY_JWK_ENDPOINT_URL = "jwkEndpointUrl";
    public static final String CFG_KEY_CLOCK_SKEW = "clockSkew";
    public static final String JCEPROVIDER_IBM = "IBMJCE";
    public static final String SECRANDOM_SHA1PRNG = "SHA1PRNG";
    public static final String SECRANDOM_IBM = "IBMSecureRandom";
    public static final String ISSUER = "iss";
    public static final String SUBJECT = "sub";
    public static final String AUDIENCE = "aud";
    public static final String SCOPE = "scope";
    public static final String EXPIRATION = "exp";
    public static final String NOT_BEFORE = "nbf";
    public static final String ISSUED_AT = "iat";
    public static final String ID = "jti";
    public static final String KEY = "signKey";
    public static final String ALG = "signAlg";
    public static final String KS = "KeyStore";
    public static final String KS_ALIAS = "KeyStore_ALIAS";
    public static final String TS = "TrustStore";
    public static final String TS_ALIAS = "TrustStore_ALIAS";
    public static final String DELIMITER = ".";
    static final long serialVersionUID = 1418443808615390835L;

    public static String convertToBase64(String source) {
        if (source == null) {
            return null;
        }
        return Base64.encodeBase64URLSafeString((byte[])StringUtils.getBytesUtf8((String)source));
    }

    public static String convertToBase64(byte[] source) {
        if (source == null) {
            return null;
        }
        return Base64.encodeBase64URLSafeString((byte[])source);
    }

    public static byte[] decodeFromBase64(String encoded) {
        if (encoded == null) {
            return null;
        }
        return Base64.decodeBase64((String)encoded);
    }

    public static String decodeFromBase64String(String encoded) {
        if (encoded == null) {
            return null;
        }
        return new String(Base64.decodeBase64((String)encoded));
    }

    public static boolean isBase64Encoded(String str) {
        if (!JsonUtils.isNullEmpty(str)) {
            return Base64.isArrayByteBase64((byte[])StringUtils.getBytesUtf8((String)str));
        }
        return false;
    }

    public static String fromBase64ToJsonString(String source) {
        return StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)source));
    }

    public static String toJson(String source) {
        if (source == null) {
            return null;
        }
        try {
            return StringUtils.newStringUtf8((byte[])source.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.common.jwk.utils.JsonUtils", (String)"126", null, (Object[])new Object[]{source});
            return null;
        }
    }

    public static boolean isNullEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static boolean isJson(String tokenString) {
        boolean result = false;
        if (!JsonUtils.isNullEmpty(tokenString) && (tokenString.startsWith("{") && tokenString.endsWith("}") || tokenString.startsWith("[") && tokenString.endsWith("]"))) {
            result = true;
        }
        return result;
    }

    public static Object claimFromJsonObject(String jsonFormattedString, String claimName) throws JoseException {
        if (jsonFormattedString == null) {
            return null;
        }
        Object claim = null;
        Map jobj = JsonUtil.parseJson((String)jsonFormattedString);
        if (jobj != null) {
            claim = jobj.get(claimName);
        }
        return claim;
    }

    public static Map claimsFromJsonObject(String jsonFormattedString) throws JoseException {
        ConcurrentHashMap claimsMap = new ConcurrentHashMap();
        if (jsonFormattedString == null) {
            return claimsMap;
        }
        Map jobj = JsonUtil.parseJson((String)jsonFormattedString);
        Set entries = jobj.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Key : " + key + ", Value: " + value), (Object[])new Object[0]);
            }
            if (JsonUtils.isNullEmpty(key) || value == null) continue;
            claimsMap.put(key, value);
        }
        return claimsMap;
    }

    public static List<String> trimIt(String[] strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < strings.length; ++i) {
            String result = JsonUtils.trimIt(strings[i]);
            if (result == null) continue;
            results.add(result);
        }
        if (results.size() > 0) {
            return results;
        }
        return null;
    }

    public static String trimIt(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).isEmpty()) {
            return null;
        }
        return str;
    }

    public static String[] splitTokenString(String tokenString) {
        if (tokenString == null) {
            return null;
        }
        boolean isPlainTextJWT = false;
        if (tokenString.endsWith(DELIMITER)) {
            isPlainTextJWT = true;
        }
        String[] pieces = tokenString.split(Pattern.quote(DELIMITER));
        if (!isPlainTextJWT && pieces.length != 3) {
            return null;
        }
        return pieces;
    }

    public static String getPayload(String jwt) {
        String[] jwtInfo = JsonUtils.splitTokenString(jwt);
        if (jwtInfo != null) {
            return jwtInfo[1];
        }
        return null;
    }

    public static String getRandom(int length) {
        StringBuffer result = new StringBuffer(length);
        char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        Random r = JsonUtils.getRandom();
        for (int i = 0; i < length; ++i) {
            int n = r.nextInt(62);
            result.append(chars[n]);
        }
        return result.toString();
    }

    static Random getRandom() {
        Random result = null;
        try {
            result = Security.getProvider(JCEPROVIDER_IBM) != null ? SecureRandom.getInstance(SECRANDOM_IBM) : SecureRandom.getInstance(SECRANDOM_SHA1PRNG);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.common.jwk.utils.JsonUtils", (String)"293", null, (Object[])new Object[0]);
            result = new Random();
        }
        return result;
    }

    public static long calculate(long valid) {
        long lifetimeSeconds = valid * 60L * 60L;
        long timeInSeconds = System.currentTimeMillis() / 1000L;
        return timeInSeconds + lifetimeSeconds;
    }

    public static String toJson(Map<String, Object> claimsMap) {
        return JsonUtil.toJson(claimsMap);
    }

    public static String getDate(long current) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date resultdate = new Date(current);
        return sdf.format(resultdate);
    }
}

