/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.persistence.internal;

import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import org.apache.geronimo.osgi.locator.ProviderLocator;
import org.apache.geronimo.specs.jpa.PersistenceActivator;

public class HybridPersistenceActivator
extends PersistenceActivator {
    private volatile WeakHashMap<ModuleMetaData, List<PersistenceProvider>> providerCache = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PersistenceProvider> getPersistenceProviders() {
        List<PersistenceProvider> nonOSGiProviders = null;
        ModuleMetaData mmd = this.getModuleMetaData();
        if (mmd != null) {
            WeakHashMap<ModuleMetaData, List<PersistenceProvider>> weakHashMap = this.providerCache;
            synchronized (weakHashMap) {
                nonOSGiProviders = this.providerCache.get(mmd);
                if (nonOSGiProviders == null) {
                    nonOSGiProviders = this.findProviders();
                    this.providerCache.put(mmd, nonOSGiProviders);
                }
            }
        } else {
            nonOSGiProviders = this.findProviders();
        }
        ArrayList<PersistenceProvider> combinedProviders = new ArrayList<PersistenceProvider>(nonOSGiProviders);
        combinedProviders.addAll(super.getPersistenceProviders());
        return combinedProviders;
    }

    private ModuleMetaData getModuleMetaData() {
        try {
            return ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData().getModuleMetaData();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private List<PersistenceProvider> findProviders() {
        ArrayList<PersistenceProvider> nonOSGiProviders = new ArrayList<PersistenceProvider>();
        ClassLoader cl = PrivClassLoader.get(null);
        if (cl == null) {
            cl = PrivClassLoader.get(HybridPersistenceActivator.class);
        }
        try {
            List<Object> providers = ProviderLocator.getServices(PersistenceProvider.class.getName(), this.getClass(), cl);
            for (Object o : providers) {
                if (!(o instanceof PersistenceProvider)) continue;
                nonOSGiProviders.add((PersistenceProvider)o);
            }
        }
        catch (Exception e) {
            throw new PersistenceException("Failed to load provider from META-INF/services", e);
        }
        return Collections.unmodifiableList(nonOSGiProviders);
    }

    @Override
    public void clearCachedProviders() {
        this.providerCache.clear();
        super.clearCachedProviders();
    }

    private static class PrivClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final Class<?> c;

        public static ClassLoader get(Class<?> c) {
            PrivClassLoader action = new PrivClassLoader(c);
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(action);
            }
            return action.run();
        }

        private PrivClassLoader(Class<?> c) {
            this.c = c;
        }

        @Override
        public ClassLoader run() {
            if (this.c != null) {
                return this.c.getClassLoader();
            }
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

