/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.proxyhandler;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageType;
import com.ibm.ws.sib.mfp.control.SubscriptionMessage;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.io.MECommsTrc;
import com.ibm.ws.sib.processor.proxyhandler.MESubscription;
import com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler;
import com.ibm.ws.sib.processor.proxyhandler.Neighbour;
import com.ibm.ws.sib.processor.proxyhandler.Neighbours;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;

public class NeighbourProxyListener
implements AsynchConsumerCallback {
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private static final TraceComponent tc = SibTr.register(NeighbourProxyListener.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Neighbours iNeighbours;
    private MultiMEProxyHandler iProxyHandler;
    private ArrayList iAddTopics;
    private ArrayList iAddTopicSpaces;
    private ArrayList iAddTopicSpaceMappings;
    private ArrayList iDeleteTopics;
    private ArrayList iDeleteTopicSpaces;
    private DestinationManager iDestinationManager;

    NeighbourProxyListener(Neighbours neighbours, MultiMEProxyHandler proxyHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"NeighbourProxyListener", (Object)new Object[]{neighbours, proxyHandler});
        }
        this.iNeighbours = neighbours;
        this.iProxyHandler = proxyHandler;
        this.iDestinationManager = this.iProxyHandler.getMessageProcessor().getDestinationManager();
        this.iAddTopics = new ArrayList();
        this.iAddTopicSpaces = new ArrayList();
        this.iAddTopicSpaceMappings = new ArrayList();
        this.iDeleteTopics = new ArrayList();
        this.iDeleteTopicSpaces = new ArrayList();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"NeighbourProxyListener", (Object)this);
        }
    }

    public void consumeMessages(LockedMessageEnumeration messages) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"consumeMessages", (Object)new Object[]{messages});
        }
        SIBusMessage jsMessage = null;
        while (messages.hasNext()) {
            try {
                jsMessage = messages.nextLocked();
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener.consumeMessages", (String)"1:157:1.73", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            if (jsMessage != null && ((JsMessage)jsMessage).getJsMessageType() != MessageType.SUBSCRIPTION) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Message On incorrect Destination, expecting message of Type " + MessageType.SUBSCRIPTION + " received " + ((JsMessage)jsMessage).getJsMessageType()));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"consumeMessages");
                }
                return;
            }
            if (jsMessage == null) continue;
            SubscriptionMessage subMessage = null;
            try {
                subMessage = ((JsMessage)jsMessage).makeInboundSubscriptionMessage();
            }
            catch (IncorrectMessageTypeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener.consumeMessages", (String)"1:193:1.73", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            if (TraceComponent.isAnyTracingEnabled()) {
                MECommsTrc.traceMessage(tc, this.iProxyHandler.getMessageProcessor(), subMessage.getGuaranteedSourceMessagingEngineUUID(), "<-SUBC--", null, (AbstractMessage)subMessage);
            }
            LocalTransaction transaction = null;
            try {
                transaction = this.iProxyHandler.getTransactionManager().createLocalTransaction(true);
                switch (subMessage.getSubscriptionMessageType().toInt()) {
                    case 2: {
                        this.handleCreateProxySubscription(subMessage, (Transaction)transaction);
                        break;
                    }
                    case 3: {
                        this.handleDeleteProxySubscription(subMessage, (Transaction)transaction);
                        break;
                    }
                    case 1: {
                        this.handleResetState(subMessage, (Transaction)transaction, false);
                        break;
                    }
                    case 4: {
                        this.handleResetState(subMessage, (Transaction)transaction, true);
                        break;
                    }
                    case 5: {
                        this.handleResetState(subMessage, (Transaction)transaction, false);
                        break;
                    }
                }
                messages.deleteCurrent((SITransaction)transaction);
                transaction.commit();
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener.consumeMessages", (String)"1:273:1.73", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                this.handleRollback(subMessage, transaction);
            }
            catch (RuntimeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener.consumeMessages", (String)"1:286:1.73", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                this.handleRollback(subMessage, transaction);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"consumeMessages", (Object)e);
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"consumeMessages");
        }
    }

    void handleRollback(SubscriptionMessage subMessage, LocalTransaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleRollback", (Object)new Object[]{subMessage, transaction});
        }
        try {
            if (transaction != null) {
                try {
                    transaction.rollback();
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener.handleRollback", (String)"1:330:1.73", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
            }
            Transaction msTran = this.iProxyHandler.getMessageProcessor().resolveAndEnlistMsgStoreTransaction((TransactionCommon)transaction);
            switch (subMessage.getSubscriptionMessageType().toInt()) {
                case 2: {
                    this.iProxyHandler.remoteUnsubscribeEvent(this.iAddTopicSpaces, this.iAddTopics, subMessage.getBus(), msTran, false);
                    break;
                }
                case 3: {
                    this.iProxyHandler.remoteSubscribeEvent(this.iDeleteTopicSpaces, this.iDeleteTopics, subMessage.getBus(), msTran, false);
                    break;
                }
                case 1: {
                    this.iProxyHandler.remoteUnsubscribeEvent(this.iAddTopicSpaces, this.iAddTopics, subMessage.getBus(), msTran, false);
                    this.iProxyHandler.remoteSubscribeEvent(this.iDeleteTopicSpaces, this.iDeleteTopics, subMessage.getBus(), msTran, false);
                    break;
                }
            }
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener.handleRollback", (String)"1:392:1.73", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleRollback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleResetState(SubscriptionMessage resetMessage, Transaction transaction, boolean request) throws SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleResetState", (Object)new Object[]{resetMessage, transaction, new Boolean(request)});
        }
        boolean foreignTemporaryProxy = false;
        boolean foreignAllowed = true;
        String MESubUserId = null;
        boolean foreignSecuredProxy = false;
        Iterator topics = resetMessage.getTopics().iterator();
        Iterator topicSpaces = resetMessage.getTopicSpaces().iterator();
        Iterator topicSpaceMappings = resetMessage.getTopicSpaceMappings().iterator();
        byte[] meUUIDArr = resetMessage.getMEUUID();
        SIBUuid8 meUUID = new SIBUuid8(meUUIDArr);
        String busId = resetMessage.getBusName();
        Neighbour neighbour = this.iNeighbours.getNeighbour(meUUID);
        if (neighbour == null) {
            this.iProxyHandler.getLockManager().lockExclusive();
            try {
                this.iProxyHandler.createNeighbour(meUUID, busId, transaction);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Created Messaging Engine " + meUUID + " on bus " + busId));
                }
                neighbour = this.iNeighbours.getNeighbour(meUUID);
                if (!request) {
                    neighbour.sendRequestProxySubscriptions();
                }
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener.handleResetState", (String)"1:468:1.73", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"handleResetState", (Object)"Unable to create Neighbour so exiting");
                }
                return;
            }
            finally {
                this.iProxyHandler.getLockManager().unlockExclusive();
            }
        }
        if (neighbour.wasProxyRequestSent()) {
            neighbour.setRequestedProxySubscriptionsResponded();
        }
        boolean okToForward = false;
        if (this.iNeighbours.getAllBuses().length > 1) {
            okToForward = true;
            this.iAddTopics.clear();
            this.iAddTopicSpaces.clear();
            this.iAddTopicSpaceMappings.clear();
            this.iDeleteTopics.clear();
            this.iDeleteTopicSpaces.clear();
        }
        neighbour.markAllProxies();
        while (topics.hasNext()) {
            boolean proxyCreated;
            MESubscription subscription;
            String topic = (String)topics.next();
            String topicSpaceName = (String)topicSpaceMappings.next();
            String foreignTopicSpaceName = (String)topicSpaces.next();
            SIBUuid12 localTopicSpaceUuid = null;
            foreignTemporaryProxy = false;
            foreignAllowed = true;
            MESubUserId = null;
            foreignSecuredProxy = false;
            if (!busId.equals(this.iProxyHandler.getMessageProcessor().getMessagingEngineBus())) {
                DestinationHandler topicSpace = this.iDestinationManager.getDestination(topicSpaceName, false);
                if (topicSpace == null) {
                    foreignTemporaryProxy = true;
                } else {
                    if (this.iProxyHandler.getMessageProcessor().isBusSecure()) {
                        try {
                            if (!resetMessage.isSecurityUseridSentBySystem()) {
                                MESubUserId = resetMessage.getSecurityUserid();
                                foreignSecuredProxy = foreignAllowed = this.checkDestinationAccess(topicSpace, topic, MESubUserId);
                            }
                        }
                        catch (SIException e) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Caught exception " + (Object)((Object)e)));
                            }
                            foreignAllowed = false;
                        }
                    }
                    if (foreignAllowed) {
                        localTopicSpaceUuid = topicSpace.getUuid();
                    }
                }
            } else {
                localTopicSpaceUuid = new SIBUuid12(foreignTopicSpaceName);
            }
            if (foreignTemporaryProxy || !foreignAllowed || (subscription = neighbour.proxyRegistered(localTopicSpaceUuid, topicSpaceName, topic, foreignTopicSpaceName, transaction, foreignSecuredProxy, MESubUserId)) == null || !(proxyCreated = this.iNeighbours.createProxy(neighbour, this.iDestinationManager.getDestinationInternal(localTopicSpaceUuid, false), subscription, localTopicSpaceUuid, topic, false)) || !okToForward) continue;
            this.iAddTopics.add(topic);
            this.iAddTopicSpaces.add(localTopicSpaceUuid);
            this.iAddTopicSpaceMappings.add(foreignTopicSpaceName);
        }
        neighbour.sweepMarkedProxies(this.iDeleteTopicSpaces, this.iDeleteTopics, transaction, okToForward);
        if (okToForward && this.iDeleteTopics.size() > 0) {
            this.iProxyHandler.unsubscribeEvent(this.iDeleteTopicSpaces, this.iDeleteTopics, busId, transaction);
        }
        if (okToForward && this.iAddTopics.size() > 0) {
            this.iProxyHandler.subscribeEvent(this.iAddTopicSpaces, this.iAddTopics, busId, transaction);
        }
        if (request) {
            neighbour.sendReplyMessage();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleResetState");
        }
    }

    void handleDeleteProxySubscription(SubscriptionMessage deleteMessage, Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleDeleteProxySubscription", (Object)new Object[]{deleteMessage, transaction});
        }
        Iterator topics = deleteMessage.getTopics().iterator();
        Iterator topicSpaces = deleteMessage.getTopicSpaces().iterator();
        Iterator topicSpaceMappings = deleteMessage.getTopicSpaceMappings().iterator();
        byte[] meUUIDArr = deleteMessage.getMEUUID();
        SIBUuid8 meUUID = new SIBUuid8(meUUIDArr);
        String busId = deleteMessage.getBusName();
        this.deleteProxySubscription(topics, topicSpaces, topicSpaceMappings, meUUID, busId, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleDeleteProxySubscription");
        }
    }

    public void deleteProxySubscription(Iterator topics, Iterator topicSpaces, Iterator topicSpaceMappings, SIBUuid8 meUUID, String busId, Transaction transaction) throws SIResourceException {
        Neighbour neighbour;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteProxySubscription", (Object)new Object[]{topics, topicSpaces, topicSpaceMappings, meUUID, busId, transaction});
        }
        if ((neighbour = this.iNeighbours.getNeighbour(meUUID)) == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteProxySubscription", (Object)"Unknown neighbour");
            }
            return;
        }
        boolean okToForward = false;
        if (this.iNeighbours.getAllBuses().length > 1) {
            okToForward = true;
            this.iDeleteTopics.clear();
            this.iDeleteTopicSpaces.clear();
        }
        while (topics.hasNext()) {
            boolean proxyDeleted;
            MESubscription subscription;
            String topic = (String)topics.next();
            String topicSpaceName = (String)topicSpaceMappings.next();
            String foreignTopicSpaceName = (String)topicSpaces.next();
            SIBUuid12 localTopicSpaceUuid = null;
            if (!busId.equals(this.iProxyHandler.getMessageProcessor().getMessagingEngineBus())) {
                DestinationHandler topicSpace;
                block13: {
                    topicSpace = null;
                    try {
                        topicSpace = this.iDestinationManager.getDestination(topicSpaceName, false);
                    }
                    catch (SIException e) {
                        if (!tc.isDebugEnabled()) break block13;
                        SibTr.debug((TraceComponent)tc, (String)("Destination not found " + topicSpaceName));
                    }
                }
                if (topicSpace == null) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteProxySubscription", (Object)("Destination not found " + topicSpaceName));
                    }
                    return;
                }
                localTopicSpaceUuid = topicSpace.getUuid();
            } else {
                localTopicSpaceUuid = new SIBUuid12(foreignTopicSpaceName);
            }
            if ((subscription = neighbour.proxyDeregistered(localTopicSpaceUuid, topic, transaction)) == null || !(proxyDeleted = this.iNeighbours.deleteProxy(this.iDestinationManager.getDestinationInternal(localTopicSpaceUuid, false), subscription, neighbour, localTopicSpaceUuid, topic, true, false)) || !okToForward) continue;
            this.iDeleteTopics.add(topic);
            this.iDeleteTopicSpaces.add(localTopicSpaceUuid);
        }
        if (okToForward && this.iDeleteTopics.size() > 0) {
            this.iProxyHandler.unsubscribeEvent(this.iDeleteTopicSpaces, this.iDeleteTopics, busId, transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteProxySubscription");
        }
    }

    protected void handleCreateProxySubscription(SubscriptionMessage createMessage, Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleCreateProxySubscription", (Object)new Object[]{createMessage, transaction});
        }
        boolean foreignAllowed = true;
        String MESubUserId = null;
        boolean foreignSecuredProxy = false;
        Iterator topics = createMessage.getTopics().iterator();
        Iterator topicSpaces = createMessage.getTopicSpaces().iterator();
        Iterator topicSpaceMappings = createMessage.getTopicSpaceMappings().iterator();
        byte[] meUUIDArr = createMessage.getMEUUID();
        SIBUuid8 meUUID = new SIBUuid8(meUUIDArr);
        String busId = createMessage.getBusName();
        Neighbour neighbour = this.iNeighbours.getNeighbour(meUUID);
        if (neighbour == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"handleCreateProxySubscription", (Object)"Unknown neighbour");
            }
            return;
        }
        boolean okToForward = false;
        if (this.iNeighbours.getAllBuses().length > 1) {
            okToForward = true;
            this.iAddTopics.clear();
            this.iAddTopicSpaces.clear();
            this.iAddTopicSpaceMappings.clear();
        }
        while (topics.hasNext()) {
            boolean created;
            MESubscription sub;
            String topic = (String)topics.next();
            String topicSpaceName = (String)topicSpaceMappings.next();
            String foreignTopicSpaceName = (String)topicSpaces.next();
            SIBUuid12 localTopicSpaceUuid = null;
            foreignAllowed = true;
            MESubUserId = null;
            foreignSecuredProxy = false;
            if (!busId.equals(this.iProxyHandler.getMessageProcessor().getMessagingEngineBus())) {
                DestinationHandler topicSpace;
                block19: {
                    topicSpace = null;
                    try {
                        topicSpace = this.iDestinationManager.getDestination(topicSpaceName, false);
                    }
                    catch (SIException e) {
                        if (!tc.isDebugEnabled()) break block19;
                        SibTr.debug((TraceComponent)tc, (String)("Destination not found " + topicSpaceName));
                    }
                }
                if (topicSpace == null) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"handleCreateProxySubscription", (Object)("Topic Space " + topicSpaceName + " not found"));
                    }
                    return;
                }
                if (this.iProxyHandler.getMessageProcessor().isBusSecure()) {
                    try {
                        if (!createMessage.isSecurityUseridSentBySystem()) {
                            MESubUserId = createMessage.getSecurityUserid();
                            foreignSecuredProxy = foreignAllowed = this.checkDestinationAccess(topicSpace, topic, MESubUserId);
                        }
                    }
                    catch (SIException e) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Caught exception " + (Object)((Object)e)));
                        }
                        foreignAllowed = false;
                    }
                }
                if (foreignAllowed) {
                    localTopicSpaceUuid = topicSpace.getUuid();
                }
            } else {
                localTopicSpaceUuid = new SIBUuid12(foreignTopicSpaceName);
            }
            if (!foreignAllowed || (sub = neighbour.proxyRegistered(localTopicSpaceUuid, topicSpaceName, topic, foreignTopicSpaceName, transaction, foreignSecuredProxy, MESubUserId)) == null || !(created = this.iNeighbours.createProxy(neighbour, this.iDestinationManager.getDestinationInternal(localTopicSpaceUuid, false), sub, localTopicSpaceUuid, topic, false)) || !okToForward) continue;
            this.iAddTopics.add(topic);
            this.iAddTopicSpaces.add(localTopicSpaceUuid);
            this.iAddTopicSpaceMappings.add(foreignTopicSpaceName);
        }
        if (okToForward && this.iAddTopics.size() > 0) {
            this.iProxyHandler.subscribeEvent(this.iAddTopicSpaces, this.iAddTopics, busId, transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleCreateProxySubscription");
        }
    }

    private boolean checkDestinationAccess(DestinationHandler destination, String discriminator, String userId) throws SIDiscriminatorSyntaxException {
        SecurityContext secContext;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationAccess", (Object)new Object[]{destination, discriminator, userId});
        }
        boolean allowed = true;
        if (userId == null) {
            userId = "";
        }
        if (!destination.checkDestinationAccess(secContext = new SecurityContext(userId, discriminator), OperationType.RECEIVE)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"checkDestinationAccess", (Object)"not authorized to produce to this destination");
            }
            String nlsMessage = nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_18", new Object[]{destination.getName(), userId}, null);
            this.iProxyHandler.getMessageProcessor().getAccessChecker().fireDestinationAccessNotAuthorizedEvent(destination.getName(), userId, OperationType.RECEIVE, nlsMessage);
            allowed = false;
        }
        if (allowed && discriminator != null && !this.iProxyHandler.getMessageProcessor().getMessageProcessorMatching().isWildCarded(discriminator) && !destination.checkDiscriminatorAccess(secContext, OperationType.RECEIVE)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"checkDestinationAccess", (Object)"not authorized to produce to this discriminator");
            }
            SibTr.audit((TraceComponent)tc, (String)nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_20", new Object[]{destination.getName(), discriminator, userId}, null));
            allowed = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess", (Object)new Boolean(allowed));
        }
        return allowed;
    }
}

