/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.indexes;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.indexes.AbstractDestinationIndex;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.processor.utils.index.IndexFilter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;

public class DestinationIndex
extends AbstractDestinationIndex {
    private static final TraceComponent tc = SibTr.register(DestinationIndex.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private HashMap<String, HashMap<String, Index.Entry>> busIndex;

    public DestinationIndex(String localBusName) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DestinationIndex", (Object)localBusName);
        }
        this.busIndex = new HashMap(1);
        HashMap localBus = new HashMap(10);
        this.busIndex.put(localBusName, localBus);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DestinationIndex", (Object)this);
        }
    }

    @Override
    public synchronized Index.Entry put(DestinationHandler destinationHandler, AbstractDestinationIndex.AbstractDestinationType type) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{destinationHandler, type});
        }
        Index.Entry entry = super.put(destinationHandler, type);
        this.addToBusMap(destinationHandler, entry);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)entry);
        }
        return entry;
    }

    synchronized void addToBusMap(DestinationHandler destinationHandler, Index.Entry entry) {
        HashMap<String, Index.Entry> busMap;
        AbstractDestinationIndex.DestinationEntry destEntry;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addToBusMap", (Object)new Object[]{destinationHandler, entry});
        }
        if ((destEntry = (AbstractDestinationIndex.DestinationEntry)(busMap = this.getBusMap(destinationHandler.getBus())).get(destinationHandler.getName())) != null && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"*** put, duplicate name", (Object)new Object[]{destinationHandler, destEntry.data});
        }
        busMap.put(destinationHandler.getName(), entry);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addToBusMap");
        }
    }

    @Override
    public synchronized void remove(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{destinationHandler});
        }
        super.remove(destinationHandler);
        HashMap<String, Index.Entry> busMap = this.getBusMap(destinationHandler.getBus());
        AbstractDestinationIndex.DestinationEntry destEntry = (AbstractDestinationIndex.DestinationEntry)busMap.get(destinationHandler.getName());
        if (destEntry != null && destEntry.data == destinationHandler) {
            busMap.remove(destinationHandler.getName());
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"destination is not removed from the bus map", (Object)new Object[]{destEntry, destinationHandler});
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public synchronized DestinationHandler findByName(String name, String busName, IndexFilter filter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findByName", (Object)new Object[]{busName, name, filter});
        }
        DestinationHandler destinationHandler = null;
        HashMap<String, Index.Entry> busMap = this.getBusMap(busName);
        AbstractDestinationIndex.DestinationEntry destination = (AbstractDestinationIndex.DestinationEntry)busMap.get(name);
        if (destination != null && (filter == null || filter.matches(destination.type))) {
            destinationHandler = destination.getHandler();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findByName", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    private synchronized HashMap<String, Index.Entry> getBusMap(String busName) {
        HashMap<String, Index.Entry> busMap;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBusMap", (Object)new Object[]{busName});
        }
        if ((busMap = this.busIndex.get(busName)) == null) {
            busMap = new HashMap(10);
            this.busIndex.put(busName, busMap);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBusMap", busMap);
        }
        return busMap;
    }

    @Override
    public synchronized void remove(Index.Entry entry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{entry});
        }
        super.remove(entry);
        DestinationHandler dh = (DestinationHandler)entry.data;
        HashMap<String, Index.Entry> busMap = this.getBusMap(dh.getBus());
        AbstractDestinationIndex.DestinationEntry destEntry = (AbstractDestinationIndex.DestinationEntry)busMap.get(dh.getName());
        if (destEntry == entry) {
            busMap.remove(dh.getName());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public synchronized boolean containsKey(String bus, String name) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"containsKey", (Object)new Object[]{bus, name});
        }
        HashMap<String, Index.Entry> busMap = this.getBusMap(bus);
        boolean res = busMap.containsKey(name);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"containsKey", (Object)new Boolean(res));
        }
        return res;
    }

    @Override
    public synchronized void create(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"create", (Object)new Object[]{destinationHandler});
        }
        AbstractDestinationIndex.AbstractDestinationType type = this._getType(destinationHandler);
        type.state = type.state.create();
        if (type.state.isVisible()) {
            this.addToBusMap(destinationHandler, (Index.Entry)this.index.get(destinationHandler.getUuid()));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"create");
        }
    }

    public synchronized void setLocalizationFlags(DestinationHandler destinationHandler) {
        Type type = (Type)this.getType(destinationHandler);
        type.local = destinationHandler.hasLocal();
        type.remote = destinationHandler.hasRemote();
        this.setType(destinationHandler, (Index.Type)type);
    }

    public static class Type
    extends AbstractDestinationIndex.AbstractDestinationType {
        public Boolean queue = null;
        public Boolean alias = null;
        public Boolean foreignDestination = null;
        public Boolean local = null;
        public Boolean remote = null;
    }
}

