/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.MPSubscription;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import java.util.Map;

public class MPSubscriptionImpl
implements MPSubscription {
    private static final TraceComponent tc = SibTr.register(MPSubscriptionImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ConsumerDispatcher _consumerDispatcher = null;
    private MessageProcessor _messageProcessor = null;

    public MPSubscriptionImpl(ConsumerDispatcher consumerDispatcher, MessageProcessor messageProcessor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MPSubscriptionImpl", (Object)new Object[]{consumerDispatcher, messageProcessor});
        }
        this._consumerDispatcher = consumerDispatcher;
        this._messageProcessor = messageProcessor;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MPSubscriptionImpl", (Object)this);
        }
    }

    public void addSelectionCriteria(SelectionCriteria selCriteria) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIResourceException {
        boolean duplicateCriteria;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addSelectionCriteria", (Object)new Object[]{selCriteria});
        }
        if (!(duplicateCriteria = this._consumerDispatcher.getConsumerDispatcherState().addSelectionCriteria(selCriteria))) {
            try {
                this._messageProcessor.getMessageProcessorMatching().addConsumerDispatcherMatchTarget(this._consumerDispatcher, this._consumerDispatcher.getDestination().getUuid(), selCriteria);
            }
            catch (SIDiscriminatorSyntaxException e) {
                this._consumerDispatcher.getConsumerDispatcherState().removeSelectionCriteria(selCriteria);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addSelectionCriteria", (Object)((Object)e));
                }
                throw e;
            }
            catch (SISelectorSyntaxException e) {
                this._consumerDispatcher.getConsumerDispatcherState().removeSelectionCriteria(selCriteria);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addSelectionCriteria", (Object)((Object)e));
                }
                throw e;
            }
            ExternalAutoCommitTransaction tran = this._messageProcessor.getTXManager().createAutoCommitTransaction();
            if (!this._consumerDispatcher.getReferenceStream().isUpdating()) {
                try {
                    this._consumerDispatcher.getReferenceStream().requestUpdate((Transaction)tran);
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MPSubscriptionImpl.addSelectionCriteria", (String)"1:153:1.6", (Object)this);
                    this._consumerDispatcher.getConsumerDispatcherState().removeSelectionCriteria(selCriteria);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"addSelectionCriteria", (Object)"SIResourceException");
                    }
                    throw new SIResourceException((Throwable)e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addSelectionCriteria");
        }
    }

    public void removeSelectionCriteria(SelectionCriteria selCriteria) throws SIResourceException {
        boolean wasRemoved;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeSelectionCriteria", (Object)new Object[]{selCriteria});
        }
        if (wasRemoved = this._consumerDispatcher.getConsumerDispatcherState().removeSelectionCriteria(selCriteria)) {
            ExternalAutoCommitTransaction tran = this._messageProcessor.getTXManager().createAutoCommitTransaction();
            if (!this._consumerDispatcher.getReferenceStream().isUpdating()) {
                try {
                    this._consumerDispatcher.getReferenceStream().requestUpdate((Transaction)tran);
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MPSubscriptionImpl.removeSelectionCriteria", (String)"1:203:1.6", (Object)this);
                    this._consumerDispatcher.getConsumerDispatcherState().addSelectionCriteria(selCriteria);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"removeSelectionCriteria", (Object)"SIResourceException");
                    }
                    throw new SIResourceException((Throwable)e);
                }
            }
            this._messageProcessor.getMessageProcessorMatching().removeConsumerDispatcherMatchTarget(this._consumerDispatcher, selCriteria);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeSelectionCriteria");
        }
    }

    public SelectionCriteria[] getSelectionCriteria() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSelectionCriteria");
        }
        SelectionCriteria[] list = this._consumerDispatcher.getConsumerDispatcherState().getSelectionCriteriaList();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSelectionCriteria", (Object)list);
        }
        return list;
    }

    public void setUserProperties(Map userData) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setUserProperties", (Object)new Object[]{userData});
        }
        this._consumerDispatcher.getConsumerDispatcherState().setUserData(userData);
        ExternalAutoCommitTransaction tran = this._messageProcessor.getTXManager().createAutoCommitTransaction();
        if (!this._consumerDispatcher.getReferenceStream().isUpdating()) {
            try {
                this._consumerDispatcher.getReferenceStream().requestUpdate((Transaction)tran);
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MPSubscriptionImpl.setUserProperties", (String)"1:269:1.6", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"setUserProperties", (Object)"SIResourceException");
                }
                throw new SIResourceException((Throwable)e);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setUserProperties");
        }
    }

    public Map getUserProperties() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUserProperties");
        }
        Map map = this._consumerDispatcher.getConsumerDispatcherState().getUserData();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUserProperties", (Object)map);
        }
        return map;
    }

    public String getSubscriberId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriberId");
        }
        String subscriberId = this._consumerDispatcher.getConsumerDispatcherState().getSubscriberID();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriberId", (Object)subscriberId);
        }
        return subscriberId;
    }

    public String getWPMTopicSpaceName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getWPMTopicSpaceName");
        }
        String tsName = this._consumerDispatcher.getConsumerDispatcherState().getTopicSpaceName();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getWPMTopicSpaceName", (Object)tsName);
        }
        return tsName;
    }

    public String getMEName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMEName");
        }
        String meName = this._messageProcessor.getMessagingEngineName();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMEName", (Object)meName);
        }
        return meName;
    }
}

