/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.impl;

import com.ibm.ws.sib.matchspace.SimpleTest;
import com.ibm.ws.sib.matchspace.selector.impl.EvaluatorImpl;
import java.util.ArrayList;
import java.util.List;

public class CheapRangeTable {
    public static int numTables = 0;
    public static int numEntries = 0;
    int size = 0;
    RangeEntry[] ranges = new RangeEntry[3];

    public void insert(SimpleTest test, Object target) {
        if (this.size == this.ranges.length) {
            RangeEntry[] tmp = new RangeEntry[2 * this.size];
            System.arraycopy(this.ranges, 0, tmp, 0, this.size);
            this.ranges = tmp;
        }
        this.ranges[this.size] = new RangeEntry(test, target);
        ++this.size;
    }

    public Object getExact(SimpleTest test) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.ranges[i].correspondsTo(test)) continue;
            return this.ranges[i].target;
        }
        return null;
    }

    public void replace(SimpleTest test, Object target) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.ranges[i].correspondsTo(test)) continue;
            this.ranges[i].target = target;
            return;
        }
        throw new IllegalStateException();
    }

    public List find(Number value) {
        ArrayList<Object> targets = new ArrayList<Object>(1);
        for (int i = 0; i < this.size; ++i) {
            if (!this.ranges[i].contains(value)) continue;
            targets.add(this.ranges[i].target);
        }
        return targets;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void remove(SimpleTest test) {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        int toGo = -1;
        for (int i = 0; toGo < 0 && i < this.size; ++i) {
            if (!this.ranges[i].correspondsTo(test)) continue;
            toGo = i;
        }
        if (toGo < 0) {
            throw new IllegalStateException();
        }
        System.arraycopy(this.ranges, toGo + 1, this.ranges, toGo, this.size - toGo - 1);
        --this.size;
    }

    class RangeEntry {
        Number lower;
        boolean lowIncl;
        Number upper;
        boolean upIncl;
        Object target;

        RangeEntry(SimpleTest test, Object t) {
            this.lower = test.getLower();
            this.lowIncl = test.isLowIncl();
            this.upper = test.getUpper();
            this.upIncl = test.isUpIncl();
            this.target = t;
        }

        boolean correspondsTo(SimpleTest t) {
            if (this.lowIncl != t.isLowIncl() || this.upIncl != t.isUpIncl()) {
                return false;
            }
            if (this.lower == null) {
                if (t.getLower() != null) {
                    return false;
                }
            } else {
                if (t.getLower() == null) {
                    return false;
                }
                if (!EvaluatorImpl.equals(this.lower, t.getLower())) {
                    return false;
                }
            }
            if (this.upper == null) {
                if (t.getUpper() != null) {
                    return false;
                }
            } else {
                if (t.getUpper() == null) {
                    return false;
                }
                if (!EvaluatorImpl.equals(this.upper, t.getUpper())) {
                    return false;
                }
            }
            return true;
        }

        boolean contains(Number v) {
            int comp;
            if (this.lower != null && ((comp = EvaluatorImpl.compare(this.lower, v)) > 0 || !this.lowIncl && comp == 0)) {
                return false;
            }
            return this.upper == null || (comp = EvaluatorImpl.compare(this.upper, v)) >= 0 && (this.upIncl || comp != 0);
        }
    }
}

