/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.AliasDestination;
import com.ibm.ws.sib.admin.BaseDestination;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.BaseLocalizationDefinition;
import com.ibm.ws.sib.admin.DestinationAliasDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.ExtendedBoolean;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsShadowMessagingEngine;
import com.ibm.ws.sib.admin.LWMConfig;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.admin.SIBDestination;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBLocalizationPoint;
import com.ibm.ws.sib.admin.internal.BaseMessagingEngineImpl;
import com.ibm.ws.sib.admin.internal.JsAdminFactory;
import com.ibm.ws.sib.admin.internal.JsAdminFactoryImpl;
import com.ibm.ws.sib.processor.Administrator;
import com.ibm.ws.sib.processor.SIMPAdmin;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JsLocalizer {
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.internal.JsLocalizer";
    private static final TraceComponent tc = SibTr.register(JsLocalizer.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private JsAdminFactory jsaf = null;
    private BaseMessagingEngineImpl _me = null;
    private Administrator _mpAdmin = null;
    private final HashSet missingDestinations = new HashSet();
    private final HashMap<String, MainEntry> mainMap = new HashMap();
    private HashMap<String, Object> lpMap = new HashMap();
    private final HashSet newDestinations = new HashSet();
    private final HashSet alterDestinations = new HashSet();
    public ArrayList<DestinationDefinition> updatedDestDefList = new ArrayList();
    public ArrayList<LocalizationDefinition> updatedLocDefList = new ArrayList();

    public JsLocalizer(BaseMessagingEngineImpl me) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"JsLocalizer", (Object)me);
        }
        this._me = me;
        try {
            this.jsaf = JsAdminFactory.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap lps = this._me._me.getMessagingEngine().getSibLocalizationPointList();
        for (Map.Entry entry : lps.entrySet()) {
            this.addLpToMaps((LWMConfig)entry.getValue());
        }
        String busName = this._me.getBusName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Looking for bus called " + busName + "."));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"JsLocalizer");
        }
    }

    public BaseMessagingEngineImpl getEngine() {
        return this._me;
    }

    public void loadLocalizations() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"loadLocalizations", (Object)this);
        }
        DestinationDefinition dd = null;
        if (!this.isInZOSServentRegion()) {
            this._mpAdmin = ((SIMPAdmin)this._me.getMessageProcessor()).getAdministrator();
        }
        Set<Map.Entry<String, MainEntry>> s = this.mainMap.entrySet();
        Iterator<Map.Entry<String, MainEntry>> _i = s.iterator();
        while (_i.hasNext()) {
            boolean valid = true;
            Map.Entry<String, MainEntry> mapEntry = _i.next();
            String destinationName = mapEntry.getKey();
            MainEntry m = this.mainMap.get(destinationName);
            try {
                dd = (DestinationDefinition)this._me.getSIBDestination(this._me.getBusName(), destinationName);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.internal.JsLocalizer.loadLocalizations", (String)"1", (Object)this);
                String reason = m.getDestinationLocalization().getName();
                SibTr.error((TraceComponent)tc, (String)"destination config inconsistent", null);
                valid = false;
            }
            if (!valid || this.isInZOSServentRegion() || this._mpAdmin == null) continue;
            try {
                LocalizationDefinition dld = m.getDestinationLocalization();
                try {
                    this._mpAdmin.createDestinationLocalization(dd, dld);
                }
                catch (Exception e) {
                    SibTr.error((TraceComponent)tc, (String)"LOCALIZATION_EXCEPTION_SIAS0113", (Object)new Object[]{dd.getName()});
                }
                this.updatedDestDefList.add(dd);
                this.updatedLocDefList.add(dld);
                _i.remove();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.internal.JsLocalizer.loadLocalizations", (String)"2", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"CREATE_DESTINATION_FAILED_SIAS0009", (Object)dd.getName());
            }
        }
        this.updateDefinitionsAfterLoadLocalizations();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"loadLocalizations");
        }
    }

    private void addLpToMaps(LWMConfig lp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLpToMaps", (Object)lp);
        }
        SIBLocalizationPoint lpConfig = (SIBLocalizationPoint)lp;
        LocalizationDefinition ld = ((JsAdminFactoryImpl)this.jsaf).createLocalizationDefinition((LWMConfig)lpConfig);
        String lpIdentifier = lpConfig.getIdentifier();
        this.lpMap.put(lpIdentifier, new LocalizationEntry((BaseLocalizationDefinition)ld));
        String destName = lpIdentifier.substring(0, lpIdentifier.indexOf("@"));
        MainEntry mainEntry = this.mainMap.get(destName);
        if (mainEntry == null) {
            mainEntry = new MainEntry();
            mainEntry.setDestinationLocalization(ld);
            this.mainMap.put(destName, mainEntry);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLpToMaps");
        }
    }

    private MainEntry updateLpMaps(LWMConfig lp) {
        SIBLocalizationPoint lpConfig;
        String lpName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLpMaps", (Object)lp);
        }
        if (this.lpMap.containsKey(lpName = (lpConfig = (SIBLocalizationPoint)lp).getIdentifier())) {
            this.lpMap.remove(lpName);
        }
        LocalizationDefinition ld = ((JsAdminFactoryImpl)this.jsaf).createLocalizationDefinition((LWMConfig)lpConfig);
        LocalizationEntry lEntry = new LocalizationEntry((BaseLocalizationDefinition)ld);
        this.lpMap.put(lpName, lEntry);
        String destName = lpName.substring(0, lpName.indexOf("@"));
        MainEntry mainEntry = this.mainMap.get(destName);
        if (mainEntry == null) {
            mainEntry = new MainEntry();
        }
        mainEntry.setDestinationLocalization(ld);
        this.mainMap.put(destName, mainEntry);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLpMaps", this.lpMap);
        }
        return mainEntry;
    }

    public boolean addLocalizationPoint(LWMConfig lp, DestinationDefinition dd) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLocalizationPoint", (Object)lp);
        }
        boolean valid = false;
        LocalizationDefinition ld = ((JsAdminFactoryImpl)this.jsaf).createLocalizationDefinition(lp);
        if (!this.isInZOSServentRegion()) {
            this._mpAdmin = ((SIMPAdmin)this._me.getMessageProcessor()).getAdministrator();
        }
        try {
            this._mpAdmin.createDestinationLocalization(dd, ld);
            this.updatedDestDefList.add(dd);
            this.updatedLocDefList.add(ld);
            LocalizationEntry lEntry = new LocalizationEntry((BaseLocalizationDefinition)ld);
            this.lpMap.put(ld.getName(), lEntry);
            MainEntry newMainEntry = new MainEntry();
            newMainEntry.setDestinationLocalization(ld);
            this.mainMap.put(dd.getName(), newMainEntry);
            valid = true;
        }
        catch (Exception e) {
            SibTr.error((TraceComponent)tc, (String)"LOCALIZATION_EXCEPTION_SIAS0113", (Object)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLocalizationPoint", (Object)valid);
        }
        return valid;
    }

    private boolean isNewDestination(String key) {
        BaseDestinationDefinition dd = null;
        try {
            dd = this._me.getSIBDestinationByUuid(this._me.getBusName(), key, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dd == null;
    }

    public void alterLocalizationPoint(BaseDestination destination, LWMConfig lp) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alterLocalizationPoint", (Object)lp);
        }
        boolean valid = true;
        DestinationDefinition dd = null;
        DestinationAliasDefinition dAliasDef = null;
        String key = this.getMainMapKey(lp);
        MainEntry m = this.updateLpMaps(lp);
        if (m == null) {
            String reason = "com.ibm.ws.sib.admin.internal.JsLocalizer.alterLocalizationPoint(): Entry for name " + key + " not found in cache";
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)reason);
            valid = false;
        } else {
            try {
                BaseDestinationDefinition bdd = this._me.getSIBDestination(this._me.getBusName(), key);
                if (destination.isAlias()) {
                    AliasDestination aliasDest = (AliasDestination)destination;
                    dAliasDef = this.modifyAliasDestDefinition((BaseDestination)aliasDest, (DestinationAliasDefinition)bdd);
                } else {
                    dd = this.modifyDestDefinition(destination, bdd);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.internal.JsLocalizer.alterLocalizationPoint", (String)"1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                String reason = m.getDestinationLocalization().getName();
                valid = false;
            }
        }
        if (valid && !this.isInZOSServentRegion() && this._mpAdmin != null) {
            if (destination.isAlias()) {
                this._mpAdmin.alterDestinationAlias(dAliasDef);
            } else {
                LocalizationDefinition ld = m.getDestinationLocalization();
                ld.setAlterationTime(dd.getAlterationTime());
                ld.setSendAllowed(dd.isSendAllowed());
                this._mpAdmin.alterDestinationLocalization(dd, ld);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("alterLocalizationPoint: LP altered on existing destination deferring alter until end, UUID=" + key + " Name=" + dd.getName()));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alterLocalizationPoint");
        }
    }

    public void deleteLocalizationPoint(JsBus bus, LWMConfig dest) throws SIBExceptionBase, SIException {
        DestinationDefinition destDef;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteLocalizationPoint", (Object)((BaseDestination)dest).getName());
        }
        if ((destDef = (DestinationDefinition)this._me.getSIBDestination(bus.getName(), ((SIBDestination)dest).getName())) == null) {
            this.missingDestinations.add(destDef.getName());
        }
        if (!this.isInZOSServentRegion() && this._mpAdmin != null) {
            this.alterDestinations.add(destDef.getName());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("unlocalize: Dest unlocalized on existing destination deferring alter until end, Destination Name=" + destDef.getName()));
            }
        }
        this.deleteDestLocalizations(bus);
        this.alterDestinations.remove(destDef.getName());
        this.unlocalize(destDef);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteLocalizationPoint");
        }
    }

    private String getMainMapKey(LWMConfig lp) {
        String key = null;
        String lpIdentifier = ((SIBLocalizationPoint)lp).getIdentifier();
        key = lpIdentifier.substring(0, lpIdentifier.indexOf("@"));
        return key;
    }

    void startUpdate() {
        this.missingDestinations.clear();
        this.newDestinations.clear();
        this.alterDestinations.clear();
    }

    private void alterDestLocalizations() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alterDestLocalizations", (Object)this);
        }
        if (!this.isInZOSServentRegion() && this._mpAdmin != null) {
            for (String key : this.alterDestinations) {
                MainEntry m = this.mainMap.get(key);
                try {
                    DestinationDefinition destinationDefinition = (DestinationDefinition)this._me.getSIBDestinationByUuid(this._me.getBusName(), key, true);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.internal.JsLocalizer.alterDestLocalizations", (String)"1179", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                    String reason = null;
                    if (m.getDestinationLocalization() != null) {
                        reason = "uuid=" + m.getDestinationLocalization().getUuid() + " targetUuid=" + key;
                    }
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)("com.ibm.ws.sib.admin.internal.JsLocalizer: Unable to modify Message Point: " + reason));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alterDestLocalizations");
        }
    }

    private void createNewDestLocalizations() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createNewDestLocalizations", (Object)this);
        }
        if (!this.isInZOSServentRegion() && this._mpAdmin != null) {
            for (String key : this.newDestinations) {
                MainEntry m = this.mainMap.get(key);
                try {
                    DestinationDefinition destinationDefinition = (DestinationDefinition)this._me.getSIBDestinationByUuid(this._me.getBusName(), key, true);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.internal.JsLocalizer.createNewDestLocalizations", (String)"1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createNewDestLocalizations");
        }
    }

    private void deleteDestLocalizations(JsBus bus) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteDestLocalizations", (Object)this);
        }
        for (String key : this.alterDestinations) {
            try {
                DestinationDefinition dd = (DestinationDefinition)this._me.getSIBDestination(bus.getName(), key);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("deleteDestLocalizations: deleting DestinationLocalization, name =" + key + " Name="));
                }
                if (this.isInZOSServentRegion() || this._mpAdmin == null) continue;
                LocalizationEntry dldEntry = (LocalizationEntry)this.lpMap.get(dd.getName() + "@" + this._me.getName());
                LocalizationDefinition dld = (LocalizationDefinition)dldEntry.getLocalizationDefinition();
                this._mpAdmin.deleteDestinationLocalization(dd.getUUID().toString(), null);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.internal.JsLocalizer.deleteDestLocalizations", (String)"1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDestLocalizations");
        }
    }

    private boolean isInZOSServentRegion() {
        return this._me instanceof JsShadowMessagingEngine;
    }

    private void unlocalize(DestinationDefinition destDef) throws SIBExceptionBase, SIException {
        String thisMethodName = "unlocalize";
        String destName = destDef.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)new Object[]{destName});
        }
        this.lpMap.remove(destName + "@" + this._me.getName());
        MainEntry mainEntry = this.mainMap.get(destName);
        mainEntry.setDestinationLocalization(null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public void clearMPAdmin() {
        this._mpAdmin = null;
    }

    void updateDefinitionsAfterLoadLocalizations() {
        SibTr.entry((TraceComponent)tc, (String)"updateDefinitionsAfterLoadLocalizations");
        for (LocalizationDefinition dld : this.updatedLocDefList) {
            String destLPName = dld.getName();
            String destinationName = destLPName.substring(0, destLPName.indexOf("@"));
            MainEntry mainEntry = new MainEntry();
            mainEntry.setDestinationLocalization(dld);
            this.mainMap.put(destinationName, mainEntry);
            String key = destinationName + "@" + this._me.getName();
            if (!this.lpMap.containsKey(key)) continue;
            this.lpMap.remove(key);
            this.lpMap.put(key, new LocalizationEntry((BaseLocalizationDefinition)dld));
        }
        SibTr.exit((TraceComponent)tc, (String)"updateDefinitionsAfterLoadLocalizations", this.updatedLocDefList);
    }

    private DestinationDefinition modifyDestDefinition(BaseDestination config, BaseDestinationDefinition dest) {
        DestinationDefinition ddf = null;
        Reliability _reliability = null;
        Reliability _maxReliability = null;
        boolean maintainStrictOrder = false;
        boolean receiveExclusive = false;
        Reliability _exceptionDiscardReliability = Reliability.BEST_EFFORT_NONPERSISTENT;
        SIBDestination newDest = (SIBDestination)config;
        ddf = (DestinationDefinition)dest;
        ddf.setBlockedRetryTimeout(newDest.getBlockedRetryTimeout());
        ddf.setDefaultPriority(newDest.getDefaultPriority());
        String _rs = newDest.getDefaultReliability();
        if (_rs.equals("BEST_EFFORT_NONPERSISTENT")) {
            _reliability = Reliability.BEST_EFFORT_NONPERSISTENT;
        } else if (_rs.equals("ASSURED_PERSISTENT")) {
            _reliability = Reliability.ASSURED_PERSISTENT;
        } else if (_rs.equals("EXPRESS_NONPERSISTENT")) {
            _reliability = Reliability.EXPRESS_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_NONPERSISTENT")) {
            _reliability = Reliability.RELIABLE_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_PERSISTENT")) {
            _reliability = Reliability.RELIABLE_PERSISTENT;
        }
        ddf.setDefaultReliability(_reliability);
        ddf.setExceptionDestination(newDest.getExceptionDestination());
        _rs = newDest.getExceptionDiscardReliability();
        if (_rs.equals("BEST_EFFORT_NONPERSISTENT")) {
            _exceptionDiscardReliability = Reliability.BEST_EFFORT_NONPERSISTENT;
        } else if (_rs.equals("ASSURED_PERSISTENT")) {
            _exceptionDiscardReliability = Reliability.ASSURED_PERSISTENT;
        } else if (_rs.equals("EXPRESS_NONPERSISTENT")) {
            _exceptionDiscardReliability = Reliability.EXPRESS_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_NONPERSISTENT")) {
            _exceptionDiscardReliability = Reliability.RELIABLE_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_PERSISTENT")) {
            _exceptionDiscardReliability = Reliability.RELIABLE_PERSISTENT;
        }
        ddf.setExceptionDiscardReliability(_exceptionDiscardReliability);
        _rs = newDest.getMaximumReliability();
        if (_rs.equals("BEST_EFFORT_NONPERSISTENT")) {
            _maxReliability = Reliability.BEST_EFFORT_NONPERSISTENT;
        } else if (_rs.equals("ASSURED_PERSISTENT")) {
            _maxReliability = Reliability.ASSURED_PERSISTENT;
        } else if (_rs.equals("EXPRESS_NONPERSISTENT")) {
            _maxReliability = Reliability.EXPRESS_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_NONPERSISTENT")) {
            _maxReliability = Reliability.RELIABLE_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_PERSISTENT")) {
            _maxReliability = Reliability.RELIABLE_PERSISTENT;
        }
        ddf.setMaxReliability(_maxReliability);
        ddf.setMaxFailedDeliveries(newDest.getMaxFailedDeliveries());
        ddf.setRedeliveryCountPersisted(newDest.isPersistRedeliveryCount());
        ddf.setOverrideOfQOSByProducerAllowed(newDest.isOverrideOfQOSByProducerAllowed());
        ddf.setReceiveAllowed(newDest.isReceiveAllowed());
        maintainStrictOrder = newDest.isMaintainStrictOrder();
        ddf.maintainMsgOrder(maintainStrictOrder);
        receiveExclusive = newDest.isReceiveExclusive();
        ddf.setReceiveExclusive(receiveExclusive);
        if (maintainStrictOrder && !receiveExclusive) {
            ddf.setReceiveExclusive(true);
            SibTr.debug((TraceComponent)tc, (String)"RECEIVE_EXCLUSIVE_OVERRIDE_WARNING_SIAS0048", (Object)new Object[]{newDest.getName()});
        }
        ddf.setSendAllowed(newDest.isSendAllowed());
        if (ddf.getDestinationType() == DestinationType.TOPICSPACE) {
            ddf.setTopicAccessCheckRequired(newDest.isTopicAccessCheckRequired());
        }
        return ddf;
    }

    private DestinationAliasDefinition modifyAliasDestDefinition(BaseDestination destination, DestinationAliasDefinition daf) {
        String b;
        AliasDestination adest = (AliasDestination)destination;
        Reliability _reliability = null;
        Reliability _maxReliability = null;
        String _rs = adest.getDefaultReliability();
        if (_rs.equals("BEST_EFFORT_NONPERSISTENT")) {
            _reliability = Reliability.BEST_EFFORT_NONPERSISTENT;
        } else if (_rs.equals("ASSURED_PERSISTENT")) {
            _reliability = Reliability.ASSURED_PERSISTENT;
        } else if (_rs.equals("EXPRESS_NONPERSISTENT")) {
            _reliability = Reliability.EXPRESS_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_NONPERSISTENT")) {
            _reliability = Reliability.RELIABLE_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_PERSISTENT")) {
            _reliability = Reliability.RELIABLE_PERSISTENT;
        }
        if (_reliability != null) {
            daf.setDefaultReliability(_reliability);
        }
        daf.setDelegateAuthorizationCheckToTarget(adest.getDelegateAuthCheckToTargetDestination());
        _rs = adest.getMaximumReliability();
        if (_rs.equals("BEST_EFFORT_NONPERSISTENT")) {
            _maxReliability = Reliability.BEST_EFFORT_NONPERSISTENT;
        } else if (_rs.equals("ASSURED_PERSISTENT")) {
            _maxReliability = Reliability.ASSURED_PERSISTENT;
        } else if (_rs.equals("EXPRESS_NONPERSISTENT")) {
            _maxReliability = Reliability.EXPRESS_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_NONPERSISTENT")) {
            _maxReliability = Reliability.RELIABLE_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_PERSISTENT")) {
            _maxReliability = Reliability.RELIABLE_PERSISTENT;
        }
        if (_maxReliability != null) {
            daf.setMaxReliability(_maxReliability);
        }
        ExtendedBoolean _producerQOSOverrideEnabled = (b = adest.isOverrideOfQOSByProducerAllowed()).equalsIgnoreCase("TRUE") ? ExtendedBoolean.TRUE : (b.equalsIgnoreCase("FALSE") ? ExtendedBoolean.FALSE : ExtendedBoolean.NONE);
        daf.setOverrideOfQOSByProducerAllowed(_producerQOSOverrideEnabled);
        b = adest.isReceiveAllowed();
        ExtendedBoolean receiveAllowed = b.equalsIgnoreCase("TRUE") ? ExtendedBoolean.TRUE : (b.equalsIgnoreCase("FALSE") ? ExtendedBoolean.FALSE : ExtendedBoolean.NONE);
        daf.setReceiveAllowed(receiveAllowed);
        b = adest.isSendAllowed();
        ExtendedBoolean sendAllowed = b.equalsIgnoreCase("TRUE") ? ExtendedBoolean.TRUE : (b.equalsIgnoreCase("FALSE") ? ExtendedBoolean.FALSE : ExtendedBoolean.NONE);
        daf.setSendAllowed(sendAllowed);
        daf.setTargetName(adest.getTargetDestination());
        return daf;
    }

    private class LocalizationEntry {
        private BaseLocalizationDefinition _ld = null;

        private LocalizationEntry(BaseLocalizationDefinition ld) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"LocalizationEntry", (Object)ld);
            }
            this._ld = ld;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"LocalizationEntry");
            }
        }

        private BaseLocalizationDefinition getLocalizationDefinition() {
            return this._ld;
        }
    }

    private class MainEntry {
        private LocalizationDefinition _dld = null;

        private MainEntry() {
        }

        private void setDestinationLocalization(LocalizationDefinition dld) {
            this._dld = dld;
        }

        private LocalizationDefinition getDestinationLocalization() {
            return this._dld;
        }
    }
}

