/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OBCORBA;

import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.apache.yoko.orb.CORBA.Context;
import org.apache.yoko.orb.CORBA.ContextList;
import org.apache.yoko.orb.CORBA.Environment;
import org.apache.yoko.orb.CORBA.NVList;
import org.apache.yoko.orb.CORBA.NamedValue;
import org.apache.yoko.orb.CORBA.ORBPolicyFactory_impl;
import org.apache.yoko.orb.CORBA.ORBPolicyManager_impl;
import org.apache.yoko.orb.CORBA.ORBSingleton;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.CORBA.PolicyMap;
import org.apache.yoko.orb.DynamicAny.DynAnyFactory_impl;
import org.apache.yoko.orb.IOP.CodecFactory_impl;
import org.apache.yoko.orb.Messaging.RebindPolicy_impl;
import org.apache.yoko.orb.Messaging.SyncScopePolicy_impl;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.BootManager_impl;
import org.apache.yoko.orb.OB.ClientManager;
import org.apache.yoko.orb.OB.CodeSetIORInterceptor_impl;
import org.apache.yoko.orb.OB.CodeSetInfo;
import org.apache.yoko.orb.OB.ConnectTimeoutPolicy_impl;
import org.apache.yoko.orb.OB.ConnectionReusePolicy_impl;
import org.apache.yoko.orb.OB.CorbalocURLScheme_impl;
import org.apache.yoko.orb.OB.CorbanameURLScheme_impl;
import org.apache.yoko.orb.OB.CoreTraceLevels;
import org.apache.yoko.orb.OB.DispatchStrategyFactory_impl;
import org.apache.yoko.orb.OB.FileURLScheme_impl;
import org.apache.yoko.orb.OB.GIOPIncomingMessage;
import org.apache.yoko.orb.OB.GIOPOutgoingMessage;
import org.apache.yoko.orb.OB.IORURLScheme_impl;
import org.apache.yoko.orb.OB.InitialServiceManager;
import org.apache.yoko.orb.OB.InterceptorPolicy_impl;
import org.apache.yoko.orb.OB.LocateRequestPolicy_impl;
import org.apache.yoko.orb.OB.LocationTransparencyPolicy_impl;
import org.apache.yoko.orb.OB.Logger;
import org.apache.yoko.orb.OB.Logger_impl;
import org.apache.yoko.orb.OB.MessageRoutingIORInterceptor_impl;
import org.apache.yoko.orb.OB.MessageRoutingUtil;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.MultiRequestSender;
import org.apache.yoko.orb.OB.ORBControl;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.ObjectFactory;
import org.apache.yoko.orb.OB.OptionFilter;
import org.apache.yoko.orb.OB.PIManager;
import org.apache.yoko.orb.OB.ParseParams;
import org.apache.yoko.orb.OB.PluginManager;
import org.apache.yoko.orb.OB.PolicyFactoryManager;
import org.apache.yoko.orb.OB.ProtocolPolicy_impl;
import org.apache.yoko.orb.OB.ReplyTimeoutPolicy_impl;
import org.apache.yoko.orb.OB.RequestTimeoutPolicy_impl;
import org.apache.yoko.orb.OB.RetryPolicy_impl;
import org.apache.yoko.orb.OB.TimeoutPolicy_impl;
import org.apache.yoko.orb.OB.URLRegistryPackage.SchemeAlreadyExists;
import org.apache.yoko.orb.OB.URLRegistry_impl;
import org.apache.yoko.orb.OB.UnknownExceptionStrategy;
import org.apache.yoko.orb.OB.UnknownExceptionStrategy_impl;
import org.apache.yoko.orb.OB.ValueFactoryManager;
import org.apache.yoko.orb.OB.Version;
import org.apache.yoko.orb.OB.ZeroPortPolicy_impl;
import org.apache.yoko.orb.OBMessageRouting.DecayPolicyFactory_impl;
import org.apache.yoko.orb.OBMessageRouting.ImmediateSuspendPolicyFactory_impl;
import org.apache.yoko.orb.OBMessageRouting.LimitedPingPolicyFactory_impl;
import org.apache.yoko.orb.OBMessageRouting.ResumePolicyFactory_impl;
import org.apache.yoko.orb.OBMessageRouting.UnlimitedPingPolicyFactory_impl;
import org.apache.yoko.orb.OBMessaging.ExceptionHolderFactory_impl;
import org.apache.yoko.orb.OBPortableInterceptor.IMRORTFactory_impl;
import org.apache.yoko.orb.OBPortableInterceptor.ORBInitInfo_impl;
import org.apache.yoko.orb.OBPortableInterceptor.PersistentORTFactory_impl;
import org.apache.yoko.orb.OBPortableInterceptor.TransientORTFactory_impl;
import org.apache.yoko.orb.OBPortableServer.POAManagerFactory_impl;
import org.apache.yoko.orb.OCI.AccFactoryRegistry_impl;
import org.apache.yoko.orb.OCI.ConFactoryRegistry_impl;
import org.apache.yoko.orb.OCI.Plugin;
import org.apache.yoko.orb.cmsf.CmsfClientInterceptor;
import org.apache.yoko.orb.cmsf.CmsfIORInterceptor;
import org.apache.yoko.orb.cmsf.CmsfServerInterceptor;
import org.apache.yoko.orb.yasf.YasfClientInterceptor;
import org.apache.yoko.orb.yasf.YasfIORInterceptor;
import org.apache.yoko.orb.yasf.YasfServerInterceptor;
import org.apache.yoko.osgi.ProviderLocator;
import org.apache.yoko.util.PrivilegedActions;
import org.apache.yoko.util.concurrent.AutoLock;
import org.apache.yoko.util.concurrent.AutoReadWriteLock;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ContainedPackage.Description;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDef;
import org.omg.CORBA.OperationDefHelper;
import org.omg.CORBA.OperationDescription;
import org.omg.CORBA.OperationDescriptionHelper;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.Request;
import org.omg.CORBA.ServiceDetail;
import org.omg.CORBA.ServiceInformation;
import org.omg.CORBA.ServiceInformationHolder;
import org.omg.CORBA.StringSeqHolder;
import org.omg.CORBA.ValueDef;
import org.omg.CORBA.ValueDefHelper;
import org.omg.CORBA.WrongTransaction;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedProfile;
import org.omg.MessageRouting.Router;
import org.omg.MessageRouting.RouterListHolder;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.portable.Delegate;

public class ORB_impl
extends ORBSingleton {
    private final Map<String, ORBInitializer> initializers = new Hashtable<String, ORBInitializer>();
    private ORBControl orbControl_;
    private final AutoReadWriteLock destroyLock_ = new AutoReadWriteLock();
    private boolean destroy_;
    private PluginManager pluginManager_;
    private ORBInstance orbInstance_;
    private final PolicyMap policies = new PolicyMap(new Policy[0]);
    private static OptionFilter orbOptionFilter_;
    private static OptionFilter oaOptionFilter_;
    private boolean raiseDIIExceptions_ = true;

    private void initialize(StringSeqHolder args, String orbId, String serverId, String serverInstance, int concModel, CoreTraceLevels coreTraceLevels, Properties properties, Logger logger, int nativeCs, int nativeWcs, int defaultWcs) {
        try (AutoLock writeLock = this.destroyLock_.getWriteLock();){
            Plugin plugin;
            String[] params;
            String name;
            ArrayList<String> paramList;
            this.destroy_ = false;
            this.orbControl_ = new ORBControl();
            this.pluginManager_ = new PluginManager((ORB)this);
            InitialServiceManager initServiceManager = new InitialServiceManager();
            ClientManager clientManager = new ClientManager(concModel);
            ObjectFactory objectFactory = new ObjectFactory();
            PolicyFactoryManager pfManager = new PolicyFactoryManager();
            PIManager piManager = new PIManager((ORB)this);
            ValueFactoryManager valueFactoryManager = new ValueFactoryManager();
            CodecFactory_impl codecFactory = new CodecFactory_impl();
            POAManagerFactory_impl pmFactory = new POAManagerFactory_impl();
            MultiRequestSender multiRequestSender = new MultiRequestSender();
            DispatchStrategyFactory_impl dsf = new DispatchStrategyFactory_impl();
            BootManager_impl bootManager = new BootManager_impl((ORB)this);
            ConFactoryRegistry_impl conFactoryRegistry = new ConFactoryRegistry_impl();
            AccFactoryRegistry_impl accFactoryRegistry = new AccFactoryRegistry_impl();
            UnknownExceptionStrategy_impl unknownExceptionStrategy = new UnknownExceptionStrategy_impl();
            URLRegistry_impl urlRegistry = new URLRegistry_impl();
            this.orbInstance_ = new ORBInstance((ORB)this, orbId, serverId, serverInstance, objectFactory, clientManager, pfManager, piManager, initServiceManager, valueFactoryManager, codecFactory, pmFactory, multiRequestSender, properties, dsf, bootManager, logger, coreTraceLevels, conFactoryRegistry, accFactoryRegistry, unknownExceptionStrategy, urlRegistry, nativeCs, nativeWcs, defaultWcs);
            objectFactory.setORBInstance(this.orbInstance_);
            initServiceManager.setORBInstance(this.orbInstance_);
            pmFactory._OB_setORBInstance(this.orbInstance_);
            piManager.setORBInstance(this.orbInstance_);
            codecFactory._OB_setORBInstance(this.orbInstance_);
            clientManager.setORBInstance(this.orbInstance_);
            dsf._OB_setORBInstance(this.orbInstance_);
            try {
                urlRegistry.add_scheme(new IORURLScheme_impl(this.orbInstance_));
                urlRegistry.add_scheme(new FileURLScheme_impl(false, urlRegistry));
                urlRegistry.add_scheme(new FileURLScheme_impl(true, urlRegistry));
                urlRegistry.add_scheme(new CorbalocURLScheme_impl(this.orbInstance_));
                urlRegistry.add_scheme(new CorbanameURLScheme_impl((ORB)this, urlRegistry));
            }
            catch (SchemeAlreadyExists ex) {
                throw Assert.fail((Throwable)((java.lang.Object)ex));
            }
            this.orbControl_.setORBInstance(this.orbInstance_);
            this.initializeDefaultPolicies();
            DynAnyFactory_impl dynAnyFactory = new DynAnyFactory_impl(this.orbInstance_);
            try {
                initServiceManager.addInitialReference("POAManagerFactory", (Object)pmFactory);
                initServiceManager.addInitialReference("DynAnyFactory", (Object)dynAnyFactory);
                initServiceManager.addInitialReference("CodecFactory", (Object)codecFactory);
                initServiceManager.addInitialReference("DispatchStrategyFactory", dsf);
                initServiceManager.addInitialReference("BootManager", bootManager);
                initServiceManager.addInitialReference("RootPOA", null);
                initServiceManager.addInitialReference("OCIConFactoryRegistry", conFactoryRegistry);
                initServiceManager.addInitialReference("OCIAccFactoryRegistry", accFactoryRegistry);
                initServiceManager.addInitialReference("URLRegistry", urlRegistry);
            }
            catch (InvalidName ex) {
                throw Assert.fail(ex);
            }
            String prop = properties.getProperty("yoko.oci.client", "iiop");
            int pos = 0;
            while (pos != -1) {
                paramList = new ArrayList<String>();
                pos = ParseParams.parse(prop, pos, paramList);
                name = (String)paramList.remove(0);
                params = paramList.toArray(new String[0]);
                plugin = this.pluginManager_.initPlugin(name, args);
                if (plugin == null) {
                    throw new INITIALIZE("OCI client initialization failed for '" + name + "'");
                }
                plugin.init_client(params);
            }
            prop = properties.getProperty("yoko.oci.server", "iiop");
            pos = 0;
            while (pos != -1) {
                paramList = new ArrayList();
                pos = ParseParams.parse(prop, pos, paramList);
                name = (String)paramList.remove(0);
                params = paramList.toArray(new String[0]);
                plugin = this.pluginManager_.initPlugin(name, args);
                if (plugin == null) {
                    String err = "OCI server initialization failed for '" + name + "'";
                    throw new INITIALIZE(err);
                }
                plugin.init_server(params);
            }
            try {
                piManager.addIORInterceptor((IORInterceptor)new CodeSetIORInterceptor_impl(nativeCs, nativeWcs), false);
            }
            catch (DuplicateName ex) {
                throw Assert.fail(ex);
            }
            try {
                piManager.addIORInterceptor(new YasfIORInterceptor(), true);
                piManager.addClientRequestInterceptor(new YasfClientInterceptor());
                piManager.addServerRequestInterceptor(new YasfServerInterceptor(piManager.allocateSlotId()));
            }
            catch (DuplicateName ex) {
                throw Assert.fail(ex);
            }
            try {
                piManager.addIORInterceptor(new CmsfIORInterceptor(), false);
                piManager.addClientRequestInterceptor(new CmsfClientInterceptor());
                piManager.addServerRequestInterceptor(new CmsfServerInterceptor(piManager.allocateSlotId()));
            }
            catch (DuplicateName ex) {
                throw Assert.fail(ex);
            }
            try {
                RouterListHolder routerListHolder = new RouterListHolder();
                routerListHolder.value = new Router[0];
                MessageRoutingUtil.getRouterListFromConfig(this.orbInstance_, routerListHolder);
                piManager.addIORInterceptor((IORInterceptor)new MessageRoutingIORInterceptor_impl(routerListHolder.value), false);
            }
            catch (DuplicateName ex) {
                throw Assert.fail(ex);
            }
            ExceptionHolderFactory_impl exhFactory = new ExceptionHolderFactory_impl();
            valueFactoryManager.registerValueFactory("IDL:omg.org/Messaging/ExceptionHolder:1.0", exhFactory);
            java.lang.Object routerAdminPolicyFactory = new ImmediateSuspendPolicyFactory_impl();
            valueFactoryManager.registerValueFactory("IDL:omg.org/MessageRouting/ImmediateSuspendPolicy:1.0", (ValueFactory)routerAdminPolicyFactory);
            routerAdminPolicyFactory = new UnlimitedPingPolicyFactory_impl();
            valueFactoryManager.registerValueFactory("IDL:omg.org/MessageRouting/UnlimitedPingPolicy:1.0", (ValueFactory)routerAdminPolicyFactory);
            routerAdminPolicyFactory = new LimitedPingPolicyFactory_impl();
            valueFactoryManager.registerValueFactory("IDL:omg.org/MessageRouting/LimitedPingPolicy:1.0", (ValueFactory)routerAdminPolicyFactory);
            routerAdminPolicyFactory = new DecayPolicyFactory_impl();
            valueFactoryManager.registerValueFactory("IDL:omg.org/MessageRouting/DecayPolicy:1.0", (ValueFactory)routerAdminPolicyFactory);
            routerAdminPolicyFactory = new ResumePolicyFactory_impl();
            valueFactoryManager.registerValueFactory("IDL:omg.org/MessageRouting/ResumePolicy:1.0", (ValueFactory)routerAdminPolicyFactory);
            java.lang.Object ortFactory = new TransientORTFactory_impl(this.orbInstance_);
            valueFactoryManager.registerValueFactory("IDL:orb.yoko.apache.org/OBPortableInterceptor/TransientORT:1.0", (ValueFactory)ortFactory);
            ortFactory = new PersistentORTFactory_impl(this.orbInstance_);
            valueFactoryManager.registerValueFactory("IDL:orb.yoko.apache.org/OBPortableInterceptor/PersistentORT:1.0", (ValueFactory)ortFactory);
            ortFactory = new IMRORTFactory_impl();
            valueFactoryManager.registerValueFactory("IDL:orb.yoko.apache.org/OBPortableInterceptor/IMRORT:1.0", (ValueFactory)ortFactory);
            this.instantiateORBInitializers(properties, logger);
            try {
                Properties sysProperties = System.getProperties();
                this.instantiateORBInitializers(sysProperties, logger);
            }
            catch (SecurityException sysProperties) {
                // empty catch block
            }
            if (!this.initializers.isEmpty()) {
                ORBInitInfo_impl info = new ORBInitInfo_impl((ORB)this, args.value, orbId, piManager, initServiceManager, codecFactory);
                for (ORBInitializer initializer : this.initializers.values()) {
                    initializer.pre_init((ORBInitInfo)info);
                }
                for (ORBInitializer initializer : this.initializers.values()) {
                    initializer.post_init((ORBInitInfo)info);
                }
                info._OB_destroy();
            }
            piManager.setupComplete();
        }
        catch (RuntimeException ex) {
            if (this.orbControl_ != null) {
                this.orbControl_.shutdownServerClient();
                this.orbControl_.destroy();
            }
            if (this.pluginManager_ != null) {
                this.pluginManager_.destroy();
            }
            if (this.orbInstance_ != null) {
                this.orbInstance_.destroy();
                this.orbInstance_ = null;
            }
            throw ex;
        }
    }

    protected void finalize() throws Throwable {
        if (this.orbInstance_ != null) {
            Logger logger = this.orbInstance_.getLogger();
            logger.fine("ORB.destroy() was not called. This may result in resource leaks.");
        }
        super.finalize();
    }

    private void initializeDefaultPolicies() {
        Logger logger = this.orbInstance_.getLogger();
        Properties properties = this.orbInstance_.getProperties();
        block71: for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith("yoko.orb.policy.")) continue;
            String value = properties.getProperty(key);
            switch (key) {
                case "yoko.orb.policy.protocol": {
                    StringTokenizer tokenizer = new StringTokenizer(value, ", ");
                    String[] seq = new String[tokenizer.countTokens()];
                    int n = 0;
                    while (tokenizer.hasMoreTokens()) {
                        seq[n++] = tokenizer.nextToken();
                    }
                    if (seq.length == 0) {
                        String err = "ORB.init: invalid value for yoko.orb.policy.protocol: `" + value + "'";
                        logger.severe(err);
                        throw new INITIALIZE(err);
                    }
                    this.policies.add(new ProtocolPolicy_impl(seq));
                    continue block71;
                }
                case "yoko.orb.policy.connection_reuse": {
                    String err;
                    boolean b;
                    if (value.equals("true")) {
                        b = true;
                    } else if (value.equals("false")) {
                        b = false;
                    } else {
                        err = "ORB.init: invalid value for yoko.orb.policy.connection_reuse: `" + value + "'";
                        logger.severe(err);
                        throw new INITIALIZE(err);
                    }
                    this.policies.add(new ConnectionReusePolicy_impl(b));
                    continue block71;
                }
                case "yoko.orb.policy.zero_port": {
                    boolean b;
                    String err;
                    if (value.equals("true")) {
                        b = true;
                    } else if (value.equals("false")) {
                        b = false;
                    } else {
                        err = "ORB.init: invalid value for yoko.orb.policy.zero_port: `" + value + "'";
                        logger.severe(err);
                        throw new INITIALIZE(err);
                    }
                    this.policies.add(new ZeroPortPolicy_impl(b));
                    continue block71;
                }
                case "yoko.orb.policy.retry": 
                case "yoko.orb.policy.retry.max": 
                case "yoko.orb.policy.retry.interval": 
                case "yoko.orb.policy.retry.remote": {
                    continue block71;
                }
                case "yoko.orb.policy.timeout": {
                    int val = Integer.parseInt(value);
                    if (val == -1) continue block71;
                    this.policies.add(new TimeoutPolicy_impl(val));
                    continue block71;
                }
                case "yoko.orb.policy.location_transparency": {
                    short val;
                    String err;
                    if (value.equals("strict")) {
                        val = 0;
                    } else if (value.equals("relaxed")) {
                        val = 1;
                    } else {
                        err = "ORB.init: invalid value for yoko.orb.policy.location_transparency: `" + value + "'";
                        logger.severe(err);
                        throw new INITIALIZE(err);
                    }
                    this.policies.add(new LocationTransparencyPolicy_impl(val));
                    continue block71;
                }
                case "yoko.orb.policy.interceptor": {
                    boolean b;
                    String err;
                    if (value.equals("true")) {
                        b = true;
                    } else if (value.equals("false")) {
                        b = false;
                    } else {
                        err = "ORB.init: invalid value for yoko.orb.policy.interceptor: `" + value + "'";
                        logger.severe(err);
                        throw new INITIALIZE(err);
                    }
                    this.policies.add(new InterceptorPolicy_impl(b));
                    continue block71;
                }
                case "yoko.orb.policy.connect_timeout": {
                    int val = Integer.parseInt(value);
                    if (val == -1) continue block71;
                    this.policies.add(new ConnectTimeoutPolicy_impl(val));
                    continue block71;
                }
                case "yoko.orb.policy.request_timeout": {
                    int val = Integer.parseInt(value);
                    if (val == -1) continue block71;
                    this.policies.add(new RequestTimeoutPolicy_impl(val));
                    continue block71;
                }
                case "yoko.orb.policy.reply_timeout": {
                    int val = Integer.parseInt(value);
                    if (val == -1) continue block71;
                    this.policies.add(new ReplyTimeoutPolicy_impl(val));
                    continue block71;
                }
                case "yoko.orb.policy.locate_request": {
                    boolean b;
                    String err;
                    if (value.equals("true")) {
                        b = true;
                    } else if (value.equals("false")) {
                        b = false;
                    } else {
                        err = "ORB.init: invalid value for yoko.orb.policy.locate_request: `" + value + "'";
                        logger.severe(err);
                        throw new INITIALIZE(err);
                    }
                    this.policies.add(new LocateRequestPolicy_impl(b));
                    continue block71;
                }
                case "yoko.orb.policy.rebind": {
                    short val;
                    switch (value) {
                        case "transparent": {
                            val = 0;
                            break;
                        }
                        case "no_rebind": {
                            val = 1;
                            break;
                        }
                        case "no_reconnect": {
                            val = 2;
                            break;
                        }
                        default: {
                            String err = "ORB.init: invalid value for yoko.orb.policy.rebind: `" + value + "'";
                            logger.severe(err);
                            throw new INITIALIZE(err);
                        }
                    }
                    this.policies.add((Policy)new RebindPolicy_impl(val));
                    continue block71;
                }
                case "yoko.orb.policy.sync_scope": {
                    short val;
                    switch (value) {
                        case "none": {
                            val = 0;
                            break;
                        }
                        case "transport": {
                            val = 1;
                            break;
                        }
                        case "server": {
                            val = 2;
                            break;
                        }
                        case "target": {
                            val = 3;
                            break;
                        }
                        default: {
                            String err = "ORB.init: invalid value for yoko.orb.policy.sync_scope: `" + value + "'";
                            logger.severe(err);
                            throw new INITIALIZE(err);
                        }
                    }
                    this.policies.add((Policy)new SyncScopePolicy_impl(val));
                    continue block71;
                }
            }
            String err = "ORB.init: unknown property `" + key + "'";
            logger.severe(err);
            throw new INITIALIZE(err);
        }
        if (properties.getProperty("yoko.orb.policy.connection_reuse") == null) {
            this.policies.add(new ConnectionReusePolicy_impl(true));
        }
        short retry_mode = 1;
        int retry_interval = 0;
        int max_retries = 1;
        boolean retry_remote = false;
        String value = properties.getProperty("yoko.orb.policy.retry");
        if (value != null) {
            switch (value) {
                case "never": {
                    retry_mode = 0;
                    break;
                }
                case "strict": {
                    retry_mode = 1;
                    break;
                }
                case "always": {
                    retry_mode = 2;
                    break;
                }
                default: {
                    String err = "ORB.init: invalid value for yoko.orb.policy.retry: `" + value + "'";
                    logger.severe(err);
                    throw new INITIALIZE(err);
                }
            }
        }
        if ((value = properties.getProperty("yoko.orb.policy.retry.interval")) != null) {
            try {
                retry_interval = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                String err = "ORB.init: invalid value for yoko.orb.policy.retry.interval: `" + value + "'";
                logger.log(Level.SEVERE, err, ex);
                throw new INITIALIZE(err);
            }
        }
        if ((value = properties.getProperty("yoko.orb.policy.retry.max")) != null) {
            try {
                max_retries = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                String err = "ORB.init: invalid value for yoko.orb.policy.retry.max: `" + value + "'";
                logger.log(Level.SEVERE, err, ex);
                throw new INITIALIZE(err);
            }
        }
        if ((value = properties.getProperty("yoko.orb.policy.retry.remote")) != null) {
            retry_remote = value.equals("true");
        }
        this.policies.add(new RetryPolicy_impl(retry_mode, retry_interval, max_retries, retry_remote));
        ORBPolicyManager_impl pm = new ORBPolicyManager_impl(this.policies);
        InitialServiceManager initServiceManager = this.orbInstance_.getInitialServiceManager();
        try {
            initServiceManager.addInitialReference("ORBPolicyManager", (Object)pm);
        }
        catch (InvalidName ex) {
            throw Assert.fail(ex);
        }
        ObjectFactory objectFactory = this.orbInstance_.getObjectFactory();
        objectFactory.setPolicyManager(pm);
        PolicyFactoryManager pfm = this.orbInstance_.getPolicyFactoryManager();
        ORBPolicyFactory_impl factory = new ORBPolicyFactory_impl();
        pfm.registerPolicyFactory(1330577411, factory, true);
        pfm.registerPolicyFactory(1330577419, factory, true);
        pfm.registerPolicyFactory(1330577410, factory, true);
        pfm.registerPolicyFactory(0x4F4F0004, factory, true);
        pfm.registerPolicyFactory(1330577413, factory, true);
        pfm.registerPolicyFactory(1330577414, factory, true);
        pfm.registerPolicyFactory(23, factory, true);
        pfm.registerPolicyFactory(24, factory, true);
        pfm.registerPolicyFactory(1330577415, factory, true);
        pfm.registerPolicyFactory(1330577416, factory, true);
        pfm.registerPolicyFactory(1330577417, factory, true);
        pfm.registerPolicyFactory(27, factory, true);
        pfm.registerPolicyFactory(28, factory, true);
        pfm.registerPolicyFactory(29, factory, true);
        pfm.registerPolicyFactory(30, factory, true);
        pfm.registerPolicyFactory(31, factory, true);
        pfm.registerPolicyFactory(32, factory, true);
        pfm.registerPolicyFactory(37, factory, true);
        pfm.registerPolicyFactory(25, factory, true);
        pfm.registerPolicyFactory(26, factory, true);
        pfm.registerPolicyFactory(33, factory, true);
        pfm.registerPolicyFactory(34, factory, true);
        pfm.registerPolicyFactory(35, factory, true);
    }

    private void instantiateORBInitializers(Properties properties, Logger logger) {
        String magic = "org.omg.PortableInterceptor.ORBInitializerClass.";
        for (String key : properties.stringPropertyNames()) {
            String className;
            if (!key.startsWith("org.omg.PortableInterceptor.ORBInitializerClass.") || this.initializers.containsKey(className = key.substring("org.omg.PortableInterceptor.ORBInitializerClass.".length()))) continue;
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class initClass = ProviderLocator.loadClass((String)className, ((java.lang.Object)((java.lang.Object)this)).getClass(), (ClassLoader)loader);
                this.initializers.put(className, (ORBInitializer)initClass.newInstance());
            }
            catch (ClassNotFoundException ex) {
                logger.log(Level.WARNING, "ORB.init: initializer class " + className + " not found", ex);
            }
            catch (InstantiationException ex) {
                logger.log(Level.WARNING, "ORB.init: error occurred while instantiating initializer class " + className, ex);
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.WARNING, "ORB.init: cannot access initializer class " + className, ex);
            }
        }
    }

    private static boolean loadConfigFile(String configFile, Properties properties, Logger logger) {
        boolean bl;
        InputStream in;
        try {
            URL url = new URL(configFile);
            in = url.openStream();
        }
        catch (MalformedURLException e) {
            in = new FileInputStream(configFile);
        }
        BufferedInputStream bin = new BufferedInputStream(in);
        try {
            properties.load(bin);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "ORB.init: could not load configuration file " + configFile, ex);
                return false;
            }
        }
        bin.close();
        return bl;
    }

    private static String[] parseAppletParams(Applet app) {
        String[] args = new String[]{};
        String paramList = app.getParameter("ORBparams");
        if (paramList != null) {
            StringTokenizer p = new StringTokenizer(paramList);
            args = new String[p.countTokens()];
            int i = 0;
            while (p.hasMoreTokens()) {
                args[i++] = p.nextToken();
            }
        }
        return args;
    }

    private void setParameters(StringSeqHolder args, Properties initialProps, Logger logger) {
        if (args.value == null) {
            args.value = new String[0];
        }
        if (logger == null) {
            logger = new Logger_impl();
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)(initialProps == null ? (Map)AccessController.doPrivileged(PrivilegedActions.GET_SYSPROPS_OR_EMPTY_MAP) : initialProps));
        args.value = ORB_impl.ParseArgs(args.value, properties, logger);
        String orbId = "";
        String serverId = "";
        String serverInstance = "";
        int concModel = 0;
        int nativeCs = CodeSetInfo.ISO_LATIN_1.id;
        int nativeWcs = CodeSetInfo.UTF_16.id;
        int defaultWcs = 0;
        for (String key : properties.stringPropertyNames()) {
            int csid;
            if (!key.startsWith("yoko.orb.")) continue;
            String value = properties.getProperty(key);
            Assert.ensure(value != null);
            if (key.equals("yoko.orb.conc_model")) {
                if (value.equals("threaded")) {
                    concModel = 2;
                    continue;
                }
                logger.warning("ORB.init: unknown value for yoko.orb.conc_model: " + value);
                continue;
            }
            if (key.startsWith("yoko.orb.trace.") || key.startsWith("yoko.orb.policy.")) continue;
            if (key.equals("yoko.orb.id")) {
                orbId = value;
                continue;
            }
            if (key.equals("yoko.orb.server_name")) {
                if (value.length() == 0 || !Character.isLetterOrDigit(value.charAt(0))) {
                    logger.severe("ORB.init: illegal value for yoko.orb.server_name: " + value);
                    throw new INITIALIZE("ORB.init: illegal value for yoko.orb.server_name: " + value);
                }
                serverId = value;
                continue;
            }
            if (key.equals("yoko.orb.server_instance")) {
                serverInstance = value;
                continue;
            }
            if (key.equals("yoko.orb.raise_dii_exceptions")) {
                if (value.equalsIgnoreCase("true")) {
                    this.raiseDIIExceptions_ = true;
                    continue;
                }
                this.raiseDIIExceptions_ = false;
                continue;
            }
            if (key.equals("yoko.orb.native_cs")) {
                csid = CodeSetInfo.getRegistryIdForName(value);
                if (csid != 0 && csid != CodeSetInfo.UTF_8.id) {
                    nativeCs = csid;
                    continue;
                }
                logger.severe("ORB.init: unknown value for yoko.orb.native_cs: " + value);
                throw new INITIALIZE("ORB.init: unknown value for yoko.orb.native_cs: " + value);
            }
            if (key.equals("yoko.orb.native_wcs")) {
                csid = CodeSetInfo.getRegistryIdForName(value);
                if (csid != 0 && csid != CodeSetInfo.UTF_8.id) {
                    nativeWcs = csid;
                    continue;
                }
                logger.severe("ORB.init: unknown value for yoko.orb.native_wcs: " + value);
                throw new INITIALIZE("ORB.init: unknown value for yoko.orb.native_wcs: " + value);
            }
            if (key.equals("yoko.orb.default_wcs")) {
                csid = CodeSetInfo.getRegistryIdForName(value);
                if (csid != 0 && csid != CodeSetInfo.UTF_8.id) {
                    defaultWcs = csid;
                    continue;
                }
                logger.severe("ORB.init: unknown value for yoko.orb.default_wcs: " + value);
                throw new INITIALIZE("ORB.init: unknown value for yoko.orb.default_wcs: " + value);
            }
            if (key.equals("yoko.orb.extended_wchar")) {
                if (value.equals("true") || value.equals("false")) continue;
                logger.severe("ORB.init: unknown value for yoko.orb.extended_wchar: " + value);
                throw new INITIALIZE("ORB.init: unknown value for yoko.orb.extended_wchar: " + value);
            }
            if (key.equals("yoko.orb.default_init_ref")) {
                if (value.length() != 0) continue;
                logger.warning("ORB.init: invalid value for yoko.orb.default_init_ref");
                continue;
            }
            if (key.equals("yoko.orb.server_timeout") || key.equals("yoko.orb.server_shutdown_timeout") || key.equals("yoko.orb.client_timeout") || key.equals("yoko.orb.client_shutdown_timeout") || key.startsWith("yoko.orb.service.") || key.startsWith("yoko.orb.oa.") || key.startsWith("yoko.orb.poamanager.") || key.equals("yoko.orb.noIMR")) continue;
            if (key.equals("yoko.orb.use_type_code_cache")) {
                if (value.equals("true") || value.equals("false")) continue;
                logger.severe("ORB.init: unknown value for yoko.orb.use_type_code_cache: " + value);
                throw new INITIALIZE("ORB.init: unknown value for yoko.orb.use_type_code_cache: " + value);
            }
            if (key.equals("yoko.orb.giop.max_message_size")) {
                try {
                    int max = Integer.parseInt(value);
                    GIOPIncomingMessage.setMaxMessageSize(max);
                    GIOPOutgoingMessage.setMaxMessageSize(max);
                    continue;
                }
                catch (NumberFormatException ex) {
                    logger.log(Level.SEVERE, "ORB.init: invalid value for yoko.orb.giop.max_message_size: " + value, ex);
                    throw new INITIALIZE("ORB.init: invalid value for yoko.orb.giop.max_message_size: " + value);
                }
            }
            if (key.equals("yoko.orb.ami_workers")) continue;
            logger.warning("ORB.init: unknown property `" + key + "'");
        }
        CoreTraceLevels coreTraceLevels = new CoreTraceLevels(logger, properties);
        this.initialize(args, orbId, serverId, serverInstance, concModel, coreTraceLevels, properties, logger, nativeCs, nativeWcs, defaultWcs);
    }

    @Override
    public String[] list_initial_services() {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            String[] stringArray = this.orbInstance_.getInitialServiceManager().listInitialServices();
            return stringArray;
        }
    }

    @Override
    public Object resolve_initial_references(String identifier) throws InvalidName {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            InitialServiceManager initServiceManager = this.orbInstance_.getInitialServiceManager();
            try {
                Object object = initServiceManager.resolveInitialReferences(identifier);
                return object;
            }
            catch (InvalidName ex) {
                block11: {
                    Object object;
                    block12: {
                        if (!identifier.equals("RootPOA")) break block11;
                        this.orbControl_.initializeRootPOA((ORB)this);
                        object = this.resolve_initial_references(identifier);
                        if (readLock == null) break block12;
                        readLock.close();
                    }
                    return object;
                }
                throw ex;
            }
        }
    }

    @Override
    public void register_initial_reference(String name, Object obj) throws InvalidName {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            this.orbInstance_.getInitialServiceManager().addInitialReference(name, obj);
        }
    }

    @Override
    public String object_to_string(Object p) {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            IOR ior;
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            if (p == null) {
                ior = new IOR("", new TaggedProfile[0]);
            } else {
                if (p instanceof LocalObject) {
                    throw new MARSHAL(MinorCodes.describeMarshal(1330446340), 1330446340, CompletionStatus.COMPLETED_NO);
                }
                org.apache.yoko.orb.CORBA.Delegate delegate = (org.apache.yoko.orb.CORBA.Delegate)((ObjectImpl)p)._get_delegate();
                ior = delegate._OB_origIOR();
            }
            OutputStream out = new OutputStream();
            try {
                out._OB_writeEndian();
                IORHelper.write((org.omg.CORBA.portable.OutputStream)out, (IOR)ior);
                String string = "IOR:" + out.writtenBytesToAscii();
                out.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @Override
    public Object string_to_object(String ior) {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            Object object = this.orbInstance_.getObjectFactory().stringToObject(ior);
            return object;
        }
    }

    @Override
    public org.omg.CORBA.NVList create_list(int count) {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            if (count < 0) {
                count = 0;
            }
            NVList nVList = new NVList((ORB)this, count);
            return nVList;
        }
    }

    @Override
    public org.omg.CORBA.NVList create_operation_list(OperationDef oper) {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            Description d = oper.describe();
            OperationDescription desc = OperationDescriptionHelper.extract((Any)d.value);
            NVList list = new NVList((ORB)this);
            for (int i = 0; i < desc.parameters.length; ++i) {
                ParameterDescription par = desc.parameters[i];
                Any any = this.create_any();
                any.type(par.type);
                int flags = 0;
                switch (par.mode.value()) {
                    case 0: {
                        flags = 1;
                        break;
                    }
                    case 1: {
                        flags = 2;
                        break;
                    }
                    case 2: {
                        flags = 3;
                        break;
                    }
                    default: {
                        throw Assert.fail();
                    }
                }
                list.add_value(par.name, any, flags);
            }
            NVList nVList = list;
            return nVList;
        }
    }

    @Override
    public org.omg.CORBA.NVList create_operation_list(Object oper) {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            OperationDef def = OperationDefHelper.narrow((Object)oper);
            org.omg.CORBA.NVList nVList = this.create_operation_list(def);
            return nVList;
        }
    }

    @Override
    public org.omg.CORBA.NamedValue create_named_value(String name, Any value, int flags) {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            NamedValue namedValue = new NamedValue(name, value, flags);
            return namedValue;
        }
    }

    @Override
    public ExceptionList create_exception_list() {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            org.apache.yoko.orb.CORBA.ExceptionList exceptionList = new org.apache.yoko.orb.CORBA.ExceptionList();
            return exceptionList;
        }
    }

    @Override
    public org.omg.CORBA.ContextList create_context_list() {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            ContextList contextList = new ContextList();
            return contextList;
        }
    }

    @Override
    public org.omg.CORBA.Context get_default_context() {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            Context context = new Context((ORB)this, "");
            return context;
        }
    }

    @Override
    public org.omg.CORBA.Environment create_environment() {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            Environment environment = new Environment();
            return environment;
        }
    }

    @Override
    public void send_multiple_requests_oneway(Request[] requests) {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            MultiRequestSender multi = this.orbInstance_.getMultiRequestSender();
            multi.sendMultipleRequestsOneway(requests);
        }
    }

    @Override
    public void send_multiple_requests_deferred(Request[] requests) {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            MultiRequestSender multi = this.orbInstance_.getMultiRequestSender();
            multi.sendMultipleRequestsDeferred(requests);
        }
    }

    @Override
    public boolean poll_next_response() {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            MultiRequestSender multi = this.orbInstance_.getMultiRequestSender();
            boolean bl = multi.pollNextResponse();
            return bl;
        }
    }

    @Override
    public Request get_next_response() throws WrongTransaction {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            MultiRequestSender multi = this.orbInstance_.getMultiRequestSender();
            Request request = multi.getNextResponse();
            return request;
        }
    }

    public boolean get_service_information(short service_type, ServiceInformationHolder service_info) {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            service_info.value = new ServiceInformation();
            service_info.value.service_options = new int[0];
            service_info.value.service_details = new ServiceDetail[0];
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean work_pending() {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            Thread.yield();
            boolean bl = this.orbControl_.workPending();
            return bl;
        }
    }

    @Override
    public void perform_work() {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            this.orbControl_.performWork();
        }
    }

    @Override
    public void run() {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            this.orbControl_.run();
        }
    }

    @Override
    public void shutdown(boolean wait_for_completion) {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            this.orbControl_.shutdownServer(wait_for_completion);
        }
    }

    @Override
    public void destroy() {
        try (AutoLock writelock = this.destroyLock_.getWriteLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            this.orbControl_.shutdownServerClient();
            this.orbControl_.destroy();
            this.orbInstance_.destroy();
            this.orbInstance_ = null;
            this.pluginManager_.destroy();
            this.pluginManager_ = null;
            this.destroy_ = true;
        }
    }

    @Override
    public org.omg.CORBA.portable.OutputStream create_output_stream() {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            OutputStream out = new OutputStream();
            out._OB_ORBInstance(this.orbInstance_);
            OutputStream outputStream = out;
            return outputStream;
        }
    }

    public Object get_value_def(String repid) throws BAD_PARAM {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            block11: {
                if (this.destroy_) {
                    throw new OBJECT_NOT_EXIST("ORB is destroyed");
                }
                try {
                    Object obj = this.resolve_initial_references("InterfaceRepository");
                    Repository repository = RepositoryHelper.narrow((Object)obj);
                    Contained cont = repository.lookup_id(repid);
                    if (cont == null) break block11;
                    ValueDef valueDef = ValueDefHelper.narrow((Object)cont);
                    return valueDef;
                }
                catch (InvalidName ex) {
                    throw (BAD_PARAM)new BAD_PARAM("Repository lookup failed for " + repid).initCause((Throwable)ex);
                }
            }
            throw new BAD_PARAM("Repository lookup failed for " + repid);
        }
    }

    public void set_delegate(java.lang.Object wrapper) {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            Servant servant = (Servant)wrapper;
            servant._set_delegate((Delegate)new org.apache.yoko.orb.PortableServer.Delegate((ORB)this));
        }
        catch (ClassCastException ex) {
            throw (BAD_PARAM)new BAD_PARAM("Argument is not of type org.omg.PortableServer.Servant").initCause((Throwable)ex);
        }
    }

    @Override
    protected void set_parameters(String[] args, Properties properties) {
        this.setParameters(new StringSeqHolder(args), properties, null);
    }

    @Override
    protected void set_parameters(Applet app, Properties properties) {
        String[] args = ORB_impl.parseAppletParams(app);
        this.setParameters(new StringSeqHolder(args), properties, null);
    }

    public static ORB init(String[] args, Properties props, Logger logger) {
        return ORB_impl.init(new StringSeqHolder(args), props, logger);
    }

    public static ORB init(StringSeqHolder args, Properties props, Logger logger) {
        ORB_impl orb;
        block7: {
            String propName = "org.omg.CORBA.ORBClass";
            String orbClassName = null;
            try {
                orb = (ORB_impl)((java.lang.Object)ProviderLocator.getService((String)"org.omg.CORBA.ORBClass", ORB_impl.class, (ClassLoader)Thread.currentThread().getContextClassLoader()));
                if (orb != null) break block7;
                if (props != null) {
                    orbClassName = props.getProperty("org.omg.CORBA.ORBClass");
                }
                try {
                    if (orbClassName == null) {
                        orbClassName = (String)AccessController.doPrivileged(PrivilegedActions.getSysProp((String)"org.omg.CORBA.ORBClass"));
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (orbClassName == null) {
                    orbClassName = "org.apache.yoko.orb.CORBA.ORB";
                }
                orb = (ORB_impl)((java.lang.Object)ProviderLocator.loadClass((String)orbClassName, ORB_impl.class, (ClassLoader)Thread.currentThread().getContextClassLoader()).newInstance());
            }
            catch (Throwable ex) {
                throw (INITIALIZE)new INITIALIZE("Invalid ORB class: " + orbClassName + '\n' + ex.getMessage()).initCause(ex);
            }
        }
        orb.setParameters(args, props, logger);
        return orb;
    }

    public static ORB init(Applet app, Properties props, Logger logger) {
        ORB_impl orb;
        block7: {
            String propName = "org.omg.CORBA.ORBClass";
            String orbClassName = null;
            try {
                orb = (ORB_impl)((java.lang.Object)ProviderLocator.getService((String)"org.omg.CORBA.ORBClass", ORB_impl.class, (ClassLoader)Thread.currentThread().getContextClassLoader()));
                if (orb != null) break block7;
                if (props != null) {
                    orbClassName = props.getProperty("org.omg.CORBA.ORBClass");
                }
                try {
                    if (orbClassName == null) {
                        orbClassName = (String)AccessController.doPrivileged(PrivilegedActions.getSysProp((String)"org.omg.CORBA.ORBClass"));
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (orbClassName == null) {
                    orbClassName = "org.apache.yoko.orb.CORBA.ORB";
                }
                orb = (ORB_impl)((java.lang.Object)ProviderLocator.loadClass((String)orbClassName, ORB_impl.class, (ClassLoader)Thread.currentThread().getContextClassLoader()).newInstance());
            }
            catch (Throwable ex) {
                throw (INITIALIZE)new INITIALIZE("Invalid ORB class: " + orbClassName + '\n' + ex.getMessage()).initCause(ex);
            }
        }
        String[] args = ORB_impl.parseAppletParams(app);
        orb.setParameters(new StringSeqHolder(args), props, logger);
        return orb;
    }

    public static String[] ParseArgs(String[] args, Properties properties, Logger logger) {
        String[] value;
        String name;
        OptionFilter.Option[] options;
        if (logger == null) {
            logger = new Logger_impl();
        }
        String yokoConfig = properties.getProperty("yoko.config");
        String yokoConfigLoaded = properties.getProperty("yoko.config_loaded");
        if (yokoConfig != null && yokoConfigLoaded == null && ORB_impl.loadConfigFile(yokoConfig, properties, logger)) {
            properties.put("yoko.config_loaded", "true");
        }
        if (orbOptionFilter_ == null) {
            orbOptionFilter_ = new OptionFilter("ORB.init", "-ORB");
            orbOptionFilter_.add("id", 1);
            orbOptionFilter_.add("service", 2);
            orbOptionFilter_.add("InitRef", 1);
            orbOptionFilter_.add("DefaultInitRef", 1);
            orbOptionFilter_.add("property", 1);
            orbOptionFilter_.add("repository", 1);
            orbOptionFilter_.add("naming", 1);
            orbOptionFilter_.add("config", 1);
            orbOptionFilter_.add("threaded", 0);
            orbOptionFilter_.add("version", 0);
            orbOptionFilter_.add("native_cs", 1);
            orbOptionFilter_.add("native_wcs", 1);
            orbOptionFilter_.add("default_wcs", 1);
            orbOptionFilter_.add("ServerId", 1);
            orbOptionFilter_.add("register", 1);
            orbOptionFilter_.add("ListenEndpoints", 1);
            orbOptionFilter_.add("NoProprietaryAction", 0);
            orbOptionFilter_.add("server_instance", 1);
            orbOptionFilter_.add("trace_connections", 1);
            orbOptionFilter_.add("trace_requests", 1);
            orbOptionFilter_.add("trace_requests_in", 1);
            orbOptionFilter_.add("trace_requests_out", 1);
            orbOptionFilter_.add("trace_retry", 1);
            orbOptionFilter_.add("_AmiWorkers", 1);
        }
        if (oaOptionFilter_ == null) {
            oaOptionFilter_ = new OptionFilter("ORB.init", "-OA");
            oaOptionFilter_.add("host", 1);
            oaOptionFilter_.add("port", 1);
            oaOptionFilter_.add("numeric", 0);
            oaOptionFilter_.add("version", 1);
            oaOptionFilter_.add("threaded", 0);
            oaOptionFilter_.add("thread_per_client", 0);
            oaOptionFilter_.add("thread_per_request", 0);
            oaOptionFilter_.add("thread_pool", 1);
        }
        String configFile = null;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals("-ORBconfig")) continue;
                if (i + 1 >= args.length) {
                    String msg = "ORB.init: argument expected for -ORBconfig";
                    logger.severe(msg);
                    throw new INITIALIZE(msg);
                }
                configFile = args[i + 1];
                break;
            }
        }
        if (configFile != null && configFile.length() > 0) {
            ORB_impl.loadConfigFile(configFile, properties, logger);
        }
        if (properties.getProperty("yoko.orb.conc_model") == null) {
            properties.put("yoko.orb.conc_model", "threaded");
        }
        if (properties.getProperty("yoko.orb.oa.conc_model") == null) {
            properties.put("yoko.orb.oa.conc_model", "thread_per_request");
        }
        if (properties.getProperty("yoko.orb.ami_workers") == null) {
            properties.put("yoko.orb.ami_workers", "1");
        }
        block67: for (OptionFilter.Option item : options = orbOptionFilter_.parse(logger, args)) {
            name = item.name;
            value = item.value;
            switch (name) {
                case "id": {
                    properties.put("yoko.orb.id", value[0]);
                    continue block67;
                }
                case "register": 
                case "ServerId": 
                case "server_name": {
                    properties.put("yoko.orb.server_name", value[0]);
                    continue block67;
                }
                case "server_instance": {
                    properties.put("yoko.orb.server_instance", value[0]);
                    continue block67;
                }
                case "ListenEndpoints": {
                    properties.put("yoko.orb.oa.endpoint", value[0]);
                    continue block67;
                }
                case "NoProprietaryAction": {
                    properties.put("yoko.orb.noIMR", "true");
                    continue block67;
                }
                case "service": {
                    properties.put("yoko.orb.service." + value[0], value[1]);
                    continue block67;
                }
                case "InitRef": {
                    int n = value[0].indexOf(61);
                    if (n <= 0 || value[0].length() == n + 1) {
                        logger.severe("ORB.init: invalid value for -ORBInitRef");
                        throw new INITIALIZE();
                    }
                    String svc = value[0].substring(0, n);
                    String url = value[0].substring(n + 1);
                    properties.put("yoko.orb.service." + svc, url);
                    continue block67;
                }
                case "DefaultInitRef": {
                    properties.put("yoko.orb.default_init_ref", value[0]);
                    continue block67;
                }
                case "property": {
                    int n = value[0].indexOf(61);
                    if (n <= 0 || value[0].length() == n + 1) {
                        logger.severe("ORB.init: invalid value for -ORBproperty");
                        throw new INITIALIZE();
                    }
                    String propName = value[0].substring(0, n);
                    String propValue = value[0].substring(n + 1);
                    properties.put(propName, propValue);
                    continue block67;
                }
                case "repository": {
                    properties.put("yoko.orb.service.InterfaceRepository", value[0]);
                    continue block67;
                }
                case "naming": {
                    properties.put("yoko.orb.service.NameService", value[0]);
                    continue block67;
                }
                case "trace_connections": 
                case "trace_retry": 
                case "trace_requests": 
                case "trace_requests_in": 
                case "trace_requests_out": {
                    String prop = "yoko.orb.trace.";
                    prop = prop + name.substring(6);
                    properties.put(prop, value[0]);
                    continue block67;
                }
                case "threaded": {
                    properties.put("yoko.orb.conc_model", "threaded");
                    continue block67;
                }
                case "version": {
                    logger.info(Version.getVersion());
                    continue block67;
                }
                case "native_cs": {
                    properties.put("yoko.orb.native_cs", value[0]);
                    continue block67;
                }
                case "native_wcs": {
                    properties.put("yoko.orb.native_wcs", value[0]);
                    continue block67;
                }
                case "default_wcs": {
                    properties.put("yoko.orb.default_wcs", value[0]);
                    continue block67;
                }
                case "_AmiWorkers": {
                    properties.put("yoko.orb.ami_workers", value[0]);
                }
            }
        }
        block68: for (OptionFilter.Option option : options = oaOptionFilter_.parse(logger, args)) {
            name = option.name;
            value = option.value;
            switch (name) {
                case "host": {
                    properties.put("yoko.iiop.host", value[0]);
                    continue block68;
                }
                case "port": {
                    properties.put("yoko.iiop.port", value[0]);
                    continue block68;
                }
                case "numeric": {
                    properties.put("yoko.iiop.numeric", "true");
                    continue block68;
                }
                case "version": {
                    properties.put("yoko.orb.oa.version", value[0]);
                    continue block68;
                }
                case "threaded": {
                    properties.put("yoko.orb.oa.conc_model", "threaded");
                    continue block68;
                }
                case "thread_per_client": {
                    properties.put("yoko.orb.oa.conc_model", "thread_per_client");
                    continue block68;
                }
                case "thread_per_request": {
                    properties.put("yoko.orb.oa.conc_model", "thread_per_request");
                    continue block68;
                }
                case "thread_pool": {
                    properties.put("yoko.orb.oa.conc_model", "thread_pool");
                    properties.put("yoko.orb.oa.thread_pool", value[0]);
                }
            }
        }
        args = orbOptionFilter_.filter(args);
        args = oaOptionFilter_.filter(args);
        return args;
    }

    @Override
    public Policy create_policy(int type, Any any) throws PolicyError {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            Policy policy = this.orbInstance_.getPolicyFactoryManager().createPolicy(type, any);
            return policy;
        }
    }

    public ValueFactory register_value_factory(String id, ValueFactory factory) {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            ValueFactoryManager valueFactoryManager = this.orbInstance_.getValueFactoryManager();
            ValueFactory valueFactory = valueFactoryManager.registerValueFactory(id, factory);
            return valueFactory;
        }
    }

    public void unregister_value_factory(String id) {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            ValueFactoryManager valueFactoryManager = this.orbInstance_.getValueFactoryManager();
            valueFactoryManager.unregisterValueFactory(id);
        }
    }

    public ValueFactory lookup_value_factory(String id) {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            ValueFactoryManager valueFactoryManager = this.orbInstance_.getValueFactoryManager();
            ValueFactory valueFactory = valueFactoryManager.lookupValueFactory(id);
            return valueFactory;
        }
    }

    public Properties properties() {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            Properties properties = this.orbInstance_.getProperties();
            return properties;
        }
    }

    public Logger logger() {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            Logger logger = this.orbInstance_.getLogger();
            return logger;
        }
    }

    public UnknownExceptionStrategy set_unknown_exception_strategy(UnknownExceptionStrategy strategy) {
        try (AutoLock readLock = this.destroyLock_.getReadLock();){
            if (this.destroy_) {
                throw new OBJECT_NOT_EXIST("ORB is destroyed");
            }
            UnknownExceptionStrategy unknownExceptionStrategy = this.orbInstance_.setUnknownExceptionStrategy(strategy);
            return unknownExceptionStrategy;
        }
    }

    public boolean _OB_raiseDIIExceptions() {
        return this.raiseDIIExceptions_;
    }

    @Override
    public ORBInstance _OB_ORBInstance() {
        return this.orbInstance_;
    }
}

