/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import org.apache.yoko.orb.OB.CodeSetInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.portable.InputStream;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SECIOP_SEC_TRANS;
import org.omg.CSIIOP.SECIOP_SEC_TRANSHelper;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.CSIIOP.TransportAddress;
import org.omg.IOP.TaggedComponent;

public final class IORUtil {
    private static final char[] HEX_DIGIT = "0123456789abcdef".toCharArray();
    private static final int PRINTABLE_CHAR_LOW = 31;
    private static final int PRINTABLE_CHAR_HIGH = 127;

    public static void main(String ... args) {
        byte[] ba = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
        System.out.println("----");
        StringBuilder sb = new StringBuilder(200);
        for (int i = 0; i < 16; ++i) {
            IORUtil.dump_octets(ba, i, 32, sb);
            System.out.println(sb.toString());
            System.out.println("----");
            sb.setLength(0);
        }
    }

    private static void describeCSISecMechList(TaggedComponent component, StringBuilder sb) {
        org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
        in._OB_readEndian();
        CompoundSecMechList info = CompoundSecMechListHelper.read((InputStream)in);
        sb.append("CSI Security Mechanism List Components:\n");
        sb.append("    stateful: " + info.stateful + "\n");
        sb.append("    mechanism_list:\n");
        for (CompoundSecMech mech : info.mechanism_list) {
            sb.append("        target_requires: ");
            IORUtil.describeTransportFlags(mech.target_requires, sb);
            sb.append("\n");
            if (mech.transport_mech != null) {
                if (mech.transport_mech.tag == 34) {
                    sb.append("            Null Transport\n");
                } else if (mech.transport_mech.tag == 36) {
                    IORUtil.describeTLS_SEC_TRANS(mech.transport_mech, sb);
                } else if (mech.transport_mech.tag == 35) {
                    IORUtil.describeSECIOP_SEC_TRANS(mech.transport_mech, sb);
                }
            }
            if (mech.as_context_mech != null) {
                sb.append("            as_context_mech:\n");
                sb.append("                supports: ");
                IORUtil.describeTransportFlags(mech.as_context_mech.target_supports, sb);
                sb.append("\n");
                sb.append("                requires: ");
                IORUtil.describeTransportFlags(mech.as_context_mech.target_requires, sb);
                sb.append("\n");
                sb.append("                client_authentication_mech: ");
                IORUtil.format_octets(mech.as_context_mech.client_authentication_mech, sb);
                sb.append("\n");
                sb.append("                target_name: ");
                IORUtil.format_octets(mech.as_context_mech.target_name, sb);
                sb.append("\n");
            }
            if (mech.sas_context_mech == null) continue;
            sb.append("            sas_context_mech:\n");
            sb.append("                supports: ");
            IORUtil.describeTransportFlags(mech.sas_context_mech.target_supports, sb);
            sb.append("\n");
            sb.append("                requires: ");
            IORUtil.describeTransportFlags(mech.sas_context_mech.target_requires, sb);
            sb.append("\n");
            sb.append("                privilege_authorities:\n");
            for (ServiceConfiguration auth : mech.sas_context_mech.privilege_authorities) {
                sb.append("                    syntax: " + auth.syntax + "\n");
                sb.append("                    name: ");
                IORUtil.format_octets(auth.name, sb);
                sb.append("\n");
            }
            sb.append("                supported_naming_mechanisms:\n");
            for (byte[] namingMech : mech.sas_context_mech.supported_naming_mechanisms) {
                sb.append("                    ");
                IORUtil.format_octets(namingMech, sb);
                sb.append("\n");
            }
            sb.append("                supported_identity_type: ");
            IORUtil.describeIdentityToken(mech.sas_context_mech.supported_identity_types, sb);
            sb.append("\n");
        }
    }

    private static void describeTransportFlags(int flag, StringBuilder sb) {
        if ((1 & flag) != 0) {
            sb.append("NoProtection ");
        }
        if ((2 & flag) != 0) {
            sb.append("Integrity ");
        }
        if ((4 & flag) != 0) {
            sb.append("Confidentiality ");
        }
        if ((8 & flag) != 0) {
            sb.append("DetectReplay ");
        }
        if ((0x10 & flag) != 0) {
            sb.append("DetectMisordering ");
        }
        if ((0x20 & flag) != 0) {
            sb.append("EstablishTrustInTarget ");
        }
        if ((0x40 & flag) != 0) {
            sb.append("EstablishTrustInClient ");
        }
        if ((0x80 & flag) != 0) {
            sb.append("NoDelegation ");
        }
        if ((0x100 & flag) != 0) {
            sb.append("SimpleDelegation ");
        }
        if ((0x200 & flag) != 0) {
            sb.append("CompositeDelegation ");
        }
        if ((0x400 & flag) != 0) {
            sb.append("IdentityAssertion ");
        }
        if ((0x800 & flag) != 0) {
            sb.append("DelegationByClient ");
        }
    }

    private static void describeIdentityToken(int flag, StringBuilder sb) {
        if (flag == 0) {
            sb.append("Absent");
            return;
        }
        if ((1 & flag) != 0) {
            sb.append("Anonymous ");
        }
        if ((2 & flag) != 0) {
            sb.append("PrincipalName ");
        }
        if ((4 & flag) != 0) {
            sb.append("X509CertChain ");
        }
        if ((8 & flag) != 0) {
            sb.append("DistinguishedName ");
        }
    }

    private static void describeTLS_SEC_TRANS(TaggedComponent component, StringBuilder sb) {
        org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
        in._OB_readEndian();
        TLS_SEC_TRANS info = TLS_SEC_TRANSHelper.read((InputStream)in);
        sb.append("        TLS_SEC_TRANS component:\n");
        sb.append("            target_supports: ");
        IORUtil.describeTransportFlags(info.target_supports, sb);
        sb.append("\n");
        sb.append("            target_requires: ");
        IORUtil.describeTransportFlags(info.target_requires, sb);
        sb.append("\n");
        sb.append("            addresses:\n");
        for (TransportAddress address : info.addresses) {
            sb.append("                host_name: ").append(address.host_name).append("\n");
            sb.append("                port: ").append(address.port).append("\n");
        }
    }

    private static void describeSECIOP_SEC_TRANS(TaggedComponent component, StringBuilder sb) {
        org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
        in._OB_readEndian();
        SECIOP_SEC_TRANS info = SECIOP_SEC_TRANSHelper.read((InputStream)in);
        sb.append("        SECIOP_SEC_TRANS component:\n");
        sb.append("            target_supports: ");
        IORUtil.describeTransportFlags(info.target_supports, sb);
        sb.append("\n");
        sb.append("            target_requires: ");
        IORUtil.describeTransportFlags(info.target_requires, sb);
        sb.append("\n");
        sb.append("            mech_oid: ");
        IORUtil.format_octets(info.mech_oid, sb);
        sb.append("\n");
        sb.append("            target_name: ");
        IORUtil.format_octets(info.target_name, sb);
        sb.append("\n");
        sb.append("            addresses:\n");
        for (TransportAddress address : info.addresses) {
            sb.append("                host_name: ").append(address.host_name).append("\n");
            sb.append("                port: ").append(address.port).append("\n");
        }
    }

    private static void describeCodeSets(TaggedComponent component, StringBuilder sb) {
        int i;
        org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
        in._OB_readEndian();
        CodeSetComponentInfo info = CodeSetComponentInfoHelper.read((InputStream)in);
        sb.append("Native char codeset: \n");
        CodeSetInfo charInfo = CodeSetInfo.forRegistryId(info.ForCharData.native_code_set);
        if (charInfo != null) {
            sb.append("  \"");
            sb.append(charInfo.description);
            sb.append("\"\n");
        } else if (info.ForCharData.native_code_set == 0) {
            sb.append("  [No codeset information]\n");
        } else {
            sb.append("  [Unknown codeset id: ");
            sb.append(info.ForCharData.native_code_set);
            sb.append("]\n");
        }
        for (i = 0; i < info.ForCharData.conversion_code_sets.length; ++i) {
            if (i == 0) {
                sb.append("Char conversion codesets:\n");
            }
            if ((charInfo = CodeSetInfo.forRegistryId(info.ForCharData.conversion_code_sets[i])) != null) {
                sb.append("  \"");
                sb.append(charInfo.description);
                sb.append("\"\n");
                continue;
            }
            sb.append("  [Unknown codeset id: ");
            sb.append(info.ForCharData.conversion_code_sets[i]);
            sb.append("]\n");
        }
        sb.append("Native wchar codeset: \n");
        charInfo = CodeSetInfo.forRegistryId(info.ForWcharData.native_code_set);
        if (charInfo != null) {
            sb.append("  \"");
            sb.append(charInfo.description);
            sb.append("\"\n");
        } else if (info.ForWcharData.native_code_set == 0) {
            sb.append("  [No codeset information]\n");
        } else {
            sb.append("  [Unknown codeset id: ");
            sb.append(info.ForWcharData.native_code_set);
            sb.append("]\n");
        }
        for (i = 0; i < info.ForWcharData.conversion_code_sets.length; ++i) {
            if (i == 0) {
                sb.append("Wchar conversion codesets:\n");
            }
            if ((charInfo = CodeSetInfo.forRegistryId(info.ForWcharData.conversion_code_sets[i])) != null) {
                sb.append("  \"");
                sb.append(charInfo.description);
                sb.append("\"\n");
                continue;
            }
            sb.append("  [Unknown codeset id: ");
            sb.append(info.ForWcharData.conversion_code_sets[i]);
            sb.append("]\n");
        }
    }

    private static void describeGenericComponent(TaggedComponent component, String name, StringBuilder sb) {
        sb.append("Component: ");
        sb.append(name);
        sb.append('\n');
        sb.append("Component data: (");
        sb.append(component.component_data.length);
        sb.append(")\n");
        IORUtil.dump_octets(component.component_data, 0, component.component_data.length, sb);
    }

    public static String dump_octets(byte[] oct) {
        StringBuilder sb = new StringBuilder();
        IORUtil.dump_octets(oct, 0, oct.length, sb);
        return sb.toString();
    }

    public static void dump_octets(byte[] oct, StringBuilder sb) {
        IORUtil.dump_octets(oct, 0, oct.length, sb);
    }

    public static void dump_octets(byte[] oct, int offset, int count, StringBuilder sb) {
        if (count <= 0) {
            return;
        }
        StringBuilder ascii = new StringBuilder(18);
        switch (offset % 16) {
            case 0: {
                break;
            }
            case 15: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 14: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 13: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 12: {
                sb.append("   ");
                ascii.append(" ");
            }
            case 11: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 10: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 9: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 8: {
                sb.append("   ");
                ascii.append(" ");
            }
            case 7: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 6: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 5: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 4: {
                sb.append("   ");
                ascii.append(" ");
            }
            case 3: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 2: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 1: {
                sb.append("  ");
                ascii.append(" ");
            }
        }
        ascii.append(" \"");
        for (int i = offset; i < offset + count; ++i) {
            int b = oct[i] & 0xFF;
            ascii.append(31 < b && b < 127 ? (char)b : (char)'.');
            sb.append(HEX_DIGIT[b >> 4]);
            sb.append(HEX_DIGIT[b & 0xF]);
            if (i % 4 != 3) continue;
            sb.append(' ');
            if (i % 16 != 15) continue;
            sb.append((CharSequence)ascii).append("\"\n");
            ascii.setLength(0);
            ascii.append(" \"");
            if (i % 256 != 255) continue;
            sb.append("-----------------------------------\n");
        }
        switch ((offset + count) % 16) {
            case 0: {
                break;
            }
            case 1: {
                sb.append("  ");
            }
            case 2: {
                sb.append("  ");
            }
            case 3: {
                sb.append("   ");
            }
            case 4: {
                sb.append("  ");
            }
            case 5: {
                sb.append("  ");
            }
            case 6: {
                sb.append("  ");
            }
            case 7: {
                sb.append("   ");
            }
            case 8: {
                sb.append("  ");
            }
            case 9: {
                sb.append("  ");
            }
            case 10: {
                sb.append("  ");
            }
            case 11: {
                sb.append("   ");
            }
            case 12: {
                sb.append("  ");
            }
            case 13: {
                sb.append("  ");
            }
            case 14: {
                sb.append("  ");
            }
            case 15: {
                sb.append("   ").append((CharSequence)ascii).append("\"\n");
            }
        }
    }

    public static void format_octets(byte[] oct, StringBuilder sb) {
        IORUtil.format_octets(oct, 0, oct.length, sb);
    }

    public static void format_octets(byte[] oct, int offset, int count, StringBuilder sb) {
        if (count <= 0) {
            return;
        }
        sb.append('\"');
        for (int i = offset; i < offset + count; ++i) {
            int n = oct[i] & 0xFF;
            if (n >= 32 && n <= 127) {
                sb.append((char)n);
                continue;
            }
            sb.append('?');
        }
        sb.append('\"');
    }

    public static void describe_component(TaggedComponent component, StringBuilder sb) {
        switch (component.tag) {
            case 0: {
                org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
                in._OB_readEndian();
                int id = in.read_ulong();
                sb.append("Component: TAG_ORB_TYPE = ");
                sb.append("0x");
                sb.append(Integer.toHexString(id));
                sb.append('\n');
                break;
            }
            case 1: {
                IORUtil.describeCodeSets(component, sb);
                break;
            }
            case 2: {
                IORUtil.describeGenericComponent(component, "TAG_POLICIES", sb);
                break;
            }
            case 3: {
                org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
                in._OB_readEndian();
                String host = in.read_string();
                int port = in.read_ushort();
                sb.append("Alternate IIOP address:\n");
                sb.append("  host: ");
                sb.append(host);
                sb.append('\n');
                sb.append("  port: ");
                sb.append(port < 0 ? 65535 + port + 1 : port);
                sb.append('\n');
                break;
            }
            case 13: {
                IORUtil.describeGenericComponent(component, "TAG_ASSOCIATION_OPTIONS", sb);
                break;
            }
            case 14: {
                IORUtil.describeGenericComponent(component, "TAG_SEC_NAME", sb);
                break;
            }
            case 15: {
                IORUtil.describeGenericComponent(component, "TAG_SPKM_1_SEC_MECH", sb);
                break;
            }
            case 16: {
                IORUtil.describeGenericComponent(component, "TAG_SPKM_2_SEC_MECH", sb);
                break;
            }
            case 17: {
                IORUtil.describeGenericComponent(component, "TAG_KerberosV5_SEC_MECH", sb);
                break;
            }
            case 18: {
                IORUtil.describeGenericComponent(component, "TAG_CSI_ECMA_Secret_SEC_MECH", sb);
                break;
            }
            case 19: {
                IORUtil.describeGenericComponent(component, "TAG_CSI_ECMA_Hybrid_SEC_MECH", sb);
                break;
            }
            case 33: {
                IORUtil.describeCSISecMechList(component, sb);
                break;
            }
            case 31: {
                IORUtil.describeGenericComponent(component, "TAG_OTS_POLICY", sb);
                break;
            }
            case 32: {
                IORUtil.describeGenericComponent(component, "TAG_INV_POLICY", sb);
                break;
            }
            case 35: {
                IORUtil.describeGenericComponent(component, "TAG_SECIOP_SEC_TRANS", sb);
                break;
            }
            case 34: {
                IORUtil.describeGenericComponent(component, "TAG_NULL_TAG", sb);
                break;
            }
            case 36: {
                IORUtil.describeGenericComponent(component, "TAG_TLS_SEC_TRANS", sb);
                break;
            }
            case 20: {
                IORUtil.describeGenericComponent(component, "TAG_SSL_SEC_TRANS", sb);
                break;
            }
            case 21: {
                IORUtil.describeGenericComponent(component, "TAG_CSI_ECMA_Public_SEC_MECH", sb);
                break;
            }
            case 22: {
                IORUtil.describeGenericComponent(component, "TAG_GENERIC_SEC_MECH", sb);
                break;
            }
            case 25: {
                org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
                in._OB_readEndian();
                String codebase = in.read_string();
                sb.append("Component: TAG_JAVA_CODEBASE = `");
                sb.append(codebase);
                sb.append("'\n");
                break;
            }
            case 5: {
                IORUtil.describeGenericComponent(component, "TAG_COMPLETE_OBJECT_KEY", sb);
                break;
            }
            case 6: {
                IORUtil.describeGenericComponent(component, "TAG_ENDPOINT_ID_POSITION", sb);
                break;
            }
            case 12: {
                IORUtil.describeGenericComponent(component, "TAG_LOCATION_POLICY", sb);
                break;
            }
            case 100: {
                IORUtil.describeGenericComponent(component, "TAG_DCE_STRING_BINDING", sb);
                break;
            }
            case 101: {
                IORUtil.describeGenericComponent(component, "TAG_DCE_BINDING_NAME", sb);
                break;
            }
            case 102: {
                IORUtil.describeGenericComponent(component, "TAG_DCE_NO_PIPES", sb);
                break;
            }
            case 103: {
                IORUtil.describeGenericComponent(component, "TAG_DCE_SEC_MECH", sb);
                break;
            }
            default: {
                String name = "unknown (tag = ";
                name = name + component.tag;
                name = name + ")";
                IORUtil.describeGenericComponent(component, name, sb);
                break;
            }
        }
    }
}

