/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import org.apache.yoko.orb.OB.CodeConverterBase;
import org.apache.yoko.orb.OB.CodeSetDatabase;
import org.apache.yoko.orb.OB.CodeSetInfo;
import org.apache.yoko.orb.OB.ORBInstance;

public final class CodeConverters {
    public static final CodeConverters NULL_CONVERTER = new CodeConverters(null, null, null, null);
    public final CodeConverterBase inputCharConverter;
    public final CodeConverterBase outputCharConverter;
    public final CodeConverterBase inputWcharConverter;
    public final CodeConverterBase outputWcharConverter;

    private CodeConverters(CodeConverterBase charIn, CodeConverterBase charOut, CodeConverterBase wcharIn, CodeConverterBase wcharOut) {
        this.inputCharConverter = charIn;
        this.outputCharConverter = charOut;
        this.inputWcharConverter = wcharIn;
        this.outputWcharConverter = wcharOut;
    }

    private CodeConverters(CodeConverters c) {
        this(c.inputCharConverter, c.outputCharConverter, c.inputWcharConverter, c.outputWcharConverter);
    }

    public static CodeConverters createCopy(CodeConverters template) {
        if (template == null) {
            return NULL_CONVERTER;
        }
        if (template == NULL_CONVERTER) {
            return NULL_CONVERTER;
        }
        return new CodeConverters(template);
    }

    public static CodeConverters create(ORBInstance orbInst, int alienCs, int alienWcs) {
        int nativeCs = orbInst.getNativeCs();
        int nativeWcs = orbInst.getNativeWcs();
        CodeConverterBase charIn = CodeSetDatabase.getConverter(alienCs, nativeCs);
        CodeConverterBase charOut = CodeSetDatabase.getConverter(nativeCs, alienCs);
        CodeConverterBase wcharIn = CodeSetDatabase.getConverter(alienWcs, nativeWcs);
        CodeConverterBase wcharOut = CodeSetDatabase.getConverter(nativeWcs, alienWcs);
        if (charIn == null && charOut == null && wcharIn == null && wcharOut == null) {
            return NULL_CONVERTER;
        }
        return new CodeConverters(charIn, charOut, wcharIn, wcharOut);
    }

    public static CodeConverters createForWcharWriteOnly() {
        return new CodeConverters(null, null, null, CodeSetDatabase.getConverter(CodeSetInfo.UTF_16, CodeSetInfo.UTF_16));
    }

    public boolean equals(Object obj) {
        CodeConverters conv = (CodeConverters)obj;
        if (conv == null) {
            return false;
        }
        boolean a = false;
        boolean b = false;
        boolean c = false;
        boolean d = false;
        if (this.inputCharConverter == null && conv.inputCharConverter == null) {
            a = true;
        } else if (this.inputCharConverter != null && this.inputCharConverter.equals((Object)conv.inputCharConverter)) {
            a = true;
        }
        if (this.outputCharConverter == null && conv.outputCharConverter == null) {
            b = true;
        } else if (this.outputCharConverter != null && this.outputCharConverter.equals((Object)conv.outputCharConverter)) {
            b = true;
        }
        if (this.inputWcharConverter == null && conv.inputWcharConverter == null) {
            c = true;
        } else if (this.inputWcharConverter != null && this.inputWcharConverter.equals((Object)conv.inputWcharConverter)) {
            c = true;
        }
        if (this.outputWcharConverter == null && conv.outputWcharConverter == null) {
            d = true;
        } else if (this.outputWcharConverter != null && this.outputWcharConverter.equals((Object)conv.outputWcharConverter)) {
            d = true;
        }
        return a && b && c && d;
    }

    public int hashCode() {
        int result = this.inputCharConverter != null ? this.inputCharConverter.hashCode() : 0;
        result = 29 * result + (this.outputCharConverter != null ? this.outputCharConverter.hashCode() : 0);
        result = 29 * result + (this.inputWcharConverter != null ? this.inputWcharConverter.hashCode() : 0);
        result = 29 * result + (this.outputWcharConverter != null ? this.outputWcharConverter.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CodeConverters{\noutputCharConverter=" + this.outputCharConverter + "\noutputWcharConverter=" + this.outputWcharConverter + "\n}";
    }
}

