/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.cdi23.interceptors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.cdi23.helper.Utils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.astefanutti.metrics.cdi23.MetricResolver;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import javax.annotation.Priority;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.annotation.SimplyTimed;

@SimplyTimed
@Interceptor
@Priority(value=1010)
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SimplyTimedInterceptor {
    private final Bean<?> bean;
    private final MetricRegistry registry;
    private final MetricResolver resolver;
    static final long serialVersionUID = -491513148203955244L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Inject
    private SimplyTimedInterceptor(@Intercepted Bean<?> bean, MetricRegistry registry, MetricResolver resolver) {
        this.bean = bean;
        this.registry = registry;
        this.resolver = resolver;
    }

    @AroundConstruct
    private Object timedConstructor(InvocationContext context) throws Exception {
        return this.simplyTimedCallable(context, context.getConstructor());
    }

    @AroundInvoke
    private Object timedMethod(InvocationContext context) throws Exception {
        return this.simplyTimedCallable(context, context.getMethod());
    }

    @AroundTimeout
    private Object timedTimeout(InvocationContext context) throws Exception {
        return this.simplyTimedCallable(context, context.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Member & AnnotatedElement> Object simplyTimedCallable(InvocationContext context, E element) throws Exception {
        MetricResolver.Of<SimplyTimed> simplyTimed = this.resolver.simplyTimed(this.bean.getBeanClass(), element);
        MetricID MetricID2 = new MetricID(simplyTimed.metricName(), Utils.tagsToTags(simplyTimed.tags()));
        SimpleTimer simpleTimer = (SimpleTimer)this.registry.getMetrics().get(MetricID2);
        if (simpleTimer == null) {
            throw new IllegalStateException("No timer with metricID [" + MetricID2 + "] found in registry [" + this.registry + "]");
        }
        SimpleTimer.Context time = simpleTimer.time();
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            time.stop();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.metrics.cdi23.interceptors.SimplyTimedInterceptor", SimplyTimedInterceptor.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.cdi.resources.MetricsCDI");
    }
}

